/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.financeiro.FaturaRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FaturaExamesDao {
    private String[] filtroColeta = null;
    private String[] filtroDestino = null;
    private String[] filtroEstacao = null;
    private String[] filtroConvenio = null;
    private String[] filtroSetor = null;
    private String[] filtroGrupo = null;
    private String[] filtroMedicoConselho = null;
    private String[] filtroMedicoCrm = null;
    private String[] filtroMedicoUF = null;
    private String[] filtroSituacao = null;
    private String[] filtroSituacaoExames = null;
    private String[] filtroPaciente = null;
    private String[] filtroExame = null;
    private String[] filtroUnidadeSaude = null;
    private String[] filtroEmpresa = null;
    private String dataInicio = null;
    private String dataFim = null;
    private String horaInicio = null;
    private String horaFim = null;
    private boolean apenasConferidas = false;
    private boolean isVerificarConferidos = false;
    private boolean isExibirNaoFaturar = false;
    private String textoFiltroConvenio = "";
    private boolean apenasComResultado = false;

    public String sqlRequisicoes(Statement st, String filial, String codigoConvenio, String codigoRequisicao, String guiaRequisicao, String guiaExames, boolean trazerFaturados, boolean isExibirNaoFaturar) throws Exception {
        String ordemFatura = this.getTipoOrdemFaturaConvenio(st, filial, codigoConvenio);
        boolean ordenacaoTiss = this.getOrdenacaoTiss(st, filial, codigoConvenio);
        StringBuilder buf = new StringBuilder();
        buf.append(this.getCamposSelect(false, ordemFatura));
        buf.append(this.getJoinSelect(false));
        buf.append(this.getWhereSelect(false, st, filial, codigoConvenio, codigoRequisicao, guiaRequisicao, guiaExames, trazerFaturados, isExibirNaoFaturar));
        buf.append(this.getGroupBySelect(false));
        buf.append(" UNION ");
        buf.append(this.getCamposSelect(true, ordemFatura));
        buf.append(this.getJoinSelect(true));
        buf.append(this.getWhereSelect(true, st, filial, codigoConvenio, codigoRequisicao, guiaRequisicao, guiaExames, trazerFaturados, isExibirNaoFaturar));
        buf.append(this.getGroupBySelect(true));
        buf.append(this.getOrderBySelect(ordemFatura, ordenacaoTiss));
        return buf.toString();
    }

    private String getCamposSelect(boolean isConvenioRepasse, String ordemFatura) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ");
        buf.append("        fil.fil_codigo ");
        buf.append("       ,fil.fil_cnpj ");
        buf.append("       ,fil.fil_razaosocial ");
        buf.append("       ,fil.fil_cnes ");
        buf.append("       ,exr.req_codigo ");
        buf.append("       ,exr.exa_codigo ");
        buf.append("       ,emc.emc_pagina ");
        buf.append("       ,emc.emc_ordem ");
        buf.append("       ,exr.exr_ordem ");
        buf.append("       ,exr.met_codigo ");
        buf.append("       ,ese.set_codigo ");
        buf.append("       ,con.con_codigo ");
        buf.append("       ,con.lay_codigo ");
        buf.append("       ,exr.mco_codigo ");
        buf.append("       ,(req.req_dataguiaconferida is not null) as guiaconferida ");
        buf.append("       ,exr.exr_codautorizacao ");
        buf.append("       ,exr.exr_dataautorizacao ");
        buf.append("       ,exr.exr_datavalidadeautorizacao ");
        buf.append("       ,con.con_razao ");
        buf.append("       ,con.con_fantasia ");
        buf.append("       ,'").append(ordemFatura).append("' as ordemFatura ");
        buf.append("       ,med.med_nome ");
        buf.append("       ,med.med_cpf ");
        buf.append("       ,med.med_conselho ");
        buf.append("       ,med.med_crm ");
        buf.append("       ,med.med_uf ");
        buf.append("       ,med.med_cbo ");
        buf.append("       ,mec.mec_codigooperadora ");
        buf.append("       ,exa.exa_descricao ");
        buf.append("       ,exr.exr_vlrexame ");
        buf.append("       ,exr.exr_vlrchexame ");
        buf.append("       ,exr.exr_vlrch ");
        buf.append("       ,exr.exr_vlrmaterial ");
        buf.append("       ,coalesce(exr.exr_vlrbalcaoconvenio, 0) as exr_vlrbalcaoconvenio ");
        buf.append("       ,exr.exr_data ");
        buf.append("       ,exr.usr_codigo ");
        buf.append("       ,exr.exr_deveguia ");
        buf.append("       ,mco.mco_descricao ");
        buf.append("       ,mco.mco_abreviatura ");
        buf.append("       ,ent.ent_razaosocial ");
        buf.append("       ,set.set_tipoalimentos ");
        buf.append("       ,CASE WHEN con.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(req.req_titular), ''), pac.pac_nome) ELSE pac.pac_nome end");
        buf.append("       ,pac.pac_cor ");
        buf.append("       ,pac.nli_codigo ");
        buf.append("       ,pac.ein_codigo ");
        buf.append("       ,pac.ein_codigo ");
        buf.append("       ,nac.nli_descricao ");
        buf.append("       ,ein.ein_descricao ");
        buf.append("       ,pac.pac_codigo ");
        buf.append("       ,pac.pac_endereco ");
        buf.append("       ,pac.pac_tipologradouroendereco ");
        buf.append("       ,pac.pac_cep ");
        buf.append("       ,pac.bai_codigo ");
        buf.append("       ,pac.cid_codigo ");
        buf.append("       ,pac.pac_complemento ");
        buf.append("       ,pac.pac_numeroendereco ");
        buf.append("       ,pac.pac_cartaosus ");
        buf.append("       ,cid.cid_codigoibge ");
        buf.append("       ,cid.cid_nome ");
        buf.append("       ,bai.bai_descricao ");
        buf.append("       ,exa.exa_tipobpa ");
        buf.append("       ,req.req_data ");
        buf.append("       ,req.req_dtfatura ");
        buf.append("       ,req.req_hora ");
        buf.append("       ,req.req_horafatura ");
        buf.append("       ,req.col_codigo ");
        buf.append("       ,req.des_codigo ");
        buf.append("       ,req.sit_codigo ");
        buf.append("       ,req.req_cartaosus ");
        buf.append("       ,req.req_dataguia ");
        buf.append("       ,emc.emc_codigocbhpm as codigoCBHPM ");
        buf.append("       ,sit.sit_descricao ");
        buf.append("       ,col.col_descricao ");
        buf.append("       ,des.des_descricao ");
        buf.append("       ,req.req_titular ");
        buf.append("       ,exr.exr_situacao ");
        buf.append("       ,exr.exr_datacortesia ");
        buf.append("       ,exr.exr_motivoprazo ");
        buf.append("       ,req.req_quarto ");
        buf.append("       ,req.req_leito ");
        buf.append("       ,req.ala_codigo ");
        buf.append("       ,ala.ala_descricao ");
        buf.append("       ,tpe.tpe_uco ");
        buf.append("       ,tpe.tpe_tipocbhpm ");
        buf.append("       ,tpe.tpe_tabelaans ");
        buf.append("       ,tpp.tpp_valor ");
        buf.append("       ,pcp.tpp_valor as tpp_valorconvenio ");
        buf.append("       ,exr.exr_naofaturar as exr_naofaturar ");
        buf.append("       ,(select array_to_string(array_agg(c10_codigo), ',') from requisicaocid10 c10 where exr.fil_codigo = c10.fil_codigo and exr.req_codigo = c10.req_codigo) as cid10 ");
        StringBuilder aux = new StringBuilder();
        if (isConvenioRepasse) {
            String repasse = " ,CASE WHEN COALESCE(cre.cre_tipocalculo, 'P') = 'P' THEN ";
            aux.append(" ,CASE WHEN conprinc.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(req_titular), ''), pac_nome) ELSE pac_nome END as ordemPaciente ");
            aux.append(" ,stringtodouble_index(req.req_guiarepasse) as ordenacaoguia ");
            aux.append(" ,req.req_guiarepasse as req_guia ");
            aux.append(" ,req.req_matricularepasse ");
            aux.append(" ,req.req_validadeguiarepasse as req_validadeguia ");
            aux.append(" ,req.req_deveguiarepasse ");
            aux.append(" ,req.req_nomeplanorepasse as req_nomeplano ");
            aux.append(" ,req.req_validadecarteirarepasse ");
            aux.append(" ,req.req_datarecebeuguiarepasse ");
            aux.append(" ,req.req_guiaprincipalrepasse ");
            aux.append(" ,req.usr_codguiarepasse ");
            aux.append(" ,exr.exr_valorcustorepasse ");
            aux.append(" ,exr.exr_valorucorepasse ");
            aux.append(" ,exr.exr_valorporterepasse ");
            aux.append(" ,exr.exr_porterepasse ");
            aux.append(" ,req.req_guiarepasse as exr_guia ");
            aux.append(" ,req.req_validadeguiarepasse as exr_validadeguia ");
            aux.append(" ,exr.exr_dataguia ");
            aux.append(" ,exr.exr_datafaturarepasse ");
            aux.append(" ,exr.exa_codigopai as codigoExamePai ");
            aux.append(" ,exr.mco_codigopai as materialExamePai ");
            aux.append(" ,COALESCE(conprinc.con_codigo, con.con_codigo) as codigoConvenioPrincipal ");
            aux.append(" ,COALESCE(conprinc.con_razao, con.con_razao) as razaoConvenioPrincipal ");
            aux.append(" ,COALESCE(conprinc.con_fantasia, con.con_fantasia) as fantasiaConvenioPrincipal ");
            aux.append(repasse).append(" conprinc.con_faturaeletronica \t\tELSE con.con_faturaeletronica \t\tEND as con_faturaeletronica");
            aux.append(repasse).append(" conprinc.con_percpgtomaterial \t\tELSE con.con_percpgtomaterial \t\tEND as con_percpgtomaterial");
            aux.append(repasse).append(" conprinc.con_descontoporte \t\t\tELSE con.con_descontoporte \t\t\t\tEND as con_descontoporte ");
            aux.append(repasse).append(" conprinc.con_descontouco \t\t\t\tELSE con.con_descontouco \t\t\t\t\tEND as con_descontouco ");
            aux.append(repasse).append(" conprinc.con_acrescimoporte \t\t\tELSE con.con_acrescimoporte \t\t\tEND as con_acrescimoporte");
            aux.append(repasse).append(" conprinc.con_acrescimouco \t\t\t\tELSE con.con_acrescimouco \t\t\t\tEND as con_acrescimouco ");
            aux.append(" ,COALESCE(conprinc.con_percpgto, 0) as con_percpgto ");
            aux.append(repasse).append(" conprinc.con_fatfmaterial \t\t\t\tELSE con.con_fatfmaterial \t\t\t\tEND as con_fatfmaterial ");
            aux.append(repasse).append(" conprinc.con_faturarrecoleta \t\tELSE con.con_faturarrecoleta\t\t\tEND as con_faturarrecoleta ");
            aux.append(repasse).append(" conprinc.con_multa \t\t\t\t\t\t\tELSE con.con_multa \t\t\t\t\t\t\t\tEND as con_multa ");
            aux.append(repasse).append(" conprinc.con_mora \t\t\t\t\t\t\t\tELSE con.con_mora \t\t\t\t\t\t\t\tEND as con_mora ");
            aux.append(repasse).append(" conprinc.con_bonus \t\t\t\t\t\t\tELSE con.con_bonus \t\t\t\t\t\t\t\tEND as con_bonus ");
            aux.append(repasse).append(" conprinc.con_acrescimo \t\t\t\t\tELSE con.con_acrescimo \t\t\t\t\t\tEND as con_acrescimo ");
            aux.append(repasse).append(" conprinc.con_tpcalcfatu \t\t\t\t\tELSE con.con_tpcalcfatu \t\t\t\t\tEND as con_tpcalcfatu ");
            aux.append(repasse).append(" conprinc.con_tpcalcch \t\t\t\t\t\tELSE con.con_tpcalcch \t\t\t\t\t\tEND as con_tpcalcch ");
            aux.append(repasse).append(" conprinc.con_cobrmaterial \t\t\t\tELSE con.con_cobrmaterial \t\t\t\tEND as con_cobrmaterial ");
            aux.append(repasse).append(" conprinc.con_valorch \t\t\t\t\t\tELSE con.con_valorch \t\t\t\t\t\t\tEND as con_valorch ");
            aux.append(repasse).append(" conprinc.con_ordemfatura \t\t\t\tELSE con.con_ordemfatura \t\t\t\t\tEND as con_ordemfatura ");
            aux.append(repasse).append(" conprinc.con_titdep \t\t\t\t\t\t\tELSE con.con_titdep \t\t\t\t\t\t\tEND as con_titdep ");
            aux.append(repasse).append(" conprinc.con_reajuste \t\t\t\t\t\tELSE con.con_reajuste \t\t\t\t\t\tEND as con_reajuste ");
            aux.append(repasse).append(" conprinc.con_precosdiferenciados ELSE con.con_precosdiferenciados \tEND as con_precosdiferenciados ");
            aux.append(repasse).append(" conprinc.con_fatfiliais \t\t\t\t\tELSE con.con_fatfiliais \t\t\t\t\tEND as con_fatfiliais ");
            aux.append(repasse).append(" conprinc.con_agrupaambguia       ELSE con.con_agrupaambguia        END as con_agrupaambguia ");
            aux.append(repasse).append(" conprinc.tpe_codigo \t\t\t\t\t\t\tELSE con.tpe_codigo \t\t\t\t\t\t\tEND as tpe_codigoconvenio ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                aux.append(repasse).append(" COALESCE(dtmprinc.dtm_valor, dtpprinc.dtp_valor)   ELSE COALESCE(dtm.dtm_valor, dtp.dtp_valor)   END as dtp_valor ");
                aux.append(repasse).append(" COALESCE(NULLIF(dtmprinc.dtm_codamb, ''), dtpprinc.dtp_codamb) ELSE COALESCE(NULLIF(dtm.dtm_codamb, ''), dtp.dtp_codamb) END as codigoAMB ");
                aux.append(repasse).append(" COALESCE(dtmprinc.dtm_percentual, dtpprinc.dtp_percentual) ELSE COALESCE(dtm.dtm_percentual, dtp.dtp_percentual) END as dtp_percentual ");
                aux.append(repasse).append(" COALESCE(dtmprinc.tpp_porte, dtpprinc.tpp_porte) ELSE COALESCE(dtm.tpp_porte, dtp.tpp_porte) END as tpp_porte ");
            } else {
                aux.append(repasse).append(" dtpprinc.dtp_valor \t\t\t\tELSE dtp.dtp_valor \t\t\t\t\tEND as dtp_valor ");
                aux.append(repasse).append(" dtpprinc.dtp_codamb \t\t\t\tELSE dtp.dtp_codamb \t\t\t\tEND as codigoAMB ");
                aux.append(repasse).append(" dtpprinc.dtp_percentual \t\tELSE dtp.dtp_percentual \t\tEND as dtp_percentual ");
                aux.append(repasse).append(" dtpprinc.tpp_porte         ELSE dtp.tpp_porte          END as tpp_porte ");
            }
            aux.append(repasse).append(" 0 END as agrupamento ");
            aux.append(repasse).append(" 0 END as agrupamento2 ");
            aux.append(repasse).append(" cprprinc.cpr_valor \t\t\t\tELSE cpr.cpr_valor \t\t\t\t\tEND as cpr_valor ");
            aux.append(repasse).append(" cprprinc.cpr_percentual \t\tELSE cpr.cpr_percentual \t\tEND as cpr_percentual ");
            aux.append(repasse).append(" cprprinc.tpp_porte \t\t\t\tELSE cpr.tpp_porte \t\t\t\t\tEND as tpp_porteconvenio ");
            aux.append(" ,COALESCE(cre.cre_tipocalculo, '").append("P").append("') as tipoCalculo ");
            aux.append(" ,true as isConvenioRepasse ");
        } else {
            aux.append(" ,CASE WHEN con.con_titdep = 'T' THEN COALESCE(NULLIF(TRIM(req_titular), ''), pac_nome) ELSE pac_nome END as ordemPaciente ");
            aux.append(" ,stringtodouble_index(req.req_guia) as ordenacaoguia ");
            aux.append(" ,req.req_guia as req_guia ");
            aux.append(" ,req.req_matricula ");
            aux.append(" ,null as req_validadeguia ");
            aux.append(" ,req.req_deveguia ");
            aux.append(" ,req.req_nomeplano ");
            aux.append(" ,req.req_validadecarteira ");
            aux.append(" ,req.req_datarecebeuguia ");
            aux.append(" ,req.req_guiaprincipal ");
            aux.append(" ,req.usr_codrecebeuguia ");
            aux.append(" ,exr.exr_valorcusto ");
            aux.append(" ,exr.exr_valoruco ");
            aux.append(" ,exr.exr_valorporte ");
            aux.append(" ,exr.exr_porte ");
            aux.append(" ,CASE WHEN con.con_examesporguia = 0 THEN COALESCE(NULLIF(trim(exr.exr_guia), ''), NULLIF(trim(req.req_guia), '')) ELSE NULLIF(trim(exr.exr_guia), '') END as exr_guia ");
            aux.append(" ,exr.exr_validadeguia ");
            aux.append(" ,exr.exr_dataguia ");
            aux.append(" ,exr.exr_datafatura ");
            aux.append(" ,exr.exa_codigopai as codigoExamePai ");
            aux.append(" ,exr.mco_codigopai as materialExamePai ");
            aux.append(" ,con.con_codigo as codigoConvenioPrincipal ");
            aux.append(" ,con.con_razao as razaoConvenioPrincipal ");
            aux.append(" ,con.con_fantasia as fantasiaConvenioPrincipal ");
            aux.append(" ,con.con_faturaeletronica ");
            aux.append(" ,con.con_percpgtomaterial ");
            aux.append(" ,con.con_descontoporte ");
            aux.append(" ,con.con_descontouco ");
            aux.append(" ,con.con_acrescimoporte ");
            aux.append(" ,con.con_acrescimouco ");
            aux.append(" ,COALESCE(con.con_percpgto, 0) as con_percpgto ");
            aux.append(" ,con.con_fatfmaterial ");
            aux.append(" ,con.con_faturarrecoleta ");
            aux.append(" ,con.con_multa ");
            aux.append(" ,con.con_mora ");
            aux.append(" ,con.con_bonus ");
            aux.append(" ,con.con_acrescimo ");
            aux.append(" ,con.con_tpcalcfatu ");
            aux.append(" ,con.con_tpcalcch ");
            aux.append(" ,con.con_cobrmaterial ");
            aux.append(" ,con.con_valorch ");
            aux.append(" ,con.con_ordemfatura ");
            aux.append(" ,con.con_titdep ");
            aux.append(" ,con.con_reajuste ");
            aux.append(" ,con.con_precosdiferenciados ");
            aux.append(" ,con.con_fatfiliais ");
            aux.append(" ,con.con_agrupaambguia ");
            aux.append(" ,con.tpe_codigo as tpe_codigoconvenio ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                aux.append(" ,COALESCE(dtm.dtm_valor, dtp.dtp_valor) as dtp_valor ");
                aux.append(" ,COALESCE(NULLIF(dtm.dtm_codamb, ''), dtp.dtp_codamb) as codigoAMB ");
                aux.append(" ,COALESCE(dtm.dtm_percentual, dtp.dtp_percentual) as dtp_percentual ");
                aux.append(" ,COALESCE(dtm.tpp_porte, dtp.tpp_porte) as tpp_porte ");
            } else {
                aux.append(" ,dtp.dtp_valor ");
                aux.append(" ,dtp.dtp_codamb as codigoAMB ");
                aux.append(" ,dtp.dtp_percentual ");
                aux.append(" ,dtp.tpp_porte ");
            }
            aux.append(" ,count(COALESCE(agr.exa_codigo, agr2.exa_codigo)) as agrupamento ");
            aux.append(" ,count(COALESCE(aec3.exa_codigo, aec4.exa_codigo)) as agrupamento2 ");
            aux.append(" ,cpr.cpr_valor ");
            aux.append(" ,cpr.cpr_percentual ");
            aux.append(" ,cpr.tpp_porte as tpp_porteconvenio ");
            aux.append(" ,'").append("P").append("' as tipoCalculo ");
            aux.append(" ,false as isConvenioRepasse ");
        }
        buf.append(aux.toString());
        return buf.toString();
    }

    private String getJoinSelect(boolean isConvenioRepasse) {
        StringBuilder buf = new StringBuilder();
        buf.append("   from examerequisicao \t\t\t\texr ");
        buf.append("   join filiais_postocoleta     fil on exr.fil_codigo = fil.fil_codigo ");
        buf.append("   join requisicao \t\t\t\t\t\t\treq on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   left join exames\t \t\t\t\t\t\texa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        if (isConvenioRepasse) {
            buf.append("   left join convenios\t              con      \ton req.fil_codigo  = con.fil_codigo \t\tand req.con_codrepasse  = con.con_codigo ");
            buf.append("   left join conveniospreco           cpr      \ton exr.fil_codigo  = cpr.fil_codigo \t\t and exr.exa_codigo \t\t = cpr.exa_codigo \t\t and exr.mco_codigo  = cpr.mco_codigo  \t\tand con.con_codigo \t= cpr.con_codigo ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and exr.exa_codigo = dtm.exa_codigo and exr.mco_codigo = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
            }
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo\t= dtp.tpe_codigo ");
            buf.append("   left join agrupaexameconvenio \t\t\taec      \ton exr.fil_codigo  = aec.fil_codigo \t\tand exr.exa_codigo \t\t \t= aec.exa_codigo \t\tand exr.mco_codigo  = aec.mco_codigo  \tand con.con_codigo \t= aec.con_codigo \tand aec.aec_tipo = '").append("F").append("' ");
            buf.append("   left join exameagrupaexameconvenio agr  \t\t \ton aec.fil_codigo  = agr.fil_codigo \tand aec.exa_codigo \t= agr.exa_codigo\tand aec.mco_codigo  = agr.mco_codigo  and aec.con_codigo \t= agr.con_codigo \tand aec.aec_tipo = '").append("F").append("' ");
            buf.append("   left join agrupaexameconvenio \t\t\taec2     \ton exr.fil_codigo  = aec2.fil_codigo \t \tand exr.exa_codigo \t\t \t= aec2.exa_codigo \tand exr.mco_codigo  = aec2.mco_codigo  \tand aec2.aec_tipo \t= '").append("F").append("' and aec2.aec_ignorarconvenio = true ");
            buf.append("   left join exameagrupaexameconvenio agr2 \t\t \ton aec2.fil_codigo = agr2.fil_codigo \tand aec2.exa_codigo = agr2.exa_codigo and aec2.mco_codigo = agr2.mco_codigo\tand aec2.con_codigo = agr2.con_codigo and aec2.aec_tipo = '").append("F").append("' \tand agr.fil_codigo IS NULL ");
            buf.append("   left join agrupaexameconvenio \t\t\taec3 \t\t \ton exr.fil_codigo  = aec3.fil_codigo \t\tand con.con_codigo  \t\t= aec3.con_codigo \tand exr.exa_codigo  = aec3.exa_codigo \tand aec3.aec_tipo \t= '").append("F").append("' and aec3.aec_ignorarmaterial = true ");
            buf.append("   left join agrupaexameconvenio \t\t\taec4 \t\t \ton exr.fil_codigo  = aec4.fil_codigo \t\tand exr.exa_codigo  \t\t= aec4.exa_codigo \tand aec4.aec_tipo \t= '").append("F").append("' and aec4.aec_ignorarmaterial = true \t\tand aec4.aec_ignorarconvenio = true ");
            buf.append("   left join convenios \t              conprinc  on req.fil_codigo = conprinc.fil_codigo  \tand req.con_codigo \t= conprinc.con_codigo ");
            buf.append("   left join conveniospreco           cprprinc on exr.fil_codigo = cprprinc.fil_codigo and exr.exa_codigo \t\t = cprprinc.exa_codigo and exr.mco_codigo = cprprinc.mco_codigo and conprinc.con_codigo = cprprinc.con_codigo ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append(" left join detalhetabelaprecometodologia dtmprinc on exr.fil_codigo = dtmprinc.fil_codigo and exr.exa_codigo = dtmprinc.exa_codigo and exr.mco_codigo = dtmprinc.mco_codigo and conprinc.tpe_codigo = dtmprinc.tpe_codigo and exr.met_codigo = dtmprinc.met_codigo ");
            }
            buf.append(" left join detalhetabelapreco dtpprinc on exr.fil_codigo = dtpprinc.fil_codigo and exr.exa_codigo = dtpprinc.exa_codigo and exr.mco_codigo = dtpprinc.mco_codigo and conprinc.tpe_codigo = dtpprinc.tpe_codigo ");
            buf.append("   left join agrupaexameconvenio \t\t\taecprinc3 on exr.fil_codigo\t= aecprinc3.fil_codigo \tand con.con_codigo \t= aecprinc3.con_codigo \tand exr.exa_codigo\t= aecprinc3.exa_codigo\tand aecprinc3.aec_tipo \t= '").append("F").append("' and aecprinc3.aec_ignorarmaterial = true ");
            buf.append("   left join conveniosrepasse\t\t\t\t\tcre \t\t on con.fil_codigo = cre.fil_codigo \t\t and conprinc.con_codigo = cre.con_codigo       and con.con_codigo = cre.con_codrepasse ");
            buf.append("   left join medicoconveniotiss mec on req.fil_codigo = mec.fil_codigo and req.con_codrepasse   = mec.con_codigo    and req.med_conselho = mec.med_conselho\tand req.med_crm = mec.med_crm and req.med_uf = mec.med_uf ");
        } else {
            buf.append("   left join convenios \t              con  on req.fil_codigo  = con.fil_codigo  and req.con_codigo  = con.con_codigo ");
            buf.append("   left join conveniospreco           cpr  on exr.fil_codigo  = cpr.fil_codigo  and exr.exa_codigo  = cpr.exa_codigo  and exr.mco_codigo  = cpr.mco_codigo  and con.con_codigo  = cpr.con_codigo ");
            if (ParametrosGerais.getPrecoMetodologia()) {
                buf.append(" left join detalhetabelaprecometodologia dtm on exr.fil_codigo = dtm.fil_codigo and exr.exa_codigo = dtm.exa_codigo and exr.mco_codigo = dtm.mco_codigo and con.tpe_codigo = dtm.tpe_codigo and exr.met_codigo = dtm.met_codigo ");
            }
            buf.append(" left join detalhetabelapreco dtp on exr.fil_codigo = dtp.fil_codigo and exr.exa_codigo = dtp.exa_codigo and exr.mco_codigo = dtp.mco_codigo and con.tpe_codigo = dtp.tpe_codigo ");
            buf.append("   left join agrupaexameconvenio \t\t\taec  on exr.fil_codigo  = aec.fil_codigo  and exr.exa_codigo  = aec.exa_codigo  and exr.mco_codigo  = aec.mco_codigo  and con.con_codigo  = aec.con_codigo  and aec.aec_tipo = '").append("F").append("' ");
            buf.append("   left join exameagrupaexameconvenio agr  on aec.fil_codigo  = agr.fil_codigo  and aec.exa_codigo  = agr.exa_codigo  and aec.mco_codigo  = agr.mco_codigo  and aec.con_codigo  = agr.con_codigo  and agr.aec_tipo = '").append("F").append("' ");
            buf.append("   left join agrupaexameconvenio \t\t\taec2 on exr.fil_codigo  = aec2.fil_codigo and exr.exa_codigo  = aec2.exa_codigo and exr.mco_codigo  = aec2.mco_codigo and aec2.aec_tipo   = '").append("F").append("' and aec2.aec_ignorarconvenio = true ");
            buf.append("   left join exameagrupaexameconvenio agr2 on aec2.fil_codigo = agr2.fil_codigo and aec2.exa_codigo = agr2.exa_codigo and aec2.mco_codigo = agr2.mco_codigo and agr2.aec_tipo = '").append("F").append("' and agr.fil_codigo IS NULL ");
            buf.append("   left join agrupaexameconvenio \t\t\taec3 on exr.fil_codigo  = aec3.fil_codigo and con.con_codigo  = aec3.con_codigo and exr.exa_codigo  = aec3.exa_codigo and aec3.aec_tipo = '").append("F").append("' and aec3.aec_ignorarmaterial = true ");
            buf.append("   left join agrupaexameconvenio \t\t\taec4 on exr.fil_codigo  = aec4.fil_codigo and exr.exa_codigo  = aec4.exa_codigo and aec4.aec_tipo = '").append("F").append("' and aec4.aec_ignorarmaterial = true and aec4.aec_ignorarconvenio = true ");
            buf.append("   left join medicoconveniotiss mec on req.fil_codigo = mec.fil_codigo and req.con_codigo   = mec.con_codigo    and req.med_conselho = mec.med_conselho\tand req.med_crm = mec.med_crm and req.med_uf = mec.med_uf ");
        }
        buf.append("   left join examesetor \t\t\t\tese on exa.fil_codigo = ese.fil_codigo and exa.exa_codigo \t= ese.exa_codigo \t\tand ese.ese_default = true ");
        buf.append("   left JOIN setores            set ON ese.fil_codigo = set.fil_codigo and ese.set_codigo   = set.set_codigo");
        buf.append("   left join medico \t\t\t\t\t\tmed on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho\tand req.med_crm = med.med_crm \t\t\t\t  and req.med_uf = med.med_uf ");
        buf.append("   left join situacao \t\t\t\t  sit on req.fil_codigo = sit.fil_codigo and req.sit_codigo \t= sit.sit_codigo ");
        buf.append("   left join materialcoleta \t\tmco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo\t\t= mco.mco_codigo ");
        buf.append("   left join paciente \t\t\t\t\tpac on req.fil_codigo = pac.fil_codigo and req.pac_codigo \t= pac.pac_codigo ");
        buf.append("   left join nacionalidade      nac on pac.nli_codigo = nac.nli_codigo ");
        buf.append("   left join etniaindigena      ein on pac.ein_codigo = ein.ein_codigo ");
        buf.append("   left join cidades  \t\t\t\t\tcid on pac.fil_codigo = cid.fil_codigo and pac.cid_codigo \t= cid.cid_codigo ");
        buf.append("   left join bairro  \t\t\t\t\t  bai on pac.fil_codigo = bai.fil_codigo and pac.bai_codigo \t= bai.bai_codigo ");
        buf.append("   left join coletas \t\t\t\t\t\tcol on req.fil_codigo = col.fil_codigo and req.col_codigo \t= col.col_codigo ");
        buf.append("   left join destino \t\t\t\t\t\tdes on req.fil_codigo = des.fil_codigo and req.des_codigo \t= des.des_codigo ");
        buf.append("   left join alahospital  \t\t\tala on req.fil_codigo = ala.fil_codigo and req.ala_codigo \t= ala.ala_codigo ");
        buf.append("   left join examematcoleta   \temc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo \t= emc.exa_codigo \t\tand exr.mco_codigo = emc.mco_codigo ");
        if (this.filtroGrupo != null && this.filtroGrupo.length > 0) {
            buf.append(" left join examematgrupo\temg on exr.fil_codigo = emg.fil_codigo\t\t  and exr.exa_codigo \t\t= emg.exa_codigo \t  and exr.mco_codigo = emg.mco_codigo ");
        }
        if (ParametrosGerais.getPrecoMetodologia()) {
            buf.append("   left join tabelaprecoexames        tpem on dtp.fil_codigo = tpem.fil_codigo and dtp.tpe_codigo = tpem.tpe_codigo ");
            buf.append("   left join tabelaprecoexamesporte   tppm on dtp.fil_codigo = tppm.fil_codigo and dtp.tpe_codigo = tppm.tpe_codigo and dtp.tpp_porte = tppm.tpp_porte ");
            buf.append("   left join tabelaprecoexamesporte   pcpm on cpr.fil_codigo = pcpm.fil_codigo and cpr.tpe_codigo = pcpm.tpe_codigo and cpr.tpp_porte = pcpm.tpp_porte ");
        }
        buf.append("   left join tabelaprecoexames        tpe on dtp.fil_codigo = tpe.fil_codigo and dtp.tpe_codigo = tpe.tpe_codigo ");
        buf.append("   left join tabelaprecoexamesporte   tpp on dtp.fil_codigo = tpp.fil_codigo and dtp.tpe_codigo = tpp.tpe_codigo and dtp.tpp_porte = tpp.tpp_porte ");
        buf.append("   left join tabelaprecoexamesporte   pcp on cpr.fil_codigo = pcp.fil_codigo and cpr.tpe_codigo = pcp.tpe_codigo and cpr.tpp_porte = pcp.tpp_porte ");
        buf.append("   left join entidade   ent on req.fil_codigo = ent.fil_codigo and req.ent_codempresa = ent.ent_codigo ");
        return buf.toString();
    }

    private String getWhereSelect(boolean isConvenioRepasse, Statement st, String filial, String convenio, String requisicao, String guiaRequisicao, String guiaExame, boolean trazerFaturados, boolean isExibirNaoFaturar) throws NumberFormatException, Exception {
        String convenioAux;
        String filialAux;
        StringBuilder buf = new StringBuilder();
        buf.append("  where ");
        buf.append(" exr.exr_excluido = false ");
        boolean isConsiderarAgendamento = false;
        if (this.apenasConferidas) {
            buf.append(" and req.req_dataguiaconferida is not null ");
        }
        if (!trazerFaturados) {
            buf.append(this.pesquisaExamesFatuados(isConvenioRepasse, trazerFaturados));
        }
        String string = filialAux = filial == null ? Variaveis.filialPadrao : filial;
        Object object = convenio == null ? (this.filtroConvenio == null || this.filtroConvenio.length == 0 ? null : this.filtroConvenio[0]) : (convenioAux = convenio);
        if (filialAux != null && convenioAux != null) {
            buf.append(" and ");
            StringBuilder temp = new StringBuilder(" (");
            temp.append(" (con.fil_codigo, con.con_codigo) IN (");
            if (this.filtroConvenio != null && this.filtroConvenio.length > 0) {
                for (int i = 0; i < this.filtroConvenio.length; ++i) {
                    temp.append(" (").append(Variaveis.filialPadrao).append(", ").append(this.filtroConvenio[i]).append(") ");
                    StringBuilder sb = new StringBuilder();
                    sb.append(" select fil_codfat ");
                    sb.append("       ,con_codfat ");
                    sb.append("   from filialfatura ");
                    sb.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    sb.append("    and con_codigo = ").append(this.filtroConvenio[i]);
                    if (Variaveis.integrarDadosEntreFiliais) {
                        sb.append(" and fil_codfat = ").append(Variaveis.filialPadrao);
                    }
                    ResultSet rsFatura = Conexao.executeQuery(st, sb.toString());
                    while (rsFatura.next()) {
                        temp.append(" , (").append(rsFatura.getString("fil_codfat")).append(", ").append(rsFatura.getString("con_codfat")).append(") ");
                    }
                    if (!isConsiderarAgendamento) {
                        ConvenioService convenioService = new ConvenioService();
                        isConsiderarAgendamento = convenioService.isConsiderarAgendamentoCota(Integer.valueOf(filialAux), Integer.valueOf(this.filtroConvenio[i]));
                    }
                    rsFatura.close();
                    if (i >= this.filtroConvenio.length - 1) continue;
                    temp.append(" , ");
                }
            } else if (filialAux != null && convenioAux != null) {
                temp.append(" (").append(filialAux).append(", ").append(convenioAux).append(") ");
                StringBuilder sb = new StringBuilder();
                sb.append(" select fil_codfat ");
                sb.append("       ,con_codfat ");
                sb.append("   from filialfatura ");
                sb.append("  where fil_codigo = ").append(filialAux);
                sb.append("    and con_codigo = ").append(convenioAux);
                if (Variaveis.integrarDadosEntreFiliais) {
                    sb.append(" and fil_codfat = ").append(Variaveis.filialPadrao);
                }
                ResultSet rsFatura = Conexao.executeQuery(st, sb.toString());
                while (rsFatura.next()) {
                    temp.append(" , (").append(rsFatura.getString("fil_codfat")).append(", ").append(rsFatura.getString("con_codfat")).append(") ");
                }
                rsFatura.close();
            }
            temp.append(") ) ");
            this.textoFiltroConvenio = temp.toString();
            buf.append(this.textoFiltroConvenio);
        }
        buf.append(this.consideraAgendamento(isConsiderarAgendamento));
        if (this.filtroColeta != null && this.filtroColeta.length > 0) {
            buf.append(" and col.col_codigo in (");
            for (int i = 0; i < this.filtroColeta.length; ++i) {
                buf.append("'").append(this.filtroColeta[i]).append("'");
                if (i >= this.filtroColeta.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroDestino != null && this.filtroDestino.length > 0) {
            buf.append(" and des.des_codigo in (");
            for (int i = 0; i < this.filtroDestino.length; ++i) {
                buf.append("'").append(this.filtroDestino[i]).append("'");
                if (i >= this.filtroDestino.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroEstacao != null && this.filtroEstacao.length > 0) {
            buf.append(" and req.est_codigo in (");
            for (int i = 0; i < this.filtroEstacao.length; ++i) {
                buf.append(this.filtroEstacao[i]);
                if (i >= this.filtroEstacao.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroSetor != null && this.filtroSetor.length > 0) {
            buf.append(" and ese.set_codigo in (");
            for (int i = 0; i < this.filtroSetor.length; ++i) {
                buf.append(this.filtroSetor[i]);
                if (i >= this.filtroSetor.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroGrupo != null && this.filtroGrupo.length > 0) {
            buf.append(" and emg.grp_codigo in (");
            for (int i = 0; i < this.filtroGrupo.length; ++i) {
                buf.append("'").append(this.filtroGrupo[i]).append("'");
                if (i >= this.filtroGrupo.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroMedicoConselho != null && this.filtroMedicoCrm != null && this.filtroMedicoUF != null && this.filtroMedicoConselho.length > 0 && this.filtroMedicoCrm.length > 0 && this.filtroMedicoUF.length > 0 && this.filtroMedicoConselho.length == this.filtroMedicoCrm.length && this.filtroMedicoCrm.length == this.filtroMedicoUF.length) {
            buf.append(" and (");
            for (int i = 0; i < this.filtroMedicoCrm.length; ++i) {
                buf.append(" (med.med_conselho = '").append(this.filtroMedicoConselho[i]).append("' and ");
                buf.append("  med.med_crm = '").append(this.filtroMedicoCrm[i]).append("' and ");
                buf.append("  med.med_uf = '").append(this.filtroMedicoUF[i]).append("') ");
                if (i >= this.filtroMedicoCrm.length - 1) continue;
                buf.append(" or ");
            }
            buf.append(") ");
        }
        if (this.filtroSituacao != null && this.filtroSituacao.length > 0) {
            buf.append(" and sit.sit_codigo in (");
            for (int i = 0; i < this.filtroSituacao.length; ++i) {
                buf.append(this.filtroSituacao[i]);
                if (i >= this.filtroSituacao.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroPaciente != null && this.filtroPaciente.length > 0) {
            buf.append(" and pac.pac_codigo in (");
            for (int i = 0; i < this.filtroPaciente.length; ++i) {
                buf.append(this.filtroPaciente[i]);
                if (i >= this.filtroPaciente.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroExame != null && this.filtroExame.length > 0) {
            buf.append(" and exa.exa_codigo in (");
            for (int i = 0; i < this.filtroExame.length; ++i) {
                buf.append("'").append(StringUtil.textoDB(this.filtroExame[i])).append("'");
                if (i >= this.filtroExame.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroUnidadeSaude != null && this.filtroUnidadeSaude.length > 0) {
            buf.append(" and req.uns_codigo in (");
            for (int i = 0; i < this.filtroUnidadeSaude.length; ++i) {
                buf.append("'").append(StringUtil.textoDB(this.filtroUnidadeSaude[i])).append("'");
                if (i >= this.filtroUnidadeSaude.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.filtroSituacaoExames != null && this.filtroSituacaoExames.length > 0) {
            buf.append(" and exr.exr_situacao in ('");
            for (int i = 0; i < this.filtroSituacaoExames.length; ++i) {
                buf.append(this.filtroSituacaoExames[i]);
                if (i >= this.filtroSituacaoExames.length - 1) continue;
                buf.append("','");
            }
            buf.append("')");
        }
        if (this.filtroEmpresa != null && this.filtroEmpresa.length > 0) {
            buf.append(" and ent.ent_codigo in (");
            for (int i = 0; i < this.filtroEmpresa.length; ++i) {
                buf.append("'").append(StringUtil.textoDB(this.filtroEmpresa[i])).append("'");
                if (i >= this.filtroEmpresa.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (this.apenasComResultado) {
            buf.append(" and todosexamesprontos(exr.fil_codigo, exr.req_codigo) ");
        }
        if (requisicao != null) {
            buf.append(" and (req.fil_codigo, req.req_codigo) = (").append(filial).append(", ").append(requisicao).append(") ");
        } else if (guiaRequisicao != null) {
            buf.append(" and req.req_guia = '").append(guiaRequisicao).append("' ");
        } else if (guiaExame != null) {
            buf.append(" and exr.exr_guia = '").append(guiaExame).append("' ");
        }
        return buf.toString();
    }

    private String consideraAgendamento(boolean isConsiderarAgendamento) {
        StringBuilder buf = new StringBuilder();
        if (!isConsiderarAgendamento) {
            buf.append(" and req.req_excluida = false ");
        }
        if (!Funcoes.textoVazio(this.dataInicio)) {
            buf.append(" and req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicio)).append("' ");
        }
        if (!Funcoes.textoVazio(this.dataFim)) {
            buf.append(" and req.req_dtfatura <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFim)).append("' ");
        }
        if (Funcoes.verificaHora(this.horaInicio)) {
            buf.append(" and req.req_horafatura >= '").append(this.horaInicio).append("' ");
        }
        if (Funcoes.verificaHora(this.horaFim)) {
            buf.append(" and req.req_horafatura <= '").append(this.horaFim).append("' ");
        }
        if (!this.isExibirNaoFaturar) {
            buf.append(" and (exr.exr_naofaturar <> true or exr.exr_naofaturar is null) ");
        }
        return buf.toString();
    }

    private Object pesquisaExamesFatuados(boolean isConvenioRepasse, boolean trazerFaturados) {
        if (isConvenioRepasse) {
            return " and exr.exr_datafaturarepasse is null ";
        }
        return " and exr.exr_datafatura is null ";
    }

    private String getGroupBySelect(boolean isConvenioRepasse) {
        StringBuilder buf = new StringBuilder();
        buf.append(" group by exr.fil_codigo            ,exr.req_codigo       ,exr.exa_codigo       \t,con.con_codigo ");
        buf.append("         ,exr.mco_codigo       \t\t\t,guiaconferida        ,exr.exr_codautorizacao ,tpp.tpp_valor ");
        buf.append("         ,con.con_razao             ,con.con_fantasia     ,med.med_nome         \t,med.med_cpf ");
        buf.append("         ,med.med_conselho          ,med.med_crm          ,med.med_uf           \t,exa.exa_descricao ");
        buf.append("         ,exr.exr_vlrexame          ,exr.exr_vlrchexame   ,exr.exr_vlrch        \t,exr.exr_vlrmaterial ");
        buf.append("         ,exr.exr_vlrbalcaoconvenio\t,exr.exr_data         ,exr.usr_codigo \t\t\t\t,ese.set_codigo , set_tipoalimentos");
        buf.append("         ,mco.mco_descricao         ,mco.mco_abreviatura  ,pac.pac_nome         \t,req.req_data ");
        buf.append("         ,req.req_dtfatura          ,req.req_hora         ,req.req_horafatura     ,exr.exr_ordem ");
        buf.append("         ,req.col_codigo            ,req.des_codigo       ,req.sit_codigo \t\t    ,req.req_cartaosus       \t,codigoCBHPM ");
        buf.append("         ,sit.sit_descricao         ,col.col_descricao    ,des.des_descricao    \t,req.req_titular ");
        buf.append("         ,codigoAMB                 ,exr.exr_situacao     ,exr.exr_datacortesia \t,exr.exr_motivoprazo ");
        buf.append("         ,req.req_quarto       \t\t\t,req.req_leito        ,req.ala_codigo \t\t\t\t,tpp_porteconvenio ");
        buf.append("         ,ala.ala_descricao         ,tpe.tpe_uco          ,tpe.tpe_tipocbhpm    \t,tpp_valorconvenio ");
        buf.append("         ,tpe_codigoconvenio\t\t\t\t,exr.exr_guia \t\t\t\t,exr.exr_deveguia \t\t\t,exr.exr_validadeguia ");
        buf.append("         ,mec.mec_codigooperadora   ,exr.exr_dataguia     ,fil.fil_cnpj           ,fil.fil_razaosocial ");
        buf.append("         ,tpe.tpe_tabelaans         ,fil.fil_codigo       ,med.med_cbo            ,pac.pac_codigo ");
        buf.append("         ,exr.exr_dataautorizacao   ,exr.exr_datavalidadeautorizacao              ,req.req_dataguia ");
        buf.append("         ,exr.met_codigo            ,con.lay_codigo       ,emc.emc_pagina         ,emc.emc_ordem ");
        buf.append("\t\t\t\t ,ordenacaoguia             ,fil.fil_cnes         ,exr.exa_codigopai      ,exr.mco_codigopai ");
        buf.append("         ,pac.pac_endereco          ,pac.pac_tipologradouroendereco               ,pac.pac_cep ");
        buf.append("         ,pac.bai_codigo            ,pac.cid_codigo       ,exa.exa_tipobpa \t\t\t\t,pac.pac_complemento ");
        buf.append("         ,pac.pac_numeroendereco    ,cid.cid_codigoibge   ,pac.pac_cartaosus\t\t\t,cid.cid_nome, bai.bai_descricao ");
        buf.append("         ,pac.pac_cor \t\t\t\t\t    ,pac.nli_codigo\t\t\t\t,pac.ein_codigo ");
        buf.append("         ,nac.nli_descricao \t\t\t\t,ein.ein_descricao ");
        StringBuilder aux = new StringBuilder();
        aux.append("         ,con.con_percpgto            ,con.con_fatfmaterial \t,con.con_faturarrecoleta ,con.con_multa ");
        aux.append("         ,con.con_bonus               ,con.con_acrescimo    \t,con.con_tpcalcfatu   \t ,con.con_tpcalcch ");
        aux.append("         ,con.con_cobrmaterial        ,con.con_valorch      \t,con.con_ordemfatura  \t ,con.con_titdep ");
        aux.append("         ,con.con_precosdiferenciados ,con.con_reajuste     \t,con.con_fatfiliais   \t ,con.con_descontoporte ");
        aux.append("\t\t\t\t ,con.con_percpgtomaterial \t\t,con.con_descontouco \t\t,con.con_acrescimoporte  ,con.con_acrescimouco ");
        aux.append("\t\t\t\t ,con.con_faturaeletronica  \t,dtp.tpp_porte          ,cpr.cpr_valor \t\t\t\t\t ,cpr.cpr_percentual ");
        aux.append("         ,exr.exr_valorcusto \t\t      ,exr.exr_porte          ,exr.exr_valoruco        ,exr.exr_valorporte ");
        aux.append("         ,exr.exr_datafatura          ,exr.exr_naofaturar     ,con.con_agrupaambguia   ,con.con_mora ");
        aux.append("         ,dtp.dtp_valor               ,dtp.dtp_percentual     ,dtp.dtp_valor           ,dtp.dtp_percentual ");
        if (ParametrosGerais.getPrecoMetodologia()) {
            aux.append("         ,dtm.dtm_valor             ,dtm.dtm_percentual     ,dtm.dtm_valor           ,dtm.dtm_percentual ,dtm.tpp_porte ");
        }
        buf.append(aux.toString());
        if (isConvenioRepasse) {
            aux = new StringBuilder(aux.toString().replaceAll(",con.", ",conprinc."));
            aux = new StringBuilder(aux.toString().replaceAll(",dtp.", ",dtpprinc."));
            aux = new StringBuilder(aux.toString().replaceAll(",cpr.", ",cprprinc."));
            if (ParametrosGerais.getPrecoMetodologia()) {
                aux = new StringBuilder(aux.toString().replaceAll(",dtm.", ",dtmprinc."));
            }
            aux = new StringBuilder(aux.toString().replaceAll("exr.exr_valorcusto", "exr.exr_valorcustorepasse"));
            aux = new StringBuilder(aux.toString().replaceAll("exr.exr_valoruco", "exr.exr_valorucorepasse"));
            aux = new StringBuilder(aux.toString().replaceAll("exr.exr_valorporte", "exr.exr_valorporterepasse"));
            aux = new StringBuilder(aux.toString().replaceAll("exr.exr_porte", "exr.exr_porterepasse"));
            aux = new StringBuilder(aux.toString().replaceAll("exr.exr_datafatura", "exr.exr_datafaturarepasse"));
            buf.append(aux.toString());
            buf.append(" ,cre.cre_tipocalculo \t\t\t,req.req_guiarepasse\t\t\t\t\t ,req.req_matricularepasse\t\t\t\t\t,req.req_validadeguiarepasse  ");
            buf.append(" ,req.req_deveguiarepasse\t\t,req.req_nomeplanorepasse\t\t\t ,req.req_validadecarteirarepasse\t  ,req.req_datarecebeuguiarepasse ");
            buf.append(" ,req.usr_codguiarepasse \t\t,req.req_guiaprincipalrepasse  ,conprinc.con_codigo \t\t\t\t\t\t\t,conprinc.con_razao ");
            buf.append(" ,conprinc.con_fantasia     ,aecprinc3.aec_ignorarmaterial ,req_validadeguia, ent_razaosocial ");
            return buf.toString();
        }
        buf.append(" ,req.req_guia\t\t\t\t   ,req.req_matricula\t\t          ,req.req_validadeguia\t\t\t\t,req.req_guiaprincipal ");
        buf.append(" ,req.req_deveguia\t\t   ,req.req_nomeplano\t\t          ,req.req_validadecarteira\t\t,req.req_datarecebeuguia ");
        buf.append(" ,req.usr_codrecebeuguia ,aec3.aec_ignorarmaterial      ,con.con_examesporguia, ent.ent_razaosocial ");
        return buf.toString();
    }

    private String getOrderBySelect(String ordemFatura, boolean ordenacaoTiss) {
        StringBuilder buf = new StringBuilder();
        buf.append(" order by ");
        if (ordemFatura == null || ordemFatura.equals("R")) {
            buf.append(" fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("D")) {
            buf.append(" req_data, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("F")) {
            buf.append(" req_dtfatura, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("N")) {
            buf.append(" ordemPaciente, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("G")) {
            buf.append(" ordenacaoguia, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("M")) {
            buf.append(" req_matricula, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("E")) {
            buf.append(" med_nome, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("C")) {
            buf.append(" med_crm, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("X")) {
            buf.append(" req_data, exr_guia, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("T")) {
            buf.append(" des_codigo, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("P")) {
            buf.append(" req_data, pac_nome, fil_codigo, req_codigo,");
        } else if (ordemFatura.equals("S")) {
            buf.append(" set_tipoalimentos, req_data,pac_nome, fil_codigo, req_codigo, set_codigo,");
        } else if (ordemFatura.equals("W")) {
            buf.append(" ent_razaosocial, fil_codigo, req_codigo, ");
        } else if (ordemFatura.equals("Z")) {
            buf.append(" ent_razaosocial, ordemPaciente, fil_codigo, req_codigo,");
        }
        buf.append(" con_codigo ");
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            buf.append(" ,exr_ordem, exa_codigo, mco_codigo ");
            return buf.toString();
        }
        if (ParametrosGerais.getOrdenarSetor()) {
            buf.append(" ,set_codigo ");
        }
        if (ParametrosGerais.getOrdemComprovante().equals("C")) {
            buf.append(" ,exa_codigo, mco_codigo ");
        } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
            buf.append(" ,emc_pagina, emc_ordem, exa_codigo, mco_codigo ");
        }
        return buf.toString();
    }

    public String getTipoOrdemFaturaConvenio(Statement st, String filial, String convenio) throws SQLException {
        String convenioAux;
        String filialAux;
        String string = filialAux = filial == null ? Variaveis.filialPadrao : filial;
        Object object = convenio == null ? (this.filtroConvenio == null || this.filtroConvenio.length == 0 ? null : this.filtroConvenio[0]) : (convenioAux = convenio);
        if (filialAux != null && convenioAux != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" select con_ordemfatura ");
            sb.append("   from convenios ");
            sb.append("  where fil_codigo = ").append(filialAux);
            sb.append("    and con_codigo = ").append(convenioAux);
            ResultSet rsFatura = Conexao.executeQuery(st, sb.toString());
            if (rsFatura.next()) {
                return rsFatura.getString("con_ordemfatura");
            }
        }
        return "R";
    }

    private boolean getOrdenacaoTiss(Statement st, String filial, String convenio) throws SQLException {
        String convenioAux;
        String filialAux;
        String string = filialAux = filial == null ? Variaveis.filialPadrao : filial;
        Object object = convenio == null ? (this.filtroConvenio == null || this.filtroConvenio.length == 0 ? null : this.filtroConvenio[0]) : (convenioAux = convenio);
        if (filialAux != null && convenioAux != null) {
            String conf;
            String eletronico;
            StringBuilder sb = new StringBuilder();
            sb.append(" select con_faturaeletronica ");
            sb.append("   from convenios ");
            sb.append("  where fil_codigo = ").append(filialAux);
            sb.append("    and con_codigo = ").append(convenioAux);
            ResultSet rsFatura = Conexao.executeQuery(st, sb.toString());
            if (rsFatura.next() && (eletronico = rsFatura.getString("con_faturaeletronica")) != null && !Funcoes.textoVazio(eletronico) && (conf = StringUtil.getValor(eletronico, "faturamentoEletronico")) != null && !Funcoes.textoVazio(conf) && (conf = StringUtil.getValor(conf, "ordenacaoTiss")) != null && !Funcoes.textoVazio(conf)) {
                return conf.toUpperCase().equalsIgnoreCase("TRUE");
            }
        }
        return false;
    }

    public String[] getFiltroColeta() {
        return this.filtroColeta;
    }

    public void setFiltroColeta(String[] filtroColeta) {
        this.filtroColeta = filtroColeta;
    }

    public String[] getFiltroDestino() {
        return this.filtroDestino;
    }

    public void setFiltroDestino(String[] filtroDestino) {
        this.filtroDestino = filtroDestino;
    }

    public String[] getFiltroEstacao() {
        return this.filtroEstacao;
    }

    public void setFiltroEstacao(String[] filtroEstacao) {
        this.filtroEstacao = filtroEstacao;
    }

    public String[] getFiltroConvenio() {
        return this.filtroConvenio;
    }

    public void setFiltroConvenio(String[] filtroConvenio) {
        this.filtroConvenio = filtroConvenio;
    }

    public String[] getFiltroSetor() {
        return this.filtroSetor;
    }

    public void setFiltroSetor(String[] filtroSetor) {
        this.filtroSetor = filtroSetor;
    }

    public String[] getFiltroGrupo() {
        return this.filtroGrupo;
    }

    public void setFiltroGrupo(String[] filtroGrupo) {
        this.filtroGrupo = filtroGrupo;
    }

    public String[] getFiltroMedicoConselho() {
        return this.filtroMedicoConselho;
    }

    public void setFiltroMedicoConselho(String[] filtroMedicoConselho) {
        this.filtroMedicoConselho = filtroMedicoConselho;
    }

    public String[] getFiltroMedicoCrm() {
        return this.filtroMedicoCrm;
    }

    public void setFiltroMedicoCrm(String[] filtroMedicoCrm) {
        this.filtroMedicoCrm = filtroMedicoCrm;
    }

    public String[] getFiltroMedicoUF() {
        return this.filtroMedicoUF;
    }

    public void setFiltroMedicoUF(String[] filtroMedicoUF) {
        this.filtroMedicoUF = filtroMedicoUF;
    }

    public String[] getFiltroSituacao() {
        return this.filtroSituacao;
    }

    public void setFiltroSituacao(String[] filtroSituacao) {
        this.filtroSituacao = filtroSituacao;
    }

    public String[] getFiltroSituacaoExames() {
        return this.filtroSituacaoExames;
    }

    public void setFiltroSituacaoExames(String[] filtroSituacaoExames) {
        this.filtroSituacaoExames = filtroSituacaoExames;
    }

    public String[] getFiltroPaciente() {
        return this.filtroPaciente;
    }

    public void setFiltroPaciente(String[] filtroPaciente) {
        this.filtroPaciente = filtroPaciente;
    }

    public String[] getFiltroExame() {
        return this.filtroExame;
    }

    public void setFiltroExame(String[] filtroExame) {
        this.filtroExame = filtroExame;
    }

    public String[] getFiltroUnidadeSaude() {
        return this.filtroUnidadeSaude;
    }

    public void setFiltroUnidadeSaude(String[] filtroUnidadeSaude) {
        this.filtroUnidadeSaude = filtroUnidadeSaude;
    }

    public String[] getFiltroEmpresa() {
        return this.filtroEmpresa;
    }

    public void setFiltroEmpresa(String[] filtroEmpresa) {
        this.filtroEmpresa = filtroEmpresa;
    }

    public String getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(String dataInicio) {
        this.dataInicio = dataInicio;
    }

    public String getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(String dataFim) {
        this.dataFim = dataFim;
    }

    public String getHoraInicio() {
        return this.horaInicio;
    }

    public void setHoraInicio(String horaInicio) {
        this.horaInicio = horaInicio;
    }

    public String getHoraFim() {
        return this.horaFim;
    }

    public void setHoraFim(String horaFim) {
        this.horaFim = horaFim;
    }

    public boolean isApenasConferidas() {
        return this.apenasConferidas;
    }

    public void setApenasConferidas(boolean apenasConferidas) {
        this.apenasConferidas = apenasConferidas;
    }

    public boolean isVerificarConferidos() {
        return this.isVerificarConferidos;
    }

    public void setVerificarConferidos(boolean isVerificarConferidos) {
        this.isVerificarConferidos = isVerificarConferidos;
    }

    public boolean isApenasComResultado() {
        return this.apenasComResultado;
    }

    public void setApenasComResultado(boolean apenasComResultado) {
        this.apenasComResultado = apenasComResultado;
    }

    public boolean isExibirNaoFaturar() {
        return this.isExibirNaoFaturar;
    }

    public void setExibirNaoFaturar(boolean isExibirNaoFaturar) {
        this.isExibirNaoFaturar = isExibirNaoFaturar;
    }

    public String getTextoFiltroConvenio() {
        return this.textoFiltroConvenio;
    }

    public void setTextoFiltroConvenio(String textoFiltroConvenio) {
        this.textoFiltroConvenio = textoFiltroConvenio;
    }

    public void insert(String codigo, String filialPadrao, DadosFaturamento dados) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append(" insert ");
        buf.append("   into faturarequisicao (fil_codigo ");
        buf.append("                         ,fil_kodigo ");
        buf.append("                         ,fat_codigo ");
        buf.append("                         ,req_codigo ");
        buf.append("                         ,con_codigo ");
        buf.append("                         ,fre_total ");
        buf.append("                         ,fre_totalch ");
        buf.append("                         ,fre_totalexames ");
        buf.append("                         ,fre_totalmateriais) ");
        buf.append(" values (").append(filialPadrao);
        buf.append("        ,").append(String.valueOf(dados.getCodigoFilial()));
        buf.append("        ,").append(codigo);
        buf.append("        ,").append(dados.getRequisicao());
        buf.append("        ,").append(dados.getCodigoConvenio());
        buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotal())));
        buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotalCH())));
        buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotalExames())));
        buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotalMateriais()))).append(") ");
        Conexao.execute(filialPadrao, Conexao.getStatement(), buf.toString());
    }

    public FaturaRequisicaoVO buscaPorCodigo(String codigo, String filialPadrao, DadosFaturamento dados) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append(" select fat_codigo, req_codigo, fre_totalmateriais, fre_totalexames, ");
        buf.append(" fre_totalch, fre_total, con_codigo ");
        buf.append(" from faturarequisicao where ");
        buf.append("fil_codigo = ").append(filialPadrao);
        buf.append(" and fil_kodigo = ").append(String.valueOf(dados.getCodigoFilial()));
        buf.append(" and req_codigo = ").append(dados.getRequisicao());
        buf.append(" and fat_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        FaturaRequisicaoVO faturaRequisicao = null;
        while (rs.next()) {
            faturaRequisicao = new FaturaRequisicaoVO();
            ConvenioVO convenio = new ConvenioVO();
            convenio.setCodigo(rs.getInt("con_codigo"));
            faturaRequisicao.setConvenio(convenio);
            faturaRequisicao.setFatura(Integer.valueOf(codigo));
            RequisicaoVO requisicaoVO = new RequisicaoVO();
            requisicaoVO.setCodigo(rs.getInt("req_codigo"));
            faturaRequisicao.setRequisicao(requisicaoVO);
            faturaRequisicao.setTotalCh(rs.getBigDecimal("fre_totalch"));
            faturaRequisicao.setTotal(rs.getBigDecimal("fre_total"));
            faturaRequisicao.setTotalExames(rs.getBigDecimal("fre_totalexames"));
            faturaRequisicao.setTotalMateriais(rs.getBigDecimal("fre_totalmateriais"));
        }
        return faturaRequisicao;
    }

    public void update(String codigo, String filialPadrao, DadosFaturamento dados, FaturaRequisicaoVO faturaRequisicao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append(" update ");
        buf.append(" faturarequisicao ");
        buf.append(" set fre_total = ").append(Funcoes.limpaDecimal(String.valueOf(faturaRequisicao.getTotal().add(dados.getValorTotal()))));
        buf.append(" ,fre_totalch = ").append(Funcoes.limpaDecimal(String.valueOf(faturaRequisicao.getTotalCh().add(dados.getValorTotalCH()))));
        buf.append(" ,fre_totalexames = ").append(Funcoes.limpaDecimal(String.valueOf(faturaRequisicao.getTotalExames().add(dados.getValorTotalExames()))));
        buf.append(" ,fre_totalmateriais = ").append(Funcoes.limpaDecimal(String.valueOf(faturaRequisicao.getTotalMateriais().add(dados.getValorTotalMateriais()))));
        buf.append(" where ");
        buf.append("fil_codigo = ").append(filialPadrao);
        buf.append(" and fil_kodigo = ").append(String.valueOf(dados.getCodigoFilial()));
        buf.append(" and req_codigo = ").append(dados.getRequisicao());
        buf.append(" and fat_codigo = ").append(codigo);
        Conexao.execute(filialPadrao, Conexao.getStatement(), buf.toString());
    }
}

