/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.service.financeiro.ReceberPagarService;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;

public class FaturaDao
extends AbstractThreadDao {
    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and fat_codigo = " + codigo;
        Set fats = FaturaDao.load(FaturaBean.class, where);
        if (fats == null || fats.size() == 0 || fats.size() > 1) {
            return null;
        }
        FaturaBean fat = (FaturaBean)fats.toArray()[0];
        try {
            fat.setComissaoGerada(this.isComissaoGerada(fat));
        }
        catch (SQLException sqle) {
            fat.setComissaoGerada(false);
        }
        return fat;
    }

    public boolean isComissaoGerada(String filial, String codigoFatura) throws SQLException {
        FaturaBean fatura = new FaturaBean();
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        fatura.setFilial(filialVO);
        fatura.setCodigo(Integer.parseInt(codigoFatura));
        return this.isComissaoGerada(fatura);
    }

    private boolean isComissaoGerada(FaturaBean fatura) throws SQLException {
        if (fatura == null || fatura.getFilial() == null || fatura.getCodigo() == null) {
            return false;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct a.* ");
        buf.append("   from fatura a ");
        buf.append("   join faturarequisicao fre on a.fil_codigo = fre.fil_codigo and a.fat_codigo = fre.fat_codigo ");
        buf.append("   join requisicao req on fre.fil_codigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("   join convenioentidade cen on con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo ");
        buf.append("   join entidade ent on cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo ");
        buf.append("  where a.fil_codigo = ").append(fatura.getFilial().getCodigo());
        buf.append("    and a.fat_codigo = ").append(fatura.getCodigo());
        buf.append("    and (a.fat_datacomissao IS NOT NULL ");
        buf.append("         or (select COUNT(1) ");
        buf.append("               from receberpagar rpg ");
        buf.append("               join notafiscal nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo ");
        buf.append("               join faturanotafiscal fnf on nfi.fil_codigo = fnf.fil_codigo and nfi.nfi_codigo = fnf.nfi_codigo ");
        buf.append("               join fatura fat on fnf.fil_codigo = fat.fil_codigo and fnf.fat_codigo = fat.fat_codigo ");
        buf.append("              where fat.fat_codigo = a.fat_codigo ");
        buf.append("                and fat.fil_codigo = a.fil_codigo ");
        buf.append("                and rpg.rpg_origem = '").append("C").append("' ");
        buf.append("                and rpg.rpg_tipo = '").append("P").append("' ");
        buf.append("                and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("') ");
        buf.append("            ) > 0) ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            Conexao.fecharStatement(st);
            rs.close();
            return true;
        }
        Conexao.fecharStatement(st);
        rs.close();
        return false;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and fat_codigo = " + codigo;
        Set fats = this.loadVO(FaturaVO.class, where);
        if (fats == null || fats.size() == 0 || fats.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)fats.toArray()[0];
    }

    @Override
    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        AbstractThreadBean bean = super.voToBean(vo, classeBean);
        return bean;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    public boolean isFaturaConferida(String filial, String codigoFatura) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select case when fat_dtconferencia IS NULL then false else true end as conferida ");
        buf.append("   from fatura ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and fat_codigo = ").append(codigoFatura);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getBoolean("conferida");
        }
        return false;
    }

    public ArrayList<ReceberPagarBean> getTitulosComissaoFatura(String codigoFilial, String codigoFatura) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_codigo ");
        buf.append("       ,rpg_codigo ");
        buf.append("   from faturareceberpagar ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and fat_codigo = ").append(codigoFatura);
        buf.append("    and frp_tipo = '").append("C").append("' ");
        ArrayList<ReceberPagarBean> listaRecPag = null;
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            listaRecPag = new ArrayList<ReceberPagarBean>();
            ReceberPagarService service = new ReceberPagarService();
            do {
                ReceberPagarBean recPag = (ReceberPagarBean)service.get(codigoFilial, rs.getString("rpg_codigo"));
                listaRecPag.add(recPag);
            } while (rs.next());
            return listaRecPag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getValorRestanteFatura(String codigoFilial, String codigoFatura) throws SQLException {
        Statement st;
        block2: {
            BigDecimal bigDecimal;
            StringBuilder buf = new StringBuilder();
            buf.append(" select (fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100)) - SUM(COALESCE(fnf.fnf_valorfatura, 0)) as valorRestante ");
            buf.append("   from fatura fat ");
            buf.append("   left join faturanotafiscal fnf on fat.fil_codigo = fnf.fil_codigo and fat.fat_codigo = fnf.fat_codigo ");
            buf.append("  where fat.fil_codigo = ").append(codigoFilial);
            buf.append("    and fat.fat_codigo = ").append(codigoFatura);
            buf.append("  group by fat.fat_totalexames ");
            buf.append("          ,fat.fat_totalmateriais ");
            buf.append("          ,fat.fat_adicional ");
            buf.append("          ,fat_despcobranca ");
            buf.append("          ,fat_percacrescimo ");
            buf.append("          ,fat_percdesconto ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block2;
                bigDecimal = rs.getBigDecimal("valorRestante");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bigDecimal;
        }
        Conexao.fecharStatement(st);
        return null;
    }
}

