/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.util.impressao.sql.ValorIn;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.financeiro.ExportarFaturasVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ExportarFaturasDao
extends AbstractThreadDao {
    private final String CODIGO = "C\u00f3digo";
    private int casas = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();

    public ArrayList<ExportarFaturasVO> getBean(Integer[] filiais, Integer[] convenios, String ordem, String dataInicio, String dataFim, boolean filtrarPorVencimento, boolean reenviarArquivo) throws ThreadDaoException {
        ValorIn fil = new ValorIn(filiais);
        ValorIn con = new ValorIn(convenios);
        StringBuilder sql = new StringBuilder(this.getSQLConsulta(fil.toString(), con.toString(), ordem, dataInicio, dataFim, filtrarPorVencimento, reenviarArquivo));
        ArrayList<ExportarFaturasVO> fats = this.loadFaturas(sql.toString());
        if (fats == null || fats.size() == 0) {
            return null;
        }
        return fats;
    }

    private ArrayList<ExportarFaturasVO> loadFaturas(String sql) throws ThreadDaoException {
        ArrayList<ExportarFaturasVO> faturas = new ArrayList<ExportarFaturasVO>();
        ExportarFaturasVO exp = null;
        int codigoFaturaAnterior = 0;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQueryPerformance(st, sql.toString());
            while (rs.next()) {
                if (this.isMesmaFatura(codigoFaturaAnterior, rs)) {
                    this.setValorTipoAlimentos(exp, rs);
                    continue;
                }
                exp = new ExportarFaturasVO();
                exp.setTotalFisicoQuimico(new Double(0.0));
                exp.setTotalMicrobiologico(new Double(0.0));
                exp.setTotalOutros(new Double(0.0));
                exp.setTotalCromatografia(new Double(0.0));
                FaturaVO fat = new FaturaVO();
                FilialVO fil = new FilialVO();
                fil.setCodigo(rs.getInt("fil_codigo"));
                fat.setFilial(fil);
                fat.setCodigo(rs.getInt("fat_codigo"));
                ConvenioVO convenio = new ConvenioVO();
                convenio.setCodigo(rs.getInt("con_codigo"));
                convenio.setFantasia(rs.getString("con_fantasia"));
                fat.setConvenio(convenio);
                fat.setDataEmissao(rs.getDate("fat_dtemis"));
                fat.setPercentualAcrescimo(rs.getDouble("fat_percacrescimo"));
                fat.setPercentualDesconto(rs.getDouble("fat_percdesconto"));
                fat.setValorAdicional(rs.getDouble("fat_adicional"));
                fat.setValorDespesaCobranca(rs.getDouble("fat_despcobranca"));
                fat.setPercentualDesconto(rs.getDouble("fat_percdesconto"));
                fat.setValorTotalExames(rs.getDouble("fat_totalexames"));
                fat.setValorTotalMateriais(rs.getDouble("fat_totalmateriais"));
                fat.setVencimento(rs.getDate("fat_dtvenc"));
                fat.setDataArquivo(rs.getDate("fat_dataarquivo"));
                this.setValorTipoAlimentos(exp, rs);
                exp.setFatura(fat);
                faturas.add(exp);
                codigoFaturaAnterior = rs.getInt("fat_codigo");
            }
        }
        catch (SQLException e) {
            throw new ThreadDaoException(e.getMessage() + "\n" + sql.toString());
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return faturas;
    }

    private void setValorTipoAlimentos(ExportarFaturasVO exp, ResultSet rs) throws SQLException {
        if (this.isTipoFisicoQuimico(rs.getString("set_tipoalimentos"))) {
            exp.setTotalFisicoQuimico(this.soma(exp.getTotalFisicoQuimico(), rs.getDouble("fer_total")));
        } else if (this.isTipoMicrobiologico(rs.getString("set_tipoalimentos"))) {
            exp.setTotalMicrobiologico(this.soma(exp.getTotalMicrobiologico(), rs.getDouble("fer_total")));
        } else if (this.isTipoCromatografia(rs.getString("set_tipoalimentos"))) {
            exp.setTotalCromatografia(this.soma(exp.getTotalCromatografia(), rs.getDouble("fer_total")));
        } else {
            exp.setTotalOutros(this.soma(exp.getTotalOutros(), rs.getDouble("fer_total")));
        }
    }

    private Double soma(Double totalTipo, Double valor) {
        if (totalTipo != null) {
            return new BigDecimal(String.valueOf(totalTipo)).add(new BigDecimal(String.valueOf(valor))).doubleValue();
        }
        return valor;
    }

    private boolean isMesmaFatura(int codigoFaturaAnterior, ResultSet rs) throws SQLException {
        return rs.getInt("fat_codigo") == codigoFaturaAnterior;
    }

    private boolean isTipoFisicoQuimico(String tipo) {
        return tipo.equalsIgnoreCase("F");
    }

    private boolean isTipoMicrobiologico(String tipo) {
        return tipo.equalsIgnoreCase("M");
    }

    private boolean isTipoCromatografia(String tipo) {
        return tipo.equalsIgnoreCase("C");
    }

    private String getSQLConsulta(String filiais, String convenios, String ordem, String dataInicio, String dataFim, boolean filtrarPorVencimento, boolean reenviarArquivo) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT s.set_tipoalimentos, ");
        sql.append("       fat_dtemis,");
        sql.append("       fer.fer_total, ");
        sql.append("       fat_totalexames, ");
        sql.append("       fat_dataarquivo, ");
        sql.append("       a.fat_codigo, fat_percacrescimo, ");
        sql.append("       c.con_codigo, ");
        sql.append("       c.con_fantasia, ");
        sql.append("       fat_datahora, ");
        sql.append("       fat_dtvenc, ");
        sql.append("       fat_totalexamesch, ");
        sql.append("       fat_totalmateriais, ");
        sql.append("       fat_dtinicio, ");
        sql.append("       fat_adicional, ");
        sql.append("       fat_percdesconto, ");
        sql.append("       fat_despcobranca, ");
        sql.append("       fat_dtfim, ");
        sql.append("       a.fil_codigo ");
        sql.append("FROM   fatura a ");
        sql.append("       LEFT JOIN faturaexamerequisicao fer on a.fil_codigo = fer.fil_codigo");
        sql.append("                                          AND a.fat_codigo = fer.fat_codigo");
        sql.append("       LEFT JOIN examematcoleta emc on fer.fil_codigo = emc.fil_codigo");
        sql.append("                                   AND fer.exa_codigo = emc.exa_codigo");
        sql.append("                                   AND fer.mco_codigo = emc.mco_codigo");
        sql.append("       LEFT JOIN examesetor es on fer.fil_codigo = es.fil_codigo");
        sql.append("                              AND fer.exa_codigo = es.exa_codigo");
        sql.append("                              AND es.ese_default ");
        sql.append("       LEFT JOIN setores s on es.fil_codigo = s.fil_codigo");
        sql.append("                          AND es.set_codigo = s.set_codigo");
        sql.append("       LEFT JOIN convenios c ON a.fil_codigo = c.fil_codigo ");
        sql.append("                          AND a.con_codigo = c.con_codigo");
        sql.append(" WHERE a.fil_codigo in (").append(filiais).append(") ");
        sql.append(" AND c.con_codigo in (").append(convenios).append(") ");
        if (!reenviarArquivo) {
            sql.append(" and fat_dataarquivo  is null ");
        }
        sql.append(" and fat_datacancelamento is null ");
        if (filtrarPorVencimento) {
            sql.append(" AND fat_dtvenc >= '").append(Funcoes.formataData("yyyy/MM/dd", dataInicio)).append("' AND fat_dtvenc <= '").append(Funcoes.formataData("yyyy/MM/dd", dataFim)).append("'");
        } else {
            sql.append(" AND fat_dtemis >= '").append(Funcoes.formataData("yyyy/MM/dd", dataInicio)).append("' AND fat_dtemis <= '").append(Funcoes.formataData("yyyy/MM/dd", dataFim)).append("'");
        }
        sql.append(" ORDER BY ").append(this.getOrdem(ordem));
        return sql.toString();
    }

    private Object getOrdem(String ordem) {
        if (ordem.equalsIgnoreCase("C\u00f3digo")) {
            return "fat_codigo , con_fantasia";
        }
        return "con_fantasia, fat_codigo ";
    }

    public void atualizarDataArquivo(ExportarFaturasVO fat) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        String dataServidor = this.retornaDate();
        buf.append("UPDATE fatura SET fat_dataarquivo = '").append(Funcoes.formatDataHora(dataServidor)).append("'");
        buf.append(" WHERE fil_codigo = ").append(fat.getFatura().getFilial().getCodigo());
        buf.append("   AND fat_codigo = ").append(fat.getFatura().getCodigo());
        Conexao.executeUpdatePerformance(String.valueOf(fat.getFatura().getFilial().getCodigo()), st, buf.toString());
        Conexao.arquivaSQL();
    }

    private String retornaDate() {
        Date dataAtual = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dtAtual = sdf.format(dataAtual);
        return dtAtual;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

