/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.financeiro.contrassenha.RequisicaoContrassenhaVO;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.financeiro.ContrasSenhaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.financeiro.ContrasSenhaVO;
import jalis.model.vo.recepcao.ContrasSenhaRequisicaoVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ContrasSenhaDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ContrasSenhaDao.load(ContrasSenhaBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ContrasSenhaBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(ContrasSenhaVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ContrasSenhaVO)aux.toArray()[0];
    }

    public List<RequisicaoContrassenhaVO> getDadosRequisicaoContrassenha(String codigoPaciente) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuffer buf = new StringBuffer("");
        buf.append("select a.req_codigo, a.req_data, a.con_codigo, b.con_fantasia, c.pac_codigo, c.pac_nome, ");
        buf.append("a.req_total, a.req_totpago, a.req_desconto, a.req_vlrdesconto, a.req_acrescimo, a.req_vlracrescimo, b.con_percvalorminimo ");
        buf.append("from requisicao a ");
        buf.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
        buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.pac_codigo = ");
        buf.append(codigoPaciente);
        buf.append(" and a.req_excluida = false ");
        buf.append(" order by a.req_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        ArrayList<RequisicaoContrassenhaVO> listaContrassenhaRequisicaoVO = new ArrayList<RequisicaoContrassenhaVO>();
        while (rs.next()) {
            RequisicaoContrassenhaVO contrassenhaRequisicaoVO = new RequisicaoContrassenhaVO();
            RequisicaoVO requisicaoVO = new RequisicaoVO();
            requisicaoVO.setCodigo(rs.getInt("req_codigo"));
            requisicaoVO.setData(rs.getDate("req_data"));
            requisicaoVO.setTotalPago(rs.getDouble("req_totpago"));
            requisicaoVO.setTotal(rs.getDouble("req_total"));
            requisicaoVO.setDesconto(rs.getDouble("req_desconto"));
            requisicaoVO.setValorDesconto(rs.getDouble("req_vlrdesconto"));
            requisicaoVO.setAcrescimo(rs.getDouble("req_acrescimo"));
            requisicaoVO.setValorAcrescimo(rs.getDouble("req_vlracrescimo"));
            contrassenhaRequisicaoVO.setRequisicaoVO(requisicaoVO);
            ConvenioVO convenioVO = new ConvenioVO();
            convenioVO.setCodigo(rs.getInt("con_codigo"));
            convenioVO.setFantasia(rs.getString("con_fantasia"));
            convenioVO.setPercValorMinimoRequisicao(rs.getDouble("con_percvalorminimo"));
            contrassenhaRequisicaoVO.setConvenioVO(convenioVO);
            PacienteVO pacienteVO = new PacienteVO();
            pacienteVO.setCodigo(rs.getInt("pac_codigo"));
            pacienteVO.setNome(rs.getString("pac_nome"));
            contrassenhaRequisicaoVO.setPacienteVO(pacienteVO);
            listaContrassenhaRequisicaoVO.add(contrassenhaRequisicaoVO);
        }
        return listaContrassenhaRequisicaoVO;
    }

    public List<ExameRequisicaoVO> getDadosExameRequisicaoContrassenha(String filial, String codigoRequisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuffer buf = new StringBuffer("");
        buf.delete(0, buf.length());
        buf.append("select a.exa_codigo, b.exa_descricao, a.mco_codigo from examerequisicao a ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and a.req_codigo = ");
        buf.append(codigoRequisicao);
        buf.append(" and a.exr_excluido = false ");
        buf.append(" order by a.exa_codigo ");
        ResultSet rsExm = st.executeQuery(buf.toString());
        ArrayList<ExameRequisicaoVO> listaContrassenhaExameRequisicao = new ArrayList<ExameRequisicaoVO>();
        while (rsExm.next()) {
            ExameRequisicaoVO exameRequisicaoVO = new ExameRequisicaoVO();
            ExameVO exameVO = new ExameVO();
            exameVO.setCodigo(rsExm.getString("exa_codigo"));
            exameVO.setDescricao(rsExm.getString("exa_descricao"));
            MaterialColetaVO exameMaterialVO = this.getDadosMaterial(filial, rsExm.getString("mco_codigo"));
            exameRequisicaoVO.setExame(exameVO);
            exameRequisicaoVO.setMaterial(exameMaterialVO);
            listaContrassenhaExameRequisicao.add(exameRequisicaoVO);
        }
        return listaContrassenhaExameRequisicao;
    }

    public MaterialColetaVO getDadosMaterial(String filial, String codigoMaterial) throws SQLException {
        StringBuilder buf = new StringBuilder("select mco_codigo, mco_descricao, mco_solicitarmat, mco_abreviatura, mco_solicitararea ");
        buf.append("from materialcoleta ");
        buf.append("where fil_codigo = ");
        buf.append(filial);
        buf.append(" and mco_codigo = ");
        buf.append(String.valueOf(codigoMaterial));
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            MaterialColetaVO materialColetaVO = new MaterialColetaVO();
            materialColetaVO.setCodigo(rs.getInt("mco_codigo"));
            materialColetaVO.setDescricao(rs.getString("mco_descricao"));
            return materialColetaVO;
        }
        return null;
    }

    public void inserirContrassenha(String filial, String valorDesconto, String motivo) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("insert into contrasenha(fil_codigo, cse_codigo, cse_desconto, cse_datahora, ");
        buf.append("cse_motivo, usr_codigo) values (");
        buf.append(filial);
        buf.append(", ");
        buf.append(DBUtil.getSequencia(st, "contrasenha", true));
        buf.append(", ");
        if (Funcoes.isNumeric(valorDesconto)) {
            buf.append(Funcoes.limpaDecimal(valorDesconto));
        } else {
            buf.append("0");
        }
        buf.append(", current_timestamp, '");
        buf.append(StringUtil.textoDB(motivo));
        buf.append("', '");
        buf.append(Variaveis.login);
        buf.append("')");
        Conexao.execute(filial, st, buf.toString());
        Conexao.arquivaSQL();
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    public String retornaPacienteNome(String filial, String codPaciente) throws SQLException {
        String paciente = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select a.pac_nome ");
        buf.append("from paciente a ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.pac_codigo = ");
        buf.append(codPaciente);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            paciente = rs.getString("pac_nome");
        }
        return paciente;
    }

    public ContrasSenhaRequisicaoVO retornaContrasSenhaRequisicao(String filial, String senha) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo, cse_codigo, pac_codigo, con_codigo, med_conselho, med_crm, ");
        buf.append("med_uf, usr_codigo, usr_codgerada, cse_datahora, cse_datahoragerada, ");
        buf.append("cse_valorbalcao, cse_tipo, cse_totalrequisicao, cse_valorpagorequisicao ");
        buf.append(" from contrassenharequisicao ");
        buf.append(" where fil_codigo = ").append(filial);
        buf.append(" and cse_codigo = ").append(senha);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(buf.toString());
        ContrasSenhaRequisicaoVO contrassenhaRequisicaoVO = null;
        while (rs.next()) {
            contrassenhaRequisicaoVO = new ContrasSenhaRequisicaoVO();
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(rs.getInt("fil_codigo"));
            contrassenhaRequisicaoVO.setFilial(filialVO);
            ContrasSenhaVO contrasSenhaVO = new ContrasSenhaVO();
            contrasSenhaVO.setCodigo(rs.getInt("cse_codigo"));
            contrassenhaRequisicaoVO.setContrasSenha(contrasSenhaVO);
            PacienteVO pacienteVO = new PacienteVO();
            pacienteVO.setCodigo(rs.getInt("pac_codigo"));
            contrassenhaRequisicaoVO.setPaciente(pacienteVO);
            ConvenioVO convenioVO = new ConvenioVO();
            convenioVO.setCodigo(rs.getInt("con_codigo"));
            convenioVO.setPercValorMinimoRequisicao(new ConvenioService().retornaPercentualConvenio(rs.getInt("fil_codigo"), rs.getInt("con_codigo")));
            contrassenhaRequisicaoVO.setConvenio(convenioVO);
            MedicoVO medicoVO = new MedicoVO();
            medicoVO.setConselho(rs.getString("med_conselho"));
            medicoVO.setCrm(rs.getString("med_crm"));
            medicoVO.setUf(rs.getString("med_uf"));
            contrassenhaRequisicaoVO.setMedico(medicoVO);
            contrassenhaRequisicaoVO.setValorPago(rs.getDouble("cse_valorpagorequisicao"));
            contrassenhaRequisicaoVO.setValorTotalRequisicao(rs.getDouble("cse_totalrequisicao"));
        }
        return contrassenhaRequisicaoVO;
    }
}

