/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;

public class ConferenciaGuiasDAO {
    private final String CAMPO_EXAMES = "examesrequisicao";
    private final String CAMPO_GRAVAR_REQUISICAO = "gravardados";
    private final String CAMPO_GRAVAR_EXAME = "gravardadosexame";
    private final String CAMPO_REMOVER = "removerconferencia";
    private final String CAMPO_ALTERADA_MATRICULA = "matriculaalterada";
    private final String CAMPO_ALTERADA_VALIDADE = "validadealterada";

    public void atualizaDadosExamesAgrupados(Registro req, Registro exame) throws ParseException, SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" update examerequisicao ");
        buf.append("     set exr_codautorizacao =  '").append(StringUtil.textoDB(exame.getString("exr_codautorizacao"))).append("'");
        buf.append("    , exr_naofaturar = ").append(exame.getBoolean("exr_naofaturar") ? "true" : "false");
        buf.append(this.getCamposUpdate(req, exame));
        buf.append("  where fil_codigo = ").append(req.getString("fil_codigo"));
        buf.append("    and req_codigo = ").append(req.getString("req_codigo"));
        if (!exame.getBoolean("agrupado")) {
            buf.append("    and exa_codigo = '").append(StringUtil.textoDB(exame.getString("exa_codigo"))).append("'");
            buf.append("    and mco_codigo = ").append(exame.getString("mco_codigo"));
            Conexao.executeUpdate(req.getString("fil_codigo"), st, buf.toString());
            DBUtil.gravaLogSituacaoExameRequisicao(st, req.getString("fil_codigo"), req.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), exame.getString("exr_situacao"), false);
        } else {
            buf.append("    and exa_codigo = '").append(StringUtil.textoDB(exame.getString("codigoexamepai"))).append("'");
            buf.append("    and mco_codigo = ").append(exame.getString("materialexamepai"));
            Conexao.executeUpdate(req.getString("fil_codigo"), st, buf.toString());
            if (this.atualizouRegistro(req, exame)) {
                this.inseriExameRequisicaoAgrupada(req, exame);
            }
        }
    }

    private String getCamposUpdate(Registro req, Registro exame) throws ParseException, SQLException {
        StringBuilder buf = new StringBuilder();
        if (!exame.getBoolean("agrupado")) {
            buf.append("\t     ,usr_codnaofaturar = ").append(exame.getBoolean("exr_naofaturar") ? "'" + StringUtil.textoDB(Variaveis.login) + "'" : "null");
            buf.append("       ,exr_guia = ").append(exame.getString("exr_guia") == null ? " null " : "'" + StringUtil.textoDB(exame.getString("exr_guia")).trim() + "' ");
            buf.append(this.verificaData(exame, "exr_dataguia"));
            buf.append(this.verificaData(exame, "exr_validadeguia"));
            buf.append("       ,exr_deveguia = ").append(exame.getBoolean("exr_deveguia"));
            buf.append(this.verificaData(exame, "exr_dataautorizacao"));
            buf.append(this.verificaData(exame, "exr_datavalidadeautorizacao"));
            if (exame.getString("exr_situacao").equals("A")) {
                buf.append("     ,exr_datadigita = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("' ");
                buf.append("     ,exr_situacao = '").append(exame.getString("exr_situacao")).append("' ");
            }
        } else {
            buf.append(this.verificaData(exame, "exr_dataautorizacao"));
            buf.append(this.verificaData(exame, "exr_datavalidadeautorizacao"));
        }
        return buf.toString();
    }

    public int atualizaExameRequisicaoAgrupada(Registro req, Registro exame) throws ParseException, SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" update examerequisicaoguiaagrupada ");
        buf.append("    set exg_guia = ").append(exame.getString("exr_guia") == null ? " null " : "'" + StringUtil.textoDB(exame.getString("exr_guia")).trim() + "' ");
        buf.append("       ,exg_validadeguia = ").append(exame.getDate("exr_validadeguia") == null ? " null " : "'" + exame.getDate("exr_validadeguia") + "' ");
        buf.append("       ,exg_dataguia = ").append(exame.getDate("exr_dataguia") == null ? " null " : "'" + exame.getDate("exr_dataguia") + "' ");
        buf.append("       ,exg_deveguia = ").append(exame.getBoolean("exr_deveguia"));
        buf.append("  where fil_codigo = ").append(req.getString("fil_codigo"));
        buf.append("    and req_codigo = ").append(req.getString("req_codigo"));
        buf.append("    and exa_codigo = '").append(exame.getString("codigoexamepai")).append("' ");
        buf.append("    and mco_codigo = ").append(exame.getString("materialexamepai"));
        buf.append("    and exa_codfilho = '").append(exame.getString("exa_codigo")).append("' ");
        buf.append("    and mco_codfilho = ").append(exame.getString("mco_codigo"));
        return Conexao.executeUpdate(req.getString("fil_codigo"), st, buf.toString());
    }

    public void inseriExameRequisicaoAgrupada(Registro req, Registro exame) throws ParseException, SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" insert into examerequisicaoguiaagrupada ");
        buf.append("      values(").append(req.getString("fil_codigo"));
        buf.append("            ,'").append(exame.getString("codigoexamepai")).append("' ");
        buf.append("            ,'").append(exame.getString("exa_codigo")).append("' ");
        buf.append("            ,").append(exame.getInt("materialexamepai"));
        buf.append("            ,").append(exame.getInt("mco_codigo"));
        buf.append("            ,").append(req.getString("req_codigo"));
        if (exame.getString("exr_guia") != null) {
            buf.append("            ,'").append(StringUtil.textoDB(exame.getString("exr_guia")).trim()).append("' ");
        } else {
            buf.append("            ,null ");
        }
        if (exame.getDate("exr_validadeguia") != null) {
            buf.append("          ,'").append(exame.getDate("exr_validadeguia")).append("' ");
        } else {
            buf.append("          ,null ");
        }
        buf.append("            ,").append(exame.getBoolean("exr_deveguia"));
        if (exame.getDate("exr_dataguia") != null) {
            buf.append("          ,'").append(exame.getDate("exr_dataguia")).append("' ");
        } else {
            buf.append("          ,null ");
        }
        buf.append(") ");
        Conexao.executeUpdate(req.getString("fil_codigo"), st, buf.toString());
    }

    private boolean atualizouRegistro(Registro req, Registro exame) throws ParseException, SQLException {
        return this.atualizaExameRequisicaoAgrupada(req, exame) == 0;
    }

    public void updateDadosRequisicao(Registro req) throws ParseException, SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("update requisicao set  ");
        buf.append("req_deveguia = ").append(req.getBoolean("req_deveguia") ? "true" : "false").append(", ");
        if (req.getBoolean("deviaguia") || req.getBoolean("req_deveguia")) {
            buf.append("usr_codrecebeuguia = ").append(req.getBoolean("deviaguia") ? "'" + StringUtil.textoDB(Variaveis.login) + "'" : "null").append(", ");
            buf.append("req_datarecebeuguia = ").append(req.getBoolean("deviaguia") ? "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date()) + "'" : "null").append(", ");
        }
        buf.append("req_titular = '").append(StringUtil.textoDB(req.getString("req_titular"))).append("' ");
        if (req.getBoolean("gravarConferido")) {
            buf.append(",req_dataguiaconferida = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("', ");
            buf.append("usr_codguiaconferida = '").append(StringUtil.textoDB(Variaveis.login)).append("' ");
        } else if (req.getBoolean("removerconferencia")) {
            buf.append(",req_dataguiaconferida = null, usr_codguiaconferida = null ");
        }
        if (req.getBoolean("matriculaalterada")) {
            buf.append(", req_matricula = '").append(StringUtil.textoDB(req.getString("req_matricula"))).append("' ");
            buf.append(", req_guia = '").append(StringUtil.textoDB(req.getString("req_guia"))).append("' ");
        } else {
            buf.append(", req_guia = ").append(req.getString("req_guia") == null ? " null " : "'" + req.getString("req_guia") + "' ");
        }
        buf.append(", req_guiaprincipal = ").append(req.getString("req_guiaprincipal") == null ? " null " : "'" + req.getString("req_guiaprincipal") + "' ");
        buf.append(this.verificaData(req, "req_validadeguia"));
        buf.append(", req_token = '").append(req.getString("req_token")).append("'");
        buf.append(" where fil_codigo = ").append(req.getString("fil_codigo"));
        buf.append(" and req_codigo = ").append(req.getString("req_codigo"));
        Conexao.execute(req.getString("fil_codigo"), st, buf.toString());
    }

    public void insertRequisicaoUsuario(Registro req) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("insert into requisicaousuario (fil_codigo, req_codigo, usr_codigo, reu_data) values (");
        buf.append(req.getString("fil_codigo"));
        buf.append(", ");
        buf.append(req.getString("req_codigo"));
        buf.append(", '");
        buf.append(Variaveis.login);
        buf.append("', '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("')");
        Conexao.execute(req.getString("fil_codigo"), st, buf.toString());
    }

    private String verificaData(Registro exame, String campo) throws ParseException {
        StringBuilder texto = new StringBuilder();
        if (exame.getDate(campo) != null) {
            texto.append("    ,").append(campo).append("= '").append(Funcoes.formataData("MM/dd/yyyy", exame.getDate(campo))).append("'");
        }
        return texto.toString();
    }
}

