/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.exportadores;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.exportadores.LogSMSBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogSMSDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    FilialService filialService = new FilialService();
    PacienteService pacienteService = new PacienteService();
    RequisicaoService requisicaoService = new RequisicaoService();

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("filial", Variaveis.filialPadrao);
        chaves.put("codigo", codigo);
        return this.getBean(chaves);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQuantidadeSms(String codigoFilial, String[] situacoes, Date dataInicial) throws SQLException {
        Statement st;
        block11: {
            int n;
            StringBuilder bufWhere = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(*) as qtde ");
            buf.append("   from logsms ");
            if (!Funcoes.textoVazio(codigoFilial)) {
                bufWhere.append(" fil_codigo = ").append(codigoFilial);
            }
            if (situacoes != null) {
                if (!Funcoes.textoVazio(bufWhere.toString())) {
                    bufWhere.append(" and ");
                }
                bufWhere.append(" sms_situacao IN (");
                for (int i = 0; i < situacoes.length; ++i) {
                    if (i > 0) {
                        bufWhere.append(", ");
                    }
                    bufWhere.append("'").append(situacoes[i]).append("'");
                }
                bufWhere.append(") ");
            }
            if (dataInicial != null) {
                if (!Funcoes.textoVazio(bufWhere.toString())) {
                    bufWhere.append(" and ");
                }
                bufWhere.append(" date_trunc('day', sms_datahora) >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
            }
            if (!Funcoes.textoVazio(bufWhere.toString())) {
                buf.append(" where ").append(bufWhere.toString());
            }
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block11;
                n = rs.getInt("qtde");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return n;
        }
        int n = 0;
        Conexao.fecharStatement(st);
        return n;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSMSBean> getByPacCodigo(String codigoFilial, String codigoPaciente) {
        ArrayList<LogSMSBean> result = new ArrayList<LogSMSBean>();
        StringBuilder builder = new StringBuilder();
        builder.append("select fil_codigo, sms_codigo, sms_datahora, sms_situacao, sms_mensagemerro, sms_mensagem, sms_origem, sms_dataenvio, sms_id, pac_codigo, req_codigo, sms_celular ");
        builder.append("from logsms ");
        builder.append("where fil_codigo = ").append(codigoFilial);
        builder.append(" and pac_codigo = ").append(codigoPaciente);
        builder.append(" and sms_situacao = '");
        builder.append(ExportaSMS.SituacaoSMS.TIPO_SMS_SITUACAO_ENVIADO.getCodigo());
        builder.append("'");
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, builder.toString());
            while (rs.next()) {
                LogSMSBean bean = this.montaBean(rs);
                result.add(bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogSMSBean> getByPacReqCodigo(String codigoFilial, String codigoPaciente, String codigoRequisicao) {
        ArrayList<LogSMSBean> result = new ArrayList<LogSMSBean>();
        StringBuilder builder = new StringBuilder();
        builder.append("select fil_codigo, sms_codigo, sms_datahora, sms_situacao, sms_mensagemerro, sms_mensagem, sms_origem, sms_dataenvio, sms_id, pac_codigo, req_codigo, sms_celular ");
        builder.append("from logsms ");
        builder.append(" where fil_codigo = ").append(Integer.parseInt(codigoFilial));
        builder.append(" and pac_codigo = ").append(codigoPaciente);
        builder.append(" and sms_situacao = '").append(ExportaSMS.SituacaoSMS.TIPO_SMS_SITUACAO_ENVIADO.getCodigo()).append("'");
        builder.append(" and req_codigo =  ").append(Integer.parseInt(codigoRequisicao));
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, builder.toString());
            while (rs.next()) {
                LogSMSBean bean = this.montaBean(rs);
                result.add(bean);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        finally {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogSMSBean montaBean(ResultSet rs) {
        LogSMSBean bean = new LogSMSBean();
        try {
            bean.setCelular(rs.getString("sms_celular"));
            bean.setCodigo(rs.getLong("sms_codigo"));
            bean.setDataEnvio(rs.getDate("sms_dataenvio"));
            bean.setDataHora(rs.getTimestamp("sms_datahora"));
            bean.setFilial((FilialVO)this.filialService.getVO(rs.getString("fil_codigo")));
            bean.setMensagem(rs.getString("sms_mensagem"));
            bean.setMensagemErro(rs.getString("sms_mensagemerro"));
            bean.setOrigem(rs.getString("sms_origem"));
            bean.setPaciente((PacienteVO)this.pacienteService.getVO(rs.getString("pac_codigo")));
            if (rs.getString("req_codigo") != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", rs.getString("fil_codigo"));
                chaves.put("req_codigo", rs.getString("req_codigo"));
                bean.setRequisicao((RequisicaoVO)this.requisicaoService.getVO(chaves));
            }
            bean.setSituacao(rs.getString("sms_situacao"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return bean;
        }
    }
}

