/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.exportadores;

import jalis.comum.Conexao;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.exportadores.LogEmailBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LogEmailDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    FilialService filialService = new FilialService();
    PacienteService pacienteService = new PacienteService();
    RequisicaoService requisicaoService = new RequisicaoService();

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = LogEmailDao.load(LogEmailBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (LogEmailBean)aux.toArray()[0];
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    public List<LogEmailBean> getBeanByPacCodigo(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, ema_codigo, ema_situacao, pac_codigo, req_codigo, ema_anexo, ema_extensao, ema_datahora, ema_email, ema_mensagem, ema_assunto, ema_origem ");
        sql.append("from logemail ");
        sql.append(where);
        ArrayList<LogEmailBean> beans = new ArrayList<LogEmailBean>();
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                beans.add(this.extraiLogEmail(rs));
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return beans;
    }

    public List<LogEmailBean> getBeanByPacReqCodigo(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, ema_codigo, ema_situacao, pac_codigo, req_codigo, ema_anexo, ema_extensao, ema_datahora, ema_email, ema_mensagem, ema_assunto, ema_origem ");
        sql.append("from logemail ");
        sql.append(where);
        ArrayList<LogEmailBean> beans = new ArrayList<LogEmailBean>();
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                beans.add(this.extraiLogEmail(rs));
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEmailBean extraiLogEmail(ResultSet rs) {
        LogEmailBean bean = new LogEmailBean();
        try {
            bean.setAssunto(rs.getString("ema_assunto"));
            bean.setCodigo(rs.getLong("ema_codigo"));
            bean.setDataHora(rs.getTimestamp("ema_datahora"));
            bean.setEma_extensao(rs.getString("ema_extensao"));
            bean.setEmail(rs.getString("ema_email"));
            bean.setFilial((FilialVO)this.filialService.getVO(rs.getString("fil_codigo")));
            bean.setMensagem(rs.getString("ema_mensagem"));
            bean.setPaciente((PacienteVO)this.pacienteService.getVO(rs.getString("pac_codigo")));
            bean.setOrigem(rs.getString("ema_origem"));
            if (rs.getString("req_codigo") != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", rs.getString("fil_codigo"));
                chaves.put("req_codigo", rs.getString("req_codigo"));
                bean.setRequisicao((RequisicaoVO)this.requisicaoService.getVO(chaves));
            }
            bean.setSituacao(rs.getString("ema_situacao"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return bean;
        }
    }
}

