/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.exportacao;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConsultaIntegracaoDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarDadosRequisicao(Registro dadosCorrigidos) {
        String matricula = Funcoes.textoVazio(dadosCorrigidos.getString("matricula")) ? null : StringUtil.textoDBEscape(dadosCorrigidos.getString("matricula"));
        String cartaoSUS = Funcoes.textoVazio(dadosCorrigidos.getString("cartaosus")) ? null : StringUtil.textoDBEscape(dadosCorrigidos.getString("cartaosus"));
        String codFilial = dadosCorrigidos.getString("filial");
        StringBuilder sql = new StringBuilder("");
        sql.append("update requisicao set ");
        sql.append(" req_matricula = ").append(matricula);
        sql.append(" , req_cartaosus = ").append(cartaoSUS);
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(dadosCorrigidos.getString("Requisi\u00e7\u00e3o"));
        Statement statement = Conexao.getStatement();
        try {
            Conexao.execute(codFilial, statement, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                this.anularSQL();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(statement);
                throw throwable;
            }
            Conexao.fecharStatement(statement);
        }
        Conexao.fecharStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarDadosExameRequisicao(Registro dadosCorrigidos) {
        String guia = Funcoes.textoVazio(dadosCorrigidos.getString("guia")) ? null : StringUtil.textoDBEscape(dadosCorrigidos.getString("guia"));
        String dataGuia = Funcoes.textoVazio(dadosCorrigidos.getString("dataGuia")) ? null : StringUtil.textoDBEscape(dadosCorrigidos.getString("dataGuia"));
        String codFilial = dadosCorrigidos.getString("filial");
        String idExame = dadosCorrigidos.getString("idExame");
        StringBuilder sql = new StringBuilder("");
        sql.append("update examerequisicao set ");
        sql.append(" exr_guia = ").append(guia);
        sql.append(" , exr_dataguia = ").append(dataGuia);
        if (!Funcoes.textoVazio(idExame)) {
            sql.append(" , exr_codautorizacao = ").append(idExame);
        }
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(dadosCorrigidos.getString("Requisi\u00e7\u00e3o"));
        sql.append(" and exa_codigo = '").append(dadosCorrigidos.getString("exame")).append("'");
        sql.append(" and mco_codigo = ").append(dadosCorrigidos.getString("codigoMaterial"));
        Statement statement = Conexao.getStatement();
        try {
            Conexao.execute(codFilial, statement, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                this.anularSQL();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(statement);
                throw throwable;
            }
            Conexao.fecharStatement(statement);
        }
        Conexao.fecharStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarDadosExportaIntegracaoOperadora(Registro reg, boolean exportado) {
        String retorno = exportado ? "Situa\u00e7\u00e3o alterado para exportado manualmente" : "Exporta\u00e7\u00e3o desmarcada manualmente";
        String exporta = exportado ? "T" : "";
        StringBuilder buf = new StringBuilder();
        buf.append(" update exportaintegracaooperadora ");
        buf.append(" set eio_exportado = ").append(exportado);
        buf.append(" ,eio_retorno = ").append(StringUtil.textoDBEscape(retorno));
        buf.append(" ,eio_situacao = ").append(StringUtil.textoDBEscape(exporta));
        buf.append(" ,req_codigo = ").append(reg.getString("Requisi\u00e7\u00e3o"));
        buf.append(" ,exa_codigo = ").append(StringUtil.textoDBEscape(reg.getString("exame")));
        buf.append(" ,mco_codigo = ").append(reg.getString("codigoMaterial"));
        buf.append(" where fil_codigo = ").append(reg.getString("filial"));
        buf.append(" and eio_codigo = ").append(reg.getString("log"));
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ConexaoTemporaria.executeUpdate(st, buf);
            ConexaoTemporaria.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                this.anularSQL();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inserirLogCorrigido(Registro dadosCorrigidos) {
        PreparedStatement ps;
        block4: {
            StringBuilder sql = new StringBuilder();
            ps = null;
            Connection connection = Conexao.getConnection();
            try {
                sql.append(" insert into exportaintegracaooperadora (");
                sql.append(" fil_codigo, ");
                sql.append(" con_codigo, ");
                sql.append(" eio_codigo, ");
                sql.append(" eio_datahora, ");
                sql.append(" eio_operacao, ");
                sql.append(" eio_situacao, ");
                sql.append(" eio_tipooperacao, ");
                sql.append(" eio_exportado, ");
                sql.append(" req_codigo, ");
                sql.append(" pac_codigo, ");
                sql.append(" exa_codigo, ");
                sql.append(" mco_codigo ");
                sql.append(" ) values (");
                sql.append(dadosCorrigidos.getString("filial")).append(", ");
                sql.append(dadosCorrigidos.getString("codigoConvenio")).append(" ,");
                sql.append(" nextval('exportaintegracaooperadora_").append(dadosCorrigidos.getString("filial")).append("_sequence')").append(" ,");
                sql.append(" current_timestamp").append(" ,");
                sql.append(StringUtil.textoDBEscape(dadosCorrigidos.getString("xmlLog").replaceAll("\n+", ""))).append(", ");
                sql.append(StringUtil.textoDBEscape("C")).append(", ");
                sql.append(StringUtil.textoDBEscape(dadosCorrigidos.getString("tipoOperacao"))).append(", ");
                sql.append("false, ");
                sql.append(dadosCorrigidos.getString("Requisi\u00e7\u00e3o")).append(" ,");
                sql.append(StringUtil.textoDBEscape(dadosCorrigidos.getString("codigoPaciente"))).append(" ,");
                sql.append(StringUtil.textoDBEscape(dadosCorrigidos.getString("exame"))).append(", ");
                sql.append(dadosCorrigidos.getString("codigoMaterial")).append(")");
                ps = connection.prepareStatement(sql.toString(), 1);
                ps.execute();
                ResultSet rs = ps.getGeneratedKeys();
                if (!rs.next()) break block4;
                dadosCorrigidos.setValor("conferencia", rs.getString("eio_datahora"));
                dadosCorrigidos.setValor("log", rs.getString("eio_codigo"));
                dadosCorrigidos.setValor("usrconferencia", Variaveis.login);
            }
            catch (SQLException e) {
                try {
                    this.anularSQL();
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(ps);
                    throw throwable;
                }
                Conexao.fecharStatement(ps);
            }
        }
        Conexao.fecharStatement(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verificaLogPrecisandoCorrecao(Registro reg, FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora protocolo) {
        boolean bl;
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        ResultSet rs = null;
        try {
            sql.append("select eio_situacao from exportaintegracaooperadora ");
            sql.append(" where fil_codigo = ").append(reg.getString("filial"));
            sql.append(" and req_codigo = ").append(reg.getString("Requisi\u00e7\u00e3o"));
            sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(reg.getString("exame")));
            sql.append(" and mco_codigo = ").append(StringUtil.textoDBEscape(reg.getString("codigoMaterial")));
            sql.append(" and eio_situacao in ('");
            sql.append("R").append("', '");
            sql.append("N").append("') ");
            sql.append(" and eio_operacao ilike '%").append(protocolo.getDescricao()).append("%'");
            rs = Conexao.executeQuery(st, sql.toString());
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharResultSet(rs);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharResultSet(rs);
            return true;
        }
        Conexao.fecharStatement(st);
        Conexao.fecharResultSet(rs);
        return bl;
    }
}

