/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.TransfEstoqueVO;
import jalis.service.estoque.TransfEstoqueLanctoEstoqueService;
import jalis.service.estoque.TransfEstoqueMaterialService;
import java.util.Set;

public class TransfEstoqueDao
extends AbstractThreadDao {
    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return this.getBean(Variaveis.filialPadrao, codigo, false);
    }

    public AbstractThreadBean getBean(String filial, String codigo, boolean trazerEstornados) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and tra_codigo = ").append(codigo);
        Set transfEstoque = TransfEstoqueDao.load(TransfEstoqueBean.class, where.toString());
        if (transfEstoque != null && transfEstoque.size() == 1) {
            TransfEstoqueBean bean = (TransfEstoqueBean)transfEstoque.iterator().next();
            bean.setMateriais(new TransfEstoqueMaterialService().getMateriaisTransferenciaEstoque(filial, codigo, trazerEstornados));
            bean.setLancamentos(new TransfEstoqueLanctoEstoqueService().getLancamentoTransferencia(filial, codigo));
            return bean;
        }
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and tra_codigo = ").append(codigo);
        Set transfEstoque = this.loadVO(TransfEstoqueVO.class, where.toString());
        if (transfEstoque == null || transfEstoque.size() == 0 || transfEstoque.size() > 1) {
            return null;
        }
        return (TransfEstoqueVO)transfEstoque.toArray()[0];
    }
}

