/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.MontagemKitBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.MontagemKitVO;
import jalis.service.estoque.MontagemKitMaterialService;
import java.util.Set;

public class MontagemKitDao
extends AbstractThreadDao {
    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        try {
            return this.getBean(Variaveis.filialPadrao, codigo);
        }
        catch (Exception e) {
            new ThreadDaoException("Erro ao buscar dados da montagem.");
            return null;
        }
    }

    public AbstractThreadBean getBean(String filial, String codigo) throws Exception {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and mnt_codigo = ").append(codigo);
        Set montagem = MontagemKitDao.load(MontagemKitBean.class, where.toString());
        if (montagem == null || montagem.size() == 0 || montagem.size() > 1) {
            return null;
        }
        MontagemKitBean bean = (MontagemKitBean)montagem.toArray()[0];
        bean.setMateriais(new MontagemKitMaterialService().getMateriaisKit(filial, codigo));
        return bean;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and mnt_codigo = ").append(codigo);
        Set montagem = MontagemKitDao.load(MontagemKitVO.class, where.toString());
        if (montagem == null || montagem.size() == 0 || montagem.size() > 1) {
            return null;
        }
        MontagemKitVO vo = (MontagemKitVO)montagem.toArray()[0];
        return vo;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and mnt_codigo = ").append(codigo);
        Set montagem = MontagemKitDao.load(MontagemKitVO.class, where.toString());
        if (montagem == null || montagem.size() == 0 || montagem.size() > 1) {
            return null;
        }
        MontagemKitVO vo = (MontagemKitVO)montagem.toArray()[0];
        return vo;
    }
}

