/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.TipoMaterialVO;
import jalis.model.vo.estoque.UnidadeMedidaVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.estoque.MaterialLoteLanctoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MaterialLoteDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    MaterialLoteLanctoEstoqueService materialLoteLanctoEstoqueService = new MaterialLoteLanctoEstoqueService();

    @Override
    public Set loadVO(Class cls, String where) throws ThreadDaoException {
        return super.loadVO(cls, where);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and mll_codigo = " + codigo;
        Set materiais = this.loadVO(MaterialLoteVO.class, where);
        if (materiais == null || materiais.size() == 0 || materiais.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)materiais.toArray()[0];
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set matLote = MaterialLoteDao.load(MaterialLoteBean.class, where);
        if (matLote == null || matLote.size() == 0 || matLote.size() > 1) {
            return null;
        }
        MaterialLoteBean materialLoteBean = (MaterialLoteBean)matLote.toArray()[0];
        this.carregaDadosLanctosEstoque(materialLoteBean);
        return materialLoteBean;
    }

    public ArrayList<MaterialLoteBean> getBeans(Map<String, Object> chaves, boolean isMostrarConsumidos) throws ThreadDaoException {
        Set matLote;
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        wheres.add(" not mll_removido ");
        String where = " where " + StringUtil.implode(wheres, " and ");
        if (!isMostrarConsumidos) {
            where = where + " and mll_quantidade > mll_quantidadeconsumida ";
        }
        if ((matLote = MaterialLoteDao.load(MaterialLoteBean.class, where)) == null || matLote.size() == 0) {
            return null;
        }
        for (MaterialLoteBean aux : matLote) {
            this.carregaDadosLanctosEstoque(aux);
        }
        ArrayList<MaterialLoteBean> lotes = new ArrayList<MaterialLoteBean>();
        for (MaterialLoteBean aux : matLote) {
            if (aux.getLancamentosEstoque() == null) continue;
            lotes.add(aux);
        }
        return lotes;
    }

    private void adicionarMaterialLoteSessao(Set<MaterialLoteBean> matLote) {
        HashMap<Integer, AbstractThreadBean> matLoteHashMap = new HashMap<Integer, AbstractThreadBean>();
        HashMap<Integer, MaterialVO> materialVoHashMap = new HashMap<Integer, MaterialVO>();
        HashMap<String, UsuarioVO> usuarioVoHashMap = new HashMap<String, UsuarioVO>();
        HashMap<Integer, FilialVO> filialVoHashMap = new HashMap<Integer, FilialVO>();
        HashMap<String, AbstractThreadBean> unidadeMedidaVoHashMap = new HashMap<String, AbstractThreadBean>();
        HashMap<Integer, AbstractThreadBean> tipoMaterialVoHashMap = new HashMap<Integer, AbstractThreadBean>();
        for (MaterialLoteBean materialLoteBean : matLote) {
            matLoteHashMap.put(materialLoteBean.getCodigo(), materialLoteBean.toVO());
            if (materialLoteBean.getMaterial() != null && materialLoteBean.getMaterial().getCodigo() != null) {
                materialVoHashMap.put(materialLoteBean.getMaterial().getCodigo(), materialLoteBean.getMaterial());
            }
            if (materialLoteBean.getUsuarioCriacao() != null && materialLoteBean.getUsuarioCriacao().getCodigo() != null) {
                usuarioVoHashMap.put(materialLoteBean.getUsuarioCriacao().getCodigo(), materialLoteBean.getUsuarioCriacao());
            }
            if (materialLoteBean.getUsuarioRemocao() != null && materialLoteBean.getUsuarioRemocao().getCodigo() != null) {
                usuarioVoHashMap.put(materialLoteBean.getUsuarioRemocao().getCodigo(), materialLoteBean.getUsuarioRemocao());
            }
            if (materialLoteBean.getFilial() != null && materialLoteBean.getFilial().getCodigo() != null) {
                filialVoHashMap.put(materialLoteBean.getFilial().getCodigo(), materialLoteBean.getFilial());
            }
            if (materialLoteBean.getMaterial() != null && materialLoteBean.getMaterial().getUnidadeMedida() != null) {
                unidadeMedidaVoHashMap.put(materialLoteBean.getMaterial().getUnidadeMedida().getCodigo(), materialLoteBean.getMaterial().getUnidadeMedida().toVO());
            }
            if (materialLoteBean.getMaterial() == null || materialLoteBean.getMaterial().getTipoMaterial() == null) continue;
            tipoMaterialVoHashMap.put(materialLoteBean.getMaterial().getTipoMaterial().getCodigo(), materialLoteBean.getMaterial().getTipoMaterial().toVO());
        }
        if (Conexao.getHashMapSessao().get(MaterialLoteBean.class.getName()) != null) {
            Conexao.getHashMapSessao().get(MaterialLoteBean.class.getName()).putAll(matLoteHashMap);
        } else {
            Conexao.getHashMapSessao().put(MaterialLoteBean.class.getName(), matLoteHashMap);
        }
        if (Conexao.getHashMapSessao().get(MaterialLoteVO.class.getName()) != null) {
            Conexao.getHashMapSessao().get(MaterialLoteVO.class.getName()).putAll(matLoteHashMap);
        } else {
            Conexao.getHashMapSessao().put(MaterialLoteVO.class.getName(), matLoteHashMap);
        }
        if (Conexao.getHashMapSessao().get(MaterialVO.class.getName()) != null) {
            Conexao.getHashMapSessao().get(MaterialVO.class.getName()).putAll(materialVoHashMap);
        } else {
            Conexao.getHashMapSessao().put(MaterialVO.class.getName(), materialVoHashMap);
        }
        if (Conexao.getHashMapSessao().get(UsuarioVO.class.getName()) != null) {
            Conexao.getHashMapSessao().get(UsuarioVO.class.getName()).putAll(usuarioVoHashMap);
        } else {
            Conexao.getHashMapSessao().put(UsuarioVO.class.getName(), usuarioVoHashMap);
        }
        if (Conexao.getHashMapSessao().get(FilialVO.class.getName()) != null) {
            Conexao.getHashMapSessao().get(FilialVO.class.getName()).putAll(filialVoHashMap);
        } else {
            Conexao.getHashMapSessao().put(FilialVO.class.getName(), filialVoHashMap);
        }
        if (Conexao.getHashMapSessao().get(UnidadeMedidaVO.class.getName()) != null) {
            Conexao.getHashMapSessao().get(UnidadeMedidaVO.class.getName()).putAll(unidadeMedidaVoHashMap);
        } else {
            Conexao.getHashMapSessao().put(UnidadeMedidaVO.class.getName(), unidadeMedidaVoHashMap);
        }
        if (Conexao.getHashMapSessao().get(TipoMaterialVO.class.getName()) != null) {
            Conexao.getHashMapSessao().get(TipoMaterialVO.class.getName()).putAll(tipoMaterialVoHashMap);
        } else {
            Conexao.getHashMapSessao().put(TipoMaterialVO.class.getName(), tipoMaterialVoHashMap);
        }
    }

    private void carregaDadosLanctosEstoque(MaterialLoteBean matLote) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", matLote.getFilial().getCodigo());
        chaves.put("mll_codigo", matLote.getCodigo());
        matLote.setLancamentosEstoque(this.materialLoteLanctoEstoqueService.getBeans(chaves));
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set matLote = MaterialLoteDao.load(MaterialLoteVO.class, where);
        if (matLote == null || matLote.size() == 0 || matLote.size() > 1) {
            return null;
        }
        return (MaterialLoteVO)matLote.toArray()[0];
    }

    public void removerLoteLancamentoEstoque(String filial, String codigoLancamentoEstoque, Date dataHoraRemocao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select mll_codigo ");
        buf.append("   from materiallotelanctoestoque ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and lce_codigo = ").append(codigoLancamentoEstoque);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            buf.setLength(0);
            buf.append(" update materiallote ");
            buf.append("    set mll_datahoraremovido = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataHoraRemocao)).append("' ");
            buf.append("       ,mll_removido = true ");
            buf.append("       ,usr_codremovido = '").append(Variaveis.login).append("' ");
            buf.append("  where fil_codigo = ").append(filial);
            buf.append("    and mll_codigo = ").append(rs.getInt("mll_codigo"));
            Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
        }
    }

    public void removerLoteLancamentoEstoque(String filialPadrao, MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoqueBean, Date dataHoraRemocao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select mll_codigo ");
        buf.append("   from materiallotelanctoestoque ");
        buf.append("  where fil_codigo = ").append(filialPadrao);
        buf.append("    and lce_codigo = ").append(materialLoteLanctoEstoqueBean.getLancamento().getCodigo());
        buf.append("    and mll_codigo = ").append(materialLoteLanctoEstoqueBean.getMaterialLote().getCodigo());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            buf.setLength(0);
            buf.append(" update materiallote ");
            buf.append("    set mll_datahoraremovido = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataHoraRemocao)).append("' ");
            buf.append("       ,mll_removido = true ");
            buf.append("       ,usr_codremovido = '").append(Variaveis.login).append("' ");
            buf.append("  where fil_codigo = ").append(filialPadrao);
            buf.append("    and mll_codigo = ").append(rs.getInt("mll_codigo"));
            Conexao.executeUpdate(filialPadrao, Conexao.getStatement(), buf.toString());
        }
    }

    public ArrayList<MaterialLoteBean> buscaMaterialLote(Integer filial, Integer material, boolean isMostrarLoteConsumido) {
        ArrayList<MaterialLoteBean> materiaisLote = new ArrayList<MaterialLoteBean>();
        Statement st = null;
        ResultSet resultSet = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select mll.mll_codigo\t\t          as codigoMaterialLote ");
        buf.append("       ,mll.mll_lote\t\t            as codigoLote ");
        buf.append("       ,mll.mll_datalote\t\t\t   \tas dataLote ");
        buf.append("       ,mll.mll_validadelote\t\t\tas validadeLote ");
        buf.append("       ,mll.mll_quantidade\t\t\t\tas quantidadeLote ");
        buf.append("       ,mll.mll_quantidadeconsumida as quantidadeConsumidaLote ");
        buf.append("       ,mll.mll_quantidade - mll.mll_quantidadeconsumida as quantidadeRestanteLote ");
        buf.append("       ,mll.usr_codigo            as codigoUsuarioCadastroLote ");
        buf.append("       ,mll.mll_datahora          as dataCadastroLote ");
        buf.append("       ,mll.mll_observacao        as observacaoLote ");
        buf.append("       ,mll.mll_codigo            as materialLote ");
        buf.append("       ,mll.mll_removido          as materialRemovido ");
        buf.append("       ,mll.usr_codaberto         as codigoUsuarioaberturaLote");
        buf.append("       ,mll.usr_codfechado        as codigoUsuariofechamentoLote");
        buf.append("       ,mll.mll_aberto            as dataHoraAberturaLote");
        buf.append("       ,mll.mll_fechado           as dataHoraFechamentoLote");
        buf.append("       ,mll.mll_aberturainicial   as dataAberturaInicial");
        buf.append("       ,mll.usr_codaberturainicial as codigoUsuarioAberturaInicial");
        buf.append("       ,a.mat_codigo\t\t          as codigoMaterial ");
        buf.append("       ,a.mat_descricao \t\t\t\t\tas descricaoMaterial ");
        buf.append("       ,a.mat_valorunit \t\t\t\t\tas valorUnitarioMaterial ");
        buf.append("       ,a.mat_valorultcompra \t\t\tas valorUltimaCompraMaterial ");
        buf.append("       ,a.mat_dataultcompra \t\t\tas dataUltimaCompraMaterial ");
        buf.append("       ,a.mat_qtdeultcompra \t\t\tas quantidadeUltimaCompraMaterial ");
        buf.append("       ,a.mat_ptoreposicao \t\t\t\tas pontoReposicaoMaterial ");
        buf.append("       ,a.mat_dataultentrega \t\t\tas dataUltimaEntregaMaterial ");
        buf.append("       ,a.mat_marca \t\t\t\t\t\t\tas marcaMaterial ");
        buf.append("       ,a.mat_modelo \t\t\t\t\t\t\tas modeloMaterial ");
        buf.append("       ,a.mat_reposicaoautomatica as reposicaoAutomaticaMaterial ");
        buf.append("       ,a.usr_codigo \t\t\t\t\t\t\tas codigoUsuarioCadastroMaterial ");
        buf.append("       ,a.mat_imobilizado \t\t\t\tas imobilizadoMaterial ");
        buf.append("       ,a.mat_solicitarpatrimonio as solicitarPatrimonioMaterial ");
        buf.append("       ,a.mat_fichatecnica \t\t\t\tas fichaTecnicaMaterial ");
        buf.append("       ,a.mat_criarlotekit \t\t\t\tas criarLoteKitMaterial ");
        buf.append("\t     ,a.mat_inativo \t\t\t\t\t\tas materialInativo ");
        buf.append("       ,unm.unm_codigo \t\t\t\t\t\tas codigoUnidadeMedida ");
        buf.append("       ,unm.unm_descricao \t\t\t\tas descricaoUnidadeMedida ");
        buf.append("       ,tpm.tpm_codigo \t\t\t\t\t\tas codigoTipoMaterial ");
        buf.append("       ,tpm.tpm_descricao \t\t\t\tas descricaoTipoMaterial ");
        buf.append("        ,fpc.fil_codigo  as codigoFilial ");
        buf.append("        ,fpc.fil_cnpj    as cnpjFilial ");
        buf.append("        ,fpc.fil_simplesnacional as simplesNacionalFilial ");
        buf.append("       ,u.usr_codigo              as codigoUsuario ");
        buf.append("       ,current_date              as dataservidor ");
        buf.append("   from materiallote mll ");
        buf.append("   left join material a on mll.fil_codigo = a.fil_codigo and mll.mat_codigo = a.mat_codigo and not mll.mll_removido ");
        buf.append("   left join unidademedida unm on mll.fil_codigo = unm.fil_codigo and a.unm_codigo = unm.unm_codigo ");
        buf.append("   left join tipomaterial tpm on mll.fil_codigo = tpm.fil_codigo and a.tpm_codigo = tpm.tpm_codigo ");
        buf.append("   left join usuario u on mll.fil_codigo = u.fil_codigo and mll.usr_codigo = u.usr_codigo ");
        buf.append("   left join filiais_postocoleta fpc on mll.fil_codigo = fpc.fil_codigo ");
        buf.append("   where a.fil_codigo = ").append(filial);
        buf.append("   and a.mat_codigo = ").append(material);
        buf.append("   and not mll.mll_removido ");
        buf.append("   and a.mat_solicitarlote ");
        if (!isMostrarLoteConsumido) {
            buf.append(" and mll.mll_quantidade > mll.mll_quantidadeconsumida ");
        }
        st = Conexao.getStatement();
        try {
            resultSet = Conexao.executeQuery(st, buf.toString());
            if (resultSet.next()) {
                do {
                    MaterialLoteBean materialLoteBean = new MaterialLoteBean();
                    materialLoteBean.setCodigo(resultSet.getInt("codigoMaterialLote"));
                    materialLoteBean.setLote(resultSet.getString("codigoLote"));
                    materialLoteBean.setDataLote(resultSet.getDate("dataLote"));
                    materialLoteBean.setValidadeLote(resultSet.getDate("validadeLote"));
                    materialLoteBean.setQuantidade(resultSet.getDouble("quantidadeLote"));
                    materialLoteBean.setQuantidadeConsumida(resultSet.getDouble("quantidadeConsumidaLote"));
                    materialLoteBean.setDataHoraCriacao(resultSet.getTimestamp("dataCadastroLote"));
                    materialLoteBean.setObservacao(resultSet.getString("observacaoLote"));
                    materialLoteBean.setRemovido(resultSet.getBoolean("materialRemovido"));
                    materialLoteBean.setDataHoraAberto(resultSet.getTimestamp("dataHoraAberturaLote"));
                    materialLoteBean.setDataHoraFechado(resultSet.getTimestamp("dataHoraFechamentoLote"));
                    materialLoteBean.setDataHoraAberto(resultSet.getTimestamp("dataAberturaInicial"));
                    materialLoteBean.setDataHoraServidor(resultSet.getDate("dataservidor"));
                    UsuarioVO usuarioAberturaVO = new UsuarioVO();
                    usuarioAberturaVO.setCodigo(resultSet.getString("codigoUsuarioAberturaInicial"));
                    materialLoteBean.setUsuarioAberturaInicial(usuarioAberturaVO);
                    MaterialLoteVO materialLoteVO = new MaterialLoteVO();
                    materialLoteVO.setCodigo(resultSet.getInt("codigoMaterialLote"));
                    materialLoteVO.setLote(resultSet.getString("codigoLote"));
                    materialLoteVO.setDataLote(resultSet.getDate("dataLote"));
                    materialLoteVO.setValidadeLote(resultSet.getDate("validadeLote"));
                    materialLoteVO.setQuantidade(resultSet.getDouble("quantidadeLote"));
                    materialLoteVO.setQuantidadeConsumida(resultSet.getDouble("quantidadeConsumidaLote"));
                    materialLoteVO.setDataHoraCriacao(resultSet.getTimestamp("dataCadastroLote"));
                    materialLoteVO.setObservacao(resultSet.getString("observacaoLote"));
                    MaterialVO materialVO = new MaterialVO();
                    materialVO.setCodigo(resultSet.getInt("codigoMaterial"));
                    materialVO.setDescricao(resultSet.getString("descricaoMaterial"));
                    materialVO.setValorUnit(resultSet.getDouble("valorUnitarioMaterial"));
                    materialVO.setValorUltimaCompra(resultSet.getDouble("valorUltimaCompraMaterial"));
                    materialVO.setDataUltimaCompra(resultSet.getDate("dataUltimaCompraMaterial"));
                    materialVO.setQuantidadeUltimaCompra(resultSet.getDouble("quantidadeUltimaCompraMaterial"));
                    materialVO.setPontoReposicao(resultSet.getDouble("pontoReposicaoMaterial"));
                    materialVO.setDataUltimaEntrega(resultSet.getDate("dataUltimaEntregaMaterial"));
                    materialVO.setMarca(resultSet.getString("marcaMaterial"));
                    materialVO.setModelo(resultSet.getString("modeloMaterial"));
                    materialVO.setReposicaoAutomatica(resultSet.getBoolean("reposicaoAutomaticaMaterial"));
                    materialVO.setImobilizado(resultSet.getBoolean("imobilizadoMaterial"));
                    materialVO.setSolicitarPatrimonio(resultSet.getBoolean("solicitarPatrimonioMaterial"));
                    materialVO.setFichaTecnica(resultSet.getBoolean("fichaTecnicaMaterial"));
                    materialVO.setInativo(resultSet.getBoolean("materialInativo"));
                    materialLoteBean.setMaterial(materialVO);
                    materialLoteVO.setMaterial(materialVO);
                    UnidadeMedidaVO unidadeMedidaVO = new UnidadeMedidaVO();
                    unidadeMedidaVO.setCodigo(resultSet.getString("codigoUnidadeMedida"));
                    unidadeMedidaVO.setDescricao(resultSet.getString("descricaoUnidadeMedida"));
                    TipoMaterialVO tipoMaterialVO = new TipoMaterialVO();
                    tipoMaterialVO.setCodigo(resultSet.getInt("codigoTipoMaterial"));
                    tipoMaterialVO.setDescricao(resultSet.getString("descricaoTipoMaterial"));
                    FilialVO filialVO = new FilialVO();
                    filialVO.setCodigo(resultSet.getInt("codigoFilial"));
                    filialVO.setCnpj(resultSet.getString("cnpjFilial"));
                    filialVO.setSimplesNacional(resultSet.getBoolean("simplesNacionalFilial"));
                    materialLoteBean.setFilial(filialVO);
                    UsuarioVO usuarioVO = new UsuarioVO();
                    usuarioVO.setCodigo(resultSet.getString("codigoUsuario"));
                    materialLoteVO.setUsuarioCriacao(usuarioVO);
                    materialLoteBean.setLancamentosEstoque(this.carregaMaterialLoteLanctoEstoqueBean(filialVO, materialLoteVO));
                    materialLoteBean.setUsuarioAberto(usuarioVO);
                    materialLoteBean.setUsuarioFechamento(usuarioVO);
                    materiaisLote.add(materialLoteBean);
                } while (resultSet.next());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return materiaisLote;
    }

    private Set<MaterialLoteLanctoEstoqueBean> carregaMaterialLoteLanctoEstoqueBean(FilialVO filial, MaterialLoteVO materialLote) {
        HashSet<MaterialLoteLanctoEstoqueBean> materiaisLoteLanctoEstoqueBean = new HashSet<MaterialLoteLanctoEstoqueBean>();
        Statement st = null;
        ResultSet resultSet = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select    mle.mll_codigo             as codigoMaterialLoteLancamento ");
        buf.append("          ,mle.lce_codigo             as codigoLce ");
        buf.append("          ,mle.mll_quantidade         as quantidadeMaterialLancamento");
        buf.append("          ,cel.cel_codigo\t\t\t\t\t\tas codigoCelulaEstoque ");
        buf.append("          ,cel.cel_descricao         as descricaoCelulaEstoque ");
        buf.append("          ,cel.cel_inativa as celulaInativa ");
        buf.append("          ,cel.cel_padrao as celulaPadrao ");
        buf.append("          ,cel.cel_baixarautomatico as celulaBaixarAutomatico ");
        buf.append("       ,lce.lce_codigo            as codigoLanctoEstoque ");
        buf.append("       ,lce.lce_datahora\t\t\t\t\tas dataHoraLanctoEstoque ");
        buf.append("       ,lce.lce_tipo\t\t\t\t\t\t\tas tipoLanctoEstoque ");
        buf.append("       ,lce.lce_tipoorigem\t\t\t\tas tipoOrigemLanctoEstoque ");
        buf.append("       ,lce.lce_quantidade\t\t\t\tas quantidadeLanctoEstoque ");
        buf.append("       ,lce.usr_codigo\t\t\t\t\t\tas codigoUsuarioLanctoEstoque ");
        buf.append("       ,lce.usr_codconciliacao\t\tas codigoUsuarioConciliacaoLanctoEstoque ");
        buf.append("       ,lce.lce_situacao\t\t\t\t\tas situacaoLanctoEstoque ");
        buf.append("       ,lce.lce_conciliacao\t\t\t\tas dataHoraConciliacaoLanctoEstoque ");
        buf.append("       ,etm.etm_datahora \t\t\t\t\tas dataHoraEstoqueManual ");
        buf.append("       ,etm.etm_observacao \t\t\t\tas observacaoEstoqueManual ");
        buf.append("       ,etm.usr_codigo\t\t\t\t\t\tas codigoUsuarioEstoqueManual ");
        buf.append("       ,cen.cen_datahora\t\t\t\t\tas dataHoraConferenciaEntrada ");
        buf.append("       ,cen.usr_codigo\t\t\t\t\t\tas codigoUsuarioConferenciaEntrada ");
        buf.append("       ,cen.cen_observacao\t\t\t\tas observacaoConferenciaEntrada ");
        buf.append("       ,ces.ces_datahora\t\t\t\t\tas dataHoraConferenciaEstoque ");
        buf.append("       ,ces.ces_observacao\t\t\t\tas observacaoConferenciaEstoque ");
        buf.append("       ,ces.usr_codigo\t\t\t\t\t\tas codigoUsuarioConferenciaEstoque ");
        buf.append("       ,nfi.nfi_codigo\t\t\t\t\t\tas codigoNotaFiscal ");
        buf.append("       ,nfi.ser_codigo\t\t\t\t\t\tas serieNotaFiscal ");
        buf.append("       ,nfi.nfi_numero \t\t\t\t\t\tas numeroNotaFiscal ");
        buf.append("       ,nfi.nfi_tipocadastro\t\t\tas tipoCadastroNotaFiscal ");
        buf.append("       ,nfi.usr_codigo            as codigoUsuarioNotaFiscal ");
        buf.append("       ,nfi.nfi_datahora          as dataHoraNotaFiscal ");
        buf.append("       ,nfi.nfi_dataemissao\t\t\t\tas dataEmissaoNotaFiscal ");
        buf.append("       ,nfi.nfi_situacao\t\t\t\t\tas situacaoNotaFiscal ");
        buf.append("       ,nfi.nfi_observacao\t\t\t\tas observacaoNotaFiscal ");
        buf.append("       ,nfi.nfi_subtotal\t\t\t\t\tas valorBrutoNotaFiscal ");
        buf.append("       ,nfi.nfi_valortotal \t\t\t\tas valorLiquidoNotaFiscal ");
        buf.append("       ,nfi.nfi_numerorps         as numeroRpsNotaFiscal ");
        buf.append("\t     ,ped.ped_codigo\t\t\t\t\t\tas codigoPedidoCompra ");
        buf.append("       ,ped.ped_datahora\t\t\t\t\tas dataHoraPedidoCompra ");
        buf.append("       ,ped.ped_observacao\t\t\t\tas observacaoPedidoCompra ");
        buf.append("       ,ped.ped_total\t\t\t\t\t\t\tas valorTotalPedidoCompra ");
        buf.append("       ,ped.usr_codigo\t\t\t\t\t\tas codigoUsuarioPedidoCompra ");
        buf.append("       ,COALESCE(sde.sde_saldo, 0) as saldoAtualEstoque ");
        buf.append("       , '' as usuarioAberturaLote ");
        buf.append("       , '' as dataAberturaLote ");
        buf.append("       , '' as usuarioFechamentoLote ");
        buf.append("       , '' as dataFechamentoLote ");
        buf.append(" from materiallotelanctoestoque mle ");
        buf.append(" left join lanctoestoque lce on mle.fil_codigo = lce.fil_codigo and mle.lce_codigo = lce.lce_codigo and lce.lce_datahoracancelamento IS NULL ");
        buf.append(" left join celulaestoque cel on mle.fil_codigo = cel.fil_codigo and lce.cel_codigo = cel.cel_codigo ");
        buf.append(" left join estoquemanuallanctoestoque aux1 on lce.fil_codigo = aux1.fil_codigo and lce.lce_codigo = aux1.lce_codigo ");
        buf.append(" left join conferenciaentradalanctoestoque aux2 on lce.fil_codigo = aux2.fil_codigo and lce.lce_codigo = aux2.lce_codigo ");
        buf.append(" left join conferenciaestoquelanctoestoque aux3 on lce.fil_codigo = aux3.fil_codigo and lce.lce_codigo = aux3.lce_codigo ");
        buf.append(" left join estoquemanual etm on aux1.fil_codigo = etm.fil_codigo and aux1.etm_codigo = etm.etm_codigo ");
        buf.append(" left join conferenciaentrada cen on aux2.fil_codigo = cen.fil_codigo and aux2.cen_codigo = cen.cen_codigo and cen.cen_datahoracancelamento IS NULL ");
        buf.append(" left join conferenciaestoque ces on aux3.fil_codigo = ces.fil_codigo and aux3.ces_codigo = ces.ces_codigo ");
        buf.append(" left join pedido ped on cen.fil_codigo = ped.fil_codigo and cen.ped_codigo = ped.ped_codigo and ped.usr_codexclusao IS NULL ");
        buf.append(" left join saldoestoque sde on lce.fil_codigo = sde.fil_codigo and lce.mat_codigo = sde.mat_codigo and sde.sde_data = (select max(aux.sde_data) from saldoestoque aux where aux.fil_codigo = sde.fil_codigo and aux.mat_codigo = sde.mat_codigo) ");
        buf.append(" left join notafiscallanctoestoque nle on lce.fil_codigo = nle.fil_codigo and lce.lce_codigo = nle.lce_codigo ");
        buf.append(" left join notafiscal nfi on ((cen.fil_codigo = nfi.fil_codigo and cen.nfi_codigo = nfi.nfi_codigo) or (nle.fil_codigo = nfi.fil_codigo and nle.nfi_codigo = nfi.nfi_codigo)) and nfi.usr_codcancelada IS NULL ");
        buf.append(" where mle.fil_codigo = ").append(filial.getCodigo());
        buf.append(" and mle.mll_codigo = ").append(materialLote.getCodigo());
        st = Conexao.getStatement();
        try {
            resultSet = Conexao.executeQuery(st, buf.toString());
            if (resultSet.next()) {
                do {
                    LancamentoEstoqueVO lancamentoEstoqueVO = new LancamentoEstoqueVO();
                    lancamentoEstoqueVO.setCodigo(resultSet.getInt("codigoLanctoEstoque"));
                    lancamentoEstoqueVO.setDataHora(resultSet.getDate("dataHoraLanctoEstoque"));
                    lancamentoEstoqueVO.setTipo(resultSet.getString("tipoLanctoEstoque"));
                    lancamentoEstoqueVO.setTipoOrigem(resultSet.getString("tipoOrigemLanctoEstoque"));
                    lancamentoEstoqueVO.setQuantidade(resultSet.getDouble("quantidadeLanctoEstoque"));
                    lancamentoEstoqueVO.setFilial(filial);
                    MaterialLoteLanctoEstoqueBean materialBean = new MaterialLoteLanctoEstoqueBean();
                    materialBean.setFilial(filial);
                    materialBean.setLancamento(lancamentoEstoqueVO);
                    materialBean.setMaterialLote(materialLote);
                    materialBean.setQuantidade(resultSet.getDouble("quantidadeMaterialLancamento"));
                    CelulaEstoqueVO celulaEstoqueVO = new CelulaEstoqueVO();
                    celulaEstoqueVO.setCodigo(resultSet.getInt("codigoCelulaEstoque"));
                    celulaEstoqueVO.setDescricao(resultSet.getString("descricaoCelulaEstoque"));
                    celulaEstoqueVO.setInativa(resultSet.getBoolean("celulaInativa"));
                    celulaEstoqueVO.setPadrao(resultSet.getBoolean("celulaPadrao"));
                    celulaEstoqueVO.setBaixarAutomatico(resultSet.getBoolean("celulaBaixarAutomatico"));
                    celulaEstoqueVO.setFilial(filial);
                    lancamentoEstoqueVO.setCelula(celulaEstoqueVO);
                    NotaFiscalVO notafiscalVO = new NotaFiscalVO();
                    notafiscalVO.setCodigo(resultSet.getInt("codigoNotaFiscal"));
                    notafiscalVO.setDataEmissao(resultSet.getDate("dataEmissaoNotaFiscal"));
                    notafiscalVO.setSituacao(resultSet.getString("situacaoNotaFiscal"));
                    notafiscalVO.setFilial(filial);
                    PedidoBean pedidoBean = new PedidoBean();
                    pedidoBean.setCodigo(resultSet.getInt("codigoPedidoCompra"));
                    pedidoBean.setFilial(filial);
                    materiaisLoteLanctoEstoqueBean.add(materialBean);
                } while (resultSet.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return materiaisLoteLanctoEstoqueBean;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

