/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.ConferenciaEntradaLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialAlternativoBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.NotaFiscalLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoLanctoEstoqueBean;
import jalis.model.dao.cadastro.material.FichaTecnicaDao;
import jalis.model.dao.estoque.MaterialAlternativoDao;
import jalis.model.dao.estoque.MaterialLoteDao;
import jalis.model.dao.estoque.MaterialPatrimonioDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.cadastro.EntidadeService;
import jalis.service.estoque.ConferenciaEntradaLanctoEstoqueService;
import jalis.service.estoque.NotaFiscalLanctoEstoqueService;
import jalis.service.estoque.PedidoLanctoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class MaterialDao
extends AbstractThreadDao {
    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return this.getBean(Variaveis.filialPadrao, codigo, false, null, null, true, true);
    }

    public AbstractThreadBean getBean(String filial, String codigo, boolean somenteAtivos, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote, boolean carregarDadosLotes, boolean carregarDadosAlternativos) throws ThreadDaoException {
        return this.getBean(filial, codigo, somenteAtivos, notaEntradaLote, pedidoLote, carregarDadosLotes, carregarDadosAlternativos, false);
    }

    public AbstractThreadBean getBean(String filial, String codigo, boolean somenteAtivos, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote, boolean carregarDadosLotes, boolean carregarDadosAlternativos, boolean carregarLotesConsumidos) throws ThreadDaoException {
        Set materiais;
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and mat_codigo = ").append(codigo);
        if (somenteAtivos) {
            where.append(" and not mat_inativo ");
        }
        MaterialBean material = null;
        Set set = materiais = Funcoes.isNumeric(codigo) ? MaterialDao.load(MaterialBean.class, where.toString()) : null;
        if (materiais == null || materiais.size() == 0 || materiais.size() > 1) {
            return null;
        }
        material = material == null ? (MaterialBean)materiais.toArray()[0] : material;
        material.setMateriaisComposicao(new FichaTecnicaDao().getMateriaisFilhos(filial, material.getCodigo().toString()));
        ArrayList<MaterialPatrimonioBean> listaPatrimonios = new ArrayList<MaterialPatrimonioBean>(new MaterialPatrimonioDao().getPatrimoniosMaterial(filial, material.getCodigo().toString()));
        material.setPatrimonios(listaPatrimonios);
        if (carregarDadosLotes) {
            this.carregarDadosLotes(material, notaEntradaLote, pedidoLote, carregarLotesConsumidos);
        }
        if (carregarDadosAlternativos) {
            this.carregarDadosMateriaisAlternativos(material);
        }
        return material;
    }

    public ArrayList<MaterialAlternativoBean> getBeanPorAlternativo(String filial, String codigo) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", filial);
        chaves.put("lower(mal_codigo)", codigo.trim().toLowerCase());
        ArrayList<MaterialAlternativoBean> listaAlternativos = new MaterialAlternativoDao().getBeans(chaves);
        return listaAlternativos;
    }

    private void carregarDadosMateriaisAlternativos(MaterialBean material) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", material.getFilial().getCodigo());
        chaves.put("mat_codigo", material.getCodigo());
        ArrayList<MaterialAlternativoBean> listaAlternativos = new MaterialAlternativoDao().getBeans(chaves);
        material.setMateriaisAlternativos(listaAlternativos);
    }

    public void carregarDadosLotes(MaterialBean material, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote, boolean isMostrarConsumidos) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        ArrayList<MaterialLoteBean> listaLotes = new MaterialLoteDao().buscaMaterialLote(material.getFilial().getCodigo(), material.getCodigo(), isMostrarConsumidos);
        if (listaLotes != null) {
            NotaFiscalLanctoEstoqueService notaLanctoService = new NotaFiscalLanctoEstoqueService();
            PedidoLanctoEstoqueService pedidoLanctoService = new PedidoLanctoEstoqueService();
            block0: for (int i = 0; i < listaLotes.size(); ++i) {
                listaLotes.get(i).setQuantidadeConsumidaOriginal((double)listaLotes.get(i).getQuantidadeConsumida());
                for (MaterialLoteLanctoEstoqueBean loteLancto : listaLotes.get(i).getLancamentosEstoque()) {
                    if (loteLancto == null || !loteLancto.getLancamento().getTipo().equalsIgnoreCase("E")) continue;
                    if (notaEntradaLote != null) {
                        chaves = new HashMap();
                        chaves.put("fil_codigo", material.getFilial().getCodigo());
                        chaves.put("nfi_codigo", notaEntradaLote.getCodigo());
                        chaves.put("lce_codigo", loteLancto.getLancamento().getCodigo());
                        NotaFiscalLanctoEstoqueBean notaLanctoBean = (NotaFiscalLanctoEstoqueBean)notaLanctoService.getBean(chaves);
                        if (notaLanctoBean == null) continue;
                        listaLotes.get(i).setAlterar(true);
                        continue block0;
                    }
                    if (pedidoLote == null) continue;
                    chaves = new HashMap();
                    chaves.put("fil_codigo", material.getFilial().getCodigo());
                    chaves.put("ped_codigo", pedidoLote.getCodigo());
                    chaves.put("lce_codigo", loteLancto.getLancamento().getCodigo());
                    PedidoLanctoEstoqueBean pedidoLanctoBean = (PedidoLanctoEstoqueBean)pedidoLanctoService.getBean(chaves);
                    if (pedidoLanctoBean == null) continue;
                    listaLotes.get(i).setAlterar(true);
                    continue block0;
                }
            }
        }
        material.setLotes(listaLotes);
    }

    public void carregarDadosLotes(MaterialVO material, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote, boolean isMostrarConsumidos) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", material.getFilial().getCodigo());
        chaves.put("mat_codigo", material.getCodigo());
        ArrayList<MaterialLoteBean> listaLotes = new MaterialLoteDao().buscaMaterialLote(material.getFilial().getCodigo(), material.getCodigo(), isMostrarConsumidos);
        if (listaLotes != null) {
            NotaFiscalLanctoEstoqueService notaLanctoService = new NotaFiscalLanctoEstoqueService();
            PedidoLanctoEstoqueService pedidoLanctoService = new PedidoLanctoEstoqueService();
            block0: for (int i = 0; i < listaLotes.size(); ++i) {
                listaLotes.get(i).setQuantidadeConsumidaOriginal((double)listaLotes.get(i).getQuantidadeConsumida());
                for (MaterialLoteLanctoEstoqueBean loteLancto : listaLotes.get(i).getLancamentosEstoque()) {
                    if (loteLancto == null || !loteLancto.getLancamento().getTipo().equalsIgnoreCase("E")) continue;
                    if (notaEntradaLote != null) {
                        chaves = new HashMap();
                        chaves.put("fil_codigo", material.getFilial().getCodigo());
                        chaves.put("nfi_codigo", notaEntradaLote.getCodigo());
                        chaves.put("lce_codigo", loteLancto.getLancamento().getCodigo());
                        NotaFiscalLanctoEstoqueBean notaLanctoBean = (NotaFiscalLanctoEstoqueBean)notaLanctoService.getBean(chaves);
                        if (notaLanctoBean == null) continue;
                        listaLotes.get(i).setAlterar(true);
                        continue block0;
                    }
                    if (pedidoLote == null) continue;
                    chaves = new HashMap();
                    chaves.put("fil_codigo", material.getFilial().getCodigo());
                    chaves.put("ped_codigo", pedidoLote.getCodigo());
                    chaves.put("lce_codigo", loteLancto.getLancamento().getCodigo());
                    PedidoLanctoEstoqueBean pedidoLanctoBean = (PedidoLanctoEstoqueBean)pedidoLanctoService.getBean(chaves);
                    if (pedidoLanctoBean == null) continue;
                    listaLotes.get(i).setAlterar(true);
                    continue block0;
                }
            }
            material.setLotes(listaLotes);
        }
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo, false);
    }

    public AbstractThreadVO getVO(String filial, String codigo, boolean somenteAtivos) throws ThreadDaoException {
        Set materiais;
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and mat_codigo = ").append(codigo);
        if (somenteAtivos) {
            where.append(" and not mat_inativo ");
        }
        if ((materiais = MaterialDao.load(MaterialVO.class, where.toString())) == null || materiais.size() == 0 || materiais.size() > 1) {
            return null;
        }
        return (MaterialVO)materiais.toArray()[0];
    }

    public EntidadeVO getUltimoFornecedorCompra(String filial, String codigoMaterial) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.ent_codigo ");
        buf.append("   from notafiscal a ");
        buf.append("   left join notafiscalmaterial b on a.fil_codigo = b.fil_codigo and a.nfi_codigo = b.nfi_codigo ");
        buf.append("  where b.mat_codigo = ").append(codigoMaterial);
        buf.append("    and a.fil_codigo = ").append(filial);
        buf.append("    and a.nfi_tipo = '").append("E").append("' ");
        buf.append("    and a.nfi_situacao not IN ('").append("E").append("', '").append("C").append("') ");
        buf.append(" order by a.nfi_codigo desc limit 1");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            EntidadeVO entidade = (EntidadeVO)new EntidadeService().getVO(filial, rs.getString("ent_codigo"));
            return entidade;
        }
        return null;
    }

    public void carregarDadosLotesNotaEntrada(MaterialVO material, NotaFiscalVO notaEntradaLote) throws ThreadDaoException {
        if (material == null || notaEntradaLote == null) {
            return;
        }
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", material.getFilial().getCodigo());
        chaves.put("mat_codigo", material.getCodigo());
        ArrayList<MaterialLoteBean> listaLotes = new MaterialLoteDao().buscaMaterialLote(material.getFilial().getCodigo(), material.getCodigo(), true);
        ArrayList<MaterialLoteBean> retorno = new ArrayList<MaterialLoteBean>();
        if (listaLotes != null) {
            NotaFiscalLanctoEstoqueService notaLanctoService = new NotaFiscalLanctoEstoqueService();
            ConferenciaEntradaLanctoEstoqueService conferenciaLanctoService = new ConferenciaEntradaLanctoEstoqueService();
            for (int i = 0; i < listaLotes.size(); ++i) {
                for (MaterialLoteLanctoEstoqueBean loteLancto : listaLotes.get(i).getLancamentosEstoque()) {
                    if (loteLancto == null || !loteLancto.getLancamento().getTipo().equalsIgnoreCase("E")) continue;
                    chaves = new HashMap();
                    chaves.put("fil_codigo", material.getFilial().getCodigo());
                    chaves.put("nfi_codigo", notaEntradaLote.getCodigo());
                    chaves.put("lce_codigo", loteLancto.getLancamento().getCodigo());
                    NotaFiscalLanctoEstoqueBean notaLanctoBean = (NotaFiscalLanctoEstoqueBean)notaLanctoService.getBean(chaves);
                    if (notaLanctoBean != null) {
                        retorno.add(listaLotes.get(i));
                        continue;
                    }
                    ConferenciaEntradaLanctoEstoqueBean conferenciaLanctoBean = conferenciaLanctoService.getConferenciaEntradaLanctoEstoque(material.getFilial().getCodigo().toString(), loteLancto.getLancamento().getCodigo().toString());
                    if (conferenciaLanctoBean == null || conferenciaLanctoBean.getConferenciaEntrada().getNotaFiscal() == null || conferenciaLanctoBean.getConferenciaEntrada().getNotaFiscal().getCodigo().intValue() != notaEntradaLote.getCodigo().intValue()) continue;
                    retorno.add(listaLotes.get(i));
                }
            }
            material.setLotes(retorno);
        }
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return this.getVO(filial, codigo, false);
    }

    public void inserirMaterialUsuario(MaterialUsuarioVO materialUsuarioVO) throws SQLException {
        this.validarMaterial(Conexao.getStatement(), materialUsuarioVO, true);
        StringBuilder buf = new StringBuilder();
        buf.append("insert into materialusuario (fil_codigo, mat_codigo, usr_codigo, mus_tipo) values(");
        buf.append(materialUsuarioVO.getCodigoFilial()).append(",");
        buf.append(materialUsuarioVO.getCodigoMaterial()).append(",");
        buf.append(StringUtil.textoDBEscape(materialUsuarioVO.getCodigoUsuario())).append(",");
        buf.append(StringUtil.textoDBEscape(materialUsuarioVO.getTipoMaterialUsuario())).append(")");
        Conexao.executeUpdate(materialUsuarioVO.getCodigoFilial().toString(), Conexao.getStatement(), buf);
    }

    public List<MaterialUsuarioVO> buscaUsuarioMaterial(MaterialUsuarioVO materialUsuarioVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.fil_codigo, a.mat_codigo, a.usr_codigo, a.mus_tipo ");
        buf.append("   from materialusuario a ");
        buf.append("  where a.fil_codigo = ").append(materialUsuarioVO.getCodigoFilial());
        if (materialUsuarioVO.getCodigoMaterial() != null && !Funcoes.textoVazio(materialUsuarioVO.getCodigoMaterial().toString())) {
            buf.append("    and a.mat_codigo = ").append(materialUsuarioVO.getCodigoMaterial());
        }
        if (!Funcoes.textoVazio(materialUsuarioVO.getCodigoUsuario())) {
            buf.append("    and a.usr_codigo = ").append(StringUtil.textoDBEscape(materialUsuarioVO.getCodigoUsuario()));
        }
        if (!Funcoes.textoVazio(materialUsuarioVO.getTipoMaterialUsuario())) {
            buf.append("    and a.mus_tipo = ").append(StringUtil.textoDBEscape(materialUsuarioVO.getTipoMaterialUsuario()));
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<MaterialUsuarioVO> listaMaterial = new ArrayList<MaterialUsuarioVO>();
        while (rs.next()) {
            MaterialUsuarioVO materialUsuario = new MaterialUsuarioVO();
            materialUsuario.setCodigoFilial(rs.getInt("fil_codigo"));
            materialUsuario.setCodigoMaterial(rs.getInt("mat_codigo"));
            materialUsuario.setCodigoUsuario(rs.getString("usr_codigo"));
            materialUsuario.setTipoMaterialUsuario(rs.getString("mus_tipo"));
            listaMaterial.add(materialUsuario);
        }
        return listaMaterial;
    }

    public List<MaterialVO> buscaMaterial(MaterialUsuarioVO materialUsuarioVO) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.mat_codigo, a.mat_descricao ");
        buf.append("   from material a ");
        buf.append("  where a.fil_codigo = ").append(materialUsuarioVO.getCodigoFilial());
        if (!Funcoes.textoVazio(materialUsuarioVO.getCodigoMaterial().toString())) {
            buf.append("    and a.mat_codigo = ").append(materialUsuarioVO.getCodigoMaterial());
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<MaterialVO> listaMaterial = new ArrayList<MaterialVO>();
        while (rs.next()) {
            MaterialVO materialVO = new MaterialVO();
            materialVO.setCodigo(rs.getInt("mat_codigo"));
            materialVO.setDescricao(rs.getString("mat_descricao"));
            listaMaterial.add(materialVO);
        }
        return listaMaterial;
    }

    public void deletar(MaterialUsuarioVO materialUsuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("delete from materialUsuario where fil_codigo = ");
        buf.append(materialUsuario.getCodigoFilial()).append(" and mat_codigo = ");
        buf.append(materialUsuario.getCodigoMaterial());
        buf.append(" and usr_codigo = ").append(StringUtil.textoDBEscape(materialUsuario.getCodigoUsuario()));
        buf.append(" and mus_tipo = ").append(StringUtil.textoDBEscape(materialUsuario.getTipoMaterialUsuario()));
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(materialUsuario.getCodigoFilial().toString(), st, buf);
        this.validarMaterial(st, materialUsuario, false);
    }

    public void validarMaterial(Statement st, MaterialUsuarioVO materialUsuarioVO, boolean situacao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.mat_codigo ");
        buf.append("   from materialusuario a ");
        buf.append("  where a.fil_codigo = ").append(materialUsuarioVO.getCodigoFilial());
        buf.append(" and a.mat_codigo = ").append(materialUsuarioVO.getCodigoMaterial());
        buf.append(" and mus_tipo = ").append(StringUtil.textoDBEscape(materialUsuarioVO.getTipoMaterialUsuario()));
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (!rs.next()) {
            StringBuilder but = new StringBuilder();
            but.append(" update material set ");
            if (materialUsuarioVO.getTipoMaterialUsuario().equals("R")) {
                but.append("  mat_reposicaoautomatica = ").append(situacao);
            } else {
                but.append(" mat_avisarvalidadelote = ").append(situacao);
            }
            but.append("  where fil_codigo = ").append(materialUsuarioVO.getCodigoFilial());
            but.append(" and mat_codigo = ").append(materialUsuarioVO.getCodigoMaterial());
            if (!Funcoes.textoVazio(materialUsuarioVO.getCodigoMaterial().toString())) {
                but.append("    and mat_codigo = ").append(materialUsuarioVO.getCodigoMaterial());
            }
            Conexao.executeUpdate(materialUsuarioVO.getCodigoFilial().toString(), Conexao.getStatement(), but);
        }
    }

    public AbstractThreadBean getBeanNFI(Integer codigoFilial, Integer codigoMaterial) throws SQLException, ThreadDaoException {
        MaterialBean materialBean = null;
        StringBuilder buffer = new StringBuilder();
        buffer.append(" select ");
        buffer.append(" nfi.nfi_codigo");
        buffer.append(" from notafiscal nfi");
        buffer.append(" join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo");
        buffer.append(" where nfi.fil_codigo = ").append(codigoFilial);
        buffer.append(" and nfi.usr_codcancelada is null");
        buffer.append(" and nfm.mat_codigo  =").append(codigoMaterial);
        buffer.append(" order by nfi.nfi_codigo desc limit 1");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
        if (rs.next()) {
            buffer.delete(0, buffer.length());
            buffer.append(" select ");
            buffer.append(" nfi.nfi_codigo,");
            buffer.append(" nfi.nfi_valorfrete/sum(nfm.nfm_quantidade) as frete");
            buffer.append(" from notafiscal nfi");
            buffer.append(" join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo");
            buffer.append(" where nfi.fil_codigo = ").append(codigoFilial);
            buffer.append(" and nfi.usr_codcancelada is null");
            buffer.append(" and nfi.nfi_codigo =  ").append(rs.getString("nfi_codigo"));
            buffer.append(" group by nfi.nfi_codigo, nfi.nfi_valorfrete");
            buffer.append(" order by nfi.nfi_codigo desc limit 1");
            ResultSet res = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
            if (res.next()) {
                materialBean = (MaterialBean)this.getBean(String.valueOf(codigoFilial), String.valueOf(codigoMaterial), false, null, null, true, true);
                materialBean.setCodigoUltimaCompraNfi(res.getInt("nfi_codigo"));
                materialBean.setCalculoRateioFreteUltimaCompra(res.getDouble("frete"));
            }
        }
        return materialBean;
    }

    public AbstractThreadBean getBeanConf(Integer codigoFilial, Integer codigoMaterial, Integer nota, Integer pedido) throws SQLException, ThreadDaoException {
        MaterialBean materialBean = null;
        StringBuilder buffer = new StringBuilder();
        buffer.append(" select");
        buffer.append(" le.lce_codigo as codigo");
        buffer.append(" from lanctoestoque le");
        buffer.append(" join conferenciaentradalanctoestoque cele on le.fil_codigo = cele.fil_codigo and le.lce_codigo = cele.lce_codigo");
        buffer.append(" left join conferenciaentradamaterial cem on le.fil_codigo = cem.fil_codigo and cele.cen_codigo = cem.cen_codigo");
        buffer.append(" left join conferenciaentrada ce on ce.fil_codigo = cem.fil_codigo and ce.cen_codigo = cem.cen_codigo");
        buffer.append(" where le.fil_codigo = ").append(codigoFilial);
        buffer.append(" and le.lce_tipo = 'E'");
        buffer.append(" and le.lce_tipoorigem = 'C'");
        buffer.append(" and ce.usr_codcancelamento is null");
        buffer.append(" and cem.mat_codigo = ").append(codigoMaterial);
        if (nota != null && nota > 0) {
            buffer.append(" and ce.nfi_codigo is not null and ce.nfi_codigo > 0 ");
        }
        if (pedido != null && pedido > 0) {
            buffer.append(" and ce.ped_codigo is not null and ce.ped_codigo > 0 ");
        }
        buffer.append(" order by le.lce_codigo desc ");
        buffer.append(" limit 1");
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buffer.toString());
        if (rs.next()) {
            buffer.delete(0, buffer.length());
            buffer.append(" select");
            buffer.append(" ce.cen_codigo ");
            if (pedido != null && pedido > 0) {
                buffer.append(" , pe.ped_valorfrete as valorFrete");
                buffer.append(" , pe.ped_valorfrete/sum(cem.cem_qtderecebida) as frete");
            } else if (nota != null && nota > 0) {
                buffer.append(" , ne.nfi_valorfrete as valorFrete");
                buffer.append(" , ne.nfi_valorfrete/sum(cem.cem_qtderecebida) as frete");
            } else {
                buffer.append(" , 0 as valorFrete");
                buffer.append(" , 0 as frete");
            }
            buffer.append(" from lanctoestoque le");
            buffer.append(" join conferenciaentradalanctoestoque cele on le.fil_codigo = cele.fil_codigo and le.lce_codigo = cele.lce_codigo");
            buffer.append(" left join conferenciaentradamaterial cem on le.fil_codigo = cem.fil_codigo and cele.cen_codigo = cem.cen_codigo");
            buffer.append(" left join conferenciaentrada ce on ce.fil_codigo = cem.fil_codigo and ce.cen_codigo = cem.cen_codigo");
            buffer.append(" left join notafiscal ne on ce.fil_codigo = ne.fil_codigo and ce.nfi_codigo = ne.nfi_codigo");
            buffer.append(" left join pedido pe on ce.fil_codigo = pe.fil_codigo and ce.ped_codigo = pe.ped_codigo");
            buffer.append(" where le.fil_codigo = ").append(codigoFilial);
            buffer.append(" and le.lce_tipo = 'E'");
            buffer.append(" and le.lce_tipoorigem = 'C'");
            buffer.append(" and ce.usr_codcancelamento is null");
            if (nota != null && nota > 0) {
                buffer.append(" and ce.nfi_codigo is not null and ce.nfi_codigo > 0 ");
            }
            if (pedido != null && pedido > 0) {
                buffer.append(" and pe.ped_codigo is not null and pe.ped_codigo > 0 ");
            }
            buffer.append(" and le.lce_codigo = ").append(rs.getInt("codigo"));
            buffer.append(" group by ce.cen_codigo");
            if (pedido != null && pedido > 0) {
                buffer.append(" , pe.ped_valorfrete");
            } else if (nota != null && nota > 0) {
                buffer.append(" , ne.nfi_valorfrete");
            }
            buffer.append(" order by ce.cen_codigo desc");
            buffer.append(" limit 1");
            ResultSet res = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
            if (res.next()) {
                materialBean = (MaterialBean)this.getBean(String.valueOf(codigoFilial), String.valueOf(codigoMaterial), false, null, null, true, true);
                materialBean.setCodigoUltimaCompraCen(res.getInt("cen_codigo"));
                materialBean.setFreteUltimaCompra(res.getDouble("valorFrete"));
                materialBean.setCalculoRateioFreteUltimaCompra(res.getDouble("frete"));
            }
        }
        return materialBean;
    }

    public AbstractThreadBean getBeanPED(Integer codigoFilial, Integer codigoMaterial) throws SQLException, ThreadDaoException {
        MaterialBean materialBean = null;
        StringBuilder buffer = new StringBuilder();
        buffer.append(" select");
        buffer.append(" ped.ped_codigo");
        buffer.append(" from pedido ped");
        buffer.append(" join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo");
        buffer.append(" where ped.fil_codigo = ").append(codigoFilial);
        buffer.append(" and ped.ped_dataexclusao is null");
        buffer.append(" and pma.mat_codigo = ").append(codigoMaterial);
        buffer.append(" order by ped.ped_codigo desc");
        buffer.append(" limit 1");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
        if (rs.next()) {
            buffer.delete(0, buffer.length());
            buffer.append(" select");
            buffer.append(" ped.ped_codigo,");
            buffer.append(" ped.ped_valorfrete/sum(pma.pma_quantidade) as frete");
            buffer.append(" from pedido ped");
            buffer.append(" join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo");
            buffer.append(" where ped.fil_codigo = ").append(codigoFilial);
            buffer.append(" and ped.ped_codigo = ").append(rs.getString("ped_codigo"));
            buffer.append(" and ped.ped_dataexclusao is null");
            buffer.append(" group by ped.ped_codigo, ped.ped_valorfrete");
            buffer.append(" order by ped.ped_codigo desc");
            buffer.append(" limit 1");
            ResultSet res = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
            if (res.next()) {
                materialBean = (MaterialBean)this.getBean(String.valueOf(codigoFilial), String.valueOf(codigoMaterial), false, null, null, true, true);
                materialBean.setCodigoUltimaCompraPed(res.getInt("ped_codigo"));
                materialBean.setCalculoRateioFreteUltimaCompra(res.getDouble("frete"));
            }
        }
        return materialBean;
    }
}

