/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.laboratorio.estoque.almoxarifado.DadosUltimosCustos;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.LancamentoEstoqueUepsBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class LancamentoEstoqueUepsDao
extends AbstractThreadDao {
    public Integer getProximaCelula(String codigoFilial, String codigoMaterial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT lce.cel_codigo as codigoCelula ");
        buf.append("   FROM lanctoestoqueueps uep ");
        buf.append("   JOIN lanctoestoque lce ON uep.fil_codigo = lce.fil_codigo and uep.lce_codigo = lce.lce_codigo ");
        buf.append("  WHERE uep.fil_codigo = ").append(codigoFilial);
        buf.append("    AND lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    AND uep.lce_kodigo IS NULL ");
        buf.append("    AND lce.lce_datahoracancelamento is null ");
        buf.append("    AND uep.uep_saldorestante > 0 ");
        buf.append("    AND (1 BETWEEN (SELECT COALESCE(SUM(aux.uep_saldorestante), 0) ");
        buf.append("                      FROM (SELECT abc2.fil_codigo ");
        buf.append("                                  ,abc2.lce_datahora ");
        buf.append("                                  ,abc1.uep_saldorestante ");
        buf.append("                              FROM lanctoestoqueueps abc1 ");
        buf.append("                              JOIN lanctoestoque abc2 on abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        buf.append("                             WHERE abc2.mat_codigo = ").append(codigoMaterial);
        buf.append("                               AND abc2.fil_codigo = ").append(codigoFilial);
        buf.append("                               AND abc2.lce_datahoracancelamento is null ");
        buf.append("                             ORDER BY abc2.lce_datahora DESC) aux ");
        buf.append("                     WHERE aux.fil_codigo = ").append(codigoFilial);
        buf.append("                       AND aux.lce_datahora > lce.lce_datahora ");
        buf.append("                   ) ");
        buf.append("               AND (SELECT COALESCE(SUM(aux.uep_saldorestante), 0) ");
        buf.append("                      FROM (SELECT abc2.fil_codigo ");
        buf.append("                                  ,abc2.lce_datahora ");
        buf.append("                                  ,abc1.uep_saldorestante ");
        buf.append("                              FROM lanctoestoqueueps abc1 ");
        buf.append("                              JOIN lanctoestoque abc2 on abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        buf.append("                             WHERE abc2.mat_codigo = ").append(codigoMaterial);
        buf.append("                               AND abc2.fil_codigo = ").append(codigoFilial);
        buf.append("                               AND abc2.lce_datahoracancelamento is null ");
        buf.append("                             ORDER BY abc2.lce_datahora DESC) aux ");
        buf.append("                     WHERE aux.fil_codigo = ").append(codigoFilial);
        buf.append("                       AND aux.lce_datahora >= lce.lce_datahora)) ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("codigoCelula");
        }
        return null;
    }

    public ArrayList<LancamentoEstoqueUepsBean> getLancamentosOrigem(String codigoFilial, Double quantidade, String codigoMaterial) throws ThreadDaoException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select uep.* ");
        sql.append("   from lanctoestoqueueps uep ");
        sql.append("   join lanctoestoque lce on uep.fil_codigo = lce.fil_codigo and uep.lce_codigo = lce.lce_codigo ");
        sql.append("  where uep.fil_codigo = ").append(codigoFilial);
        sql.append("    and uep.lce_kodigo IS NULL ");
        sql.append("    and lce.mat_codigo = ").append(codigoMaterial);
        sql.append("    and lce.lce_datahoracancelamento is null ");
        sql.append("    and uep.uep_saldorestante > 0 ");
        sql.append("    and (uep.uep_saldorestante < ").append(quantidade);
        sql.append("        or ").append(quantidade).append(" between (select COALESCE(SUM(aux.uep_saldorestante), 0) ");
        sql.append("                                                     from (select abc2.fil_codigo ");
        sql.append("                                                                 ,abc2.lce_datahora ");
        sql.append("                                                                 ,abc1.uep_saldorestante ");
        sql.append("                                                             from lanctoestoqueueps abc1 ");
        sql.append("                                                             join lanctoestoque abc2 on abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        sql.append("                                                            where abc2.mat_codigo = ").append(codigoMaterial);
        sql.append("                                                              and abc2.fil_codigo = ").append(codigoFilial);
        sql.append("                                                              and abc2.lce_datahoracancelamento is null ");
        sql.append("                                                         order by abc2.lce_datahora DESC) aux ");
        sql.append("                                                    where aux.fil_codigo = ").append(codigoFilial);
        sql.append("                                                      and aux.lce_datahora > lce.lce_datahora) ");
        sql.append("                                              and (select COALESCE(SUM(aux.uep_saldorestante), 0) ");
        sql.append("                                                     from (select abc2.fil_codigo ");
        sql.append("                                                                 ,abc2.lce_datahora ");
        sql.append("                                                                 ,abc1.uep_saldorestante ");
        sql.append("                                                             from lanctoestoqueueps abc1 ");
        sql.append("                                                             join lanctoestoque abc2 on abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        sql.append("                                                            where abc2.mat_codigo = ").append(codigoMaterial);
        sql.append("                                                              and abc2.fil_codigo = ").append(codigoFilial);
        sql.append("                                                              and abc2.lce_datahoracancelamento is null ");
        sql.append("                                                         order by abc2.lce_datahora DESC) aux ");
        sql.append("                                                    where aux.fil_codigo = ").append(codigoFilial);
        sql.append("                                                      and aux.lce_datahora >= lce.lce_datahora)) ");
        Set aux = this.loadManual(LancamentoEstoqueUepsBean.class, sql.toString());
        if (aux == null || aux.size() == 0) {
            return null;
        }
        ArrayList<LancamentoEstoqueUepsBean> lista = new ArrayList<LancamentoEstoqueUepsBean>();
        for (LancamentoEstoqueUepsBean uepsAux : aux) {
            lista.add(uepsAux);
        }
        if (lista.size() == 0) {
            return null;
        }
        Collections.sort(lista);
        return lista;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    public Set getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and lce_codigo = " + codigo;
        Set lanctos = LancamentoEstoqueUepsDao.load(LancamentoEstoqueUepsBean.class, where);
        if (lanctos == null || lanctos.size() == 0) {
            return null;
        }
        return lanctos;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DadosUltimosCustos> getUltimosCustos(String filial, String material, int quantidade) throws SQLException {
        ArrayList<DadosUltimosCustos> arrayList;
        block7: {
            Statement st;
            block5: {
                block6: {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select lce.lce_conciliacao as data ");
                    buf.append("       ,uep.uep_valorunitario as valor ");
                    buf.append("       ,uep.uep_quantidade as qtde ");
                    buf.append("   from lanctoestoqueueps uep ");
                    buf.append("   join lanctoestoque lce on uep.fil_codigo = lce.fil_codigo and uep.lce_codigo = lce.lce_codigo and lce.lce_tipo = '").append("E").append("' and lce.lce_situacao = '").append("O").append("' ");
                    buf.append("  where lce.fil_codigo = ").append(filial);
                    buf.append("    and lce.mat_codigo = ").append(material);
                    buf.append("    and lce.lce_datahoracancelamento is null ");
                    buf.append("  order by lce.lce_conciliacao desc ");
                    buf.append("  limit ").append(quantidade);
                    st = null;
                    try {
                        st = Conexao.getStatement();
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        ArrayList<DadosUltimosCustos> lista = new ArrayList<DadosUltimosCustos>();
                        while (rs.next()) {
                            DadosUltimosCustos dados = new DadosUltimosCustos(rs.getDate("data"), rs.getDouble("valor"), rs.getDouble("qtde"));
                            lista.add(dados);
                        }
                        if (lista.size() <= 0) break block5;
                        arrayList = lista;
                        if (st == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            Conexao.fecharStatement(st);
                        }
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                return arrayList;
            }
            arrayList = null;
            if (st == null) break block7;
            Conexao.fecharStatement(st);
        }
        return arrayList;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

