/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.laboratorio.estoque.almoxarifado.DadosUltimosCustos;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.LancamentoEstoquePepsBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class LancamentoEstoquePepsDao
extends AbstractThreadDao {
    public Integer getProximaCelula(String codigoFilial, String codigoMaterial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT lce.cel_codigo as codigoCelula ");
        buf.append("   FROM lanctoestoquepeps pep1 ");
        buf.append("   JOIN lanctoestoque lce ON pep1.fil_codigo = lce.fil_codigo AND pep1.lce_codigo = lce.lce_codigo ");
        buf.append("  WHERE pep1.fil_codigo = ").append(codigoFilial);
        buf.append("    AND lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    AND pep1.lce_kodigo IS NULL ");
        buf.append("    AND lce.lce_datahoracancelamento is null ");
        buf.append("    AND pep1.pep_saldorestante > 0 ");
        buf.append("    AND (1 BETWEEN (SELECT Coalesce(SUM(aux.pep_saldorestante), 0) ");
        buf.append("                      FROM (SELECT abc2.fil_codigo ");
        buf.append("                                  ,abc2.lce_datahora ");
        buf.append("                                  ,abc1.pep_saldorestante ");
        buf.append("                              FROM lanctoestoquepeps abc1 ");
        buf.append("                              JOIN lanctoestoque abc2 ON abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        buf.append("                             WHERE abc2.mat_codigo = ").append(codigoMaterial);
        buf.append("                               AND abc2.fil_codigo = ").append(codigoFilial);
        buf.append("                               AND abc2.lce_datahoracancelamento is null ");
        buf.append("                             ORDER BY abc2.lce_datahora) aux ");
        buf.append("                     WHERE aux.fil_codigo = ").append(codigoFilial);
        buf.append("                       AND aux.lce_datahora < lce.lce_datahora ");
        buf.append("                   ) ");
        buf.append("               AND (SELECT Coalesce(SUM(aux.pep_saldorestante), 0) ");
        buf.append("                      FROM (SELECT abc2.fil_codigo ");
        buf.append("                                  ,abc2.lce_datahora ");
        buf.append("                                  ,abc1.pep_saldorestante ");
        buf.append("                              FROM lanctoestoquepeps abc1 ");
        buf.append("                              JOIN lanctoestoque abc2 ON abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        buf.append("                             WHERE abc2.mat_codigo = ").append(codigoMaterial);
        buf.append("                               AND abc2.fil_codigo = ").append(codigoFilial);
        buf.append("                               AND abc2.lce_datahoracancelamento is null ");
        buf.append("                             ORDER BY abc2.lce_datahora) aux ");
        buf.append("                     WHERE aux.fil_codigo = ").append(codigoFilial);
        buf.append("                       AND aux.lce_datahora <= lce.lce_datahora) ");
        buf.append("        ) ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("codigoCelula");
        }
        return null;
    }

    public ArrayList<LancamentoEstoquePepsBean> getLancamentosOrigem(String codigoFilial, Double quantidade, String codigoMaterial) throws ThreadDaoException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select pep1.* ");
        sql.append("   from lanctoestoquepeps pep1 ");
        sql.append("   join lanctoestoque lce on pep1.fil_codigo = lce.fil_codigo and pep1.lce_codigo = lce.lce_codigo ");
        sql.append("  where pep1.fil_codigo = ").append(codigoFilial);
        sql.append("    and pep1.lce_kodigo IS NULL ");
        sql.append("    and lce.mat_codigo = ").append(codigoMaterial);
        sql.append("    and lce.lce_datahoracancelamento is null ");
        sql.append("    and pep1.pep_saldorestante > 0 ");
        sql.append("    and (pep1.pep_saldorestante < ").append(quantidade);
        sql.append("        or ").append(quantidade).append(" between (select COALESCE(SUM(aux.pep_saldorestante), 0) ");
        sql.append("                                                     from (select abc2.fil_codigo ");
        sql.append("                                                                 ,abc2.lce_datahora ");
        sql.append("                                                                 ,abc1.pep_saldorestante ");
        sql.append("                                                             from lanctoestoquepeps abc1 ");
        sql.append("                                                             join lanctoestoque abc2 on abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        sql.append("                                                            where abc2.mat_codigo = ").append(codigoMaterial);
        sql.append("                                                              and abc2.fil_codigo = ").append(codigoFilial);
        sql.append("                                                              and abc2.lce_datahoracancelamento is null ");
        sql.append("                                                         order by abc2.lce_datahora) aux ");
        sql.append("                                                    where aux.fil_codigo = ").append(codigoFilial);
        sql.append("                                                      and aux.lce_datahora < lce.lce_datahora) ");
        sql.append("                                              and (select COALESCE(SUM(aux.pep_saldorestante), 0) ");
        sql.append("                                                     from (select abc2.fil_codigo ");
        sql.append("                                                                 ,abc2.lce_datahora ");
        sql.append("                                                                 ,abc1.pep_saldorestante ");
        sql.append("                                                             from lanctoestoquepeps abc1 ");
        sql.append("                                                             join lanctoestoque abc2 on abc1.fil_codigo = abc2.fil_codigo AND abc1.lce_codigo = abc2.lce_codigo ");
        sql.append("                                                            where abc2.mat_codigo = ").append(codigoMaterial);
        sql.append("                                                              and abc2.fil_codigo = ").append(codigoFilial);
        sql.append("                                                              and abc2.lce_datahoracancelamento is null ");
        sql.append("                                                         order by abc2.lce_datahora) aux ");
        sql.append("                                                    where aux.fil_codigo = ").append(codigoFilial);
        sql.append("                                                      and aux.lce_datahora <= lce.lce_datahora)) ");
        Set aux = this.loadManual(LancamentoEstoquePepsBean.class, sql.toString());
        if (aux == null || aux.size() == 0) {
            return null;
        }
        ArrayList<LancamentoEstoquePepsBean> lista = new ArrayList<LancamentoEstoquePepsBean>();
        for (LancamentoEstoquePepsBean pepsAux : aux) {
            lista.add(pepsAux);
        }
        if (lista.size() == 0) {
            return null;
        }
        Collections.sort(lista);
        return lista;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    public Set getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and lce_codigo = " + codigo;
        Set lanctos = LancamentoEstoquePepsDao.load(LancamentoEstoquePepsBean.class, where);
        if (lanctos == null || lanctos.size() == 0) {
            return null;
        }
        return lanctos;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DadosUltimosCustos> getUltimosCustos(String filial, String material, int quantidade) throws SQLException {
        ArrayList<DadosUltimosCustos> arrayList;
        block7: {
            Statement st;
            block5: {
                block6: {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select lce.lce_conciliacao as data ");
                    buf.append("       ,pep.pep_valorunitario as valor ");
                    buf.append("       ,pep.pep_quantidade as qtde ");
                    buf.append("   from lanctoestoquepeps pep ");
                    buf.append("   join lanctoestoque lce on pep.fil_codigo = lce.fil_codigo and pep.lce_codigo = lce.lce_codigo and lce.lce_tipo = '").append("E").append("' and lce.lce_situacao = '").append("O").append("' ");
                    buf.append("  where lce.fil_codigo = ").append(filial);
                    buf.append("    and lce.mat_codigo = ").append(material);
                    buf.append("    and lce.lce_datahoracancelamento is null ");
                    buf.append("  order by lce.lce_conciliacao desc ");
                    buf.append("  limit ").append(quantidade);
                    st = null;
                    try {
                        st = Conexao.getStatement();
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        ArrayList<DadosUltimosCustos> lista = new ArrayList<DadosUltimosCustos>();
                        while (rs.next()) {
                            DadosUltimosCustos dados = new DadosUltimosCustos(rs.getDate("data"), rs.getDouble("valor"), rs.getDouble("qtde"));
                            lista.add(dados);
                        }
                        if (lista.size() <= 0) break block5;
                        arrayList = lista;
                        if (st == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            Conexao.fecharStatement(st);
                        }
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                return arrayList;
            }
            arrayList = null;
            if (st == null) break block7;
            Conexao.fecharStatement(st);
        }
        return arrayList;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

