/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.util.StringUtil;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class LancamentoEstoqueDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    private final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    public LancamentoEstoqueBean getBean(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append("  where fil_codigo = ").append(filial);
        where.append("    and lce_codigo = ").append(codigo);
        Set aux = LancamentoEstoqueDao.load(LancamentoEstoqueBean.class, where.toString());
        if (aux == null || aux.size() == 0) {
            return null;
        }
        return (LancamentoEstoqueBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append("  where fil_codigo = ").append(filial);
        where.append("    and lce_codigo = ").append(codigo);
        Set aux = LancamentoEstoqueDao.load(LancamentoEstoqueVO.class, where.toString());
        if (aux == null || aux.size() == 0) {
            return null;
        }
        return (LancamentoEstoqueVO)aux.toArray()[0];
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("    and lce_codigo = ").append(codigo);
        Set aux = LancamentoEstoqueDao.load(LancamentoEstoqueVO.class, where.toString());
        if (aux == null || aux.size() == 0) {
            return null;
        }
        return (LancamentoEstoqueVO)aux.toArray()[0];
    }

    public String getSituacaoLancamento(String filial, String codigoLancamentoEstoque) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select lce_situacao ");
        buf.append("   from lanctoestoque ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and lce_codigo = ").append(codigoLancamentoEstoque);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("lce_situacao");
        }
        return null;
    }

    public ArrayList<LancamentoEstoqueBean> getLancamentosMaterial(String codigoFilial, String codigoMaterial, Integer limite) throws ThreadDaoException {
        LinkedHashSet<AbstractThreadBean> aux;
        StringBuilder where = new StringBuilder();
        where.append("  where fil_codigo = ").append(codigoFilial);
        where.append("    and mat_codigo = ").append(codigoMaterial);
        where.append("    and lce_datahoracancelamento IS NULL ");
        where.append("  order by lce_codigo desc ");
        if (limite != null) {
            where.append("  limit ").append(limite);
        }
        if ((aux = this.loadOrdenado(LancamentoEstoqueBean.class, where.toString())) == null || aux.size() == 0) {
            return null;
        }
        return new ArrayList<AbstractThreadBean>(aux);
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set lanctoEstoque = LancamentoEstoqueDao.load(LancamentoEstoqueBean.class, where);
        if (lanctoEstoque == null || lanctoEstoque.size() == 0 || lanctoEstoque.size() > 1) {
            return null;
        }
        return (LancamentoEstoqueBean)lanctoEstoque.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set lanctoEstoque = LancamentoEstoqueDao.load(LancamentoEstoqueVO.class, where);
        if (lanctoEstoque == null || lanctoEstoque.size() == 0 || lanctoEstoque.size() > 1) {
            return null;
        }
        return (LancamentoEstoqueVO)lanctoEstoque.toArray()[0];
    }
}

