/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.laboratorio.estoque.almoxarifado.DadosUltimosCustos;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.LancamentoEstoqueCmcBean;
import jalis.model.bean.estoque.SaldoEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class LancamentoEstoqueCmcDao
extends AbstractThreadDao {
    public int atualizaSaldoTotalCMC(String codigoFilial, String codigoMaterial, Date data, Double valorUnitario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update saldoestoque ");
        buf.append("    set sde_totalcmc = ").append(Funcoes.limpaDecimal(valorUnitario)).append(" * sde_saldo ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and mat_codigo = ").append(codigoMaterial);
        buf.append("    and sde_data = '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
        return Conexao.executeUpdate(codigoFilial, Conexao.getStatement(), buf.toString());
    }

    public int atualizaTodasCelulasCMC(String codigoFilial, String codigoMaterial, Date data, Double valorUnitario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update saldoestoquecelula ");
        buf.append("    set ces_totalcmc = ").append(Funcoes.limpaDecimal(valorUnitario)).append(" * ces_saldo ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        buf.append("    and mat_codigo = ").append(codigoMaterial);
        buf.append("    and ces_data = '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
        return Conexao.executeUpdate(codigoFilial, Conexao.getStatement(), buf.toString());
    }

    public LancamentoEstoqueCmcBean getCmcAtual(String codigoFilial, String codigoMaterial) throws ThreadDaoException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select cmc.* ");
        buf.append("   from lanctoestoquecmc cmc ");
        buf.append("   join lanctoestoque lce on cmc.fil_codigo = lce.fil_codigo and cmc.lce_codigo = lce.lce_codigo ");
        buf.append("  where cmc.fil_codigo = ").append(codigoFilial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_datahoracancelamento is null ");
        buf.append("    and lce.lce_codigo = (select MAX(lce.lce_codigo) ");
        buf.append("                            from lanctoestoquecmc cmc ");
        buf.append("                            join lanctoestoque lce on cmc.fil_codigo = lce.fil_codigo and cmc.lce_codigo = lce.lce_codigo ");
        buf.append("                           where cmc.fil_codigo = ").append(codigoFilial);
        buf.append("                             and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("                             and lce.lce_datahoracancelamento is null ");
        buf.append("                          ) ");
        buf.append("  order by cmc.cmc_codigo desc ");
        Set resultado = this.loadManual(LancamentoEstoqueCmcBean.class, buf.toString());
        if (resultado != null && resultado.size() > 0) {
            return (LancamentoEstoqueCmcBean)resultado.toArray()[0];
        }
        return null;
    }

    public Double getQuantidadeEntradas(String codigoFilial, String codigoMaterial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(cmc.cmc_quantidade) as qtde ");
        buf.append("   from lanctoestoquecmc cmc ");
        buf.append("   join lanctoestoque lce on cmc.fil_codigo = lce.fil_codigo and cmc.lce_codigo = lce.lce_codigo ");
        buf.append("  where cmc.fil_codigo = ").append(codigoFilial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_tipo = '").append("E").append("' ");
        buf.append("    and lce.lce_datahoracancelamento is null ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs != null && rs.next()) {
            return rs.getDouble("qtde");
        }
        return null;
    }

    public Double getValorTotalEntradas(String codigoFilial, String codigoMaterial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select SUM(cmc.cmc_quantidade * cmc.cmc_valorunitarioentrada) as total ");
        buf.append("   from lanctoestoquecmc cmc ");
        buf.append("   join lanctoestoque lce on cmc.fil_codigo = lce.fil_codigo and cmc.lce_codigo = lce.lce_codigo ");
        buf.append("  where cmc.fil_codigo = ").append(codigoFilial);
        buf.append("    and lce.mat_codigo = ").append(codigoMaterial);
        buf.append("    and lce.lce_tipo = '").append("E").append("' ");
        buf.append("    and lce.lce_datahoracancelamento is null ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs != null && rs.next()) {
            return rs.getDouble("total");
        }
        return null;
    }

    public SaldoEstoqueBean getValorCustoData(String codigoFilial, String codigoMaterial, Date data) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(codigoFilial);
        where.append("   and mat_codigo = ").append(codigoMaterial);
        where.append("   and sde_data = '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
        Set resultado = LancamentoEstoqueCmcDao.load(SaldoEstoqueBean.class, where.toString());
        if (resultado != null && resultado.size() > 0) {
            return (SaldoEstoqueBean)resultado.toArray()[0];
        }
        return null;
    }

    public SaldoEstoqueCelulaBean getValorCustoCelulaData(String codigoFilial, String codigoMaterial, String codigoCelula, Date data) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(codigoFilial);
        where.append("   and mat_codigo = ").append(codigoMaterial);
        where.append("   and cel_codigo = ").append(codigoCelula);
        where.append("   and sde_data = '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
        Set resultado = LancamentoEstoqueCmcDao.load(SaldoEstoqueCelulaBean.class, where.toString());
        if (resultado != null && resultado.size() > 0) {
            return (SaldoEstoqueCelulaBean)resultado.toArray()[0];
        }
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    public Set getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and lce_codigo = " + codigo;
        Set lanctos = LancamentoEstoqueCmcDao.load(LancamentoEstoqueCmcBean.class, where);
        if (lanctos == null || lanctos.size() == 0) {
            return null;
        }
        return lanctos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DadosUltimosCustos> getUltimosCustos(String filial, String material, int quantidade) throws SQLException {
        ArrayList<DadosUltimosCustos> arrayList;
        block7: {
            Statement st;
            block5: {
                block6: {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select lce.lce_conciliacao as data ");
                    buf.append("       ,cmc.cmc_valorunitarioentrada as valor ");
                    buf.append("       ,cmc.cmc_quantidade as qtde ");
                    buf.append("   from lanctoestoquecmc cmc ");
                    buf.append("   join lanctoestoque lce on cmc.fil_codigo = lce.fil_codigo and cmc.lce_codigo = lce.lce_codigo and lce.lce_tipo = '").append("E").append("' and lce.lce_situacao = '").append("O").append("' ");
                    buf.append("  where lce.fil_codigo = ").append(filial);
                    buf.append("    and lce.mat_codigo = ").append(material);
                    buf.append("    and lce.lce_datahoracancelamento is null ");
                    buf.append("  order by lce.lce_conciliacao desc ");
                    buf.append("  limit ").append(quantidade);
                    st = null;
                    try {
                        st = Conexao.getStatement();
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        ArrayList<DadosUltimosCustos> lista = new ArrayList<DadosUltimosCustos>();
                        while (rs.next()) {
                            DadosUltimosCustos dados = new DadosUltimosCustos(rs.getDate("data"), rs.getDouble("valor"), rs.getDouble("qtde"));
                            lista.add(dados);
                        }
                        if (lista.size() <= 0) break block5;
                        arrayList = lista;
                        if (st == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (st != null) {
                            Conexao.fecharStatement(st);
                        }
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
                return arrayList;
            }
            arrayList = null;
            if (st == null) break block7;
            Conexao.fecharStatement(st);
        }
        return arrayList;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

