/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.CotacaoMaterialBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.CotacaoMaterialVO;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;

public class CotacaoMaterialDao
extends AbstractThreadDao {
    public AbstractThreadBean getBean(String codigoCotacao, String codigoMaterial) throws ThreadDaoException {
        return this.getBean(Variaveis.filialPadrao, codigoCotacao, codigoMaterial);
    }

    public AbstractThreadBean getBean(String filial, String codigoCotacao, String codigoMaterial) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and cot_codigo = ").append(codigoCotacao);
        where.append("   and mat_codigo = ").append(codigoMaterial);
        Set cotacaoMaterial = CotacaoMaterialDao.load(CotacaoMaterialBean.class, where.toString());
        if (cotacaoMaterial == null || cotacaoMaterial.size() == 0 || cotacaoMaterial.size() > 1) {
            return null;
        }
        return (CotacaoMaterialBean)cotacaoMaterial.toArray()[0];
    }

    public Set getMateriaisCotacao(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and cot_codigo = ").append(codigo);
        return CotacaoMaterialDao.load(CotacaoMaterialBean.class, where.toString());
    }

    public Set getMateriaisCotacao(String codigo) throws ThreadDaoException {
        return this.getMateriaisCotacao(Variaveis.filialPadrao, codigo);
    }

    public void removeTodosMateriaisCotacao(String filial, String codigoCotacao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" delete from cotacaomaterial ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and cot_codigo = ").append(codigoCotacao);
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(filial, st, buf.toString());
        Conexao.fecharStatement(st);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and mat_codigo = ").append(codigo);
        Set material = CotacaoMaterialDao.load(CotacaoMaterialVO.class, where.toString());
        if (material == null || material.size() == 0 || material.size() > 1) {
            return null;
        }
        CotacaoMaterialVO vo = (CotacaoMaterialVO)material.toArray()[0];
        return vo;
    }

    public ArrayList<CotacaoMaterialBean> getCotacoesMaterial(String codigoFilial, String codigoMaterial, Integer limite) throws ThreadDaoException {
        Set material;
        StringBuilder where = new StringBuilder();
        where.append(" natural join cotacao ");
        where.append("   where fil_codigo = ").append(codigoFilial);
        where.append("     and mat_codigo = ").append(codigoMaterial);
        where.append("     and upper(cot_situacao) <> '").append("C").append("' ");
        if (limite != null) {
            where.append(" limit ").append(limite);
        }
        if ((material = CotacaoMaterialDao.load(CotacaoMaterialBean.class, where.toString())) == null || material.size() == 0) {
            return null;
        }
        return new ArrayList<CotacaoMaterialBean>(material);
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and mat_codigo = ").append(codigo);
        Set material = CotacaoMaterialDao.load(CotacaoMaterialVO.class, where.toString());
        if (material == null || material.size() == 0 || material.size() > 1) {
            return null;
        }
        CotacaoMaterialVO vo = (CotacaoMaterialVO)material.toArray()[0];
        return vo;
    }
}

