/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.dao.estoque.CotacaoEntidadeDao;
import jalis.model.dao.estoque.CotacaoMaterialDao;
import jalis.model.dao.estoque.CotacaoMaterialEntidadeDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.CotacaoVO;
import java.util.Set;

public class CotacaoDao
extends AbstractThreadDao {
    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        try {
            return this.getBean(Variaveis.filialPadrao, codigo);
        }
        catch (Exception e) {
            new ThreadDaoException("Erro ao buscar dados da cota\u00e7\u00e3o.");
            return null;
        }
    }

    public AbstractThreadBean getBean(String filial, String codigo) throws Exception {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and cot_codigo = ").append(codigo);
        Set cotacao = CotacaoDao.load(CotacaoBean.class, where.toString());
        if (cotacao == null || cotacao.size() == 0 || cotacao.size() > 1) {
            return null;
        }
        CotacaoBean bean = (CotacaoBean)cotacao.toArray()[0];
        bean.setMateriaisCotacao(new CotacaoMaterialDao().getMateriaisCotacao(filial, codigo));
        bean.setEntidadesCotacao(new CotacaoEntidadeDao().getBeans(filial, codigo));
        bean.setMaterialEntidadeCotacao(new CotacaoMaterialEntidadeDao().getMateriaisEntidadesCotacao(filial, codigo));
        return bean;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and cot_codigo = ").append(codigo);
        Set cotacao = CotacaoDao.load(CotacaoVO.class, where.toString());
        if (cotacao == null || cotacao.size() == 0 || cotacao.size() > 1) {
            return null;
        }
        CotacaoVO vo = (CotacaoVO)cotacao.toArray()[0];
        return vo;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and cot_codigo = ").append(codigo);
        Set cotacao = CotacaoDao.load(CotacaoVO.class, where.toString());
        if (cotacao == null || cotacao.size() == 0 || cotacao.size() > 1) {
            return null;
        }
        CotacaoVO vo = (CotacaoVO)cotacao.toArray()[0];
        return vo;
    }
}

