/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.estoque;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CelulaEstoqueDao
extends AbstractThreadDao {
    public ArrayList<CelulaEstoqueBean> getTodasCelulasFilial(String filial) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and cel_inativa = false ");
        where.append(" order by cel_descricao ");
        Set celulaEstoque = CelulaEstoqueDao.load(CelulaEstoqueBean.class, where.toString());
        if (celulaEstoque != null && celulaEstoque.size() > 0) {
            ArrayList<CelulaEstoqueBean> lista = new ArrayList<CelulaEstoqueBean>();
            Iterator it = celulaEstoque.iterator();
            while (it.hasNext()) {
                lista.add((CelulaEstoqueBean)it.next());
            }
            if (lista.size() > 0) {
                Collections.sort(lista, new Comparator<CelulaEstoqueBean>(){

                    @Override
                    public int compare(CelulaEstoqueBean o1, CelulaEstoqueBean o2) {
                        return o1.getDescricao().toLowerCase().compareTo(o2.getDescricao().toLowerCase());
                    }
                });
                return lista;
            }
            return null;
        }
        return null;
    }

    public ArrayList<CelulaEstoqueVO> getTodasCelulasFilialVO(String filial) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and cel_inativa = false ");
        where.append(" order by cel_descricao ");
        Set celulaEstoque = CelulaEstoqueDao.load(CelulaEstoqueVO.class, where.toString());
        if (celulaEstoque != null && celulaEstoque.size() > 0) {
            ArrayList<CelulaEstoqueVO> lista = new ArrayList<CelulaEstoqueVO>();
            Iterator it = celulaEstoque.iterator();
            while (it.hasNext()) {
                lista.add((CelulaEstoqueVO)it.next());
            }
            if (lista.size() > 0) {
                Collections.sort(lista, new Comparator<CelulaEstoqueVO>(){

                    @Override
                    public int compare(CelulaEstoqueVO o1, CelulaEstoqueVO o2) {
                        return o1.getDescricao().toLowerCase().compareTo(o2.getDescricao().toLowerCase());
                    }
                });
                return lista;
            }
            return null;
        }
        return null;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and cel_codigo = ").append(codigo);
        Set celulaEstoque = CelulaEstoqueDao.load(CelulaEstoqueBean.class, where.toString());
        if (celulaEstoque == null || celulaEstoque.size() == 0 || celulaEstoque.size() > 1) {
            return null;
        }
        return (CelulaEstoqueBean)celulaEstoque.toArray()[0];
    }

    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append("   and cel_codigo = ").append(codigo);
        Set celulaEstoque = CelulaEstoqueDao.load(CelulaEstoqueBean.class, where.toString());
        if (celulaEstoque == null || celulaEstoque.size() == 0 || celulaEstoque.size() > 1) {
            return null;
        }
        return (CelulaEstoqueBean)celulaEstoque.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        Set lista = this.loadVO(CelulaEstoqueVO.class, " where fil_codigo = " + filial + " and cel_codigo = " + codigo);
        if (lista == null || lista.size() == 0 || lista.size() > 1) {
            return null;
        }
        CelulaEstoqueVO bean = (CelulaEstoqueVO)lista.toArray()[0];
        return bean;
    }

    public boolean haCelulaPadrao(String filial, Integer codigo) throws ThreadDaoException {
        Statement st = Conexao.getStatement();
        Set beans = new HashSet();
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(filial);
        if (codigo != null) {
            buf.append("  and cel_codigo <> '").append(codigo).append("' ");
        }
        buf.append("  and cel_padrao = true ");
        buf.append("  and cel_inativa = false ");
        beans = CelulaEstoqueDao.load(CelulaEstoqueBean.class, buf.toString());
        Conexao.fecharStatement(st);
        return beans != null && beans.size() >= 1;
    }

    public CelulaEstoqueBean getCelulaPadrao(String filial) throws ThreadDaoException {
        Statement st = Conexao.getStatement();
        Set beans = new HashSet();
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(filial);
        buf.append("  and cel_padrao = true ");
        buf.append("  and cel_inativa = false ");
        beans = CelulaEstoqueDao.load(CelulaEstoqueBean.class, buf.toString());
        Conexao.fecharStatement(st);
        if (beans != null && beans.size() == 1) {
            return (CelulaEstoqueBean)beans.iterator().next();
        }
        return null;
    }

    public AbstractThreadVO getCelulaPadraoVO(String filial) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and cel_padrao is true";
        Set cels = this.loadVO(CelulaEstoqueVO.class, where);
        if (cels == null || cels.size() == 0 || cels.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)cels.toArray()[0];
    }
}

