/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.triagem;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.triagem.GeladeiraBean;
import jalis.model.bean.cadastro.triagem.GeladeiraPrateleiraBean;
import jalis.model.bean.triagem.GeladeiraTemperaturaBean;
import jalis.model.dao.cadastro.triagem.GeladeiraPrateleiraDao;
import jalis.model.dao.triagem.GeladeiraTemperaturaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class GeladeiraDao
extends AbstractThreadDao {
    public AbstractThreadBean getBean(String filial, String codigo, boolean carregarTemperaturas) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and gel_codigo = " + codigo;
        Set geladeiras = GeladeiraDao.load(GeladeiraBean.class, where);
        if (geladeiras == null || geladeiras.size() == 0 || geladeiras.size() > 1) {
            return null;
        }
        GeladeiraBean geladeira = (GeladeiraBean)geladeiras.toArray()[0];
        this.loadPrateleiras(geladeira);
        if (carregarTemperaturas) {
            this.loadTemperaturas(geladeira);
        }
        return geladeira;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        String where = " where gel_codigo = " + codigo;
        Set geladeiras = GeladeiraDao.load(GeladeiraBean.class, where);
        if (geladeiras == null || geladeiras.size() == 0 || geladeiras.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)geladeiras.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and gel_codigo = " + codigo;
        Set geladeiras = this.loadVO(GeladeiraVO.class, where);
        if (geladeiras == null || geladeiras.size() == 0 || geladeiras.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)geladeiras.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and gel_codigo = " + codigo;
        Set geladeiras = this.loadVO(GeladeiraVO.class, where);
        if (geladeiras == null || geladeiras.size() == 0 || geladeiras.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)geladeiras.toArray()[0];
    }

    public void loadPrateleiras(GeladeiraBean bean) throws ThreadDaoException {
        GeladeiraPrateleiraDao dao = new GeladeiraPrateleiraDao();
        String where = " where fil_codigo = " + bean.getFilial().getCodigo() + " and gel_codigo = " + bean.getCodigo();
        ArrayList<GeladeiraPrateleiraBean> prateleiras = new ArrayList<GeladeiraPrateleiraBean>(GeladeiraPrateleiraDao.load(GeladeiraPrateleiraBean.class, where));
        Collections.sort(prateleiras);
        bean.setPrateleiras(prateleiras);
    }

    @Override
    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        AbstractThreadBean bean = super.voToBean(vo, classeBean);
        this.loadPrateleiras((GeladeiraBean)bean);
        return bean;
    }

    public void loadTemperaturas(GeladeiraBean bean) throws ThreadDaoException {
        GeladeiraTemperaturaDao dao = new GeladeiraTemperaturaDao();
        String where = " where fil_codigo = " + bean.getFilial().getCodigo() + " and gel_codigo = " + bean.getCodigo();
        bean.setTemperaturas(GeladeiraTemperaturaDao.load(GeladeiraTemperaturaBean.class, where));
    }

    public boolean podeDesativarRemoverGeladeira(String filial, String codigoGeladeira) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select 1 ");
        buf.append("   from estantes ett ");
        buf.append("   join examerequisicaosoroteca ers on ett.fil_codigo = ers.fil_codigo and ett.ett_codigo = ers.ett_codigo ");
        buf.append("   join examerequisicao exr on ers.fil_codigo = exr.fil_codigo and ers.exa_codigo = exr.exa_codigo and ers.req_codigo = exr.req_codigo and ers.mco_codigo = exr.mco_codigo and exr.exr_excluido = false ");
        buf.append("  where ett.fil_codigo = ").append(filial);
        buf.append("    and ett.gel_codigo = ").append(codigoGeladeira);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        return !rs.next();
    }
}

