/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.cadastro.financeiro.CentroCustoPlanoContaBean;
import jalis.model.bean.cadastro.financeiro.PlanoContaBean;
import jalis.model.dao.cadastro.financeiro.CentroCustoPlanoContaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class PlanoContaDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and plc_reduzido = " + codigo;
        Set planos = PlanoContaDao.load(PlanoContaBean.class, where);
        if (planos == null || planos.size() == 0 || planos.size() > 1) {
            return null;
        }
        PlanoContaBean plano = (PlanoContaBean)planos.toArray()[0];
        this.loadCentrosCusto(plano);
        return plano;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and plc_reduzido = " + codigo;
        Set planos = PlanoContaDao.load(PlanoContaBean.class, where);
        if (planos == null || planos.size() == 0 || planos.size() > 1) {
            return null;
        }
        PlanoContaBean plano = (PlanoContaBean)planos.toArray()[0];
        this.loadCentrosCusto(plano);
        return plano;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and plc_reduzido = " + codigo;
        Set planos = this.loadVO(PlanoContaVO.class, where);
        if (planos == null || planos.size() == 0 || planos.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)planos.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and plc_reduzido = " + codigo;
        Set planos = this.loadVO(PlanoContaVO.class, where);
        if (planos == null || planos.size() == 0 || planos.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)planos.toArray()[0];
    }

    public PlanoContaVO getMaiorConta(String contaPai, String tamanhoNivel) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and plc_conta like '" + contaPai + "%' and length(plc_conta) = " + tamanhoNivel + " order by plc_conta desc limit 1";
        Set planos = this.loadVO(PlanoContaVO.class, where);
        if (planos == null || planos.size() == 0 || planos.size() > 1) {
            return null;
        }
        return (PlanoContaVO)planos.toArray()[0];
    }

    public boolean contaExiste(String conta) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and plc_conta = '" + conta + "'";
        Set planos = this.loadVO(PlanoContaVO.class, where);
        return planos != null && planos.size() >= 1;
    }

    public boolean contaExisteFilhos(String contaPai) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and plc_pai = " + contaPai + "";
        Set planos = this.loadVO(PlanoContaVO.class, where);
        return planos != null && planos.size() >= 1;
    }

    private void loadCentrosCusto(PlanoContaBean plano) throws ThreadDaoException {
        CentroCustoPlanoContaDao dao = new CentroCustoPlanoContaDao();
        String where = " where plc_reduzido = " + plano.getReduzido() + " and fil_codigo = " + plano.getFilial().getCodigo();
        Set centros = CentroCustoPlanoContaDao.load(CentroCustoPlanoContaBean.class, where);
        for (CentroCustoPlanoContaBean centro : centros) {
            centro.setPlanoConta((PlanoContaVO)plano.toVO());
        }
        plano.setCentrosCusto(centros);
    }

    @Override
    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        AbstractThreadBean bean = super.voToBean(vo, classeBean);
        this.loadCentrosCusto((PlanoContaBean)bean);
        return bean;
    }

    public void updateTipoContasFilhas(String filial, String contaPai, String tipo) throws ThreadDaoException {
        StringBuilder sql = new StringBuilder();
        sql.append("update planoconta set plc_tipo = '").append(tipo).append("'");
        sql.append(" where fil_codigo = ").append(filial);
        sql.append(" and plc_conta like '").append(contaPai).append("%'");
        Statement st = null;
        try {
            st = Conexao.getStatement();
            Conexao.executeUpdate(filial, st, sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public Set getPlanosTipoApropriacao(String filial, Integer tipo) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filial);
        where.append(" and plc_apropriar = ").append(tipo);
        Set planos = this.loadVO(PlanoContaVO.class, where.toString());
        if (planos == null || planos.size() == 0 || planos.size() > 1) {
            return null;
        }
        return planos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haPlanosContas(String codigoFilial) throws SQLException {
        Statement st;
        block3: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(1) > 0 as haPlanos ");
            buf.append("   from planoconta ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                bl = rs.getBoolean("haPlanos");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        Conexao.fecharStatement(st);
        return bl;
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = PlanoContaDao.load(PlanoContaBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (PlanoContaBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(PlanoContaVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (PlanoContaVO)aux.toArray()[0];
    }
}

