/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.OrigemBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.OrigemVO;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class OrigemDao
extends AbstractThreadDao {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getOrigemPadrao(String filial, String codigo) {
        Set set;
        Statement st = Conexao.getStatement();
        Set beans = new HashSet();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("  and opc_codigo <> ").append(StringUtil.textoDBEscape(codigo));
            buf.append("  and opc_padrao = true ");
            set = beans = OrigemDao.load(OrigemBean.class, buf.toString());
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "OrigemService: 166");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return null;
        }
        Conexao.fecharStatement(st);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getOrigemPadrao(String filial) {
        Set set;
        Statement st = Conexao.getStatement();
        Set beans = new HashSet();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("  and opc_padrao = true ");
            set = beans = OrigemDao.load(OrigemBean.class, buf.toString());
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "OrigemService: 166");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return null;
        }
        Conexao.fecharStatement(st);
        return set;
    }

    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and opc_codigo = " + StringUtil.textoDBEscape(codigo);
        Set origens = OrigemDao.load(OrigemBean.class, where);
        if (origens == null || origens.size() == 0 || origens.size() > 1) {
            return null;
        }
        OrigemBean serie = (OrigemBean)origens.toArray()[0];
        return serie;
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        String where = " where opc_codigo = " + StringUtil.textoDBEscape(codigo);
        Set origens = OrigemDao.load(OrigemBean.class, where);
        if (origens == null || origens.size() == 0 || origens.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)origens.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and opc_codigo = " + StringUtil.textoDBEscape(codigo);
        Set origens = this.loadVO(OrigemVO.class, where);
        if (origens == null || origens.size() == 0 || origens.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)origens.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and opc_codigo = " + StringUtil.textoDBEscape(codigo);
        Set origens = this.loadVO(OrigemVO.class, where);
        if (origens == null || origens.size() == 0 || origens.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)origens.toArray()[0];
    }

    public AbstractThreadVO getOrigemPadrao(FilialVO filial) throws ThreadDaoException {
        String where = " where fil_codigo = " + Integer.toString(filial.getCodigo()) + " and opc_padrao is true";
        Set origens = this.loadVO(OrigemVO.class, where);
        if (origens == null || origens.size() == 0 || origens.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)origens.toArray()[0];
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set loadVO(String where) throws ThreadDaoException {
        LinkedHashSet<OrigemVO> beans = new LinkedHashSet<OrigemVO>();
        String sql = OrigemDao.getSql(OrigemVO.class, where);
        Statement st = null;
        try {
            st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            while (rs.next()) {
                OrigemVO b = (OrigemVO)OrigemVO.class.getConstructors()[0].newInstance(new Object[0]);
                OrigemDao.popularDadosBean(b, rs);
                beans.add(b);
            }
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage() + "\n" + sql.toString());
                catch (Exception e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return beans;
    }
}

