/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.exame;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.SetorBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SetorUsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SetorDao
extends AbstractThreadDao {
    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) {
        return null;
    }

    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and set_codigo = " + codigo;
        Set setores = SetorDao.load(SetorBean.class, where);
        if (setores == null || setores.size() == 0 || setores.size() > 1) {
            return null;
        }
        return (AbstractThreadBean)setores.toArray()[0];
    }

    public ArrayList<SetorBean> getSetoresExame(String codigoFilial, String codigoExame) throws ThreadDaoException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select set.* ");
        buf.append("   from examesetor ese ");
        buf.append("   join setores set on ese.fil_codigo = set.fil_codigo and ese.set_codigo = set.set_codigo ");
        buf.append("  where ese.fil_codigo = ").append(codigoFilial);
        buf.append("    and ese.exa_codigo = '").append(codigoExame).append("' ");
        Set setores = this.loadManual(SetorBean.class, buf.toString());
        if (setores == null || setores.size() == 0) {
            return null;
        }
        return new ArrayList<SetorBean>(setores);
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and set_codigo = " + codigo;
        Set setores = this.loadVO(SetorVO.class, where);
        if (setores == null || setores.size() == 0 || setores.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)setores.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and set_codigo = " + codigo;
        Set setores = this.loadVO(SetorVO.class, where);
        if (setores == null || setores.size() == 0 || setores.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)setores.toArray()[0];
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, String filial) {
    }

    public SetorVO loadVO(String filial, String codigoSetor) throws SQLException {
        Statement st = Conexao.getStatement();
        SetorVO setorVO = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.set_descricao ");
        buf.append("       ,a.set_cor ");
        buf.append("       ,a.set_sigla ");
        buf.append("       ,a.set_responsavel ");
        buf.append("       ,a.usr_codigo ");
        buf.append("       ,b.usr_nome ");
        buf.append("       ,a.set_impressora ");
        buf.append("       ,a.set_enviarmensagem ");
        buf.append("       ,a.set_enviarmensagemretificado ");
        buf.append("       ,a.ide_codigo, set_tipoalimentos, a.set_assinarlaudodigital, a.usr_codlaudodigital ");
        buf.append("   from setores a ");
        buf.append("   left join usuario b on upper(a.usr_codigo) = upper(b.usr_codigo) ");
        buf.append("  where a.fil_codigo = ").append(filial);
        buf.append("    and a.set_codigo = ").append(codigoSetor);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            setorVO = new SetorVO();
            UsuarioVO user = new UsuarioVO();
            setorVO.setCodigo(Integer.parseInt(codigoSetor));
            setorVO.setDescricao(rs.getString("set_descricao"));
            setorVO.setResponsavel(rs.getString("set_responsavel"));
            setorVO.setSigla(rs.getString("set_sigla"));
            setorVO.setCor(rs.getString("set_cor"));
            user.setCodigo(rs.getString("usr_codigo"));
            user.setNome(rs.getString("usr_nome"));
            setorVO.setUsuario(user);
            setorVO.setImpressora(rs.getString("set_impressora"));
            setorVO.setIdentificacaoLamina(rs.getInt("ide_codigo"));
            setorVO.setTipoAlimentos(rs.getString("set_tipoalimentos"));
            setorVO.setEnviarMensagem(rs.getBoolean("set_enviarmensagem"));
            setorVO.setEnviarMensagemRetificado(rs.getBoolean("set_enviarmensagemretificado"));
            setorVO.setAssinarLaudoDigital(rs.getBoolean("set_assinarlaudodigital"));
            setorVO.setUsuarioAssinaLaudoDigital(rs.getString("usr_codlaudodigital"));
        }
        return setorVO;
    }

    public void inserirSetorUsuario(SetorUsuarioVO setorUsuarioVO) throws SQLException {
        this.validarSetor(Conexao.getStatement(), setorUsuarioVO, true);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into setoresusuario (fil_codigo, set_codigo, usr_codigo, seu_tipo) values (");
        sql.append(setorUsuarioVO.getCodigoFilial()).append(", ");
        sql.append(setorUsuarioVO.getCodigoSetor()).append(", '");
        sql.append(setorUsuarioVO.getCodigoUsuario()).append("', '");
        sql.append(setorUsuarioVO.getTipo()).append("')");
        Conexao.executeUpdate(setorUsuarioVO.getCodigoFilial().toString(), Conexao.getStatement(), sql);
    }

    public List<SetorUsuarioVO> buscaUsuarioSetor(SetorUsuarioVO setorUsuarioVO) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select s.fil_codigo, s.set_codigo, s.usr_codigo, s.seu_tipo ");
        sql.append(" from setoresusuario s ");
        sql.append(" where s.fil_codigo = ").append(setorUsuarioVO.getCodigoFilial());
        if (!Funcoes.textoVazio(setorUsuarioVO.getCodigoUsuario())) {
            sql.append("    and s.usr_codigo = ").append(StringUtil.textoDBEscape(setorUsuarioVO.getCodigoUsuario()));
        }
        sql.append(" and s.set_codigo = ").append(setorUsuarioVO.getCodigoSetor());
        sql.append(" and s.set_codigo = ").append(setorUsuarioVO.getCodigoSetor());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
        ArrayList<SetorUsuarioVO> listaSetor = new ArrayList<SetorUsuarioVO>();
        while (rs.next()) {
            SetorUsuarioVO setorUsuario = new SetorUsuarioVO();
            setorUsuario.setCodigoFilial(rs.getInt("fil_codigo"));
            setorUsuario.setCodigoSetor(rs.getInt("set_codigo"));
            setorUsuario.setCodigoUsuario(rs.getString("usr_codigo"));
            setorUsuario.setTipo(rs.getString("seu_tipo"));
            listaSetor.add(setorUsuario);
        }
        return listaSetor;
    }

    public void deletar(SetorUsuarioVO setorUsuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("delete from setoresusuario s where s.fil_codigo = ");
        buf.append(setorUsuario.getCodigoFilial()).append(" and s.set_codigo = ");
        buf.append(setorUsuario.getCodigoSetor());
        buf.append(" and s.usr_codigo = ").append(StringUtil.textoDBEscape(setorUsuario.getCodigoUsuario()));
        buf.append(" and seu_tipo = ").append(StringUtil.textoDBEscape(setorUsuario.getTipo()));
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(setorUsuario.getCodigoFilial().toString(), st, buf);
        this.validarSetor(st, setorUsuario, false);
    }

    public void validarSetor(Statement st, SetorUsuarioVO setorUsuarioVO, boolean situacao) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select s.set_codigo ");
        buf.append("   from setoresusuario s ");
        buf.append("  where s.fil_codigo = ").append(setorUsuarioVO.getCodigoFilial());
        buf.append(" and s.set_codigo = ").append(setorUsuarioVO.getCodigoSetor());
        buf.append(" and s.seu_tipo = ").append(StringUtil.textoDBEscape(setorUsuarioVO.getTipo()));
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (!rs.next()) {
            StringBuilder but = new StringBuilder();
            but.append(" update setores set ");
            but.append("  set_enviarmensagemretificado = ").append(situacao);
            but.append("  where fil_codigo = ").append(setorUsuarioVO.getCodigoFilial());
            but.append(" and set_codigo = ").append(setorUsuarioVO.getCodigoSetor());
            Conexao.executeUpdate(setorUsuarioVO.getCodigoFilial().toString(), Conexao.getStatement(), but);
        }
    }
}

