/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.exame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.service.cadastro.exame.ExameService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExameDao
extends AbstractThreadDao {
    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) {
        return null;
    }

    @Deprecated
    public AbstractThreadBean getBean(String filial, String codigo) {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and exa_codigo = '" + codigo + "'";
        Set setores = this.loadVO(ExameVO.class, where);
        if (setores == null || setores.size() == 0 || setores.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)setores.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + Variaveis.filialPadrao + " and exa_codigo = '" + codigo + "'";
        Set setores = this.loadVO(ExameVO.class, where);
        if (setores == null || setores.size() == 0 || setores.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)setores.toArray()[0];
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, String filial) {
    }

    public ExameVO buscaDadosExames(String filCodigo, String exaCodigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        ExameVO exameVO = null;
        buf.append(" select exa_idademin, exa_idademax, exa_idademintipo, exa_idademaxtipo, exa_sexo, ");
        buf.append(" exa_descricao, exa_horaentrada, exa_horasaida, exa_autorizacao, exa_inmetro, ");
        buf.append(" exa_filtro, exa_diagnostico, exa_interferencia, exa_sinonimo, exa_proibidoweb, ");
        buf.append(" exa_salvaparcial, exa_proibido, exa_qtdeamostras, exa_soa, exa_coa, usr_codassinaweb, exa_tipobpa, ");
        buf.append(" exa_proibidowebpaciente, exa_proibidowebconvenio, exa_proibidowebmedico, exa_proibidowebdestino, exa_proibidowebfiscal, exa_proibidowebresponsavel ");
        buf.append(" , exa_servicotiss, exa_coddespesatiss, exa_undmedidatiss, exa_cabecalhonotificacao, exa_corponotificacao ");
        buf.append(" ,exa_importarpdf ");
        buf.append(" from exames ");
        buf.append(" where fil_codigo= ").append(filCodigo);
        buf.append(" and upper(exa_codigo)=upper(").append(StringUtil.textoDBEscape(exaCodigo)).append(") ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            exameVO = new ExameVO();
            exameVO.setCodigo(exaCodigo);
            exameVO.setDescricao(rs.getString("exa_descricao"));
            exameVO.setIdadeMin(rs.getInt("exa_idademin"));
            exameVO.setIdadeMax(rs.getInt("exa_idademax"));
            exameVO.setIdadeMinTipo(rs.getString("exa_idademintipo"));
            exameVO.setIdadeMaxTipo(rs.getString("exa_idademaxtipo"));
            exameVO.setExaSexo(rs.getString("exa_sexo"));
            exameVO.setHoraEntrada(rs.getString("exa_horaentrada"));
            exameVO.setHoraSaida(rs.getString("exa_horasaida"));
            exameVO.setAutorizacao(rs.getString("exa_autorizacao"));
            exameVO.setInmetro(rs.getBoolean("exa_inmetro"));
            exameVO.setFiltro(rs.getString("exa_filtro"));
            exameVO.setDiagnostico(rs.getString("exa_diagnostico"));
            exameVO.setInterferencia(rs.getString("exa_interferencia"));
            exameVO.setSinonimo(rs.getString("exa_sinonimo"));
            exameVO.setProibidoWeb(rs.getInt("exa_proibidoweb"));
            exameVO.setSalvarParcial(rs.getBoolean("exa_salvaparcial"));
            exameVO.setProibido(rs.getBoolean("exa_proibido"));
            exameVO.setQtdeAmostras(rs.getInt("exa_qtdeamostras"));
            exameVO.setSoa(rs.getString("exa_soa"));
            exameVO.setCoa(rs.getString("exa_coa"));
            exameVO.setCodAssinaWeb(rs.getString("usr_codassinaweb"));
            exameVO.setTipoBpa(rs.getString("exa_tipobpa"));
            exameVO.setProibidoWebPaciente(rs.getBoolean("exa_proibidowebpaciente"));
            exameVO.setProibidoWebConvenio(rs.getBoolean("exa_proibidowebconvenio"));
            exameVO.setProibidoWebMedico(rs.getBoolean("exa_proibidowebmedico"));
            exameVO.setProibidoWebDestino(rs.getBoolean("exa_proibidowebdestino"));
            exameVO.setProibidoWebFiscal(rs.getBoolean("exa_proibidowebfiscal"));
            exameVO.setProibidoWebResponsavel(rs.getBoolean("exa_proibidowebresponsavel"));
            exameVO.setCabecalhoNotificacao(rs.getString("exa_cabecalhonotificacao"));
            exameVO.setCorpoNotificacao(rs.getString("exa_corponotificacao"));
            exameVO.setServicoTiss(rs.getBoolean("exa_servicotiss"));
            exameVO.setCodDespesaTiss(rs.getString("exa_coddespesatiss"));
            exameVO.setUndMedidaTiss(rs.getString("exa_undmedidatiss"));
            exameVO.setImportarPdf(rs.getBoolean("exa_importarpdf"));
        }
        return exameVO;
    }

    public String getCodigoRecipiente(String filial, String exame, int mco, String tabela) throws SQLException {
        StringBuilder rec = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" select rec_codigo from  ").append(tabela);
        buf.append(" where fil_codigo =  ").append(filial);
        buf.append("  and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
        buf.append("  and mco_codigo = ").append(mco);
        if (this.isAgruparColeta()) {
            buf.append("  and rco_interface = true");
        } else {
            buf.append("  and rtr_interface = true");
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            if (!Funcoes.textoVazio(rec.toString())) {
                rec.append(", ");
            }
            rec.append(rs.getInt("rec_codigo"));
        }
        return rec.toString();
    }

    private boolean isAgruparColeta() {
        return ParametrosGerais.getAgruparInterface() == 0;
    }

    public List<Registro> buscarExameAMB(String codigoFilial, String codigoConvenio, String codigoAMB) throws Exception {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT a.exa_codigo as codigoExame, ");
        buf.append(" a.exa_descricao, c.mco_codigo as codigoMaterial, mc.mco_descricao ");
        buf.append(" FROM detalhetabelapreco dtp ");
        buf.append(" LEFT JOIN examematcoleta c ON dtp.fil_codigo = c.fil_codigo ");
        buf.append(" AND c.exa_codigo = dtp.exa_codigo and c.mco_codigo = dtp.mco_codigo and c.emc_default ");
        buf.append(" JOIN exames a ON a.fil_codigo = dtp.fil_codigo ");
        buf.append(" AND dtp.exa_codigo = a.exa_codigo ");
        buf.append(" JOIN convenios con ON a.fil_codigo = con.fil_codigo ");
        buf.append(" AND dtp.tpe_codigo = con.tpe_codigo ");
        buf.append(" JOIN materialcoleta mc ON a.fil_codigo = mc.fil_codigo ");
        buf.append(" AND c.mco_codigo = mc.mco_codigo ");
        buf.append(" WHERE a.fil_codigo = ").append(codigoFilial);
        buf.append(" AND con.con_codigo = ").append(codigoConvenio);
        buf.append(" AND replace(replace(dtp.dtp_codamb, '.', ''), '-', '') = ").append("'").append(codigoAMB).append("'");
        buf.append(" AND dtp.dtp_proibido = false ");
        buf.append(" AND a.exa_proibido = false ");
        buf.append(" ORDER BY codigoExame ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            do {
                buf.setLength(0);
                buf.append(" where fil_codigo = ").append(codigoFilial).append(" and exa_codigo = '").append(rs.getString("codigoExame")).append("' ;");
                ExameVO exameVO = (ExameVO)new ExameService().load(buf.toString()).toArray()[0];
                Registro registro = new Registro(rs);
                registro.setValor("objetoExame", exameVO);
                registro.setValor("exame", codigoAMB);
                registro.setValor("descricaoExame", "");
                exames.add(registro);
            } while (rs.next());
        }
        return exames;
    }

    public void atualizarInterfaceExameRequisicao(String filialPadrao, String codExame, Integer codMatCol) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("select distinct(ier.int_codigo) as intCodigo from interfaceexamerequisicao ier ");
        buf.append("left join examematinterface emi on (ier.fil_codigo = emi.fil_codigo and ier.exa_codigo = emi.exa_codigo and ier.mco_codigo = emi.mco_codigo and ier.int_codigo = emi.int_codigo) ");
        buf.append("where ier.fil_codigo = ").append(filialPadrao);
        buf.append(" and emi.int_codigo is null and ier.exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
        buf.append(" and ier.mco_codigo = ").append(codMatCol);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            StringBuilder bu = new StringBuilder();
            bu.append("update interfaceexamerequisicao set ");
            bu.append(" ier_situacao = ").append(100);
            bu.append(" where fil_codigo = ").append(filialPadrao);
            bu.append(" and ier_situacao = ").append(0);
            bu.append(" and int_codigo = ").append(rs.getInt("intCodigo"));
            bu.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
            bu.append(" and mco_codigo = ").append(codMatCol);
            Conexao.executeUpdate(filialPadrao, st, bu.toString());
            bu.delete(0, bu.length());
            bu.append("update interfaceexamerequisicao set ");
            bu.append(" ier_situacao = ").append(101);
            bu.append("where fil_codigo = ").append(filialPadrao);
            bu.append("and ier_situacao = ").append(1);
            bu.append("and int_codigo = ").append(rs.getInt("intCodigo"));
            bu.append("and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
            bu.append(" and mco_codigo = ").append(codMatCol);
            Conexao.executeUpdate(filialPadrao, st, bu.toString());
            bu.delete(0, bu.length());
            bu.append("update interfaceexamerequisicao set ");
            bu.append(" ier_situacao = ").append(102);
            bu.append("where fil_codigo = ").append(filialPadrao);
            bu.append("and ier_situacao = ").append(2);
            bu.append("and int_codigo = ").append(rs.getInt("intCodigo"));
            bu.append("and exa_codigo = ").append(StringUtil.textoDBEscape(codExame));
            bu.append(" and mco_codigo = ").append(codMatCol);
            Conexao.executeUpdate(filialPadrao, st, bu.toString());
        }
    }

    public String getCabecalhoModeloNotificacao() throws SQLException {
        String cabecalho = "";
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select lay_notificacao from layout where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and lay_codigo = ");
        buf.append(ParametrosGerais.getLayCodigo());
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            cabecalho = rs.getString("lay_notificacao");
        }
        rs.close();
        Conexao.fecharStatement(st);
        return cabecalho;
    }
}

