/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.auxiliares;

import jalis.comum.Conexao;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;

public class UsuarioDao
extends AbstractThreadDao {
    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        String cod = codigo.startsWith("E'") ? codigo : StringUtil.textoDBEscape(codigo);
        String where = " where UPPER(usr_codigo) = upper(" + cod + ")";
        Set usuarios = UsuarioDao.load(UsuarioBean.class, where);
        if (usuarios == null || usuarios.size() == 0 || usuarios.size() > 1) {
            return null;
        }
        return (AbstractThreadBean)usuarios.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        String cod = codigo.startsWith("E'") ? codigo : StringUtil.textoDBEscape(codigo);
        String where = " where UPPER(usr_codigo) = upper(" + cod + ")";
        Set usuarios = this.loadVO(UsuarioVO.class, where);
        if (usuarios == null || usuarios.size() == 0 || usuarios.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)usuarios.toArray()[0];
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, String filial) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificaCodigoColetadorUsuario(String codigoUsuario, String codigoColetador) throws SQLException {
        Statement st;
        block4: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(1) as qtde ");
            buf.append("   from usuario ");
            buf.append("  where usr_codcoletor = '").append(codigoColetador).append("' ");
            buf.append("  \tand (not usr_inativo or usr_inativo is null) ");
            if (codigoUsuario != null) {
                buf.append("    and usr_codigo <> '").append(codigoUsuario).append("' ");
            }
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                bl = rs.getInt("qtde") > 0;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean usuarioTemSenhaColetador(String codigoUsuario) throws SQLException {
        boolean retorno = false;
        StringBuilder buf = new StringBuilder();
        buf.append(" select usr_codcoletor ");
        buf.append("   from usuario ");
        buf.append("  where usr_codigo = '").append(StringUtil.textoDB(codigoUsuario)).append("' ");
        buf.append("  \tand (not usr_inativo or usr_inativo is null) ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                retorno = !DBUtil.campoNull(rs.getString("usr_codcoletor")) && !Funcoes.textoVazio(rs.getString("usr_codcoletor"));
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificaSenhaUsuario(String login, String senha) throws Exception {
        Statement st;
        block3: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select upper(usr_senha) = upper(").append(StringUtil.textoDBEscape(senha)).append(") as senhaValida ");
            buf.append("   from usuario ");
            buf.append("  where upper(usr_codigo) = upper(").append(StringUtil.textoDBEscape(login)).append(")");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                bl = rs.getBoolean("senhaValida");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificaSenhaColetadorUsuario(String login, String senha) throws Exception {
        Statement st;
        block3: {
            boolean bl;
            StringBuilder buf = new StringBuilder();
            buf.append(" select usr_codcoletor = ").append(StringUtil.textoDBEscape(senha)).append(" as senhaValida ");
            buf.append("   from usuario ");
            buf.append("  where usr_codigo = ").append(StringUtil.textoDBEscape(login));
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                bl = rs.getBoolean("senhaValida");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        Conexao.fecharStatement(st);
        return bl;
    }

    public void atualizaUsuario(UsuarioVO usuario, String filialPadrao) throws Exception {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("update usuario set ");
        buf.append("usr_senha = '");
        buf.append(usuario.getSenha());
        buf.append("',");
        buf.append("usr_alterasenha = ");
        buf.append(usuario.isAlteraSenha());
        buf.append(",");
        if (this.isJanelaUsuario(usuario)) {
            buf.append("usr_nome = '");
            buf.append(usuario.getNome());
            buf.append("',");
            buf.append("tpu_codigo = ");
            buf.append(usuario.getTpuCodigo());
            buf.append(",");
            buf.append("usr_assinatura = '");
            buf.append(usuario.getAssinatura());
            buf.append("',");
            buf.append("usr_foto = '");
            buf.append(usuario.getFoto());
            buf.append("',");
            buf.append("usr_assinaturaweb = '");
            buf.append(usuario.getAssinaturaWeb());
            buf.append("',");
            buf.append("usr_codcoletor = '");
            buf.append(usuario.getCodColetor());
            buf.append("',");
            buf.append("fil_codigo = ");
            buf.append(usuario.getFilial().getCodigo());
            buf.append(",");
            buf.append("usr_mensagemweb = ");
            buf.append(usuario.isMensagemWeb());
            buf.append(",");
            buf.append("usr_inativo = ");
            buf.append(usuario.isInativo());
            buf.append(",");
            buf.append("usr_digital = '");
            buf.append(StringUtil.textoDB(usuario.getDigital()));
            buf.append("'");
            buf.append(", usr_textoassinaturadigital = '");
            buf.append(StringUtil.textoDB(usuario.getTextoAssinaturaDigital()));
            buf.append("'");
            if (this.adicionarDataInativo(usuario)) {
                buf.append(",usr_datainativo = '");
                buf.append(usuario.getDataInativoDB());
                buf.append("'");
            } else {
                buf.append(",usr_datainativo = null ");
            }
            if (this.adicionarCertificado(usuario)) {
                buf.append(",usr_certificado = ");
                buf.append(usuario.getCertificado());
                buf.append(",");
                buf.append("usr_senhacertificado = ");
                buf.append(usuario.getSenhaCertificado());
                buf.append(",");
                buf.append("usr_validadecertificado = ");
                buf.append(usuario.getValidadeCertificadoDB());
            }
            if (this.adicionarDataMudancaSenha(usuario)) {
                buf.append(",usr_dataultimasenha = ");
                buf.append("current_timestamp");
            }
        } else {
            buf.append("usr_dataultimasenha = ");
            buf.append("current_timestamp");
            if (this.adicionarInformacoesColetor(usuario)) {
                buf.append(",usr_codcoletor = '");
                buf.append(usuario.getCodColetor());
                buf.append("'");
            }
        }
        buf.append(" where upper(usr_codigo) = upper('");
        buf.append(usuario.getCodigo());
        buf.append("')");
        Conexao.execute(filialPadrao, st, buf.toString());
        this.integracaoFiliais(st, buf, filialPadrao);
    }

    public UsuarioVO buscaCodigo(String codigo) throws Exception {
        Statement st = Conexao.getStatement();
        UsuarioVO usuarioVO = new UsuarioVO();
        StringBuilder buf = new StringBuilder("select usr_codigo, usr_nome from usuario where upper(usr_codigo) = upper('");
        buf.append(codigo);
        buf.append("')");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            usuarioVO.setCodigo(rs.getString("usr_codigo"));
            usuarioVO.setNome(rs.getString("usr_nome"));
        }
        return usuarioVO;
    }

    public void inserirUsuario(UsuarioVO usuario, String filialPadrao) throws Exception {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("");
        buf.append("insert into usuario(usr_codigo, usr_nome, usr_senha, tpu_codigo, usr_assinatura");
        buf.append(", usr_foto, usr_codcoletor, fil_codigo, usr_alterasenha, usr_mensagemweb, usr_inativo, usr_assinaturaweb, usr_digital");
        buf.append(", usr_dataultimasenha, usr_textoassinaturadigital");
        if (this.adicionarCertificado(usuario)) {
            buf.append(", usr_certificado, usr_senhacertificado, usr_validadecertificado");
        }
        buf.append(") values (");
        buf.append(" '").append(usuario.getCodigo()).append("'");
        buf.append(",'").append(usuario.getNome()).append("'");
        buf.append(",'").append(StringUtil.textoDB(usuario.getSenha())).append("'");
        buf.append(", ").append(usuario.getTpuCodigo());
        buf.append(",'").append(usuario.getAssinatura()).append("'");
        buf.append(",'").append(usuario.getFoto()).append("'");
        buf.append(",'").append(StringUtil.textoDB(usuario.getCodColetor())).append("'");
        buf.append(", ").append(usuario.getFilial().getCodigo());
        buf.append(", ").append(usuario.isAlteraSenha());
        buf.append(", ").append(usuario.isMensagemWeb());
        buf.append(", ").append(usuario.isInativo());
        buf.append(",'").append(usuario.getAssinaturaWeb()).append("'");
        buf.append(",'").append(StringUtil.textoDB(usuario.getDigital())).append("'");
        buf.append(",").append("current_timestamp");
        buf.append(",'").append(StringUtil.textoDB(usuario.getTextoAssinaturaDigital())).append("'");
        if (this.adicionarCertificado(usuario)) {
            buf.append(", ").append(usuario.getCertificado());
            buf.append(", ").append(usuario.getSenhaCertificado());
            buf.append(", ").append(usuario.getValidadeCertificadoDB());
        }
        buf.append(")");
        Conexao.execute(filialPadrao, st, buf.toString());
        this.integracaoFiliais(st, buf, filialPadrao);
    }

    private void integracaoFiliais(Statement st, StringBuilder buf, String filialPadrao) throws Exception {
        String[] filiaisIntegracao;
        for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
            IntegracaoUtil.insereComandoLog(st, filialPadrao, filial, buf.toString());
        }
    }

    private boolean isJanelaUsuario(UsuarioVO usuario) {
        return usuario.getTpuCodigo() != 0;
    }

    private boolean adicionarInformacoesColetor(UsuarioVO usuario) {
        return usuario.getCodColetor() != null;
    }

    private boolean adicionarCertificado(UsuarioVO usuario) {
        return usuario.getCertificado() != null || usuario.getSenhaCertificado() != null || usuario.getValidadeCertificado() != null;
    }

    private boolean adicionarDataInativo(UsuarioVO usuario) {
        return usuario.getDataInativo() != null;
    }

    private boolean adicionarDataMudancaSenha(UsuarioVO usuario) {
        return usuario.getDataUltimaSenha() != null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

