/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro.auxiliares;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.cadastro.DadosExportaExames;
import jalis.laboratorio.cadastro.configurador.DiaTituloFraseDTO;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.BairroVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.service.cadastro.auxiliares.BairroService;
import jalis.service.cadastro.auxiliares.CidadeService;
import jalis.service.cadastro.exame.LabExternoService;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FilialDao
extends AbstractThreadDao {
    private CidadeService cidadeService = new CidadeService();
    private BairroService bairroService = new BairroService();
    private LabExternoService labExternoService = new LabExternoService();
    private final long ACESSO_PERMITIR_TRANSFERIR_FILIAIS_CNPJ_DIFERENTE = Long.parseLong("0600401306");

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        Set filiais = FilialDao.load(FilialBean.class, " where fil_codigo = " + codigo);
        if (filiais == null || filiais.size() == 0 || filiais.size() > 1) {
            return null;
        }
        return (AbstractThreadBean)filiais.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        Set filiais = this.loadVO(FilialVO.class, " where fil_codigo = " + codigo);
        if (filiais == null || filiais.size() == 0 || filiais.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)filiais.toArray()[0];
    }

    public AbstractThreadVO getVOFilialDestino(String cnpjFilialLogada, String filialPadrao, String codigoFilialDestino) throws ThreadDaoException {
        Set filiais = null;
        filiais = Acesso.getAcesso(this.ACESSO_PERMITIR_TRANSFERIR_FILIAIS_CNPJ_DIFERENTE) ? this.loadVO(FilialVO.class, " where fil_codigo <> " + filialPadrao + " and fil_codigo = " + codigoFilialDestino) : this.loadVO(FilialVO.class, " where fil_cnpj like '%" + cnpjFilialLogada + "%' and fil_codigo <> " + filialPadrao + " and fil_codigo = " + codigoFilialDestino);
        if (filiais == null || filiais.size() == 0 || filiais.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)filiais.toArray()[0];
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, String filial) {
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, String filial) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodigoResponsavelCompras(String filial) throws SQLException {
        Statement st;
        block4: {
            String string;
            if (filial == null || Funcoes.textoVazio(filial)) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select usr_codcompras as usuario ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ").append(filial);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                string = rs.getString("usuario");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return string;
        }
        String string = null;
        Conexao.fecharStatement(st);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCodigoResponsavelEstoque(String filial) throws SQLException {
        Statement st;
        block4: {
            String string;
            if (filial == null || Funcoes.textoVazio(filial)) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select usr_codestoque as usuario ");
            buf.append("   from filiais_postocoleta ");
            buf.append("  where fil_codigo = ").append(filial);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                string = rs.getString("usuario");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return string;
        }
        String string = null;
        Conexao.fecharStatement(st);
        return string;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    public String getProtocoloLaboratorioExterno(int filial, Statement st) throws SQLException {
        String protocolo = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" select lae.lae_protocolo as protocolo ");
        sql.append(" from filiais_postocoleta fil ");
        sql.append(" left join labexterno lae ");
        sql.append(" on fil.lae_codigo = lae.lae_codigo ");
        sql.append(" and fil.fil_codigo = lae.fil_codigo ");
        sql.append(" where fil.fil_codigo = ").append(filial);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            protocolo = rs.getString("protocolo");
        }
        return protocolo;
    }

    public Integer getCodigoLaboratorioExterno(int filial, Statement st) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select lae.lae_codigo");
        sql.append(" from filiais_postocoleta fil ");
        sql.append(" left join labexterno lae ");
        sql.append(" on fil.lae_codigo = lae.lae_codigo ");
        sql.append(" and fil.fil_codigo = lae.fil_codigo ");
        sql.append(" where fil.fil_codigo = ").append(filial);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            return rs.getInt("lae_codigo");
        }
        throw new SQLException("Protocolo n\u00e3o foi encontrado.");
    }

    public FilialVOAux buscaFilial(String codigo) throws Exception {
        FilialVOAux filialVO = null;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append(" select a.fil_descricao ");
        buf.append("       ,a.fil_razaosocial ");
        buf.append("       ,a.cid_codigo ");
        buf.append("       ,a.fil_cnpj ");
        buf.append("       ,a.fil_endereco ");
        buf.append("       ,a.fil_complemento ");
        buf.append("       ,a.bai_codigo ");
        buf.append("       ,a.fil_cep ");
        buf.append("       ,a.fil_fone ");
        buf.append("       ,a.fil_fax ");
        buf.append("       ,a.fil_responsavel ");
        buf.append("       ,b.cid_nome ");
        buf.append("       ,b.cid_uf ");
        buf.append("       ,c.bai_descricao ");
        buf.append("       ,a.fil_webdevedora ");
        buf.append("       ,a.fil_webvernaoassinado ");
        buf.append("       ,a.fil_exportarexames ");
        buf.append("       ,a.fil_site ");
        buf.append("       ,a.fil_email ");
        buf.append("       ,a.fil_baseweb ");
        buf.append("       ,a.fil_incompletoweb ");
        buf.append("       ,a.fil_proibidoweb ");
        buf.append("       ,a.fil_responsavelweb ");
        buf.append("       ,a.fil_devedorweb ");
        buf.append("       ,a.fil_webcpfpaciente ");
        buf.append("       ,a.fil_webmsgpopup ");
        buf.append("       ,a.fil_webrstjanela ");
        buf.append("       ,a.fil_integrar ");
        buf.append("       ,a.fil_webenviarcabecalho ");
        buf.append("       ,a.fil_webresultadotexto ");
        buf.append("       ,a.fil_webstandalone");
        buf.append("       ,a.fil_tipobase ");
        buf.append("       ,a.fil_webpdf ");
        buf.append("       ,a.fil_webassinaturaexame ");
        buf.append("       ,a.fil_apoio ");
        buf.append("       ,a.fil_cnes ");
        buf.append("       ,a.fil_webbotaoimprimir ");
        buf.append("       ,a.fil_webmostrarassinatura ");
        buf.append("       ,a.fil_webimagemassinatura ");
        buf.append("       ,a.fil_perguntas ");
        buf.append("       ,a.fil_ocultarmedicamento ");
        buf.append("       ,a.fil_devedorwebpaciente ");
        buf.append("       ,a.fil_devedorwebmedico ");
        buf.append("       ,a.fil_devedorwebconvenio ");
        buf.append("       ,a.fil_devedorwebentidade ");
        buf.append("       ,a.fil_devedorwebdestino ");
        buf.append("       ,a.fil_regimetributacao ");
        buf.append("       ,a.fil_simplesnacional ");
        buf.append("       ,a.fil_incentivocultural ");
        buf.append("       ,a.fil_cnae ");
        buf.append("       ,a.fil_inscricaomunicipal ");
        buf.append("       ,a.fil_padraolayoutnfse ");
        buf.append("       ,fil_webrequisicaopagina ");
        buf.append("       ,fil_webimagemconvenio ");
        buf.append("       ,fil_webimagemdestino ");
        buf.append("       ,fil_webemailconvenio ");
        buf.append("       ,fil_webemaildestino ");
        buf.append("       ,fil_webemailentidade ");
        buf.append("       ,fil_webemailmedico ");
        buf.append("       ,fil_webemailpaciente ");
        buf.append("       ,usr_codestoque ");
        buf.append("       ,usr_codcompras ");
        buf.append("       ,fil_incentivofiscal ");
        buf.append("       ,fil_enviarsms ");
        buf.append("       ,fil_enviaremail ");
        buf.append("       ,fil_smsaniversario ");
        buf.append("       ,fil_frasesmsaniversario ");
        buf.append("       ,fil_smsresultados ");
        buf.append("       ,fil_agruparmultiguiasms ");
        buf.append("       ,fil_frasesmsresultados ");
        buf.append("       ,fil_smssenhaweb ");
        buf.append("       ,fil_frasesmssenhaweb ");
        buf.append("       ,fil_smsrecoleta ");
        buf.append("       ,fil_smsrequisicao ");
        buf.append("       ,fil_frasesmsrecoleta ");
        buf.append("       ,fil_frasesmsrequisicao ");
        buf.append("       ,fil_smsresumofinanceiro ");
        buf.append("       ,fil_fonessmsresumo ");
        buf.append("       ,fil_smshoraresumofinanceiro ");
        buf.append("       ,fil_smshorainicial ");
        buf.append("       ,fil_smshorafinal ");
        buf.append("       ,fil_smshoraaniversario ");
        buf.append("       ,fil_emailaniversario ");
        buf.append("       ,fil_fraseemailaniversario ");
        buf.append("       ,fil_emailresultados ");
        buf.append("       ,fil_agruparmultiguiaemail ");
        buf.append("       ,fil_fraseemailresultados ");
        buf.append("       ,fil_emailsenhaweb ");
        buf.append("       ,fil_fraseemailsenhaweb ");
        buf.append("       ,fil_emailrecoleta ");
        buf.append("       ,fil_fraseemailrecoleta ");
        buf.append("       ,fil_emailrequisicao ");
        buf.append("       ,fil_fraseemailrequisicao ");
        buf.append("       ,fil_emailproposta ");
        buf.append("       ,fil_emailcotacao ");
        buf.append("       ,fil_fraseemailproposta ");
        buf.append("       ,fil_fraseemailcotacao ");
        buf.append("       ,fil_emailnfse ");
        buf.append("       ,fil_fraseemailnfse ");
        buf.append("       ,fil_configuracaoemail ");
        buf.append("       ,fil_emailhoraaniversario ");
        buf.append("       ,fil_emailassuntoaniversario ");
        buf.append("       ,fil_emailassuntorecoleta ");
        buf.append("       ,fil_emailassuntoresultados ");
        buf.append("       ,fil_emailassuntosenhaweb ");
        buf.append("       ,fil_assuntoemailrequisicao ");
        buf.append("       ,fil_assuntoemailproposta ");
        buf.append("       ,fil_assuntoemailcotacao ");
        buf.append("       ,fil_assuntoemailnfse ");
        buf.append("       ,fil_certificadort ");
        buf.append("       ,fil_certificadortsub ");
        buf.append("       ,fil_senhart ");
        buf.append("       ,fil_senhartsub ");
        buf.append("       ,fil_motivocertificado ");
        buf.append("       ,fil_localcertificado ");
        buf.append("       ,fil_logocertificadort ");
        buf.append("       ,fil_logocertificadortsub ");
        buf.append("       ,fil_emailresultadopdf ");
        buf.append("       ,fil_fraseemailresultadopdf ");
        buf.append("       ,fil_assuntoemailresultadopdf ");
        buf.append("       ,fil_emailcertificadoanalise ");
        buf.append("       ,fil_fraseemailcertificadoanalise ");
        buf.append("       ,fil_assuntoemailcertificadoanalise ");
        buf.append("       ,fil_emailentrega ");
        buf.append("       ,fil_fraseemailentrega ");
        buf.append("       ,fil_assuntoemailentrega ");
        buf.append("       ,fil_emailparacontatos ");
        buf.append("       ,fil_validadecertificadort ");
        buf.append("       ,fil_validadecertificadortsub ");
        buf.append("       ,fil_tipocertificacao ");
        buf.append("       ,fil_confignfse ");
        buf.append("       ,a.lae_codigo ");
        buf.append("       ,lae.lae_descricao ");
        buf.append("       ,fil_fraseemailsenhawebmedico ");
        buf.append("       ,fil_emailsenhawebmedico ");
        buf.append("       ,fil_assuntoemailsenhawebmedico ");
        buf.append("       ,fil_codigpushapp ");
        buf.append("       ,fil_titulopushapp ");
        buf.append("       ,fil_subtitulopushapp ");
        buf.append("       ,fil_mensagempushapp ");
        buf.append("       ,fil_enviarpushapp ");
        buf.append("       ,fil_enviarwhatsapp ");
        buf.append("       ,fil_agrupamultiguiapushapp ");
        buf.append("       ,fil_smsagendamento ");
        buf.append("       ,fil_frasesmsagendamento ");
        buf.append("       ,fil_emailagendamento ");
        buf.append("       ,fil_fraseemailagendamento ");
        buf.append("       ,fil_assuntoemailagendamento ");
        buf.append("       ,fil_naocompornfsefisica");
        buf.append("       ,fil_naocompornfsejuridica");
        buf.append("       ,fil_smsdiasagendamento");
        buf.append("       ,fil_smshorariodiasagendamento");
        buf.append("       ,fil_pushaniversario ");
        buf.append("       ,fil_pushresultados ");
        buf.append("       ,fil_pushrecoleta ");
        buf.append("       ,fil_pushrequisicao ");
        buf.append("       ,fil_pushagendamento ");
        buf.append("       ,fil_pushdiasagendamento ");
        buf.append("       ,fil_frasepushaniversario ");
        buf.append("       ,fil_frasepushresultados ");
        buf.append("       ,fil_frasepushrecoleta ");
        buf.append("       ,fil_frasepushrequisicao ");
        buf.append("       ,fil_frasepushagendamento ");
        buf.append("       ,fil_titulopushaniversario ");
        buf.append("       ,fil_titulopushresultados ");
        buf.append("       ,fil_titulopushrecoleta ");
        buf.append("       ,fil_titulopushrequisicao ");
        buf.append("       ,fil_titulopushagendamento ");
        buf.append("       ,fil_pushhoraaniversario ");
        buf.append("       ,fil_pushhorainicial ");
        buf.append("       ,fil_pushhorafinal ");
        buf.append("       ,fil_pushhorariodiasagendamento ");
        buf.append("       ,fil_whatsappaniversario ");
        buf.append("       ,fil_whatsappresultados ");
        buf.append("       ,fil_agruparmultiguiawhatsapp ");
        buf.append("       ,fil_whatsappsenhaweb ");
        buf.append("       ,fil_whatsapprecoleta ");
        buf.append("       ,fil_whatsappresumofinanceiro ");
        buf.append("       ,fil_whatsapprequisicao ");
        buf.append("       ,fil_whatsappagendamento ");
        buf.append("       ,fil_whatsappdiasagendamento ");
        buf.append("       ,fil_frasewhatsappaniversario ");
        buf.append("       ,fil_frasewhatsappresultados ");
        buf.append("       ,fil_frasewhatsappsenhaweb ");
        buf.append("       ,fil_frasewhatsapprecoleta ");
        buf.append("       ,fil_frasewhatsapprequisicao ");
        buf.append("       ,fil_frasewhatsappagendamento ");
        buf.append("       ,fil_whatsappfoneresumo ");
        buf.append("       ,fil_whatsapphorainicial ");
        buf.append("       ,fil_whatsapphorafinal ");
        buf.append("       ,fil_whatsapphoraresumo ");
        buf.append("       ,fil_whatsapphoraaniversario ");
        buf.append("       ,fil_whatsapphoradiasagendamento ");
        buf.append("   from filiais_postocoleta a ");
        buf.append("   left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo ");
        buf.append("   left join bairro  c on a.fil_codigo = c.fil_codigo and  upper(a.bai_codigo) = upper(c.bai_codigo) ");
        buf.append("   left join labexterno lae on a.fil_codigo = lae.fil_codigo and a.lae_codigo = lae.lae_codigo ");
        buf.append("   where a.fil_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            filialVO = new FilialVOAux();
            filialVO.setCodigo(Integer.parseInt(codigo));
            filialVO.setDescricao(rs.getString("fil_descricao"));
            filialVO.setRazaoSocial(rs.getString("fil_razaosocial"));
            CidadeVO cidadeVO = this.getCidadeVO(codigo, rs.getString("cid_codigo"));
            filialVO.setCidadeVO(cidadeVO);
            filialVO.setCnpj(rs.getString("fil_cnpj"));
            filialVO.setEndereco(rs.getString("fil_endereco"));
            filialVO.setComplemento(rs.getString("fil_complemento"));
            BairroVO bairroVO = this.getBairroVO(codigo, rs.getString("bai_codigo"));
            filialVO.setBairroVO(bairroVO);
            filialVO.setCep(rs.getString("fil_cep"));
            filialVO.setFone(rs.getString("fil_fone"));
            filialVO.setFax(rs.getString("fil_fax"));
            filialVO.setResponsavel(rs.getString("fil_responsavel"));
            filialVO.setWebdevedora(rs.getBoolean("fil_webdevedora"));
            filialVO.setWebvernaoassinado(rs.getBoolean("fil_webvernaoassinado"));
            filialVO.setExportarexames(rs.getBoolean("fil_exportarexames"));
            filialVO.setSite(rs.getString("fil_site"));
            filialVO.setEmail(rs.getString("fil_email"));
            filialVO.setBaseWeb(rs.getString("fil_baseweb"));
            filialVO.setIncompletoweb(rs.getString("fil_incompletoweb"));
            filialVO.setProibidoweb(rs.getString("fil_proibidoweb"));
            filialVO.setResponsavelWeb(rs.getString("fil_responsavelweb"));
            filialVO.setDevedorWeb(rs.getString("fil_devedorweb"));
            filialVO.setWebCpfPaciente(rs.getBoolean("fil_webcpfpaciente"));
            filialVO.setWebMsgPopup(rs.getBoolean("fil_webmsgpopup"));
            filialVO.setWebrstjanela(rs.getBoolean("fil_webrstjanela"));
            filialVO.setIntegrar(rs.getBoolean("fil_integrar"));
            filialVO.setWebEnviarCabecalho(rs.getBoolean("fil_webenviarcabecalho"));
            filialVO.setWebResultadoTexto(rs.getBoolean("fil_webresultadotexto"));
            filialVO.setWebStandAlone(rs.getBoolean("fil_webstandalone"));
            filialVO.setTipoBase(rs.getString("fil_tipobase"));
            filialVO.setWebPdf(rs.getBoolean("fil_webpdf"));
            filialVO.setWebAssinaturaExame(rs.getBoolean("fil_webassinaturaexame"));
            filialVO.setFilApoio(rs.getBoolean("fil_apoio"));
            filialVO.setCnes(rs.getString("fil_cnes"));
            filialVO.setWebBotaoImprimir(rs.getBoolean("fil_webbotaoimprimir"));
            filialVO.setWebMostrarAssinatura(rs.getBoolean("fil_webmostrarassinatura"));
            filialVO.setWebImagemAssinatura(rs.getString("fil_webimagemassinatura"));
            filialVO.setPerguntas(rs.getString("fil_perguntas"));
            filialVO.setOcultarMedicamento(rs.getBoolean("fil_ocultarmedicamento"));
            filialVO.setDevedorWebPaciente(rs.getBoolean("fil_devedorwebpaciente"));
            filialVO.setDevedorWebMedico(rs.getBoolean("fil_devedorwebmedico"));
            filialVO.setDevedorWebConvenio(rs.getBoolean("fil_devedorwebconvenio"));
            filialVO.setDevedorWebEntidade(rs.getBoolean("fil_devedorwebentidade"));
            filialVO.setDevedorWebDestino(rs.getBoolean("fil_devedorwebdestino"));
            filialVO.setRegimeTributacao(rs.getString("fil_regimetributacao"));
            filialVO.setSimplesNacional(rs.getBoolean("fil_simplesnacional"));
            filialVO.setIncentivoCultural(rs.getBoolean("fil_incentivocultural"));
            filialVO.setCnae(rs.getString("fil_cnae"));
            filialVO.setInscricaoMunicipal(rs.getString("fil_inscricaomunicipal"));
            filialVO.setPadraoLayoutnfse(rs.getInt("fil_padraolayoutnfse"));
            filialVO.setWebRequisicaoPagina(rs.getInt("fil_webrequisicaopagina"));
            filialVO.setWebImagemConvenio(rs.getBoolean("fil_webimagemconvenio"));
            filialVO.setWebImagemDestino(rs.getBoolean("fil_webimagemdestino"));
            filialVO.setWebEmailConvenio(rs.getBoolean("fil_webemailconvenio"));
            filialVO.setWebEmailDestino(rs.getBoolean("fil_webemaildestino"));
            filialVO.setWebEmailEntidade(rs.getBoolean("fil_webemailentidade"));
            filialVO.setWebEmailPaciente(rs.getBoolean("fil_webemailpaciente"));
            filialVO.setWebEmailMedico(rs.getBoolean("fil_webemailmedico"));
            filialVO.setCodEstoque(rs.getString("usr_codestoque"));
            filialVO.setCodCompras(rs.getString("usr_codcompras"));
            filialVO.setIncentivoFiscal(rs.getBoolean("fil_incentivofiscal"));
            filialVO.setEnviarSMS(rs.getBoolean("fil_enviarsms"));
            filialVO.setEnviarEmail(rs.getBoolean("fil_enviaremail"));
            filialVO.setSmsAniversario(rs.getBoolean("fil_smsaniversario"));
            filialVO.setFraseSmsAniversario(rs.getString("fil_frasesmsaniversario"));
            filialVO.setSmsResultados(rs.getBoolean("fil_smsresultados"));
            filialVO.setSmsAgruparMultiguia(rs.getBoolean("fil_agruparmultiguiasms"));
            filialVO.setFraseSmsResultado(rs.getString("fil_frasesmsresultados"));
            filialVO.setSmsSenhaWeb(rs.getBoolean("fil_smssenhaweb"));
            filialVO.setFraseSmsSenhaWeb(rs.getString("fil_frasesmssenhaweb"));
            filialVO.setSmsRecoleta(rs.getBoolean("fil_smsrecoleta"));
            filialVO.setSmsRequisicao(rs.getBoolean("fil_smsrequisicao"));
            filialVO.setFraseSmsRecoleta(rs.getString("fil_frasesmsrecoleta"));
            filialVO.setFraseSmsRequisicao(rs.getString("fil_frasesmsrequisicao"));
            filialVO.setSmsResumoFinanceiro(rs.getBoolean("fil_smsresumofinanceiro"));
            filialVO.setFoneSmsResumo(rs.getString("fil_fonessmsresumo"));
            filialVO.setSmshoraResumoFinanceiro(rs.getTime("fil_smshoraresumofinanceiro"));
            filialVO.setSmsHoraAgendamento(rs.getTime("fil_smshorariodiasagendamento"));
            filialVO.setSmsHoraInicial(rs.getTime("fil_smshorainicial"));
            filialVO.setSmsHoraFinal(rs.getTime("fil_smshorafinal"));
            filialVO.setSmsHoraAniversario(rs.getTime("fil_smshoraaniversario"));
            filialVO.setEmailAniversario(rs.getBoolean("fil_emailaniversario"));
            filialVO.setFraseEmailAniversario(rs.getString("fil_fraseemailaniversario"));
            filialVO.setEmailResultados(rs.getBoolean("fil_emailresultados"));
            filialVO.setEMailAgruparMultiguia(rs.getBoolean("fil_agruparmultiguiaemail"));
            filialVO.setFraseEmailResultados(rs.getString("fil_fraseemailresultados"));
            filialVO.setEmailSenhaWeb(rs.getBoolean("fil_emailsenhaweb"));
            filialVO.setFraseEmailSenhaWeb(rs.getString("fil_fraseemailsenhaweb"));
            filialVO.setEmailRecoleta(rs.getBoolean("fil_emailrecoleta"));
            filialVO.setFraseEmailRecoleta(rs.getString("fil_fraseemailrecoleta"));
            filialVO.setEmailRequisicao(rs.getBoolean("fil_emailrequisicao"));
            filialVO.setFraseEmailRequisicao(rs.getString("fil_fraseemailrequisicao"));
            filialVO.setEmailProposta(rs.getBoolean("fil_emailproposta"));
            filialVO.setEmailCotacao(rs.getBoolean("fil_emailcotacao"));
            filialVO.setFraseEmailProposta(rs.getString("fil_fraseemailproposta"));
            filialVO.setFraseEmailCotacao(rs.getString("fil_fraseemailcotacao"));
            filialVO.setEmailNFSE(rs.getBoolean("fil_emailnfse"));
            filialVO.setFraseEmailNFSE(rs.getString("fil_fraseemailnfse"));
            filialVO.setConfiguracaoEmail(rs.getString("fil_configuracaoemail"));
            filialVO.setEmailHoraAniversario(rs.getTime("fil_emailhoraaniversario"));
            filialVO.setEmailAssuntoAniversario(rs.getString("fil_emailassuntoaniversario"));
            filialVO.setEmailAssuntoRecoleta(rs.getString("fil_emailassuntorecoleta"));
            filialVO.setEmailAssuntoResultados(rs.getString("fil_emailassuntoresultados"));
            filialVO.setEmailAssuntoSenhaWeb(rs.getString("fil_emailassuntosenhaweb"));
            filialVO.setAssuntoEmailRequisicao(rs.getString("fil_assuntoemailrequisicao"));
            filialVO.setAssuntoEmailProposta(rs.getString("fil_assuntoemailproposta"));
            filialVO.setAssuntoEmailCotacao(rs.getString("fil_assuntoemailcotacao"));
            filialVO.setAssuntoEmailNFSE(rs.getString("fil_assuntoemailnfse"));
            filialVO.setCertificadoRt(rs.getString("fil_certificadort"));
            filialVO.setCertificadoSub(rs.getString("fil_certificadortsub"));
            filialVO.setSenhaRt(rs.getString("fil_senhart"));
            filialVO.setSenhaSUB(rs.getString("fil_senhartsub"));
            filialVO.setMotivoCertificado(rs.getString("fil_motivocertificado"));
            filialVO.setLocalCertificado(rs.getString("fil_localcertificado"));
            filialVO.setLogoCertificadoRt(rs.getString("fil_logocertificadort"));
            filialVO.setLogoCertificadoSub(rs.getString("fil_logocertificadortsub"));
            filialVO.setEmailResultadoPDF(rs.getBoolean("fil_emailresultadopdf"));
            filialVO.setFraseEmailResultadoPDF(rs.getString("fil_fraseemailresultadopdf"));
            filialVO.setAssuntoEmailResultadoPDF(rs.getString("fil_assuntoemailresultadopdf"));
            filialVO.setEmailCertificadoAnalise(rs.getBoolean("fil_emailcertificadoanalise"));
            filialVO.setFraseEmailCertificadoAnalise(rs.getString("fil_fraseemailcertificadoanalise"));
            filialVO.setAssuntoEmailCertificadoAnalise(rs.getString("fil_assuntoemailcertificadoanalise"));
            filialVO.setEmailEntrega(rs.getBoolean("fil_emailentrega"));
            filialVO.setFraseEmailEntrega(rs.getString("fil_fraseemailentrega"));
            filialVO.setAssuntoEmailEntrega(rs.getString("fil_assuntoemailentrega"));
            filialVO.setEmailParaContatos(rs.getBoolean("fil_emailparacontatos"));
            filialVO.setTipoCertificacao(rs.getString("fil_tipocertificacao"));
            filialVO.setValidadeCertificadoRT(rs.getDate("fil_validadecertificadort"));
            filialVO.setValidadeCErtificadoSub(rs.getDate("fil_validadecertificadortsub"));
            filialVO.setConfigNFSE(rs.getString("fil_confignfse"));
            LabExternoVO labExternoVO = this.getLabExternoVO(codigo, rs.getString("lae_codigo"));
            filialVO.setLabExternoVO(labExternoVO);
            filialVO.setFraseEmailSenhaWebMedico(rs.getString("fil_fraseemailsenhawebmedico"));
            filialVO.setEmailSenhaWebMedico(rs.getBoolean("fil_emailsenhawebmedico"));
            filialVO.setAssuntoEmailSenhaWebMedico(rs.getString("fil_assuntoemailsenhawebmedico"));
            filialVO.setAplicativo(rs.getBoolean("fil_enviarpushapp"));
            filialVO.setEnviarPushAgruparMultiguia(rs.getBoolean("fil_agrupamultiguiapushapp"));
            filialVO.setEnviarPushAniversario(rs.getBoolean("fil_pushaniversario"));
            filialVO.setEnviarPushResultados(rs.getBoolean("fil_pushresultados"));
            filialVO.setEnviarPushRecoleta(rs.getBoolean("fil_pushrecoleta"));
            filialVO.setEnviarPushRequisicao(rs.getBoolean("fil_pushrequisicao"));
            filialVO.setEnviarPushAgendamento(rs.getBoolean("fil_pushagendamento"));
            filialVO.setFrasePushAniversario(rs.getString("fil_frasepushaniversario"));
            filialVO.setFrasePushResultados(rs.getString("fil_frasepushresultados"));
            filialVO.setFrasePushRecoleta(rs.getString("fil_frasepushrecoleta"));
            filialVO.setFrasePushRequisicao(rs.getString("fil_frasepushrequisicao"));
            filialVO.setFrasePushAgendamento(rs.getString("fil_frasepushagendamento"));
            filialVO.setHoraEnvioPushAniversario(rs.getTime("fil_pushhoraaniversario"));
            filialVO.setHoraInicialEnviarPush(rs.getTime("fil_pushhorainicial"));
            filialVO.setHoraFinalEnviarPush(rs.getTime("fil_pushhorafinal"));
            filialVO.setTituloPushAniversario(rs.getString("fil_titulopushaniversario"));
            filialVO.setTituloPushResultados(rs.getString("fil_titulopushresultados"));
            filialVO.setTituloPushRecoleta(rs.getString("fil_titulopushrecoleta"));
            filialVO.setTituloPushRequisicao(rs.getString("fil_titulopushrequisicao"));
            filialVO.setTituloPushAgendamento(rs.getString("fil_titulopushagendamento"));
            filialVO.setEnviarPushDiasAgendamento(rs.getBoolean("fil_pushdiasagendamento"));
            filialVO.setHorarioEnviarPushDiasAgendamento(rs.getTime("fil_pushhorariodiasagendamento"));
            filialVO.setWhatsApp(rs.getBoolean("fil_enviarwhatsapp"));
            filialVO.setEnviarWhatsappAniversario(rs.getBoolean("fil_whatsappaniversario"));
            filialVO.setEnviarWhatsappResultados(rs.getBoolean("fil_whatsappresultados"));
            filialVO.setWhatsappAgruparMultiguia(rs.getBoolean("fil_agruparmultiguiawhatsapp"));
            filialVO.setEnviarWhatsappSenhaWeb(rs.getBoolean("fil_whatsappsenhaweb"));
            filialVO.setEnviarWhatsappRecoleta(rs.getBoolean("fil_whatsapprecoleta"));
            filialVO.setEnviarWhatsappResumoFinanceiro(rs.getBoolean("fil_whatsappresumofinanceiro"));
            filialVO.setEnviarWhatsappRequisicao(rs.getBoolean("fil_whatsapprequisicao"));
            filialVO.setEnviarWhatsappAgendamento(rs.getBoolean("fil_whatsappagendamento"));
            filialVO.setEnviarWhatsappDiasAgendamento(rs.getBoolean("fil_whatsappdiasagendamento"));
            filialVO.setFraseWhatsappAniversario(rs.getString("fil_frasewhatsappaniversario"));
            filialVO.setFraseWhatsappResultados(rs.getString("fil_frasewhatsappresultados"));
            filialVO.setFraseWhatsappSenhaWeb(rs.getString("fil_frasewhatsappsenhaweb"));
            filialVO.setFraseWhatsappRecoleta(rs.getString("fil_frasewhatsapprecoleta"));
            filialVO.setFraseWhatsappRequisicao(rs.getString("fil_frasewhatsapprequisicao"));
            filialVO.setFraseWhatsappAgendamento(rs.getString("fil_frasewhatsappagendamento"));
            filialVO.setFonesWhatsappResumo(rs.getString("fil_whatsappfoneresumo"));
            filialVO.setHoraInicialEnviarWhatsapp(rs.getTime("fil_whatsapphorainicial"));
            filialVO.setHoraFinalEnviarWhatsapp(rs.getTime("fil_whatsapphorafinal"));
            filialVO.setHorarioEnviarWhatsappResumoFinanceiro(rs.getTime("fil_whatsapphoraresumo"));
            filialVO.setHoraEnvioWhatsappAniversario(rs.getTime("fil_whatsapphoraaniversario"));
            filialVO.setHorarioEnviarWhatsappDiasAgendamento(rs.getTime("fil_whatsapphoradiasagendamento"));
            filialVO.setEmailAgendamento(rs.getBoolean("fil_emailagendamento"));
            filialVO.setFraseEmailAgendamento(rs.getString("fil_fraseemailagendamento"));
            filialVO.setFraseSmsAgendamento(rs.getString("fil_frasesmsagendamento"));
            filialVO.setSmsAgendamento(rs.getBoolean("fil_smsagendamento"));
            filialVO.setAssuntoEmailAgendamento(rs.getString("fil_assuntoemailagendamento"));
            filialVO.setNaoComporNfseFisica(rs.getBoolean("fil_naocompornfsefisica"));
            filialVO.setNaoComporNfseJuridica(rs.getBoolean("fil_naocompornfsejuridica"));
            filialVO.setSmsAvisoAgendamento(rs.getBoolean("fil_smsdiasagendamento"));
        }
        return filialVO;
    }

    private LabExternoVO getLabExternoVO(String filCodigo, String laeCodigo) throws Exception {
        if (!Funcoes.textoVazio(laeCodigo)) {
            return (LabExternoVO)this.labExternoService.getVO(filCodigo, laeCodigo);
        }
        return null;
    }

    private BairroVO getBairroVO(String filCodigo, String bairroCodigo) throws Exception {
        return this.bairroService.getBairroVO(filCodigo, bairroCodigo);
    }

    private CidadeVO getCidadeVO(String codFilial, String cidCodigo) throws Exception {
        return this.cidadeService.getCidadeVO(codFilial, cidCodigo);
    }

    public ArrayList<DadosExportaExames> buscaConfigExportacaoExames(String codigo) throws SQLException {
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        ArrayList<DadosExportaExames> dadosExportacao = new ArrayList<DadosExportaExames>();
        bui.append("select a.fil_coddestino, b.fil_descricao, a.exa_codigo, c.exa_descricao ");
        bui.append("from filiaisexamesexportar a ");
        bui.append("left join filiais_postocoleta b on a.fil_coddestino = b.fil_codigo ");
        bui.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        bui.append("where a.fil_codigo = ");
        bui.append(codigo);
        ResultSet rsExporta = Conexao.executeQuery(st, bui.toString());
        while (rsExporta.next()) {
            dadosExportacao.add(new DadosExportaExames(rsExporta.getInt("fil_coddestino"), rsExporta.getString("fil_descricao"), rsExporta.getString("exa_codigo"), rsExporta.getString("exa_descricao")));
        }
        return dadosExportacao;
    }

    public String buscaConfigIntegracaoExportaWeb(String codigo) throws SQLException {
        String filiaisWeb = "";
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        bui.append("select a.fil_kodigo ");
        bui.append("from filiaisweb a ");
        bui.append("where a.fil_codigo = ");
        bui.append(codigo);
        bui.append(" order by a.fil_kodigo");
        ResultSet rsExporta = Conexao.executeQuery(st, bui.toString());
        while (rsExporta.next()) {
            if (!Funcoes.textoVazio(filiaisWeb)) {
                filiaisWeb = filiaisWeb + ", ";
            }
            filiaisWeb = filiaisWeb + rsExporta.getString("fil_kodigo");
        }
        return filiaisWeb;
    }

    public String buscaResponsavelCertificado(String codigo) throws SQLException {
        String usuariosMensagemVencimento = "";
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        bui.append("select a.usr_codigo ");
        bui.append("from responsavelcertificado a ");
        bui.append("where a.fil_codigo = ");
        bui.append(codigo);
        bui.append(" order by 1 ");
        ResultSet rsUsuarios = Conexao.executeQuery(st, bui.toString());
        if (rsUsuarios.next()) {
            usuariosMensagemVencimento = usuariosMensagemVencimento + rsUsuarios.getString("usr_codigo");
            while (rsUsuarios.next()) {
                usuariosMensagemVencimento = usuariosMensagemVencimento + "," + rsUsuarios.getString("usr_codigo");
            }
        }
        return usuariosMensagemVencimento;
    }

    public List<FilialVOAux> getListFilialVOExportaBaseWeb(String codigoFilial) throws SQLException {
        ArrayList<FilialVOAux> filial = new ArrayList<FilialVOAux>();
        StringBuilder bui = new StringBuilder();
        Statement st = Conexao.getStatement();
        bui.append("select fil_baseweb is not null as exportar, fil_webstandalone, fil_webpdf from filiais_postocoleta where fil_codigo in ( ");
        bui.append(codigoFilial).append(" )");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            FilialVOAux filVO = new FilialVOAux();
            filVO.setTipoBase(rs.getString("exportar"));
            filVO.setWebStandAlone(rs.getBoolean("fil_webstandalone"));
            filVO.setWebPdf(rs.getBoolean("fil_webpdf"));
            filial.add(filVO);
        }
        return filial;
    }

    public FilialVOAux getDadosExportaBaseWeb(Statement st, String codigoFilial) throws SQLException {
        FilialVOAux filVO = null;
        StringBuilder bui = new StringBuilder();
        bui.append("select fil_baseweb, fil_webstandalone, fil_webpdf from filiais_postocoleta where fil_codigo = ");
        bui.append(codigoFilial);
        ResultSet rs = st.executeQuery(bui.toString());
        if (rs.next()) {
            filVO = new FilialVOAux();
            filVO.setTipoBase(rs.getString("fil_baseweb"));
            filVO.setWebStandAlone(rs.getBoolean("fil_webstandalone"));
            filVO.setWebPdf(rs.getBoolean("fil_webpdf"));
        }
        return filVO;
    }

    public FilialVOAux getDadosExportacao(Statement st, String codigoFilial) throws SQLException {
        FilialVOAux filVO = null;
        StringBuilder bui = new StringBuilder();
        bui.append("select fil_codigo, fil_baseweb, fil_webstandalone, fil_webpdf, fil_exportarexames from filiais_postocoleta where fil_codigo = ");
        bui.append(codigoFilial);
        ResultSet rs = st.executeQuery(bui.toString());
        if (rs.next()) {
            filVO = new FilialVOAux();
            filVO.setCodigo(rs.getInt("fil_codigo"));
            filVO.setTipoBase(rs.getString("fil_baseweb"));
            filVO.setWebStandAlone(rs.getBoolean("fil_webstandalone"));
            filVO.setWebPdf(rs.getBoolean("fil_webpdf"));
            filVO.setExportarexames(rs.getBoolean("fil_exportarexames"));
        }
        return filVO;
    }

    public boolean getFilialExportaPDFWeb() throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" select 1 as exportapdf ");
        buf.append(" from filiais_postocoleta ");
        buf.append(" where fil_webpdf and  fil_webstandalone = false ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        return rs.next();
    }

    public boolean getFilialExportaHtmlWeb() throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" select\t 1 as exportahtml ");
        buf.append(" from filiais_postocoleta ");
        buf.append(" where   ");
        buf.append("   NOT fil_webpdf AND (fil_baseweb is not null AND fil_baseweb <> '')  ");
        buf.append("   and fil_webstandalone = false ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        return rs.next();
    }

    public FilialVOAux contemAgrupamento(Statement st, String filCodigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        FilialVOAux filVO = null;
        buf.append("select distinct a.fil_codigo, b.fil_baseweb, b.fil_webpdf, b.fil_webstandalone from filiaisweb a ");
        buf.append("left join filiais_postocoleta b on a.fil_codigo = b.fil_codigo ");
        buf.append("where a.fil_kodigo = ").append(filCodigo);
        ResultSet rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            filVO = new FilialVOAux();
            filVO.setTipoBase(rs.getString("fil_baseweb"));
            filVO.setWebStandAlone(rs.getBoolean("fil_webstandalone"));
            filVO.setWebPdf(rs.getBoolean("fil_webpdf"));
        }
        return filVO;
    }

    public int updateDadosDmed(String xml) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" update filiais_postocoleta ");
        buf.append("    set fil_xmldmed = '").append(xml).append("' ");
        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        int qtde = Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
        Conexao.arquivaSQL();
        return qtde;
    }

    public ArrayList<DiaTituloFraseDTO> buscaDiasFraseAgendameneto(Statement st, int filial) throws SQLException {
        ArrayList<DiaTituloFraseDTO> retorno = new ArrayList<DiaTituloFraseDTO>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select fpu_dias, fpu_mensagem, fpu_titulo from fraseagendamentopush ");
        buf.append("  where fil_codigo = ").append(filial);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            DiaTituloFraseDTO dto = new DiaTituloFraseDTO();
            dto.setDia(rs.getInt("fpu_dias"));
            dto.setTitulo(rs.getString("fpu_titulo"));
            dto.setFrase(rs.getString("fpu_mensagem"));
            retorno.add(dto);
        }
        rs.close();
        return retorno;
    }

    public List<DiaTituloFraseDTO> buscaDiasFraseWppAgendameneto(Statement st, int filial) throws SQLException {
        ArrayList<DiaTituloFraseDTO> retorno = new ArrayList<DiaTituloFraseDTO>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select fwp_dias, fwp_campos from fraseagendamentowhatsapp ");
        buf.append("  where fil_codigo = ").append(filial);
        ResultSet rs = st.executeQuery(buf.toString());
        while (rs.next()) {
            DiaTituloFraseDTO dto = new DiaTituloFraseDTO();
            dto.setDia(rs.getInt("fwp_dias"));
            dto.setFrase(rs.getString("fwp_campos"));
            retorno.add(dto);
        }
        rs.close();
        return retorno;
    }
}

