/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.cadastro.convenio.TabelaPrecoExameBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.DetalheTabelaPrecoMetodologiaVO;
import jalis.model.vo.cadastro.TabelaPrecoPorteVO;
import jalis.model.vo.cadastro.TabelaPrecoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.cadastro.tabelaPreco.TabelaPrecoExameUsuarioVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TabelaPrecoDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = TabelaPrecoDao.load(TabelaPrecoExameBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (TabelaPrecoExameBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(TabelaPrecoVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (TabelaPrecoVO)aux.toArray()[0];
    }

    @Override
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    public List<PorteTabelaCBHPM> buscaPorte(String codigoFilial, String codigoTabela, String porte) throws SQLException {
        ArrayList<PorteTabelaCBHPM> listaPorte = new ArrayList<PorteTabelaCBHPM>();
        StringBuilder buf = new StringBuilder("select a.fil_codigo, a.tpe_codigo, ");
        buf.append("a.tpp_porte, a.tpp_valor ");
        buf.append(" from tabelaprecoexamesporte a ");
        buf.append("where a.fil_codigo = ").append(codigoFilial);
        buf.append(" and a.tpe_codigo = ").append(Integer.valueOf(codigoTabela));
        if (!Funcoes.textoVazio(porte)) {
            buf.append(" and a.tpp_porte = ").append(StringUtil.textoDBEscape(porte));
        }
        Statement st = ConexaoTemporaria.getStatement();
        ResultSet rs = ConexaoTemporaria.executeQuery(st, buf.toString());
        while (rs.next()) {
            PorteTabelaCBHPM porteTabela = new PorteTabelaCBHPM(rs.getString("tpp_porte"), rs.getDouble("tpp_valor"));
            listaPorte.add(porteTabela);
        }
        return listaPorte;
    }

    public List<DetalheTabelaPrecoMetodologiaVO> buscarPrecoMetodologia(Statement st, Integer codigoFilial, String codigoTabela) throws SQLException {
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, ");
        buf.append("a.dtm_proibido, a.dtm_valor, a.dtm_codamb, a.dtm_percentual, a.met_codigo, a.tpp_porte, ");
        buf.append("b.exa_descricao, a.mco_codigo from detalhetabelaprecometodologia a ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(codigoFilial);
        buf.append(" and a.tpe_codigo = ").append(codigoTabela);
        buf.append(" order by a.exa_codigo, a.mco_codigo");
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<DetalheTabelaPrecoMetodologiaVO> listaDtp = new ArrayList<DetalheTabelaPrecoMetodologiaVO>();
        while (rs.next()) {
            DetalheTabelaPrecoMetodologiaVO dtp = new DetalheTabelaPrecoMetodologiaVO();
            ExameVO exameVO = new ExameVO();
            exameVO.setCodigo(rs.getString("exa_codigo"));
            exameVO.setDescricao(rs.getString("exa_descricao"));
            dtp.setExame(exameVO);
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(codigoFilial);
            dtp.setFilial(filialVO);
            dtp.setValorCh(rs.getDouble("dtm_valor"));
            dtp.setCodigoAmb(rs.getString("dtm_codamb"));
            dtp.setPercentual(rs.getDouble("dtm_percentual"));
            dtp.setProibido(rs.getBoolean("dtm_proibido"));
            MetodologiaVO met = new MetodologiaVO();
            met.setCodigo(rs.getInt("met_codigo"));
            dtp.setMetodologia(met);
            TabelaPrecoPorteVO tpp = new TabelaPrecoPorteVO();
            tpp.setCodigo(rs.getString("tpp_porte"));
            dtp.setPorte(tpp);
            MaterialColetaVO material = new MaterialColetaVO();
            material.setCodigo(rs.getInt("mco_codigo"));
            material.setDescricao(rs.getString("mco_codigo"));
            dtp.setMatColeta(material);
            listaDtp.add(dtp);
        }
        return listaDtp;
    }

    public List<DetalheTabelaPrecoMetodologiaVO> buscarPreco(Statement st, Integer codigoFilial, String codigoTabela) throws SQLException {
        StringBuilder buf = new StringBuilder("select a.exa_codigo, a.mco_codigo, ");
        buf.append("a.dtp_proibido, a.dtp_valor, a.dtp_codamb, a.dtp_percentual, a.tpp_porte, ");
        buf.append("b.exa_descricao, a.mco_codigo from detalhetabelapreco a ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("where a.fil_codigo = ").append(codigoFilial);
        buf.append(" and a.tpe_codigo = ").append(codigoTabela);
        buf.append(" order by a.exa_codigo, a.mco_codigo");
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<DetalheTabelaPrecoMetodologiaVO> listaDtp = new ArrayList<DetalheTabelaPrecoMetodologiaVO>();
        while (rs.next()) {
            DetalheTabelaPrecoMetodologiaVO dtp = new DetalheTabelaPrecoMetodologiaVO();
            ExameVO exameVO = new ExameVO();
            exameVO.setCodigo(rs.getString("exa_codigo"));
            exameVO.setDescricao(rs.getString("exa_descricao"));
            dtp.setExame(exameVO);
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(codigoFilial);
            dtp.setFilial(filialVO);
            dtp.setValorCh(rs.getDouble("dtp_valor"));
            dtp.setCodigoAmb(rs.getString("dtp_codamb"));
            dtp.setPercentual(rs.getDouble("dtp_percentual"));
            dtp.setProibido(rs.getBoolean("dtp_proibido"));
            TabelaPrecoPorteVO tpp = new TabelaPrecoPorteVO();
            tpp.setCodigo(rs.getString("tpp_porte"));
            dtp.setPorte(tpp);
            MaterialColetaVO mat = new MaterialColetaVO();
            mat.setDescricao(rs.getString("mco_codigo"));
            mat.setFilial(filialVO);
            mat.setCodigo(rs.getInt("mco_codigo"));
            dtp.setMatColeta(mat);
            listaDtp.add(dtp);
        }
        return listaDtp;
    }

    public List<TabelaPrecoExameUsuarioVO> pesquisarHistorico(Integer codigoFilial, String dataInicio, String dataFinal, String usuario, String codigoTabela) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select teu_codigo, fil_codigo, tpe_codigo, usr_codigo, teu_datahora,");
        buf.append(" teu_alteracao from tabelaprecoexamesusuario");
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append(" and tpe_codigo = ").append(codigoTabela);
        if (!Funcoes.textoVazio(dataInicio)) {
            buf.append(" and cast(teu_datahora as date) >= '").append(dataInicio).append("'");
        }
        if (!Funcoes.textoVazio(dataFinal)) {
            buf.append(" and cast(teu_datahora as date) <= '").append(dataFinal).append("'");
        }
        if (!Funcoes.textoVazio(usuario)) {
            buf.append(" and usr_codigo ilike ").append(StringUtil.textoDBEscape(usuario));
        }
        buf.append(" order by teu_datahora desc");
        ResultSet rs = Conexao.getStatement().executeQuery(buf.toString());
        ArrayList<TabelaPrecoExameUsuarioVO> listaHistorico = new ArrayList<TabelaPrecoExameUsuarioVO>();
        while (rs.next()) {
            TabelaPrecoExameUsuarioVO tabelaPreco = new TabelaPrecoExameUsuarioVO();
            tabelaPreco.setCodigoTabelaPrecoExameUsuario(rs.getInt("teu_codigo"));
            tabelaPreco.setAlteracao(rs.getString("teu_alteracao"));
            tabelaPreco.setCodigoFilial(rs.getInt("fil_codigo"));
            tabelaPreco.setCodigoTabelaPreco(rs.getInt("tpe_codigo"));
            tabelaPreco.setCodigoUsuario(rs.getString("usr_codigo"));
            tabelaPreco.setDataHoraAlteracao(rs.getTimestamp("teu_datahora"));
            listaHistorico.add(tabelaPreco);
        }
        return listaHistorico;
    }

    public void inserirHistorico(TabelaPrecoExameUsuarioVO tpeu) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("insert into tabelaprecoexamesusuario (fil_codigo, tpe_codigo, usr_codigo, teu_datahora, teu_alteracao)");
        buf.append(" values(");
        buf.append(tpeu.getCodigoFilial()).append(",");
        buf.append(tpeu.getCodigoTabelaPreco()).append(",");
        buf.append(StringUtil.textoDBEscape(tpeu.getCodigoUsuario())).append(",");
        buf.append("'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", tpeu.getDataHoraAlteracao())).append("',");
        buf.append(StringUtil.textoDBEscape(tpeu.getAlteracao())).append(")");
        Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
    }

    public List<TabelaPrecoVO> buscarTabelaPreco(Integer codigoFilial, Integer codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select tpe_codigo, tpe_descricao, tpe_valorch, tpe_moeda, ");
        buf.append("fil_codigo, tpe_tabelaans, tpe_uco, tpe_tipocbhpm ");
        buf.append(" from tabelaprecoexames ");
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append(" and tpe_codigo = ").append(codigo);
        ResultSet rs = Conexao.getStatement().executeQuery(buf.toString());
        ArrayList<TabelaPrecoVO> listaTp = new ArrayList<TabelaPrecoVO>();
        while (rs.next()) {
            TabelaPrecoVO tp = new TabelaPrecoVO();
            tp.setCodigo(rs.getInt("tpe_codigo"));
            tp.setDescricao(rs.getString("tpe_descricao"));
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(rs.getInt("fil_codigo"));
            tp.setFilial(filialVO);
            tp.setMoeda(rs.getString("tpe_moeda"));
            tp.setTabelaANS(rs.getString("tpe_tabelaans"));
            tp.setTipoCbhpm(rs.getBoolean("tpe_tipocbhpm"));
            tp.setValorCh(rs.getDouble("tpe_valorch"));
            tp.setValorUco(rs.getDouble("tpe_uco"));
            listaTp.add(tp);
        }
        return listaTp;
    }
}

