/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class PacienteDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and pac_codigo = " + codigo;
        Set pacientes = this.loadVO(PacienteBean.class, where);
        if (pacientes == null || pacientes.size() == 0 || pacientes.size() > 1) {
            return null;
        }
        return (AbstractThreadBean)pacientes.toArray()[0];
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return this.getBean(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and pac_codigo = " + codigo;
        Set pacientes = this.loadVO(PacienteVO.class, where);
        if (pacientes == null || pacientes.size() == 0 || pacientes.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)pacientes.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    @Deprecated
    public Set load(Class cls) throws ThreadDaoException {
        return super.load(cls);
    }

    public PacienteVO getPacienteRequisicao(String filial, String codigoRequisicao) throws ThreadDaoException, SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select pac.pac_codigo as codigo ");
        buf.append("   from requisicao req ");
        buf.append("   left join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  where req.req_codigo = ").append(codigoRequisicao);
        buf.append("    and req.fil_codigo = ").append(filial);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return (PacienteVO)this.getVO(filial, rs.getString("codigo"));
        }
        return null;
    }

    public boolean verificaHaExamesLancadosConferidos(String filial, String codigoPaciente) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COUNT(1) as qtde ");
        buf.append("   from examerequisicao exr ");
        buf.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("  where exr.exr_situacao IN ('").append("C").append("', '").append("L").append("') ");
        buf.append("    and pac.fil_codigo = ").append(filial);
        buf.append("    and pac.pac_codigo = ").append(codigoPaciente);
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and NOT exr.exr_excluido ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            int qtde = rs.getInt("qtde");
            return qtde > 0;
        }
        return false;
    }

    public boolean isEmailNaoInformado(String filial, String codigoPaciente) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COALESCE(pac_emailnaoinformado, false) informado ");
        buf.append("   from paciente ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and pac_codigo = ").append(codigoPaciente);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getBoolean("informado");
        }
        return false;
    }

    public boolean isEmailVazio(String filial, String codigoPaciente) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select length(COALESCE(trim(pac_email), '')) > 0 informado ");
        buf.append("   from paciente ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and pac_codigo = ").append(codigoPaciente);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return !rs.getBoolean("informado");
        }
        return false;
    }

    public boolean isCelularVazio(String filial, String codigoPaciente) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select length(COALESCE(trim(pac_celular), '')) > 0 informado ");
        buf.append("   from paciente ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and pac_codigo = ").append(codigoPaciente);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return !rs.getBoolean("informado");
        }
        return false;
    }

    public boolean isWhatsAppVazio(String filial, String codigoPaciente) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select length(COALESCE(trim(pac_whatsapp), '')) > 0 informado ");
        buf.append("   from paciente ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and pac_codigo = ").append(codigoPaciente);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return !rs.getBoolean("informado");
        }
        return false;
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = PacienteDao.load(PacienteBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (PacienteBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(PacienteVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (PacienteVO)aux.toArray()[0];
    }

    public String getProntuarioDoPaciente(int codigoFilial, int codigoPaciente) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select coalesce(pac_prontuario,'') as prontuario from paciente ");
        sql.append(" where pac_codigo = ").append(codigoPaciente);
        sql.append(" and fil_codigo = ").append(codigoFilial);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        rs.next();
        return rs.getString("prontuario");
    }

    public ArrayList getVOPaciente(String filCodigo, String nome) throws ThreadDaoException {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(filCodigo);
        where.append(" and pac_nome ilike '").append(StringUtil.textoDB(nome)).append("' ");
        Set dadosPaciente = this.loadVO(PacienteVO.class, where.toString());
        if (dadosPaciente.isEmpty()) {
            return new ArrayList();
        }
        return new ArrayList(dadosPaciente);
    }
}

