/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro;

import jalis.comum.Conexao;
import jalis.model.vo.cadastro.MedicoContatoVO;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class MedicoContatoDao {
    public ArrayList<MedicoContatoVO> getContatosMedico(String filial, String crm, String conselho, String uf) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        ArrayList<MedicoContatoVO> contatos = new ArrayList<MedicoContatoVO>();
        buf.append(" select mct_codigo,  mct_nome, mct_email, mct_enviaremail from medicocontato ");
        buf.append(" Where fil_codigo = ").append(filial);
        buf.append(" and med_conselho = '").append(conselho).append("'");
        buf.append(" and med_crm = ").append(StringUtil.textoDBEscape(crm));
        buf.append(" and med_uf  = '").append(uf).append("'");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            MedicoContatoVO contato = new MedicoContatoVO();
            contato.setFilial(Integer.parseInt(filial));
            contato.setConselho(conselho);
            contato.setCrm(crm);
            contato.setUf(uf);
            contato.setCodigo(rs.getInt("mct_codigo"));
            contato.setContatoNome(rs.getString("mct_nome"));
            contato.setContatoEmail(rs.getString("mct_email"));
            contato.setEnviarEmail(rs.getBoolean("mct_enviaremail"));
            contatos.add(contato);
        }
        return contatos;
    }

    public Object getSequence(String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append("select nextval('medicocontato_").append(filial).append("_sequence')");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public void atualizarDadosMedicoContatos(String filial, MedicoContatoVO con) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" Update medicocontato set ");
        buf.append("  mct_nome = ").append(StringUtil.textoDBEscape(con.getContatoNome()));
        buf.append(", mct_email = ").append(StringUtil.textoDBEscape(con.getContatoEmail()));
        buf.append(", mct_enviaremail =  ").append(con.getEnviarEmail());
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("  and mct_codigo = ").append(con.getCodigo());
        Conexao.executeUpdate(filial, st, buf.toString());
    }

    public void removerContato(String filial, MedicoContatoVO con) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        buf.append(" delete from medicocontato ");
        buf.append(" Where fil_codigo = ").append(filial);
        buf.append("  AND mct_codigo = ").append(con.getCodigo());
        Conexao.executeUpdate(filial, st, buf.toString());
    }
}

