/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro;

import jalis.comum.Conexao;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.cadastro.convenio.ConvenioHistoricoCotaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioHistoricoCotaVO;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConvenioHistoricoCotaDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    public boolean verificaPoliticaAlterada(ConvenioHistoricoCotaBean bean) throws Exception {
        if (bean == null || bean.getFilial() == null || bean.getFilial().getCodigo() == null || bean.getConvenio() == null || bean.getConvenio().getCodigo() == null) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select MAX(chc_codigo) as codigo ");
        buf.append("   from convenioshistoricocota ");
        buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
        buf.append("    and con_codigo = ").append(bean.getConvenio().getCodigo());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            Integer codigo = rs.getInt("codigo");
            if (codigo == null) {
                return true;
            }
            HashMap<String, Object> mapa = new HashMap<String, Object>();
            mapa.put("fil_codigo", bean.getFilial().getCodigo());
            mapa.put("con_codigo", bean.getConvenio().getCodigo());
            mapa.put("chc_codigo", codigo);
            ConvenioHistoricoCotaBean aux = (ConvenioHistoricoCotaBean)this.getBean(mapa);
            if (aux == null) {
                return true;
            }
            return !(aux.getTipoPolitica() == null ? "" : aux.getTipoPolitica()).equalsIgnoreCase(bean.getTipoPolitica() == null ? "" : bean.getTipoPolitica()) || !(aux.getBloqueioPolitica() == null ? "" : aux.getBloqueioPolitica()).equalsIgnoreCase(bean.getBloqueioPolitica() == null ? "" : bean.getBloqueioPolitica()) || !(aux.getZerarPolitica() == null ? "" : aux.getZerarPolitica()).equalsIgnoreCase(bean.getZerarPolitica() == null ? "" : bean.getZerarPolitica()) || (aux.getValorAtual() == null ? 0.0 : aux.getValorAtual()) != (bean.getValorAtual() == null ? 0.0 : bean.getValorAtual());
        }
        return true;
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ConvenioHistoricoCotaDao.load(ConvenioHistoricoCotaBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ConvenioHistoricoCotaBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ConvenioHistoricoCotaDao.load(ConvenioHistoricoCotaVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ConvenioHistoricoCotaVO)aux.toArray()[0];
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        return null;
    }
}

