/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.dao.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.faturamento.eletronico.FabricaFaturaEletronica;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.bean.cadastro.convenio.ConvenioCotaExameBean;
import jalis.model.bean.cadastro.convenio.ConvenioCotaExameSituacaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.cadastro.exame.SituacaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.ExameService;
import jalis.service.cadastro.exame.MaterialColetaService;
import jalis.service.cadastro.exame.MetodologiaService;
import jalis.service.cadastro.exame.SituacaoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConvenioDao
extends AbstractThreadDao
implements ThreadBeanDaoMultiplasChaves {
    @Deprecated
    public AbstractThreadBean getBean(String filial, String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getBean(String codigo) throws ThreadDaoException {
        return null;
    }

    @Override
    public AbstractThreadVO getVO(String filial, String codigo) throws ThreadDaoException {
        String where = " where fil_codigo = " + filial + " and con_codigo = " + codigo;
        Set convenios = this.loadVO(ConvenioVO.class, where);
        if (convenios == null || convenios.size() == 0 || convenios.size() > 1) {
            return null;
        }
        return (AbstractThreadVO)convenios.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws ThreadDaoException {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = ConvenioDao.load(ConvenioBean.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ConvenioBean)aux.toArray()[0];
    }

    @Override
    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        ArrayList<String> wheres = new ArrayList<String>();
        for (String chave : chaves.keySet()) {
            wheres.add(chave + "=" + this.getValorParaBanco(chaves.get(chave)));
        }
        String where = " where " + StringUtil.implode(wheres, " and ");
        Set aux = this.loadVO(ConvenioVO.class, where);
        if (aux == null || aux.size() == 0 || aux.size() > 1) {
            return null;
        }
        return (ConvenioVO)aux.toArray()[0];
    }

    public BigDecimal getValorMaximoDescontoUsuario(String filial, String codigoConvenio, String codigoUsuario) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select cde_desconto as desconto ");
        buf.append("   from conveniodesconto cde ");
        buf.append("   join tipousuario tpu on cde.tpu_codigo = tpu.tpu_codigo ");
        buf.append("   join usuario usr on tpu.tpu_codigo = usr.tpu_codigo ");
        buf.append("  where cde.fil_codigo = ").append(filial);
        buf.append("    and cde.con_codigo = ").append(codigoConvenio);
        buf.append("    and usr.usr_codigo = '").append(codigoUsuario).append("' ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getBigDecimal("desconto");
        }
        return null;
    }

    public FaturamentoEletronico getProtocoloEletronico(String filial, String codigoConvenio) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_faturaeletronica ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and con_codigo = ").append(codigoConvenio);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            String xml = rs.getString("con_faturaeletronica");
            String protocolo = StringUtil.getValor(xml, "protocolo");
            return FabricaFaturaEletronica.novoFaturamentoEletronico(protocolo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConvenioUtilizaCotaExame(String filial, String codigo) throws SQLException {
        Statement st;
        block4: {
            String tipoPolitica;
            block5: {
                boolean bl;
                StringBuilder buf = new StringBuilder();
                buf.append(" select con_tipopolitica ");
                buf.append("   from convenios ");
                buf.append("  where fil_codigo = ").append(filial);
                buf.append("    and con_codigo = ").append(codigo);
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block4;
                    tipoPolitica = rs.getString("con_tipopolitica");
                    if (!Funcoes.textoVazio(tipoPolitica)) break block5;
                    bl = false;
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return bl;
            }
            boolean bl = tipoPolitica.equalsIgnoreCase("E");
            Conexao.fecharStatement(st);
            return bl;
        }
        boolean bl = false;
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTipoIntegracaoOperadoraSaude(String codigoFilial, String codigoConvenio) throws SQLException {
        Statement st;
        block4: {
            String codigoIntegracao;
            block5: {
                String string;
                StringBuilder buf = new StringBuilder();
                buf.append(" select con_tipointegracaooperadora ");
                buf.append("   from convenios ");
                buf.append("  where fil_codigo = ").append(codigoFilial);
                buf.append("    and con_codigo = ").append(codigoConvenio);
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
                    if (!rs.next()) break block4;
                    codigoIntegracao = rs.getString("con_tipointegracaooperadora");
                    if (!Funcoes.textoVazio(codigoIntegracao)) break block5;
                    string = null;
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return string;
            }
            String string = codigoIntegracao;
            Conexao.fecharStatement(st);
            return string;
        }
        String string = null;
        Conexao.fecharStatement(st);
        return string;
    }

    public String getXmlDoConvenio(String codigoFilial, String codigoConvenio) throws SQLException {
        String xml = "";
        StringBuilder sql = new StringBuilder();
        sql.append("select con_faturaeletronica from convenios ");
        sql.append("where fil_codigo = ").append(codigoFilial);
        sql.append(" and con_codigo = ").append(codigoConvenio);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            xml = rs.getString("con_faturaeletronica");
        }
        return xml;
    }

    public List<ConvenioCotaExameBean> retornaConvenioCotaExame(Integer filial, int convenio, String tipoPolitica) throws Exception {
        ArrayList<ConvenioCotaExameBean> list = new ArrayList<ConvenioCotaExameBean>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select ");
        buf.append("        c.exa_codigo, c.fil_codigo, c.met_codigo, c.mco_codigo, c.cct_quantidade, c.con_codigo ");
        buf.append("   from conveniocotaexame c ");
        buf.append("   join convenios con on c.fil_codigo = con.fil_codigo and c.con_codigo = con.con_codigo  ");
        buf.append(" where c.fil_codigo = ");
        buf.append(filial);
        buf.append(" and c.con_codigo = ");
        buf.append(convenio);
        buf.append(" and con.con_tipopolitica = ");
        buf.append(tipoPolitica);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            ConvenioCotaExameBean con = new ConvenioCotaExameBean();
            ExameVO exameVO = (ExameVO)new ExameService().getVO(rs.getString("exa_codigo"));
            FilialVO filialVO = (FilialVO)new FilialService().get(Variaveis.filialPadrao).toVO();
            MetodologiaVO metodologiaVO = (MetodologiaVO)new MetodologiaService().getVO(rs.getString("met_codigo"));
            MaterialColetaVO materialColetaVO = (MaterialColetaVO)new MaterialColetaService().getVO(rs.getString("mco_codigo"));
            ConvenioVO convenioVO = (ConvenioVO)new ConvenioService().getVO(rs.getString("con_codigo"));
            con.setExame(exameVO);
            con.setFilial(filialVO);
            con.setCodigo(convenioVO);
            con.setMaterialColeta(materialColetaVO);
            con.setMetodologia(metodologiaVO);
            con.setQuantidade(Double.parseDouble(rs.getString("cct_quantidade")));
            list.add(con);
        }
        return list;
    }

    public int retornaConvenioCotaExameQuantidade(Integer filial, int convenio, String tipoPolitica, String exame, Integer material) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select ");
        buf.append("    c.cct_quantidade ");
        buf.append("   from conveniocotaexame c ");
        buf.append("   join convenios con on c.fil_codigo = con.fil_codigo and c.con_codigo = con.con_codigo  ");
        buf.append(" where c.fil_codigo = ");
        buf.append(filial);
        buf.append(" and c.con_codigo = ");
        buf.append(convenio);
        buf.append(" and con.con_tipopolitica = ");
        buf.append(tipoPolitica);
        if (exame != null) {
            buf.append(" and c.exa_codigo = '");
            buf.append(exame).append("'");
        }
        if (material != null) {
            buf.append(" and c.mco_codigo = ");
            buf.append(material);
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("cct_quantidade");
        }
        return 0;
    }

    public List<ConvenioCotaExameSituacaoBean> retornaConvenioCotaExameSituacao(Integer filial, String convenio, String tipoPolitica) throws Exception {
        ArrayList<ConvenioCotaExameSituacaoBean> listaSituacao = new ArrayList<ConvenioCotaExameSituacaoBean>();
        StringBuilder buf = new StringBuilder();
        buf.append(" select ");
        buf.append(" c.fil_codigo, c.sit_codigo, c.con_codigo ");
        buf.append("   from conveniocotaexamesituacao c ");
        buf.append("   join convenios con on c.fil_codigo = con.fil_codigo and c.con_codigo = con.con_codigo  ");
        buf.append(" where c.fil_codigo = ");
        buf.append(filial);
        buf.append(" and c.con_codigo = ");
        buf.append(convenio);
        buf.append(" and con.con_tipopolitica = ");
        buf.append(tipoPolitica);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            ConvenioCotaExameSituacaoBean c = new ConvenioCotaExameSituacaoBean();
            FilialVO filialVO = (FilialVO)new FilialService().get(rs.getString("fil_codigo")).toVO();
            ConvenioVO convenioVO = (ConvenioVO)new ConvenioService().getVO(rs.getString("con_codigo"));
            SituacaoVO situacaoVO = (SituacaoVO)new SituacaoService().getVO(rs.getString("sit_codigo"));
            c.setFilial(filialVO);
            c.setConvenio(convenioVO);
            c.setSituacao(situacaoVO);
            listaSituacao.add(c);
        }
        return listaSituacao;
    }

    public int quantidadeRequisicaoPorPeriodoMes(int filial, int codigoConvenio, String exame, int material, boolean isConsiderarAgendamentoCota, java.util.Date data, Integer codigoRequisicao) throws Exception {
        ResultSet rs;
        if (filial < 0 || codigoConvenio < 0 || exame == null) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select COUNT(1) as qtde  ");
        buf.append(" from examerequisicao exr  ");
        buf.append(" join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
        if (isConsiderarAgendamentoCota) {
            buf.append(" left join agendamento a on req.fil_codigo = a.fil_codigo and req.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
        }
        buf.append(" where req.con_codigo =  ").append(codigoConvenio);
        buf.append(" and exr.fil_codigo = ").append(filial);
        buf.append(" and exr.exa_codigo = '").append(exame).append("'");
        buf.append(" and exr.mco_codigo = ").append(material);
        buf.append(" and date_trunc('month', req_dtfatura) = cast('").append(Funcoes.formataData("yyyy-MM", data)).append("-01' as timestamp) ");
        if (isConsiderarAgendamentoCota) {
            buf.append(" AND (NOT req.req_excluida or (a.agd_codigo is not null and a.agd_datahoracancelamento IS NULL) )");
        } else {
            buf.append(" and not req.req_excluida");
        }
        if (codigoRequisicao != null) {
            buf.append(" and req.req_codigo <> ").append(codigoRequisicao);
        }
        if ((rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString())).next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    public java.util.Date retornaDataHoraUltimoFaturamento(int filial, int codigoConvenio, String exame, int material) throws Exception {
        Date dataFatura = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select MAX(fat.fat_datahora) as data  ");
        buf.append(" from faturaexamerequisicao a  ");
        buf.append(" join faturarequisicao b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo and a.req_codigo = b.req_codigo  ");
        buf.append(" join examerequisicao exr on a.req_codigo = exr.req_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo  ");
        buf.append(" join fatura fat on b.fil_codigo = fat.fil_codigo and b.fat_codigo = fat.fat_codigo ");
        buf.append(" where fat.con_codigo = ").append(codigoConvenio);
        buf.append(" and fat.fil_codigo = ").append(filial);
        buf.append(" and a.exa_codigo = '").append(exame).append("'");
        buf.append(" and a.mco_codigo = ").append(material);
        buf.append(" and fat.fat_datacancelamento IS NULL ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            dataFatura = rs.getDate("data");
        }
        return dataFatura;
    }

    public int quantidadeRequisicaoPorDataFaturamento(int filial, int codigoConvenio, String exame, int material, boolean isConsiderarAgendamentoCota, java.util.Date data) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select COUNT(er.req_codigo) as qtde ");
        buf.append("   from requisicao a ");
        buf.append(" inner join examerequisicao er on a.fil_codigo = er.fil_codigo and a.req_codigo = er.req_codigo ");
        buf.append("   left join faturarequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo ");
        buf.append("   left join fatura c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo ");
        if (isConsiderarAgendamentoCota) {
            buf.append(" left join agendamento agend on a.fil_codigo = agend.fil_codigo and a.req_codigo = agend.req_codigo and agend.agd_datahoracancelamento IS NULL");
        }
        buf.append("  where a.con_codigo = ").append(codigoConvenio);
        buf.append("  and a.fil_codigo = ").append(filial);
        buf.append("  and er.exa_codigo = '").append(exame).append("'");
        buf.append("  and er.mco_codigo = ").append(material);
        buf.append("  and not a.req_excluida ");
        buf.append("  and not exr_excluido ");
        buf.append("  and c.fat_datacancelamento is null ");
        buf.append("  and b.req_codigo is null ");
        if (data != null) {
            buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", data)).append("' ");
        }
        if (isConsiderarAgendamentoCota) {
            buf.append(" AND (NOT a.req_excluida or (agend.agd_codigo is not null and agend.agd_datahoracancelamento IS NULL) )");
        } else {
            buf.append(" and not a.req_excluida");
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getInt("qtde");
        }
        return 0;
    }

    public Boolean isConsiderarAgendamentoCota(int filial, int codigoConvenio) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_usaragendamentopolitica ");
        buf.append("   from convenios ");
        buf.append("  where con_codigo in (").append(codigoConvenio).append(")");
        buf.append("    and fil_codigo = ").append(filial);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            return rs.getBoolean("con_usaragendamentopolitica");
        }
        return false;
    }

    public Double getPercentualPagamentoMinimo(Integer filial, Integer codigoConvenio) throws SQLException {
        Double valorMinimo = 0.0;
        StringBuilder sql = new StringBuilder();
        sql.append("select con_percvalorminimo from convenios ");
        sql.append("where fil_codigo = ").append(filial);
        sql.append(" and con_codigo = ").append(codigoConvenio);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            valorMinimo = rs.getDouble("con_percvalorminimo");
        }
        return valorMinimo;
    }

    public Integer retornaConvenioRequisicao(int filial, int requisicao, Statement st) throws SQLException {
        int retorno = 0;
        StringBuilder sql = new StringBuilder();
        sql.append(" select r.con_codigo");
        sql.append(" from requisicao r ");
        sql.append(" where r.fil_codigo = ").append(filial);
        sql.append(" and r.req_codigo = ").append(requisicao);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            retorno = rs.getInt("con_codigo");
        }
        rs.close();
        return retorno;
    }

    public Integer getCodigoLaboratorioExterno(int filial, int convenio, Statement st) throws SQLException {
        int retorno = 0;
        StringBuilder sql = new StringBuilder();
        sql.append(" select con.lae_codigo");
        sql.append(" from convenios con ");
        sql.append(" where con.fil_codigo = ").append(filial);
        sql.append(" and con.con_codigo = ").append(convenio);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            retorno = rs.getInt("lae_codigo");
        }
        rs.close();
        return retorno;
    }
}

