/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.triagem;

import jalis.model.AbstractThreadBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.triagem.MaterialEnviadoVO;
import jalis.util.Funcoes;
import java.util.Date;

@DataBaseTable(value="materialidentificado")
public class MaterialIdentificadoBean
extends AbstractThreadBean {
    @FieldTransient
    public static int QTDE_CARAC_FILIAL = 2;
    @FieldTransient
    public static int QTDE_CARAC_CELULA = 4;
    @FieldTransient
    public static int QTDE_CARAC_MATERIAL = 8;
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="cel_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private CelulaEstoqueVO celula;
    @DataBaseField(value="mat_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private MaterialVO material;
    @DataBaseField(value="mid_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="mid_dataenvio")
    @FieldTimeStamp
    private Date dataEnvio;
    @DataBaseField(value="mid_dataretorno")
    @FieldTimeStamp
    private Date dataRetorno;
    @DataBaseField(value="usr_codenvio")
    @DataBaseForeignKey
    private UsuarioVO usuarioEnvio;
    @DataBaseField(value="usr_codretorno")
    @DataBaseForeignKey
    private UsuarioVO usuarioRetorno;
    @DataBaseField(value="mid_inutilizado")
    private Boolean inutilizado;
    @DataBaseField(value="men_codigo")
    @DataBaseForeignKey
    private MaterialEnviadoVO materialEnviado;

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public CelulaEstoqueVO getCelula() {
        return this.celula;
    }

    public void setCelula(CelulaEstoqueVO celula) {
        this.celula = celula;
        this.addCampoAlterado("celula");
    }

    public MaterialVO getMaterial() {
        return this.material;
    }

    public void setMaterial(MaterialVO material) {
        this.material = material;
        this.addCampoAlterado("material");
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public Date getDataEnvio() {
        return this.dataEnvio;
    }

    public void setDataEnvio(Date dataEnvio) {
        this.dataEnvio = dataEnvio;
        this.addCampoAlterado("dataEnvio");
    }

    public Date getDataRetorno() {
        return this.dataRetorno;
    }

    public void setDataRetorno(Date dataRetorno) {
        this.dataRetorno = dataRetorno;
        this.addCampoAlterado("dataRetorno");
    }

    public UsuarioVO getUsuarioEnvio() {
        return this.usuarioEnvio;
    }

    public void setUsuarioEnvio(UsuarioVO usuarioEnvio) {
        this.usuarioEnvio = usuarioEnvio;
        this.addCampoAlterado("usuarioEnvio");
    }

    public UsuarioVO getUsuarioRetorno() {
        return this.usuarioRetorno;
    }

    public void setUsuarioRetorno(UsuarioVO usuarioRetorno) {
        this.usuarioRetorno = usuarioRetorno;
        this.addCampoAlterado("usuarioRetorno");
    }

    public Boolean getInutilizado() {
        return this.inutilizado;
    }

    public void setInutilizado(Boolean inutilizado) {
        this.inutilizado = inutilizado;
        this.addCampoAlterado("inutilizado");
    }

    public MaterialEnviadoVO getMaterialEnviado() {
        return this.materialEnviado;
    }

    public void setMaterialEnviado(MaterialEnviadoVO materialEnviado) {
        this.materialEnviado = materialEnviado;
        this.addCampoAlterado("materialEnviado");
    }

    @Override
    public AbstractThreadBean toVO() {
        return null;
    }

    public String toString() {
        String filial = Funcoes.preencheZero(this.filial.getCodigo().toString(), QTDE_CARAC_FILIAL);
        String celula = Funcoes.preencheZero(this.celula.getCodigo().toString(), QTDE_CARAC_CELULA);
        String codigo = Funcoes.preencheZero(this.getCodigo().toString(), QTDE_CARAC_MATERIAL);
        return filial + celula + codigo;
    }
}

