/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.recepcao;

import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.recepcao.OrcamentoConvenioBean;
import jalis.model.bean.recepcao.OrcamentoTaxaBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.exame.SituacaoVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.recepcao.OrcamentoVO;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

@DataBaseTable(value="orcamento")
public class OrcamentoBean
extends AbstractThreadBean
implements Serializable,
Cloneable {
    @FieldTransient
    private static final long serialVersionUID = -763670869018476059L;
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="orc_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="orc_datahora")
    @FieldTimeStamp
    private Date dataHora;
    @DataBaseField(value="orc_observacao")
    private String observacao;
    @DataBaseField(value="orc_percentualdesconto")
    private Double percentualDesconto;
    @DataBaseField(value="orc_valordesconto")
    private Double valorDesconto;
    @DataBaseField(value="orc_percentualacrescimo")
    private Double percentualAcrescimo;
    @DataBaseField(value="orc_valoracrescimo")
    private Double valorAcrescimo;
    @DataBaseField(value="orc_validade")
    private String validade;
    @DataBaseField(value="orc_solicitante")
    private String solicitante;
    @DataBaseField(value="orc_contato")
    private String contato;
    @DataBaseField(value="orc_fone")
    private String fone;
    @DataBaseField(value="orc_email")
    private String email;
    @DataBaseField(value="orc_fonecontato")
    private String foneContato;
    @DataBaseField(value="orc_proprietario")
    private String proprietario;
    @DataBaseField(value="pac_codigo")
    @DataBaseForeignKey
    private PacienteVO paciente;
    @DataBaseField(value="usr_codigo")
    @DataBaseForeignKey
    private UsuarioVO usuario;
    @DataBaseField(value="usr_codaprovado")
    @DataBaseForeignKey
    private UsuarioVO usuarioAprovacao;
    @DataBaseField(value="orc_dataaprovado")
    @FieldTimeStamp
    private Date dataHoraAprovacao;
    @DataBaseField(value="orc_aprovadopor")
    private String aprovadorPor;
    @FieldTransient
    private boolean utilizado;
    @DataBaseField(value="fpg_codigo")
    @DataBaseForeignKey
    private FormaPagamentoVO formaPagamento;
    @DataBaseField(value="sit_codigo")
    @DataBaseForeignKey
    private SituacaoVO situacao;
    @FieldTransient
    private ArrayList<OrcamentoConvenioBean> convenios = new ArrayList();
    @FieldTransient
    private ArrayList<OrcamentoTaxaBean> taxas;
    @DataBaseField(value="med_conselho")
    private String medicoConselho;
    @DataBaseField(value="med_crm")
    private String medicoCRM;
    @DataBaseField(value="med_uf")
    private String medicoUF;
    @FieldTransient
    private static final String VERSAO_OBJETO_SERIALIZAVEL_2 = "versao2";

    public void setAprovadorPor(String aprovadorPor) {
        this.aprovadorPor = aprovadorPor;
        this.addCampoAlterado("aprovadorPor");
    }

    public String getAprovadorPor() {
        return this.aprovadorPor;
    }

    public void setUsuarioAprovacao(UsuarioVO usuarioAprovacao) {
        this.addCampoAlterado("usuarioAprovacao");
        this.usuarioAprovacao = usuarioAprovacao;
    }

    public UsuarioVO getUsuarioAprovacao() {
        return this.usuarioAprovacao;
    }

    public void setDataHoraAprovacao(Date dataHoraAprovacao) {
        this.addCampoAlterado("dataHoraAprovacao");
        this.dataHoraAprovacao = dataHoraAprovacao;
    }

    public Date getDataHoraAprovacao() {
        return this.dataHoraAprovacao;
    }

    public boolean getUtilizado() {
        return this.utilizado;
    }

    public void setUtilizado(boolean utilizado) {
        this.utilizado = utilizado;
    }

    @Override
    public AbstractThreadBean toVO() {
        OrcamentoVO vo = new OrcamentoVO();
        vo.setFilial(this.getFilial());
        vo.setCodigo(this.getCodigo());
        vo.setDataHora(this.getDataHora());
        return vo;
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
        this.addCampoAlterado("dataHora");
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = StringUtil.trataCaracteresEspeciais(observacao);
        this.addCampoAlterado("observacao");
    }

    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
        this.addCampoAlterado("percentualDesconto");
    }

    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
        this.addCampoAlterado("valorDesconto");
    }

    public String getValidade() {
        return this.validade;
    }

    public void setValidade(String validade) {
        this.validade = validade;
        this.addCampoAlterado("validade");
    }

    public String getSolicitante() {
        return this.solicitante;
    }

    public void setSolicitante(String solicitante) {
        this.solicitante = solicitante;
        this.addCampoAlterado("solicitante");
    }

    public String getContato() {
        return this.contato;
    }

    public void setContato(String contato) {
        this.contato = contato;
        this.addCampoAlterado("contato");
    }

    public String getFone() {
        return this.fone;
    }

    public void setFone(String fone) {
        this.fone = fone;
        this.addCampoAlterado("fone");
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.addCampoAlterado("email");
    }

    public String getFoneContato() {
        return this.foneContato;
    }

    public void setFoneContato(String foneContato) {
        this.foneContato = foneContato;
        this.addCampoAlterado("foneContato");
    }

    public UsuarioVO getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioVO usuario) {
        this.usuario = usuario;
        this.addCampoAlterado("usuario");
    }

    public ArrayList<OrcamentoConvenioBean> getConvenios() {
        return this.convenios;
    }

    public void setConvenios(ArrayList<OrcamentoConvenioBean> convenios) {
        this.convenios = convenios;
    }

    public ArrayList<OrcamentoTaxaBean> getTaxas() {
        return this.taxas;
    }

    public void setTaxas(ArrayList<OrcamentoTaxaBean> taxas) {
        this.taxas = taxas;
    }

    public String getProprietario() {
        return this.proprietario;
    }

    public void setProprietario(String proprietario) {
        this.proprietario = proprietario;
        this.addCampoAlterado("proprietario");
    }

    public PacienteVO getPaciente() {
        return this.paciente;
    }

    public void setPaciente(PacienteVO paciente) {
        this.paciente = paciente;
        this.addCampoAlterado("paciente");
    }

    public Double getPercentualAcrescimo() {
        return this.percentualAcrescimo;
    }

    public void setPercentualAcrescimo(Double percentualAcrescimo) {
        this.percentualAcrescimo = percentualAcrescimo;
        this.addCampoAlterado("percentualAcrescimo");
    }

    public Double getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    public void setValorAcrescimo(Double valorAcrescimo) {
        this.valorAcrescimo = valorAcrescimo;
        this.addCampoAlterado("valorAcrescimo");
    }

    public FormaPagamentoVO getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(FormaPagamentoVO formaPagamento) {
        this.formaPagamento = formaPagamento;
        this.addCampoAlterado("formaPagamento");
    }

    public String getMedicoConselho() {
        return this.medicoConselho;
    }

    public void setMedicoConselho(String medicoConselho) {
        this.medicoConselho = medicoConselho;
        this.addCampoAlterado("medicoConselho");
    }

    public String getMedicoCRM() {
        return this.medicoCRM;
    }

    public void setMedicoCRM(String medicoCRM) {
        this.medicoCRM = medicoCRM;
        this.addCampoAlterado("medicoCRM");
    }

    public String getMedicoUF() {
        return this.medicoUF;
    }

    public void setMedicoUF(String medicoUF) {
        this.medicoUF = medicoUF;
        this.addCampoAlterado("medicoUF");
    }

    public Integer[] serializar() {
        try {
            final ArrayList lista = new ArrayList();
            OutputStream os = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    lista.add(b);
                }

                public ArrayList<Integer> getLista() {
                    return lista;
                }
            };
            ObjectOutputStream oos = new ObjectOutputStream(os);
            this.writeExternal(oos);
            oos.close();
            Integer[] retorno = new Integer[lista.size()];
            for (int i = 0; i < lista.size(); ++i) {
                retorno[i] = (Integer)lista.get(i);
            }
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel serializar o or\u00e7amento.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    public static OrcamentoBean desserializar(Integer[] dados) {
        byte[] auxByte = new byte[dados.length];
        for (int i = 0; i < dados.length; ++i) {
            auxByte[i] = new Byte(dados[i].toString());
        }
        ByteArrayInputStream is = new ByteArrayInputStream(auxByte);
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            if (ois != null) {
                OrcamentoBean bean = OrcamentoBean.readExternal(ois);
                ois.close();
                return bean;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel desserializar o or\u00e7amento.\n" + e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    public static OrcamentoBean readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        OrcamentoBean bean = new OrcamentoBean();
        Object obj = in.readObject();
        boolean isVersao2 = VERSAO_OBJETO_SERIALIZAVEL_2.equals(obj);
        if (!isVersao2) {
            return (OrcamentoBean)obj;
        }
        bean.setFilial((FilialVO)in.readObject());
        bean.setCodigo((Integer)in.readObject());
        bean.setDataHora((Date)in.readObject());
        bean.setObservacao((String)in.readObject());
        bean.setPercentualDesconto((Double)in.readObject());
        bean.setValorDesconto((Double)in.readObject());
        bean.setPercentualAcrescimo((Double)in.readObject());
        bean.setValorAcrescimo((Double)in.readObject());
        bean.setValidade((String)in.readObject());
        bean.setSolicitante((String)in.readObject());
        bean.setContato((String)in.readObject());
        bean.setFone((String)in.readObject());
        bean.setEmail((String)in.readObject());
        bean.setFoneContato((String)in.readObject());
        bean.setProprietario((String)in.readObject());
        bean.setPaciente((PacienteVO)in.readObject());
        bean.setUsuario((UsuarioVO)in.readObject());
        bean.setUsuarioAprovacao((UsuarioVO)in.readObject());
        bean.setDataHoraAprovacao((Date)in.readObject());
        bean.setAprovadorPor((String)in.readObject());
        bean.setUtilizado((Boolean)in.readObject());
        bean.setConvenios((ArrayList)in.readObject());
        if (isVersao2) {
            bean.setFormaPagamento((FormaPagamentoVO)in.readObject());
        }
        return bean;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(VERSAO_OBJETO_SERIALIZAVEL_2);
        out.writeObject(this.filial);
        out.writeObject(this.codigo);
        out.writeObject(this.dataHora);
        out.writeObject(this.observacao);
        out.writeObject(this.percentualDesconto);
        out.writeObject(this.valorDesconto);
        out.writeObject(this.percentualAcrescimo);
        out.writeObject(this.valorAcrescimo);
        out.writeObject(this.validade);
        out.writeObject(this.solicitante);
        out.writeObject(this.contato);
        out.writeObject(this.fone);
        out.writeObject(this.email);
        out.writeObject(this.foneContato);
        out.writeObject(this.proprietario);
        out.writeObject(this.paciente);
        out.writeObject(this.usuario);
        out.writeObject(this.usuarioAprovacao);
        out.writeObject(this.dataHoraAprovacao);
        out.writeObject(this.aprovadorPor);
        out.writeObject(this.utilizado);
        out.writeObject(this.convenios);
        out.writeObject(this.formaPagamento);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aprovadorPor == null ? 0 : this.aprovadorPor.hashCode());
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        result = 31 * result + (this.contato == null ? 0 : this.contato.hashCode());
        result = 31 * result + (this.dataHora == null ? 0 : this.dataHora.hashCode());
        result = 31 * result + (this.dataHoraAprovacao == null ? 0 : this.dataHoraAprovacao.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.filial == null ? 0 : this.filial.hashCode());
        result = 31 * result + (this.fone == null ? 0 : this.fone.hashCode());
        result = 31 * result + (this.foneContato == null ? 0 : this.foneContato.hashCode());
        result = 31 * result + (this.formaPagamento == null ? 0 : this.formaPagamento.hashCode());
        result = 31 * result + (this.observacao == null ? 0 : this.observacao.hashCode());
        result = 31 * result + (this.paciente == null ? 0 : this.paciente.hashCode());
        result = 31 * result + (this.percentualAcrescimo == null ? 0 : this.percentualAcrescimo.hashCode());
        result = 31 * result + (this.percentualDesconto == null ? 0 : this.percentualDesconto.hashCode());
        result = 31 * result + (this.proprietario == null ? 0 : this.proprietario.hashCode());
        result = 31 * result + (this.solicitante == null ? 0 : this.solicitante.hashCode());
        result = 31 * result + (this.usuario == null ? 0 : this.usuario.hashCode());
        result = 31 * result + (this.usuarioAprovacao == null ? 0 : this.usuarioAprovacao.hashCode());
        result = 31 * result + (this.utilizado ? 1231 : 1237);
        result = 31 * result + (this.validade == null ? 0 : this.validade.hashCode());
        result = 31 * result + (this.valorAcrescimo == null ? 0 : this.valorAcrescimo.hashCode());
        result = 31 * result + (this.valorDesconto == null ? 0 : this.valorDesconto.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrcamentoBean other = (OrcamentoBean)obj;
        if (this.aprovadorPor == null ? other.aprovadorPor != null : !this.aprovadorPor.equals(other.aprovadorPor)) {
            return false;
        }
        if (this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo)) {
            return false;
        }
        if (this.contato == null) {
            if (other.contato != null) {
                return false;
            }
        } else {
            if (!this.contato.equals(other.contato)) {
                return false;
            }
            if (this.convenios == null ? other.convenios != null : !this.convenios.containsAll(other.convenios)) {
                return false;
            }
        }
        if (this.dataHora == null ? other.dataHora != null : !this.dataHora.equals(other.dataHora)) {
            return false;
        }
        if (this.dataHoraAprovacao == null ? other.dataHoraAprovacao != null : !this.dataHoraAprovacao.equals(other.dataHoraAprovacao)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.filial == null ? other.filial != null : !this.filial.equals(other.filial)) {
            return false;
        }
        if (this.fone == null ? other.fone != null : !this.fone.equals(other.fone)) {
            return false;
        }
        if (this.foneContato == null ? other.foneContato != null : !this.foneContato.equals(other.foneContato)) {
            return false;
        }
        if (this.formaPagamento == null ? other.formaPagamento != null : !this.formaPagamento.equals(other.formaPagamento)) {
            return false;
        }
        if (this.observacao == null ? other.observacao != null : !this.observacao.equals(other.observacao)) {
            return false;
        }
        if (this.paciente == null ? other.paciente != null : !this.paciente.equals(other.paciente)) {
            return false;
        }
        if (this.percentualAcrescimo == null ? other.percentualAcrescimo != null : !this.percentualAcrescimo.equals(other.percentualAcrescimo)) {
            return false;
        }
        if (this.percentualDesconto == null ? other.percentualDesconto != null : !this.percentualDesconto.equals(other.percentualDesconto)) {
            return false;
        }
        if (this.proprietario == null ? other.proprietario != null : !this.proprietario.equals(other.proprietario)) {
            return false;
        }
        if (this.solicitante == null ? other.solicitante != null : !this.solicitante.equals(other.solicitante)) {
            return false;
        }
        if (this.usuario == null ? other.usuario != null : !this.usuario.equals(other.usuario)) {
            return false;
        }
        if (this.usuarioAprovacao == null ? other.usuarioAprovacao != null : !this.usuarioAprovacao.equals(other.usuarioAprovacao)) {
            return false;
        }
        if (this.utilizado != other.utilizado) {
            return false;
        }
        if (this.validade == null ? other.validade != null : !this.validade.equals(other.validade)) {
            return false;
        }
        if (this.valorAcrescimo == null ? other.valorAcrescimo != null : !this.valorAcrescimo.equals(other.valorAcrescimo)) {
            return false;
        }
        return !(this.valorDesconto == null ? other.valorDesconto != null : !this.valorDesconto.equals(other.valorDesconto));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public SituacaoVO getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoVO situacao) {
        this.situacao = situacao;
    }
}

