/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.financeiro;

import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.util.Funcoes;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@DataBaseTable(value="receberpagar")
public class ReceberPagarBean
extends AbstractThreadBean
implements BuscaBeanPreenchido,
Comparable {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="rpg_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="rpg_datahora")
    @FieldTimeStamp
    private Date dataHora;
    @DataBaseField(value="rpg_vencimento")
    @FieldDate
    private Date dataVencimento;
    @DataBaseField(value="rpg_valortotal")
    private Double valorTotal;
    @DataBaseField(value="rpg_valor")
    private Double valor;
    @DataBaseField(value="rpg_valormulta")
    private Double valorMulta;
    @DataBaseField(value="rpg_valorjuro")
    private Double valorJuro;
    @DataBaseField(value="rpg_valoracrescimo")
    private Double valorAcrescimo;
    @DataBaseField(value="rpg_percentualmulta")
    private Double percentualMulta;
    @DataBaseField(value="rpg_percentualjuro")
    private Double percentualJuro;
    @DataBaseField(value="rpg_percentualacrescimo")
    private Double percentualAcrescimo;
    @DataBaseField(value="rpg_tipojuros")
    private String tipoJuro;
    @DataBaseField(value="rpg_valordesconto")
    private Double valorDesconto;
    @DataBaseField(value="rpg_percentualdesconto")
    private Double percentualDesconto;
    @DataBaseField(value="rpg_tipo")
    private String tipo;
    @DataBaseField(value="rpg_tipodocumento")
    private String tipoDocumento;
    @DataBaseField(value="rpg_numerodocumento")
    private String numeroDocumento;
    @DataBaseField(value="rpg_taxa")
    private Double taxa;
    @DataBaseField(value="rpg_parcela")
    private Integer parcela;
    @DataBaseField(value="rpg_codigodocumento")
    private String codigoDocumento;
    @DataBaseField(value="rpg_datadocumento")
    @FieldDate
    private Date dataDocumento;
    @DataBaseField(value="rpg_dataprocessamento")
    @FieldDate
    private Date dataProcessamento;
    @DataBaseField(value="rpg_obs")
    private String observacao;
    @DataBaseField(value="ser_codigo")
    @DataBaseForeignKey
    private SeriesVO serie;
    @DataBaseField(value="rpg_tipocadastro")
    private String tipoCadastro;
    @DataBaseField(value="ent_codigo")
    @DataBaseForeignKey
    private EntidadeVO entidade;
    @DataBaseField(value="con_codigo")
    @DataBaseForeignKey
    private ConvenioVO convenio;
    @DataBaseField(value="pac_codigo")
    @DataBaseForeignKey
    private PacienteVO paciente;
    @DataBaseField(value="usr_codigo")
    @DataBaseForeignKey
    private UsuarioVO usuario;
    @DataBaseField(value="usr_codcancelado")
    @DataBaseForeignKey
    private UsuarioVO usuarioCancelado;
    @DataBaseField(value="nfi_codigo")
    @DataBaseForeignKey
    private NotaFiscalVO notaFiscal;
    @DataBaseField(value="rpg_situacao")
    private String situacao;
    @DataBaseField(value="rpg_datacancelado")
    @FieldTimeStamp
    private Date dataCancelado;
    @DataBaseField(value="rpg_irrfvalor")
    private Double irrfValor;
    @DataBaseField(value="rpg_irrfpercentual")
    private Double irrfPercentual;
    @DataBaseField(value="rpg_issvalor")
    private Double issValor;
    @DataBaseField(value="rpg_isspercentual")
    private Double issPercentual;
    @DataBaseField(value="rpg_pisvalor")
    private Double pisValor;
    @DataBaseField(value="rpg_pispercentual")
    private Double pisPercentual;
    @DataBaseField(value="rpg_csllvalor")
    private Double csllValor;
    @DataBaseField(value="rpg_csllpercentual")
    private Double csllPercentual;
    @DataBaseField(value="rpg_cofinsvalor")
    private Double cofinsValor;
    @DataBaseField(value="rpg_cofinspercentual")
    private Double cofinsPercentual;
    @DataBaseField(value="rpg_inssvalor")
    private Double inssValor;
    @DataBaseField(value="rpg_insspercentual")
    private Double inssPercentual;
    @DataBaseField(value="rpg_competencia")
    @FieldDate
    private Date dataCompetencia;
    @DataBaseField(value="usr_codprotestocobranca")
    @DataBaseForeignKey
    private UsuarioVO usuarioProtestoCobranca;
    @DataBaseField(value="usr_codcartoriocobranca")
    @DataBaseForeignKey
    private UsuarioVO usuarioCartorioCobranca;
    @DataBaseField(value="usr_codavisocobranca")
    @DataBaseForeignKey
    private UsuarioVO usuarioAvisoCobranca;
    @DataBaseField(value="rpg_dataavisocobranca")
    @FieldTimeStamp
    private Date dataAvisoCobranca;
    @DataBaseField(value="rpg_datacartoriocobranca")
    @FieldTimeStamp
    private Date dataCartorioCobranca;
    @DataBaseField(value="rpg_dataprotestocobranca")
    @FieldTimeStamp
    private Date dataProtestoCobranca;
    @DataBaseField(value="rpg_ipivalor")
    private Double valorIpi;
    @DataBaseField(value="rpg_ipipercentual")
    private Double percentualIpi;
    @DataBaseField(value="rpg_icmsvalor")
    private Double valorIcms;
    @DataBaseField(value="rpg_icmspercentual")
    private Double percentualIcms;
    @DataBaseField(value="rpg_valorfrete")
    private Double valorFrete;
    @DataBaseField(value="rpg_origem")
    private String origem = "M";
    @DataBaseField(value="usr_codcomissao")
    @DataBaseForeignKey
    private UsuarioVO usuarioComissao;
    @DataBaseField(value="rpg_datacomissao")
    @FieldTimeStamp
    private Date dataComissao;
    @DataBaseField(value="rpg_issretidopercentual")
    private Double issRetidoPercentual;
    @DataBaseField(value="rpg_issretidovalor")
    private Double issRetidoValor;
    @DataBaseField(value="rpg_inssretidopercentual")
    private Double inssRetidoPercentual;
    @DataBaseField(value="rpg_inssretidovalor")
    private Double inssRetidoValor;
    @DataBaseField(value="rpg_cofinsretidopercentual")
    private Double cofinsRetidoPercentual;
    @DataBaseField(value="rpg_cofinsretidovalor")
    private Double cofinsRetidoValor;
    @DataBaseField(value="rpg_csllretidopercentual")
    private Double csllRetidoPercentual;
    @DataBaseField(value="rpg_csllretidovalor")
    private Double csllRetidoValor;
    @DataBaseField(value="rpg_irrfretidopercentual")
    private Double irrfRetidoPercentual;
    @DataBaseField(value="rpg_irrfretidovalor")
    private Double irrfRetidoValor;
    @DataBaseField(value="rpg_pisretidopercentual")
    private Double pisRetidoPercentual;
    @DataBaseField(value="rpg_pisretidovalor")
    private Double pisRetidoValor;
    @FieldTransient
    private String razaoSocial;
    @FieldTransient
    private boolean remover;
    @FieldTransient
    private boolean inserir;
    @FieldTransient
    private boolean alterar;
    @FieldTransient
    protected Boolean usarValorMulta;
    @FieldTransient
    protected Set planosContas = new HashSet();
    @FieldTransient
    protected Set centrosCusto = new HashSet();
    @FieldTransient
    protected boolean planoContaErrado = false;
    @FieldTransient
    protected boolean centroCustoErrado = false;
    @FieldTransient
    protected boolean planoContaNaoConfigurado = false;
    @FieldTransient
    protected boolean centroCustoNaoConfigurado = false;

    public Double getIssRetidoPercentual() {
        return this.issRetidoPercentual;
    }

    public void setIssRetidoPercentual(Double issRetidoPercentual) {
        this.addCampoAlterado("issRetidoPercentual");
        this.issRetidoPercentual = issRetidoPercentual;
    }

    public Double getIssRetidoValor() {
        return this.issRetidoValor;
    }

    public void setIssRetidoValor(Double issRetidoValor) {
        this.addCampoAlterado("issRetidoValor");
        this.issRetidoValor = issRetidoValor;
    }

    public Double getInssRetidoPercentual() {
        return this.inssRetidoPercentual;
    }

    public void setInssRetidoPercentual(Double inssRetidoPercentual) {
        this.addCampoAlterado("inssRetidoPercentual");
        this.inssRetidoPercentual = inssRetidoPercentual;
    }

    public Double getInssRetidoValor() {
        return this.inssRetidoValor;
    }

    public void setInssRetidoValor(Double inssRetidoValor) {
        this.addCampoAlterado("inssRetidoValor");
        this.inssRetidoValor = inssRetidoValor;
    }

    public Double getCofinsRetidoPercentual() {
        return this.cofinsRetidoPercentual;
    }

    public void setCofinsRetidoPercentual(Double cofinsRetidoPercentual) {
        this.addCampoAlterado("cofinsRetidoPercentual");
        this.cofinsRetidoPercentual = cofinsRetidoPercentual;
    }

    public Double getCofinsRetidoValor() {
        return this.cofinsRetidoValor;
    }

    public void setCofinsRetidoValor(Double cofinsRetidoValor) {
        this.addCampoAlterado("cofinsRetidoValor");
        this.cofinsRetidoValor = cofinsRetidoValor;
    }

    public Double getCsllRetidoPercentual() {
        return this.csllRetidoPercentual;
    }

    public void setCsllRetidoPercentual(Double csllRetidoPercentual) {
        this.addCampoAlterado("csllRetidoPercentual");
        this.csllRetidoPercentual = csllRetidoPercentual;
    }

    public Double getCsllRetidoValor() {
        return this.csllRetidoValor;
    }

    public void setCsllRetidoValor(Double csllRetidoValor) {
        this.addCampoAlterado("csllRetidoValor");
        this.csllRetidoValor = csllRetidoValor;
    }

    public Double getIrrfRetidoPercentual() {
        return this.irrfRetidoPercentual;
    }

    public void setIrrfRetidoPercentual(Double irrfRetidoPercentual) {
        this.addCampoAlterado("irrfRetidoPercentual");
        this.irrfRetidoPercentual = irrfRetidoPercentual;
    }

    public Double getIrrfRetidoValor() {
        return this.irrfRetidoValor;
    }

    public void setIrrfRetidoValor(Double irrfRetidoValor) {
        this.addCampoAlterado("irrfRetidoValor");
        this.irrfRetidoValor = irrfRetidoValor;
    }

    public Double getPisRetidoPercentual() {
        return this.pisRetidoPercentual;
    }

    public void setPisRetidoPercentual(Double pisRetidoPercentual) {
        this.addCampoAlterado("pisRetidoPercentual");
        this.pisRetidoPercentual = pisRetidoPercentual;
    }

    public Double getPisRetidoValor() {
        return this.pisRetidoValor;
    }

    public void setPisRetidoValor(Double pisRetidoValor) {
        this.addCampoAlterado("pisRetidoValor");
        this.pisRetidoValor = pisRetidoValor;
    }

    public UsuarioVO getUsuarioComissao() {
        return this.usuarioComissao;
    }

    public void setUsuarioComissao(UsuarioVO usuarioComissao) {
        this.usuarioComissao = usuarioComissao;
        this.addCampoAlterado("usuarioComissao");
    }

    public Date getDataComissao() {
        return this.dataComissao;
    }

    public void setDataComissao(Date dataComissao) {
        this.dataComissao = dataComissao;
        this.addCampoAlterado("dataComissao");
    }

    public String getOrigem() {
        return this.origem == null ? "M" : this.origem;
    }

    public void setOrigem(String origem) {
        this.origem = origem;
        this.addCampoAlterado("origem");
    }

    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
        this.addCampoAlterado("valorFrete");
    }

    public Double getPercentualIcms() {
        return this.percentualIcms;
    }

    public void setPercentualIcms(Double percentualIcms) {
        this.percentualIcms = percentualIcms;
        this.addCampoAlterado("percentualIcms");
    }

    public Double getValorIpi() {
        return this.valorIpi;
    }

    public void setValorIpi(Double valorIpi) {
        this.valorIpi = valorIpi;
        this.addCampoAlterado("valorIpi");
    }

    public Double getPercentualIpi() {
        return this.percentualIpi;
    }

    public void setPercentualIpi(Double percentualIpi) {
        this.percentualIpi = percentualIpi;
        this.addCampoAlterado("percentualIpi");
    }

    public Double getValorIcms() {
        return this.valorIcms;
    }

    public void setValorIcms(Double valorIcms) {
        this.valorIcms = valorIcms;
        this.addCampoAlterado("valorIcms");
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public boolean isRemover() {
        return this.remover;
    }

    public void setRemover(boolean remover) {
        this.remover = remover;
    }

    public boolean isInserir() {
        return this.inserir;
    }

    public void setInserir(boolean inserir) {
        this.inserir = inserir;
    }

    public boolean isAlterar() {
        return this.alterar;
    }

    public void setAlterar(boolean alterar) {
        this.alterar = alterar;
    }

    @Override
    public AbstractThreadBean toVO() {
        ReceberPagarVO vo = new ReceberPagarVO();
        vo.setFilial(this.getFilial());
        vo.setCodigo(this.getCodigo());
        vo.setDataHora(this.getDataHora());
        vo.setValor(this.getValor());
        vo.setValorTotal(this.getValorTotal());
        vo.setVencimento(this.getDataVencimento());
        vo.setNumeroDocumento(this.getNumeroDocumento());
        vo.setSituacao(this.situacao);
        return vo;
    }

    public Double getTaxa() {
        return this.taxa;
    }

    public void setTaxa(Double taxa) {
        this.taxa = taxa;
        this.addCampoAlterado("taxa");
    }

    public Integer getParcela() {
        return this.parcela;
    }

    public void setParcela(Integer parcela) {
        this.parcela = parcela;
        this.addCampoAlterado("parcela");
    }

    public String getCodigoDocumento() {
        return this.codigoDocumento;
    }

    public void setCodigoDocumento(String codigoDocumento) {
        this.codigoDocumento = codigoDocumento;
        this.addCampoAlterado("codigoDocumento");
    }

    public Date getDataDocumento() {
        return this.dataDocumento;
    }

    public void setDataDocumento(Date dataDocumento) {
        this.dataDocumento = dataDocumento;
        this.addCampoAlterado("dataDocumento");
    }

    public Date getDataProcessamento() {
        return this.dataProcessamento;
    }

    public void setDataProcessamento(Date dataProcessamento) {
        this.dataProcessamento = dataProcessamento;
        this.addCampoAlterado("dataProcessamento");
    }

    public SeriesVO getSerie() {
        return this.serie;
    }

    public void setSerie(SeriesVO serie) {
        this.serie = serie;
        this.addCampoAlterado("serie");
    }

    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
        this.addCampoAlterado("tipoCadastro");
    }

    public EntidadeVO getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeVO entidade) {
        this.entidade = entidade;
        if (entidade != null && !Funcoes.textoVazio(entidade.getRazaoSocial())) {
            this.setRazaoSocial(entidade.getRazaoSocial());
        }
        this.addCampoAlterado("entidade");
    }

    public ConvenioVO getConvenio() {
        return this.convenio;
    }

    public void setConvenio(ConvenioVO convenio) {
        this.convenio = convenio;
        if (convenio != null && !Funcoes.textoVazio(convenio.getFantasia())) {
            this.setRazaoSocial(convenio.getFantasia());
        }
        this.addCampoAlterado("convenio");
    }

    public PacienteVO getPaciente() {
        return this.paciente;
    }

    public void setPaciente(PacienteVO paciente) {
        this.paciente = paciente;
        if (paciente != null && !Funcoes.textoVazio(paciente.getNome())) {
            this.setRazaoSocial(paciente.getNome());
        }
        this.addCampoAlterado("paciente");
    }

    public Double getIrrfValor() {
        return this.irrfValor;
    }

    public void setIrrfValor(Double irrfValor) {
        this.irrfValor = irrfValor;
        this.addCampoAlterado("irrfValor");
    }

    public Double getIrrfPercentual() {
        return this.irrfPercentual;
    }

    public void setIrrfPercentual(Double irrfPercentual) {
        this.irrfPercentual = irrfPercentual;
        this.addCampoAlterado("irrfPercentual");
    }

    public Double getIssValor() {
        return this.issValor;
    }

    public void setIssValor(Double issValor) {
        this.issValor = issValor;
        this.addCampoAlterado("issValor");
    }

    public Double getIssPercentual() {
        return this.issPercentual;
    }

    public void setIssPercentual(Double issPercentual) {
        this.issPercentual = issPercentual;
        this.addCampoAlterado("issPercentual");
    }

    public Double getPisValor() {
        return this.pisValor;
    }

    public void setPisValor(Double pisValor) {
        this.pisValor = pisValor;
        this.addCampoAlterado("pisValor");
    }

    public Double getPisPercentual() {
        return this.pisPercentual;
    }

    public void setPisPercentual(Double pisPercentual) {
        this.pisPercentual = pisPercentual;
        this.addCampoAlterado("pisPercentual");
    }

    public Double getCsllValor() {
        return this.csllValor;
    }

    public void setCsllValor(Double csllValor) {
        this.csllValor = csllValor;
        this.addCampoAlterado("csllValor");
    }

    public Double getCsllPercentual() {
        return this.csllPercentual;
    }

    public void setCsllPercentual(Double csllPercentual) {
        this.csllPercentual = csllPercentual;
        this.addCampoAlterado("csllPercentual");
    }

    public Double getCofinsValor() {
        return this.cofinsValor;
    }

    public void setCofinsValor(Double cofinsValor) {
        this.cofinsValor = cofinsValor;
        this.addCampoAlterado("cofinsValor");
    }

    public Double getCofinsPercentual() {
        return this.cofinsPercentual;
    }

    public void setCofinsPercentual(Double cofinsPercentual) {
        this.cofinsPercentual = cofinsPercentual;
        this.addCampoAlterado("cofinsPercentual");
    }

    public Double getInssValor() {
        return this.inssValor;
    }

    public void setInssValor(Double inssValor) {
        this.inssValor = inssValor;
        this.addCampoAlterado("inssValor");
    }

    public Double getInssPercentual() {
        return this.inssPercentual;
    }

    public void setInssPercentual(Double inssPercentual) {
        this.inssPercentual = inssPercentual;
        this.addCampoAlterado("inssPercentual");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReceberPagarBean)) {
            return false;
        }
        ReceberPagarBean rec = (ReceberPagarBean)o;
        if (rec.getFilial().getCodigo() != null && this.getFilial().getCodigo() != null && rec.getCodigo() != null && this.getCodigo() != null) {
            return rec.getFilial().getCodigo().intValue() == this.getFilial().getCodigo().intValue() && rec.getCodigo().intValue() == this.getCodigo().intValue();
        }
        return super.equals(rec);
    }

    public NotaFiscalVO getNotaFiscal() {
        return this.notaFiscal;
    }

    public void setNotaFiscal(NotaFiscalVO notaFiscal) {
        this.notaFiscal = notaFiscal;
        this.addCampoAlterado("notaFiscal");
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getCodigo()).append(" - ");
        if (this.getConvenio() != null) {
            str.append(this.getConvenio().getFantasia());
        } else if (this.getPaciente() != null) {
            str.append(this.getPaciente().getNome());
        } else if (this.getEntidade() != null) {
            str.append(this.getEntidade().getRazaoSocial());
        }
        str.append(" - ").append(this.getNumeroDocumento()).append(" - ");
        str.append(Funcoes.formataData("dd/MM/yyyy", this.getDataVencimento())).append(" - ");
        str.append("Valor: ").append(Funcoes.formataDecimal(this.getValor())).append(" - ");
        str.append("Total: ").append(this.getValorTotal() == null ? "" : Funcoes.formataDecimal(this.getValorTotal()));
        return str.toString();
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    @Override
    public AbstractThreadBean clonar() {
        ReceberPagarBean clone = (ReceberPagarBean)super.clonar();
        HashSet<ReceberPagarPlanoContaBean> planosContas = new HashSet<ReceberPagarPlanoContaBean>();
        HashSet<ReceberPagarCentroCustoBean> centrosCusto = new HashSet<ReceberPagarCentroCustoBean>();
        Iterator it = clone.getPlanosContas().iterator();
        while (it.hasNext()) {
            ReceberPagarPlanoContaBean plano = (ReceberPagarPlanoContaBean)((ReceberPagarPlanoContaBean)it.next()).clonar();
            plano.setInserir(true);
            planosContas.add(plano);
        }
        Iterator itC = clone.getCentrosCusto().iterator();
        while (itC.hasNext()) {
            ReceberPagarCentroCustoBean centro = (ReceberPagarCentroCustoBean)((ReceberPagarCentroCustoBean)itC.next()).clonar();
            centro.setInserir(true);
            centrosCusto.add(centro);
        }
        clone.setNotaFiscal(this.notaFiscal);
        clone.setPlanosContas(planosContas);
        clone.setCentrosCusto(centrosCusto);
        return clone;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
        this.addCampoAlterado("tipo");
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
        this.addCampoAlterado("dataHora");
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
        this.addCampoAlterado("valor");
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
        this.addCampoAlterado("numeroDocumento");
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
        this.addCampoAlterado("observacao");
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
        this.addCampoAlterado("tipoDocumento");
    }

    public UsuarioVO getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioVO usuario) {
        this.usuario = usuario;
        this.addCampoAlterado("usuario");
    }

    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
        this.addCampoAlterado("dataVencimento");
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
        this.addCampoAlterado("situacao");
    }

    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
        this.addCampoAlterado("dataCompetencia");
    }

    public UsuarioVO getUsuarioCancelado() {
        return this.usuarioCancelado;
    }

    public void setUsuarioCancelado(UsuarioVO usuarioCancelado) {
        this.usuarioCancelado = usuarioCancelado;
        this.addCampoAlterado("usuarioCancelado");
    }

    public Date getDataCancelado() {
        return this.dataCancelado;
    }

    public void setDataCancelado(Date dataCancelado) {
        this.dataCancelado = dataCancelado;
        this.addCampoAlterado("dataCancelado");
    }

    public Set getPlanosContas() {
        return this.planosContas;
    }

    public void setPlanosContas(Set planosContas) {
        this.planosContas = planosContas;
        this.addCampoAlterado("planosContas");
    }

    public void addPlanoConta(LancamentoPlanoContaBean planoConta) {
        this.planosContas.add(planoConta);
    }

    public void removePlanoConta(LancamentoPlanoContaBean planoConta) {
        this.planosContas.remove(planoConta);
    }

    public Double getValorMulta() {
        return this.valorMulta;
    }

    public void setValorMulta(Double valorMulta) {
        this.valorMulta = valorMulta;
        this.addCampoAlterado("valorMulta");
    }

    public Double getValorJuro() {
        return this.valorJuro;
    }

    public void setValorJuro(Double valorJuro) {
        this.valorJuro = valorJuro;
        this.addCampoAlterado("valorJuro");
    }

    public Double getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    public void setValorAcrescimo(Double valorAcrescimo) {
        this.valorAcrescimo = valorAcrescimo;
        this.addCampoAlterado("valorAcrescimo");
    }

    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
        this.addCampoAlterado("valorDesconto");
    }

    public Double getPercentualMulta() {
        return this.percentualMulta;
    }

    public void setPercentualMulta(Double percentualMulta) {
        this.percentualMulta = percentualMulta;
        this.addCampoAlterado("percentualMulta");
    }

    public Double getPercentualJuro() {
        return this.percentualJuro;
    }

    public void setPercentualJuro(Double percentualJuro) {
        this.percentualJuro = percentualJuro;
        this.addCampoAlterado("percentualJuro");
    }

    public Double getPercentualAcrescimo() {
        return this.percentualAcrescimo;
    }

    public void setPercentualAcrescimo(Double percentualAcrescimo) {
        this.percentualAcrescimo = percentualAcrescimo;
        this.addCampoAlterado("percentualAcrescimo");
    }

    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
        this.addCampoAlterado("percentualDesconto");
    }

    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
        this.addCampoAlterado("valorTotal");
    }

    public String getTipoJuro() {
        return this.tipoJuro;
    }

    public void setTipoJuro(String tipoJuro) {
        this.tipoJuro = tipoJuro;
        this.addCampoAlterado("tipoJuro");
    }

    public Set getCentrosCusto() {
        return this.centrosCusto;
    }

    public void setCentrosCusto(Set centrosCusto) {
        this.centrosCusto = centrosCusto;
        this.addCampoAlterado("centrosCusto");
    }

    public void addCentroCusto(ReceberPagarCentroCustoBean centroCusto) {
        this.centrosCusto.add(centroCusto);
    }

    public void removeCentroCusto(ReceberPagarCentroCustoBean centroCusto) {
        this.centrosCusto.remove(centroCusto);
    }

    public void setUsarValorMulta(Boolean usarValorMulta) {
        this.usarValorMulta = usarValorMulta;
    }

    public Boolean getUsarValorMulta() {
        return this.usarValorMulta;
    }

    public void setPlanoContaErrado(boolean planoContaErrado) {
        this.planoContaErrado = planoContaErrado;
    }

    public boolean isPlanoContaErrado() {
        return this.planoContaErrado;
    }

    public void setCentroCustoErrado(boolean centroCustoErrado) {
        this.centroCustoErrado = centroCustoErrado;
    }

    public boolean isCentroCustoErrado() {
        return this.centroCustoErrado;
    }

    public void setCentroCustoNaoConfigurado(boolean centroCustoNaoConfigurado) {
        this.centroCustoNaoConfigurado = centroCustoNaoConfigurado;
    }

    public boolean isCentroCustoNaoConfigurado() {
        return this.centroCustoNaoConfigurado;
    }

    public void setPlanoContaNaoConfigurado(boolean planoContaNaoConfigurado) {
        this.planoContaNaoConfigurado = planoContaNaoConfigurado;
    }

    public boolean isPlanoContaNaoConfigurado() {
        return this.planoContaNaoConfigurado;
    }

    public void addPlanoConta(ReceberPagarPlanoContaBean planoConta) {
        this.planosContas.add(planoConta);
    }

    public void removePlanoConta(ReceberPagarPlanoContaBean planoConta) {
        this.planosContas.remove(planoConta);
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this;
    }

    public void setUsuarioProtestoCobranca(UsuarioVO usuarioProtestoCobranca) {
        this.usuarioProtestoCobranca = usuarioProtestoCobranca;
        this.addCampoAlterado("usuarioProtestoCobranca");
    }

    public UsuarioVO getUsuarioProtestoCobranca() {
        return this.usuarioProtestoCobranca;
    }

    public void setUsuarioCartorioCobranca(UsuarioVO usuarioCartorioCobranca) {
        this.usuarioCartorioCobranca = usuarioCartorioCobranca;
        this.addCampoAlterado("usuarioCartorioCobranca");
    }

    public UsuarioVO getUsuarioCartorioCobranca() {
        return this.usuarioCartorioCobranca;
    }

    public void setUsuarioAvisoCobranca(UsuarioVO usuarioAvisoCobranca) {
        this.usuarioAvisoCobranca = usuarioAvisoCobranca;
        this.addCampoAlterado("usuarioAvisoCobranca");
    }

    public UsuarioVO getUsuarioAvisoCobranca() {
        return this.usuarioAvisoCobranca;
    }

    public void setDataAvisoCobranca(Date dataAvisoCobranca) {
        this.dataAvisoCobranca = dataAvisoCobranca;
        this.addCampoAlterado("dataAvisoCobranca");
    }

    public Date getDataAvisoCobranca() {
        return this.dataAvisoCobranca;
    }

    public void setDataCartorioCobranca(Date dataCartorioCobranca) {
        this.dataCartorioCobranca = dataCartorioCobranca;
        this.addCampoAlterado("dataCartorioCobranca");
    }

    public Date getDataCartorioCobranca() {
        return this.dataCartorioCobranca;
    }

    public void setDataProtestoCobranca(Date dataProtestoCobranca) {
        this.dataProtestoCobranca = dataProtestoCobranca;
        this.addCampoAlterado("dataProtestoCobranca");
    }

    public Date getDataProtestoCobranca() {
        return this.dataProtestoCobranca;
    }

    public boolean verificaCamposAlterados(ReceberPagarBean verificador, String filial) {
        try {
            Field[] camposOrigem;
            for (Field fOrigem : camposOrigem = this.getClass().getDeclaredFields()) {
                if (fOrigem.get(this) == null && fOrigem.get(verificador) == null) continue;
                if (fOrigem.get(this) == null && fOrigem.get(verificador) != null || fOrigem.get(this) != null && fOrigem.get(verificador) == null) {
                    return true;
                }
                if (!(fOrigem.isAnnotationPresent(DataBaseForeignKey.class) || fOrigem.get(this) instanceof HashSet ? !fOrigem.get(this).toString().equalsIgnoreCase(fOrigem.get(verificador).toString()) : !fOrigem.get(this).equals(fOrigem.get(verificador)) && !fOrigem.getName().equalsIgnoreCase("planoContaNaoConfigurado") && !fOrigem.getName().equalsIgnoreCase("centroCustoNaoConfigurado") && !fOrigem.getName().equalsIgnoreCase("inserir"))) continue;
                return true;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public int compareTo(Object o) {
        if (!(o instanceof ReceberPagarBean)) {
            return 0;
        }
        if (((ReceberPagarBean)o).getParcela() > this.getParcela()) {
            return -1;
        }
        if (((ReceberPagarBean)o).getParcela() < this.getParcela()) {
            return 1;
        }
        return 0;
    }
}

