/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.financeiro;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.financeiro.faturamento.integracao.DadosEspeciaisNFSe;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBaseMultipleKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.estoque.CfopVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

@DataBaseTable(value="notafiscal")
public class NotaFiscalBean
extends AbstractThreadBean
implements DadosEspeciaisNFSe {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="ser_codigo")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private SeriesVO serie;
    @DataBaseField(value="usr_codigo")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private UsuarioVO usuario;
    @DataBaseField(value="usr_codimpressao")
    @DataBaseForeignKey
    private UsuarioVO usuarioImpressao;
    @DataBaseField(value="usr_codcancelada")
    @DataBaseForeignKey
    private UsuarioVO usuarioCancelada;
    @DataBaseField(value="ent_codigo")
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private EntidadeVO entidade;
    @DataBaseField(value="pac_codigo")
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private PacienteVO paciente;
    @DataBaseField(value="con_codigo")
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private ConvenioVO convenio;
    @DataBaseField(value="fpg_codigo")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private FormaPagamentoVO formaPagamento;
    @DataBaseField(value="nfi_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="nfi_tipocadastro")
    @DataBaseFieldNotNull
    private String tipoCadastro;
    @DataBaseField(value="nfi_datahora")
    @FieldTimeStamp
    private Date dataHora;
    @DataBaseField(value="nfi_dataemissao")
    @FieldDate
    private Date dataEmissao;
    @DataBaseField(value="nfi_numero")
    @DataBaseFieldNotNull
    private Long numero;
    @DataBaseField(value="nfi_situacao")
    private String situacao;
    @DataBaseField(value="nfi_datahoraimpressao")
    @FieldTimeStamp
    private Date dataHoraImpressao;
    @DataBaseField(value="nfi_datahoracancelada")
    @FieldTimeStamp
    private Date dataHoraCancelada;
    @DataBaseField(value="nfi_observacao")
    private String observacao;
    @DataBaseField(value="nfi_valortotal")
    private Double valor;
    @DataBaseField(value="nfi_subtotal")
    private Double subTotal;
    @DataBaseField(value="nfi_tipo")
    private String tipo;
    @DataBaseField(value="nfi_irrfvalor")
    private Double irrfValor;
    @DataBaseField(value="nfi_irrfpercentual")
    private Double irrfPercentual;
    @DataBaseField(value="nfi_issvalor")
    private Double issValor;
    @DataBaseField(value="nfi_isspercentual")
    private Double issPercentual;
    @DataBaseField(value="nfi_pisvalor")
    private Double pisValor;
    @DataBaseField(value="nfi_pispercentual")
    private Double pisPercentual;
    @DataBaseField(value="nfi_csllvalor")
    private Double csllValor;
    @DataBaseField(value="nfi_csllpercentual")
    private Double csllPercentual;
    @DataBaseField(value="nfi_cofinsvalor")
    private Double cofinsValor;
    @DataBaseField(value="nfi_cofinspercentual")
    private Double cofinsPercentual;
    @DataBaseField(value="nfi_inssvalor")
    private Double inssValor;
    @DataBaseField(value="nfi_insspercentual")
    private Double inssPercentual;
    @DataBaseField(value="nfi_insspercentualoriginal")
    private Double inssPercentualOriginal;
    @DataBaseField(value="nfi_irrfpercentualoriginal")
    private Double irrfPercentualOriginal;
    @DataBaseField(value="nfi_csllpercentualoriginal")
    private Double csllPercentualOriginal;
    @DataBaseField(value="nfi_cofinspercentualoriginal")
    private Double cofinsPercentualOriginal;
    @DataBaseField(value="nfi_isspercentualoriginal")
    private Double issPercentualOriginal;
    @DataBaseField(value="nfi_pispercentualoriginal")
    private Double pisPercentualOriginal;
    @DataBaseField(value="nfi_impostoacumulado")
    private Double impostoAcumulado = 0.0;
    @DataBaseField(value="nfi_descricaocancelamento")
    private String descricaoCancelamento;
    @DataBaseField(value="mov_codigo")
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private MotivoCancelamentoVO motivoCancelamento;
    @DataBaseField(value="nfi_ipivalor")
    private Double valorIpi;
    @DataBaseField(value="nfi_ipipercentual")
    private Double percentualIpi;
    @DataBaseField(value="nfi_icmsvalor")
    private Double valorIcms;
    @DataBaseField(value="nfi_icmspercentual")
    private Double percentualIcms;
    @DataBaseField(value="cfo_codigo")
    @DataBaseForeignKey
    private CfopVO cfop;
    @DataBaseField(value="ped_codigo")
    @DataBaseForeignKey
    @DataBaseMultipleKey
    private PedidoVO pedido;
    @DataBaseField(value="usr_codautorizafinanceira")
    @DataBaseForeignKey
    private UsuarioVO usuarioAutorizacaoFinanceira;
    @DataBaseField(value="nfi_dataautorizafinanceira")
    @FieldTimeStamp
    private Date dataHoraAutorizacaoFinanceira;
    @DataBaseField(value="nfi_percentualdesconto")
    private Double percentualDescontoIncondicionado;
    @DataBaseField(value="nfi_valordesconto")
    private Double valorDescontoIncondicionado;
    @DataBaseField(value="nfi_valorfrete")
    private Double valorFrete;
    @DataBaseField(value="nfi_pdfrps")
    private Long pdfRps;
    @DataBaseField(value="nfi_xmlnfse")
    private Long xmlNfse;
    @FieldTransient
    private NotaFiscalServicoBean servico;
    @FieldTransient
    private Set parcelas;
    @FieldTransient
    private Set<FaturaNotaFiscalBean> faturasNotaFiscal;
    @FieldTransient
    private Set lancamentosRequisicao;
    @DataBaseField(value="nfi_nomepagador")
    private String nomePagador;
    @DataBaseField(value="nfi_cpfpagador")
    private String cpfPagador;
    @DataBaseField(value="nfi_issretidopercentual")
    private Double percentualISSRetido;
    @DataBaseField(value="nfi_issretidovalor")
    private Double valorISSRetido;
    @DataBaseField(value="nfi_issretidopercentualoriginal")
    private Double percentualIssRetidoOriginal;
    @DataBaseField(value="nfi_inssretidopercentual")
    private Double percentualInssRetido;
    @DataBaseField(value="nfi_inssretidovalor")
    private Double valorInssRetido;
    @DataBaseField(value="nfi_inssretidopercentualoriginal")
    private Double percentualInssRetidoOriginal;
    @DataBaseField(value="nfi_cofinsretidopercentual")
    private Double percentualCofinsRetido;
    @DataBaseField(value="nfi_cofinsretidovalor")
    private Double valorCofinsRetido;
    @DataBaseField(value="nfi_cofinsretidopercentualoriginal")
    private Double percentualCofinsRetidoOriginal;
    @DataBaseField(value="nfi_csllretidopercentual")
    private Double percentualCsllRetido;
    @DataBaseField(value="nfi_csllretidovalor")
    private Double valorCsllRetido;
    @DataBaseField(value="nfi_csllretidopercentualoriginal")
    private Double percentualCsllRetidoOriginal;
    @DataBaseField(value="nfi_irrfretidopercentual")
    private Double percentualIrrfRetido;
    @DataBaseField(value="nfi_irrfretidovalor")
    private Double valorIrrfRetido;
    @DataBaseField(value="nfi_irrfretidopercentualoriginal")
    private Double percentualIrrfRetidoOriginal;
    @DataBaseField(value="nfi_pisretidopercentual")
    private Double percentualPisRetido;
    @DataBaseField(value="nfi_pisretidovalor")
    private Double valorPisRetido;
    @DataBaseField(value="nfi_pisretidopercentualoriginal")
    private Double percentualPisRetidoOriginal;
    @DataBaseField(value="nfi_numerorps")
    private Long numeroRps;
    @DataBaseField(value="nfi_notaenviada")
    private Boolean notaEnviada;
    @DataBaseField(value="nfi_statusnfse")
    private String statusNfse;
    @DataBaseField(value="nfi_motivonfse")
    private String motivoNfse;
    @DataBaseField(value="nfi_datastatusnfse")
    @FieldTimeStamp
    private Date dataStatusNfse;
    @DataBaseField(value="nfi_protocolonfse")
    private String protocoloNfse;
    @DataBaseField(value="nfi_chaverpsnfse")
    private String chaveRpsNfse;
    @DataBaseField(value="nfi_chavenfse")
    private String chaveNfse;
    @DataBaseField(value="nfi_pesquisafornecedor")
    private String pesquisaFornecedor;
    @FieldTransient
    ArrayList<NotaFiscalMaterialBean> materiais;
    @FieldTransient
    ArrayList<MaterialBean> materiaisAlterados;
    @FieldTransient
    private Boolean serieAlterada = Boolean.FALSE;
    @FieldTransient
    private Long rpsDaSerieAlterada;

    public String getPesquisaFornecedor() {
        return this.pesquisaFornecedor;
    }

    public void setPesquisaFornecedor(String pesquisaFornecedor) {
        this.pesquisaFornecedor = pesquisaFornecedor;
    }

    public ArrayList<MaterialBean> getMateriaisAlterados() {
        return this.materiaisAlterados;
    }

    public void setMateriaisAlterados(ArrayList<MaterialBean> materiaisAlterados) {
        this.materiaisAlterados = materiaisAlterados;
    }

    public Boolean getNotaEnviada() {
        return this.notaEnviada;
    }

    public void setNotaEnviada(Boolean notaEnviada) {
        this.notaEnviada = notaEnviada;
        this.addCampoAlterado("notaEnviada");
    }

    public String getStatusNfse() {
        return this.statusNfse;
    }

    public void setStatusNfse(String statusNfse) {
        this.statusNfse = statusNfse;
        this.addCampoAlterado("statusNfse");
    }

    public String getMotivoNfse() {
        return this.motivoNfse;
    }

    public void setMotivoNfse(String motivoNfse) {
        this.motivoNfse = motivoNfse;
        this.addCampoAlterado("motivoNfse");
    }

    public Date getDataStatusNfse() {
        return this.dataStatusNfse;
    }

    public void setDataStatusNfse(Date dataStatusNfse) {
        this.dataStatusNfse = dataStatusNfse;
        this.addCampoAlterado("dataStatusNfse");
    }

    public String getProtocoloNfse() {
        return this.protocoloNfse;
    }

    public void setProtocoloNfse(String protocoloNfse) {
        this.protocoloNfse = protocoloNfse;
        this.addCampoAlterado("protocoloNfse");
    }

    public String getChaveRpsNfse() {
        return this.chaveRpsNfse;
    }

    public void setChaveRpsNfse(String chaveRpsNfse) {
        this.chaveRpsNfse = chaveRpsNfse;
        this.addCampoAlterado("chaveRpsNfse");
    }

    public String getChaveNfse() {
        return this.chaveNfse;
    }

    public void setChaveNfse(String chaveNfse) {
        this.chaveNfse = chaveNfse;
        this.addCampoAlterado("chaveNfse");
    }

    public void setFaturasNotaFiscal(Set<FaturaNotaFiscalBean> faturasNotaFiscal) {
        this.faturasNotaFiscal = faturasNotaFiscal;
    }

    public Double getPercentualISSRetido() {
        return this.percentualISSRetido;
    }

    public void setPercentualISSRetido(Double percentualISSRetido) {
        this.addCampoAlterado("percentualISSRetido");
        this.percentualISSRetido = percentualISSRetido;
    }

    public Double getValorISSRetido() {
        return this.valorISSRetido;
    }

    public void setValorISSRetido(Double valorISSRetido) {
        this.addCampoAlterado("valorISSRetido");
        this.valorISSRetido = valorISSRetido;
    }

    public Double getPercentualIssRetidoOriginal() {
        return this.percentualIssRetidoOriginal;
    }

    public void setPercentualIssRetidoOriginal(Double percentualIssRetidoOriginal) {
        this.addCampoAlterado("percentualIssRetidoOriginal");
        this.percentualIssRetidoOriginal = percentualIssRetidoOriginal;
    }

    public Double getPercentualInssRetido() {
        return this.percentualInssRetido;
    }

    public void setPercentualInssRetido(Double percentualInssRetido) {
        this.addCampoAlterado("percentualInssRetido");
        this.percentualInssRetido = percentualInssRetido;
    }

    public Double getValorInssRetido() {
        return this.valorInssRetido;
    }

    public void setValorInssRetido(Double valorInssRetido) {
        this.addCampoAlterado("valorInssRetido");
        this.valorInssRetido = valorInssRetido;
    }

    public Double getPercentualInssRetidoOriginal() {
        return this.percentualInssRetidoOriginal;
    }

    public void setPercentualInssRetidoOriginal(Double percentualInssRetidoOriginal) {
        this.addCampoAlterado("percentualInssRetidoOriginal");
        this.percentualInssRetidoOriginal = percentualInssRetidoOriginal;
    }

    public Double getPercentualCofinsRetido() {
        return this.percentualCofinsRetido;
    }

    public void setPercentualCofinsRetido(Double percentualCofinsRetido) {
        this.addCampoAlterado("percentualCofinsRetido");
        this.percentualCofinsRetido = percentualCofinsRetido;
    }

    public Double getValorCofinsRetido() {
        return this.valorCofinsRetido;
    }

    public void setValorCofinsRetido(Double valorCofinsRetido) {
        this.addCampoAlterado("valorCofinsRetido");
        this.valorCofinsRetido = valorCofinsRetido;
    }

    public Double getPercentualCofinsRetidoOriginal() {
        return this.percentualCofinsRetidoOriginal;
    }

    public void setPercentualCofinsRetidoOriginal(Double percentualCofinsRetidoOriginal) {
        this.addCampoAlterado("percentualCofinsRetidoOriginal");
        this.percentualCofinsRetidoOriginal = percentualCofinsRetidoOriginal;
    }

    public Double getPercentualCsllRetido() {
        return this.percentualCsllRetido;
    }

    public void setPercentualCsllRetido(Double percentualCsllRetido) {
        this.addCampoAlterado("percentualCsllRetido");
        this.percentualCsllRetido = percentualCsllRetido;
    }

    public Double getValorCsllRetido() {
        return this.valorCsllRetido;
    }

    public void setValorCsllRetido(Double valorCsllRetido) {
        this.addCampoAlterado("valorCsllRetido");
        this.valorCsllRetido = valorCsllRetido;
    }

    public Double getPercentualCsllRetidoOriginal() {
        return this.percentualCsllRetidoOriginal;
    }

    public void setPercentualCsllRetidoOriginal(Double percentualCsllRetidoOriginal) {
        this.addCampoAlterado("percentualCsllRetidoOriginal");
        this.percentualCsllRetidoOriginal = percentualCsllRetidoOriginal;
    }

    public Double getPercentualIrrfRetido() {
        return this.percentualIrrfRetido;
    }

    public void setPercentualIrrfRetido(Double percentualIrrfRetido) {
        this.addCampoAlterado("percentualIrrfRetido");
        this.percentualIrrfRetido = percentualIrrfRetido;
    }

    public Double getValorIrrfRetido() {
        return this.valorIrrfRetido;
    }

    public void setValorIrrfRetido(Double valorIrrfRetido) {
        this.addCampoAlterado("valorIrrfRetido");
        this.valorIrrfRetido = valorIrrfRetido;
    }

    public Double getPercentualIrrfRetidoOriginal() {
        return this.percentualIrrfRetidoOriginal;
    }

    public void setPercentualIrrfRetidoOriginal(Double percentualIrrfRetidoOriginal) {
        this.addCampoAlterado("percentualIrrfRetidoOriginal");
        this.percentualIrrfRetidoOriginal = percentualIrrfRetidoOriginal;
    }

    public Double getPercentualPisRetido() {
        return this.percentualPisRetido;
    }

    public void setPercentualPisRetido(Double percentualPisRetido) {
        this.addCampoAlterado("percentualPisRetido");
        this.percentualPisRetido = percentualPisRetido;
    }

    public Double getValorPisRetido() {
        return this.valorPisRetido;
    }

    public void setValorPisRetido(Double valorPisRetido) {
        this.addCampoAlterado("valorPisRetido");
        this.valorPisRetido = valorPisRetido;
    }

    public Double getPercentualPisRetidoOriginal() {
        return this.percentualPisRetidoOriginal;
    }

    public void setPercentualPisRetidoOriginal(Double percentualPisRetidoOriginal) {
        this.addCampoAlterado("percentualPisRetidoOriginal");
        this.percentualPisRetidoOriginal = percentualPisRetidoOriginal;
    }

    public Long getNumeroRps() {
        return this.numeroRps;
    }

    public void setNumeroRps(Long numeroRps) {
        this.numeroRps = numeroRps;
        this.addCampoAlterado("numeroRps");
    }

    public Double getValorFrete() {
        return this.valorFrete;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
        this.addCampoAlterado("valorFrete");
    }

    public UsuarioVO getUsuarioAutorizacaoFinanceira() {
        return this.usuarioAutorizacaoFinanceira;
    }

    public void setUsuarioAutorizacaoFinanceira(UsuarioVO usuarioAutorizacaoFinanceira) {
        this.usuarioAutorizacaoFinanceira = usuarioAutorizacaoFinanceira;
        this.addCampoAlterado("usuarioAutorizacaoFinanceira");
    }

    public Date getDataHoraAutorizacaoFinanceira() {
        return this.dataHoraAutorizacaoFinanceira;
    }

    public void setDataHoraAutorizacaoFinanceira(Date dataHoraAutorizacaoFinanceira) {
        this.dataHoraAutorizacaoFinanceira = dataHoraAutorizacaoFinanceira;
        this.addCampoAlterado("dataHoraAutorizacaoFinanceira");
    }

    public Double getPercentualDescontoIncondicionado() {
        return this.percentualDescontoIncondicionado;
    }

    public void setPercentualDescontoIncondicionado(Double percentualDescontoIncondicionado) {
        this.percentualDescontoIncondicionado = percentualDescontoIncondicionado;
        this.addCampoAlterado("percentualDescontoIncondicionado");
    }

    public Double getValorDescontoIncondicionado() {
        return this.valorDescontoIncondicionado;
    }

    public void setValorDescontoIncondicionado(Double valorDescontoIncondicionado) {
        this.valorDescontoIncondicionado = valorDescontoIncondicionado;
        this.addCampoAlterado("valorDescontoIncondicionado");
    }

    public ArrayList<NotaFiscalMaterialBean> getMateriais() {
        return this.materiais;
    }

    public void setMateriais(ArrayList<NotaFiscalMaterialBean> materiais) {
        this.materiais = materiais;
    }

    public PedidoVO getPedido() {
        return this.pedido;
    }

    public void setPedido(PedidoVO pedido) {
        this.pedido = pedido;
        this.addCampoAlterado("pedido");
    }

    public CfopVO getCfop() {
        return this.cfop;
    }

    public void setCfop(CfopVO cfop) {
        this.cfop = cfop;
        this.addCampoAlterado("cfop");
    }

    public Double getValorIpi() {
        return this.valorIpi;
    }

    public void setValorIpi(Double valorIpi) {
        this.valorIpi = valorIpi;
        this.addCampoAlterado("valorIpi");
    }

    public Double getPercentualIpi() {
        return this.percentualIpi;
    }

    public void setPercentualIpi(Double percentualIpi) {
        this.percentualIpi = percentualIpi;
        this.addCampoAlterado("percentualIpi");
    }

    public Double getValorIcms() {
        return this.valorIcms;
    }

    public void setValorIcms(Double valorIcms) {
        this.valorIcms = valorIcms;
        this.addCampoAlterado("valorIcms");
    }

    public Double getPercentualIcms() {
        return this.percentualIcms;
    }

    public void setPercentualIcms(Double percentualIcms) {
        this.percentualIcms = percentualIcms;
        this.addCampoAlterado("percentualIcms");
    }

    public NotaFiscalBean() {
        this.dataEmissao = new Date();
    }

    public MotivoCancelamentoVO getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(MotivoCancelamentoVO motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
        this.addCampoAlterado("motivoCancelamento");
    }

    public String getDescricaoCancelamento() {
        return this.descricaoCancelamento;
    }

    public void setDescricaoCancelamento(String descricaoCancelamento) {
        this.descricaoCancelamento = descricaoCancelamento;
        this.addCampoAlterado("descricaoCancelamento");
    }

    @Override
    public AbstractThreadBean toVO() {
        NotaFiscalVO notaVO = new NotaFiscalVO();
        notaVO.setFilial(this.getFilial());
        notaVO.setCodigo(this.getCodigo());
        notaVO.setDataEmissao(this.getDataEmissao());
        notaVO.setNumero(this.getNumero());
        notaVO.setSerie(this.getSerie());
        notaVO.setSituacao(this.getSituacao());
        notaVO.setTipo(this.getTipo());
        notaVO.setValor(this.getValor());
        notaVO.setSubTotal(this.getSubTotal());
        notaVO.setNumeroRps(this.getNumeroRps());
        return notaVO;
    }

    public Double getSubTotal() {
        return this.subTotal;
    }

    public void setSubTotal(Double subTotal) {
        this.subTotal = subTotal;
        this.addCampoAlterado("subTotal");
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public SeriesVO getSerie() {
        return this.serie;
    }

    public void setSerie(SeriesVO serie) {
        this.serie = serie;
        this.addCampoAlterado("serie");
    }

    public UsuarioVO getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioVO usuario) {
        this.usuario = usuario;
        this.addCampoAlterado("usuario");
    }

    public UsuarioVO getUsuarioImpressao() {
        return this.usuarioImpressao;
    }

    public void setUsuarioImpressao(UsuarioVO usuarioImpressao) {
        this.usuarioImpressao = usuarioImpressao;
        this.addCampoAlterado("usuarioImpressao");
    }

    public UsuarioVO getUsuarioCancelada() {
        return this.usuarioCancelada;
    }

    public void setUsuarioCancelada(UsuarioVO usuarioCancelada) {
        this.usuarioCancelada = usuarioCancelada;
        this.addCampoAlterado("usuarioCancelada");
    }

    public EntidadeVO getEntidade() {
        return this.entidade;
    }

    public void setEntidade(EntidadeVO entidade) {
        this.entidade = entidade;
        this.addCampoAlterado("entidade");
    }

    public PacienteVO getPaciente() {
        return this.paciente;
    }

    public void setPaciente(PacienteVO paciente) {
        this.paciente = paciente;
        this.addCampoAlterado("paciente");
    }

    public ConvenioVO getConvenio() {
        return this.convenio;
    }

    public void setConvenio(ConvenioVO convenio) {
        this.convenio = convenio;
        this.addCampoAlterado("convenio");
    }

    public FormaPagamentoVO getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(FormaPagamentoVO formaPagamento) {
        this.formaPagamento = formaPagamento;
        this.addCampoAlterado("formaPagamento");
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
        this.addCampoAlterado("tipoCadastro");
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
        this.addCampoAlterado("dataHora");
    }

    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
        this.addCampoAlterado("dataEmissao");
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
        this.addCampoAlterado("situacao");
    }

    public Date getDataHoraImpressao() {
        return this.dataHoraImpressao;
    }

    public void setDataHoraImpressao(Date dataHoraImpressao) {
        this.dataHoraImpressao = dataHoraImpressao;
        this.addCampoAlterado("dataHoraImpressao");
    }

    public Date getDataHoraCancelada() {
        return this.dataHoraCancelada;
    }

    public void setDataHoraCancelada(Date dataHoraCancelada) {
        this.dataHoraCancelada = dataHoraCancelada;
        this.addCampoAlterado("dataHoraCancelada");
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
        this.addCampoAlterado("observacao");
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
        this.addCampoAlterado("valor");
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
        this.addCampoAlterado("tipo");
    }

    public Double getIrrfValor() {
        return this.irrfValor;
    }

    public void setIrrfValor(Double irrfValor) {
        this.irrfValor = irrfValor;
        this.addCampoAlterado("irrfValor");
    }

    public Double getIrrfPercentual() {
        return this.irrfPercentual;
    }

    public void setIrrfPercentual(Double irrfPercentual) {
        this.irrfPercentual = irrfPercentual;
        this.addCampoAlterado("irrPercentual");
    }

    public Double getIssValor() {
        return this.issValor;
    }

    public void setIssValor(Double issValor) {
        this.issValor = issValor;
        this.addCampoAlterado("issValor");
    }

    public Double getIssPercentual() {
        return this.issPercentual;
    }

    public void setIssPercentual(Double issPercentual) {
        this.issPercentual = issPercentual;
        this.addCampoAlterado("issPercentual");
    }

    public Double getPisValor() {
        return this.pisValor;
    }

    public void setPisValor(Double pisValor) {
        this.pisValor = pisValor;
        this.addCampoAlterado("pisValor");
    }

    public Double getPisPercentual() {
        return this.pisPercentual;
    }

    public void setPisPercentual(Double pisPercentual) {
        this.pisPercentual = pisPercentual;
        this.addCampoAlterado("pisPercentual");
    }

    public Double getCsllValor() {
        return this.csllValor;
    }

    public void setCsllValor(Double csllValor) {
        this.csllValor = csllValor;
        this.addCampoAlterado("csllValor");
    }

    public Double getCsllPercentual() {
        return this.csllPercentual;
    }

    public void setCsllPercentual(Double csllPercentual) {
        this.csllPercentual = csllPercentual;
        this.addCampoAlterado("csllPercentual");
    }

    public Double getCofinsValor() {
        return this.cofinsValor;
    }

    public void setCofinsValor(Double cofinsValor) {
        this.cofinsValor = cofinsValor;
        this.addCampoAlterado("cofinsValor");
    }

    public Double getCofinsPercentual() {
        return this.cofinsPercentual;
    }

    public void setCofinsPercentual(Double cofinsPercentual) {
        this.cofinsPercentual = cofinsPercentual;
        this.addCampoAlterado("cofinsPercentual");
    }

    public Double getInssValor() {
        return this.inssValor;
    }

    public void setInssValor(Double inssValor) {
        this.inssValor = inssValor;
        this.addCampoAlterado("inssValor");
    }

    public Double getInssPercentual() {
        return this.inssPercentual;
    }

    public void setInssPercentual(Double inssPercentual) {
        this.inssPercentual = inssPercentual;
        this.addCampoAlterado("inssPercentual");
    }

    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
        this.addCampoAlterado("numero");
    }

    public Set getLancamentosRequisicao() {
        return this.lancamentosRequisicao;
    }

    public void setLancamentosRequisicao(Set lancamentosRequisicao) {
        this.lancamentosRequisicao = lancamentosRequisicao;
    }

    public String getNomePagador() {
        return this.nomePagador;
    }

    public void setNomePagador(String nomePagador) {
        this.nomePagador = nomePagador;
        this.addCampoAlterado("nomePagador");
    }

    public String getCpfPagador() {
        return this.cpfPagador;
    }

    public void setCpfPagador(String cpfPagador) {
        this.cpfPagador = cpfPagador;
        this.addCampoAlterado("cpfPagador");
    }

    public NotaFiscalServicoBean getServico() {
        return this.servico;
    }

    public void setServico(NotaFiscalServicoBean servico) {
        this.servico = servico;
        this.addCampoAlterado("servico");
    }

    public Set getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(Set parcelas) {
        this.parcelas = parcelas;
        this.addCampoAlterado("parcelas");
    }

    public Set<FaturaNotaFiscalBean> getFaturasNotaFiscal() {
        return this.faturasNotaFiscal;
    }

    public Double getImpostoAcumulado() {
        return this.impostoAcumulado;
    }

    public void setImpostoAcumulado(Double impostoAcumulado) {
        this.impostoAcumulado = impostoAcumulado;
        this.addCampoAlterado("impostoAcumulado");
    }

    public Double getInssPercentualOriginal() {
        return this.inssPercentualOriginal;
    }

    public void setInssPercentualOriginal(Double inssPercentualOriginal) {
        this.inssPercentualOriginal = inssPercentualOriginal;
        this.addCampoAlterado("inssPercentualOriginal");
    }

    public Double getIrrfPercentualOriginal() {
        return this.irrfPercentualOriginal;
    }

    public void setIrrfPercentualOriginal(Double irrfPercentualOriginal) {
        this.irrfPercentualOriginal = irrfPercentualOriginal;
        this.addCampoAlterado("irrfPercentualOriginal");
    }

    public Double getCsllPercentualOriginal() {
        return this.csllPercentualOriginal;
    }

    public void setCsllPercentualOriginal(Double csllPercentualOriginal) {
        this.csllPercentualOriginal = csllPercentualOriginal;
        this.addCampoAlterado("csllPercentualOriginal");
    }

    public Double getCofinsPercentualOriginal() {
        return this.cofinsPercentualOriginal;
    }

    public void setCofinsPercentualOriginal(Double cofinsPercentualOriginal) {
        this.cofinsPercentualOriginal = cofinsPercentualOriginal;
        this.addCampoAlterado("cofinsPercentualOriginal");
    }

    public Double getIssPercentualOriginal() {
        return this.issPercentualOriginal;
    }

    public void setIssPercentualOriginal(Double issPercentualOriginal) {
        this.issPercentualOriginal = issPercentualOriginal;
        this.addCampoAlterado("issPercentualOriginal");
    }

    public Double getPisPercentualOriginal() {
        return this.pisPercentualOriginal;
    }

    public void setPisPercentualOriginal(Double pisPercentualOriginal) {
        this.pisPercentualOriginal = pisPercentualOriginal;
        this.addCampoAlterado("pisPercentualOriginal");
    }

    public BigDecimal getValorDeducoes() {
        if (this.getServico() != null && this.getServico().getServico() != null) {
            BigDecimal percentual = new BigDecimal("100");
            percentual = percentual.subtract(new BigDecimal(this.getServico().getServico().getPercentualDeduzir() != null ? this.getServico().getServico().getPercentualDeduzir().toString() : "0"));
            percentual = percentual.setScale(ParametrosGerais.getCasasPrecoImposto(), ParametrosGerais.getArredondamentoPrecoImposto());
            BigDecimal deducao = new BigDecimal(this.getSubTotal().toString());
            deducao = deducao.multiply(percentual);
            deducao = deducao.divide(new BigDecimal("100"), ParametrosGerais.getArredondamentoPrecoImposto());
            deducao = deducao.setScale(ParametrosGerais.getCasasPrecoImposto(), ParametrosGerais.getArredondamentoPrecoImposto());
            return deducao;
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getBaseCalculo() {
        BigDecimal baseCalculo = new BigDecimal(this.getSubTotal().toString());
        return baseCalculo;
    }

    public BigDecimal getValorLiquido() {
        BigDecimal valorLiquido = this.getBaseCalculo();
        valorLiquido = valorLiquido.subtract(this.getValorDeducoes());
        return valorLiquido;
    }

    @Override
    public String getDescricaoTabela() {
        return "notafiscal";
    }

    @Override
    public String getDescricaoCadastro() {
        return "Nota Fiscal";
    }

    public Long getPdfRps() {
        return this.pdfRps;
    }

    public void setPdfRps(Long pdfRps) {
        this.pdfRps = pdfRps;
        this.addCampoAlterado("pdfRps");
    }

    public Long getXmlNfse() {
        return this.xmlNfse;
    }

    public void setXmlNfse(Long xmlNfse) {
        this.xmlNfse = xmlNfse;
        this.addCampoAlterado("xmlNfse");
    }

    public Boolean getSerieAlterada() {
        return this.serieAlterada;
    }

    public void setSerieAlterada(Boolean serieAlterada) {
        this.serieAlterada = serieAlterada;
    }

    public void setRpsDaSerieAlterada(Long rpsDaSerieAlterada) {
        this.rpsDaSerieAlterada = rpsDaSerieAlterada;
    }

    public Long getRpsDaSerieAlterada() {
        return this.rpsDaSerieAlterada;
    }
}

