/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.financeiro;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoRPBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaRPBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@DataBaseTable(value="lanctocaixa")
public class LancamentoBean
extends AbstractThreadBean
implements BuscaBeanPreenchido {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="lcx_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="lcx_tipo")
    private String tipo;
    @DataBaseField(value="lcx_datahora")
    @FieldTimeStamp
    private Date dataHora;
    @DataBaseField(value="lcx_valor")
    private Double valor;
    @DataBaseField(value="lcx_banco")
    private Integer banco;
    @DataBaseField(value="lcx_agencia")
    private String agencia;
    @DataBaseField(value="lcx_documento")
    private String numeroDocumento;
    @DataBaseField(value="lcx_obs")
    private String observacao;
    @DataBaseField(value="lcx_tipodocumento")
    private String tipoDocumento;
    @DataBaseField(value="lcx_tipopagamento")
    private String tipoPagamento;
    @DataBaseField(value="usr_codigo")
    @DataBaseForeignKey
    private UsuarioVO usuario;
    @DataBaseField(value="cco_reduzido")
    @DataBaseForeignKey
    private ContaCorrenteVO contaCorrente;
    @DataBaseField(value="lcx_nrcheque")
    private String numeroCheque;
    @DataBaseField(value="lcx_validadecartao")
    @FieldDate
    private Date validadeCartao;
    @DataBaseField(value="lcx_nrcartao")
    private String numeroCartao;
    @DataBaseField(value="lcx_cartaocredito")
    private String cartaoCredito;
    @DataBaseField(value="lcx_conta")
    private String conta;
    @DataBaseField(value="lcx_conciliacao")
    @FieldDate
    private Date dataConciliacao;
    @DataBaseField(value="lcx_vencimento")
    @FieldDate
    private Date dataVencimento;
    @DataBaseField(value="est_codigo")
    @DataBaseFieldNotNull
    @DataBasePrimaryKey
    @DataBaseForeignKey
    private EstacaoVO estacao;
    @DataBaseField(value="lcx_competencia")
    @FieldDate
    private Date dataCompetencia;
    @DataBaseField(value="usr_codcancelado")
    @DataBaseForeignKey
    private UsuarioVO usuarioCancelado;
    @DataBaseField(value="lcx_datacancelado")
    @FieldTimeStamp
    private Date dataCancelado;
    @DataBaseField(value="mov_codigo")
    @DataBaseForeignKey
    private MotivoCancelamentoVO motivoCancelado;
    @DataBaseField(value="lcx_descricaocancelado")
    private String descricaoCancelado;
    @DataBaseField(value="lcx_valormulta")
    private Double valorMulta;
    @DataBaseField(value="lcx_valorjuro")
    private Double valorJuro;
    @DataBaseField(value="lcx_valoracrescimo")
    private Double valorAcrescimo;
    @DataBaseField(value="lcx_valordesconto")
    private Double valorDesconto;
    @DataBaseField(value="lcx_percentualmulta")
    private Double percentualMulta;
    @DataBaseField(value="lcx_percentualjuro")
    private Double percentualJuro;
    @DataBaseField(value="lcx_percentualacrescimo")
    private Double percentualAcrescimo;
    @DataBaseField(value="lcx_percentualdesconto")
    private Double percentualDesconto;
    @DataBaseField(value="lcx_valortotal")
    private Double valorTotal;
    @DataBaseField(value="hpa_codigo")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private HistoricoPadraoVO historicoPadrao;
    @DataBaseField(value="lcx_situacao")
    private String situacao;
    @DataBaseField(value="lcx_tipojuro")
    private String tipoJuro;
    @DataBaseField(value="lcx_kodigo")
    @DataBaseForeignKey
    private Integer complementarCodigo;
    @DataBaseField(value="est_kodigo")
    @DataBaseForeignKey
    private EstacaoVO complementarEstacao;
    @DataBaseField(value="lcx_tipoorigem")
    private String tipoOrigem;
    @DataBaseField(value="lcx_descricaohistorico")
    private String descricaoHistorico;
    @DataBaseField(value="lcx_sacado")
    private String sacado;
    @DataBaseField(value="lcx_nomepagador")
    private String nomePagador;
    @DataBaseField(value="lcx_cpfpagador")
    private String cpfPagador;
    @DataBaseField(value="fil_codentrefilial")
    @DataBaseForeignKey
    private FilialVO filialTransferencia;
    @DataBaseField(value="lcx_nomedescfolha")
    private String nomeDescFolha;
    @DataBaseField(value="lcx_setordescfolha")
    private String setorDescFolha;
    @DataBaseField(value="lcx_autorizadodescfolha")
    private String autorizadoDescFolha;
    @DataBaseField(value="lcx_tipotransferencia")
    private String tipoTransferencia;
    @DataBaseField(value="lcx_pix")
    private String pix;
    @FieldTransient
    protected Boolean usarValorMulta;
    @FieldTransient
    protected Set planosContas = new HashSet();
    @FieldTransient
    protected Set centrosCusto = new HashSet();
    @FieldTransient
    protected Set<LancamentoPlanoContaRPBean> planosContasRP = new HashSet<LancamentoPlanoContaRPBean>();
    @FieldTransient
    protected Set<LancamentoCentroCustoRPBean> centrosCustoRP = new HashSet<LancamentoCentroCustoRPBean>();
    @FieldTransient
    private NotaFiscalVO notaFiscal;
    @FieldTransient
    protected boolean planoContaErrado = false;
    @FieldTransient
    protected boolean centroCustoErrado = false;
    @FieldTransient
    protected boolean planoContaNaoConfigurado = false;
    @FieldTransient
    protected boolean centroCustoNaoConfigurado = false;
    @FieldTransient
    private LancamentoBean lancamentoDestinoTransferencia = null;

    public LancamentoBean getLancamentoDestinoTransferencia() {
        return this.lancamentoDestinoTransferencia;
    }

    public void setLancamentoDestinoTransferencia(LancamentoBean lancto) {
        this.lancamentoDestinoTransferencia = lancto;
    }

    public FilialVO getFilialTransferencia() {
        return this.filialTransferencia;
    }

    public void setFilialTransferencia(FilialVO filialTransferencia) {
        this.filialTransferencia = filialTransferencia;
    }

    public NotaFiscalVO getNotaFiscal() {
        return this.notaFiscal;
    }

    public void setNotaFiscal(NotaFiscalVO notaFiscal) {
        this.notaFiscal = notaFiscal;
    }

    public String getNomePagador() {
        return this.nomePagador;
    }

    public void setNomePagador(String nomePagador) {
        this.nomePagador = nomePagador;
        this.addCampoAlterado("nomePagador");
    }

    public String getCpfPagador() {
        return this.cpfPagador;
    }

    public void setCpfPagador(String cpfPagador) {
        this.cpfPagador = cpfPagador;
        this.addCampoAlterado("cpfPagador");
    }

    public void setSacado(String sacado) {
        this.sacado = sacado;
        this.addCampoAlterado("sacado");
    }

    public String getSacado() {
        return this.sacado;
    }

    public String getDescricaoHistorico() {
        return this.descricaoHistorico;
    }

    public void setDescricaoHistorico(String descricaoHistorico) {
        this.descricaoHistorico = descricaoHistorico;
        this.addCampoAlterado("descricaoHistorico");
    }

    public String getTipoOrigem() {
        return this.tipoOrigem;
    }

    public void setTipoOrigem(String tipoOrigem) {
        this.tipoOrigem = tipoOrigem;
        this.addCampoAlterado("tipoOrigem");
    }

    public void setComplementarCodigo(Integer complementarCodigo) {
        this.complementarCodigo = complementarCodigo;
        this.addCampoAlterado("complementarCodigo");
    }

    public Integer getComplementarCodigo() {
        return this.complementarCodigo;
    }

    public void setComplementarEstacao(EstacaoVO complementarEstacao) {
        this.complementarEstacao = complementarEstacao;
        this.addCampoAlterado("complementarEstacao");
    }

    public EstacaoVO getComplementarEstacao() {
        return this.complementarEstacao;
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public String getPix() {
        return this.pix;
    }

    public void setPix(String pix) {
        if (!Funcoes.textoVazio(pix)) {
            pix = StringUtil.trataCaracteresEspeciais(pix);
        }
        this.pix = pix;
    }

    @Override
    public AbstractThreadBean toVO() {
        LancamentoVO vo = new LancamentoVO();
        vo.setFilial(this.getFilial());
        vo.setCodigo(this.getCodigo());
        vo.setEstacao(this.getEstacao());
        vo.setValor(this.getValor());
        vo.setValorTotal(this.getValorTotal());
        vo.setDocumento(this.getNumeroDocumento());
        vo.setContaCorrente(this.getContaCorrente());
        vo.setDataVencimento(this.getDataVencimento());
        vo.setDataConciliacao(this.getDataConciliacao());
        vo.setTipo(this.getTipo());
        vo.setTipoPagamento(this.tipoPagamento);
        return vo;
    }

    public Integer getBanco() {
        return this.banco;
    }

    public void setBanco(Integer banco) {
        this.banco = banco;
        this.addCampoAlterado("banco");
    }

    public String getAgencia() {
        return this.agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = agencia;
        this.addCampoAlterado("agencia");
    }

    public String getTipoPagamento() {
        return this.tipoPagamento;
    }

    public void setTipoPagamento(String tipoPagamento) {
        this.tipoPagamento = tipoPagamento;
        this.addCampoAlterado("tipoPagamento");
    }

    public ContaCorrenteVO getContaCorrente() {
        return this.contaCorrente;
    }

    public void setContaCorrente(ContaCorrenteVO contaCorrente) {
        this.contaCorrente = contaCorrente;
        this.addCampoAlterado("contaCorrente");
    }

    public String getNumeroCheque() {
        return this.numeroCheque;
    }

    public void setNumeroCheque(String numeroCheque) {
        this.numeroCheque = numeroCheque;
        this.addCampoAlterado("numeroCheque");
    }

    public Date getValidadeCartao() {
        return this.validadeCartao;
    }

    public void setValidadeCartao(Date validadeCartao) {
        this.validadeCartao = validadeCartao;
        this.addCampoAlterado("validadeCartao");
    }

    public String getNumeroCartao() {
        return this.numeroCartao;
    }

    public void setNumeroCartao(String numeroCartao) {
        this.numeroCartao = numeroCartao;
        this.addCampoAlterado("numeroCartao");
    }

    public String getCartaoCredito() {
        return this.cartaoCredito;
    }

    public void setCartaoCredito(String cartaoCredito) {
        this.cartaoCredito = cartaoCredito;
        this.addCampoAlterado("cartaoCredito");
    }

    public String getConta() {
        return this.conta;
    }

    public void setConta(String conta) {
        this.conta = conta;
        this.addCampoAlterado("conta");
    }

    public Date getDataConciliacao() {
        return this.dataConciliacao;
    }

    public void setDataConciliacao(Date dataConciliacao) {
        this.dataConciliacao = dataConciliacao;
        this.addCampoAlterado("dataConciliacao");
    }

    public EstacaoVO getEstacao() {
        return this.estacao;
    }

    public void setEstacao(EstacaoVO estacao) {
        this.estacao = estacao;
        this.addCampoAlterado("estacao");
    }

    public MotivoCancelamentoVO getMotivoCancelado() {
        return this.motivoCancelado;
    }

    public void setMotivoCancelado(MotivoCancelamentoVO motivoCancelado) {
        this.motivoCancelado = motivoCancelado;
        this.addCampoAlterado("motivoCancelado");
    }

    public String getDescricaoCancelado() {
        return this.descricaoCancelado;
    }

    public void setDescricaoCancelado(String descricaoCancelado) {
        this.descricaoCancelado = descricaoCancelado;
        this.addCampoAlterado("descricaoCancelado");
    }

    public HistoricoPadraoVO getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    public void setHistoricoPadrao(HistoricoPadraoVO historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
        this.addCampoAlterado("historicoPadrao");
    }

    public String getNomeDescFolha() {
        return this.nomeDescFolha;
    }

    public void setNomeDescFolha(String nomeDescFolha) {
        this.nomeDescFolha = nomeDescFolha;
        this.addCampoAlterado("nomeDescFolha");
    }

    public String getSetorDescFolha() {
        return this.setorDescFolha;
    }

    public void setSetorDescFolha(String setorDescFolha) {
        this.setorDescFolha = setorDescFolha;
        this.addCampoAlterado("setorDescFolha");
    }

    public String getAutorizadoDescFolha() {
        return this.autorizadoDescFolha;
    }

    public void setAutorizadoDescFolha(String autorizadoDescFolha) {
        this.autorizadoDescFolha = autorizadoDescFolha;
        this.addCampoAlterado("autorizadoDescFolha");
    }

    @Override
    public AbstractThreadBean clonar() {
        LancamentoBean clone = (LancamentoBean)super.clonar();
        HashSet<AbstractThreadBean> planosContas = new HashSet<AbstractThreadBean>();
        HashSet<AbstractThreadBean> centrosCusto = new HashSet<AbstractThreadBean>();
        HashSet<LancamentoPlanoContaRPBean> planosContasRP = new HashSet<LancamentoPlanoContaRPBean>();
        HashSet<LancamentoCentroCustoRPBean> centrosCustoRP = new HashSet<LancamentoCentroCustoRPBean>();
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        for (AbstractThreadBean aux : clone.getPlanosContas()) {
            aux = (LancamentoPlanoContaBean)aux.clonar();
            ((LancamentoPlanoContaBean)aux).setInserir(true);
            ((LancamentoPlanoContaBean)aux).setEstacao(estacao);
            planosContas.add(aux);
        }
        clone.setPlanosContas(planosContas);
        for (AbstractThreadBean aux : clone.getCentrosCusto()) {
            aux = (LancamentoCentroCustoBean)aux.clonar();
            ((LancamentoCentroCustoBean)aux).setInserir(true);
            centrosCusto.add(aux);
        }
        clone.setCentrosCusto(centrosCusto);
        Iterator<Object> it = clone.getPlanosContasRP().iterator();
        while (it.hasNext()) {
            planosContasRP.add((LancamentoPlanoContaRPBean)((AbstractThreadBean)it.next()).clonar());
        }
        clone.setPlanosContasRP(planosContasRP);
        it = clone.getCentrosCustoRP().iterator();
        while (it.hasNext()) {
            centrosCustoRP.add((LancamentoCentroCustoRPBean)((AbstractThreadBean)it.next()).clonar());
        }
        clone.setCentroCustoRP(centrosCustoRP);
        return clone;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
        this.addCampoAlterado("tipo");
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
        this.addCampoAlterado("dataHora");
    }

    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
        this.addCampoAlterado("valor");
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
        this.addCampoAlterado("numeroDocumento");
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
        this.addCampoAlterado("observacao");
    }

    public String getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(String tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
        this.addCampoAlterado("tipoDocumento");
    }

    public UsuarioVO getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioVO usuario) {
        this.usuario = usuario;
        this.addCampoAlterado("usuario");
    }

    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
        this.addCampoAlterado("dataVencimento");
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
        this.addCampoAlterado("situacao");
    }

    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
        this.addCampoAlterado("dataCompetencia");
    }

    public UsuarioVO getUsuarioCancelado() {
        return this.usuarioCancelado;
    }

    public void setUsuarioCancelado(UsuarioVO usuarioCancelado) {
        this.usuarioCancelado = usuarioCancelado;
        this.addCampoAlterado("usuarioCancelado");
    }

    public Date getDataCancelado() {
        return this.dataCancelado;
    }

    public void setDataCancelado(Date dataCancelado) {
        this.dataCancelado = dataCancelado;
        this.addCampoAlterado("dataCancelado");
    }

    public Set getPlanosContas() {
        return this.planosContas;
    }

    public void setPlanosContas(Set planosContas) {
        this.planosContas = planosContas;
    }

    public void addPlanoConta(LancamentoPlanoContaBean planoConta) {
        this.planosContas.add(planoConta);
    }

    public void removePlanoConta(LancamentoPlanoContaBean planoConta) {
        this.planosContas.remove(planoConta);
    }

    public void removeTodosPlanosConta() {
        this.planosContas.clear();
    }

    public Set<LancamentoPlanoContaRPBean> getPlanosContasRP() {
        return this.planosContasRP;
    }

    public void setPlanosContasRP(Set<LancamentoPlanoContaRPBean> planosContasRP) {
        this.planosContasRP = planosContasRP;
    }

    public void addPlanoContaRP(LancamentoPlanoContaRPBean planoContaRP) {
        this.planosContasRP.add(planoContaRP);
    }

    public void removePlanoContaRP(LancamentoPlanoContaRPBean planoContaRP) {
        this.planosContasRP.remove(planoContaRP);
    }

    public void removeTodosPlanosContaRP() {
        this.planosContasRP.clear();
    }

    public Set<LancamentoCentroCustoRPBean> getCentrosCustoRP() {
        return this.centrosCustoRP;
    }

    public void setCentroCustoRP(Set<LancamentoCentroCustoRPBean> centrosCustoRP) {
        this.centrosCustoRP = centrosCustoRP;
    }

    public void addCentroCustoRP(LancamentoCentroCustoRPBean centroCustoRP) {
        this.centrosCustoRP.add(centroCustoRP);
    }

    public void removeCentroCustoRP(LancamentoCentroCustoRPBean centroCustoRP) {
        this.centrosCustoRP.remove(centroCustoRP);
    }

    public void removeTodosCentrosCustoRP() {
        this.centrosCustoRP.clear();
    }

    public void removeTodosCentrosCusto() {
        this.centrosCusto.clear();
    }

    public Double getValorMulta() {
        return this.valorMulta;
    }

    public void setValorMulta(Double valorMulta) {
        this.valorMulta = valorMulta;
        this.addCampoAlterado("valorMulta");
    }

    public Double getValorJuro() {
        return this.valorJuro;
    }

    public void setValorJuro(Double valorJuro) {
        this.valorJuro = valorJuro;
        this.addCampoAlterado("valorJuro");
    }

    public Double getValorAcrescimo() {
        return this.valorAcrescimo;
    }

    public void setValorAcrescimo(Double valorAcrescimo) {
        this.valorAcrescimo = valorAcrescimo;
        this.addCampoAlterado("valorAcrescimo");
    }

    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
        this.addCampoAlterado("valorDesconto");
    }

    public Double getPercentualMulta() {
        return this.percentualMulta;
    }

    public void setPercentualMulta(Double percentualMulta) {
        this.percentualMulta = percentualMulta;
        this.addCampoAlterado("percentualMulta");
    }

    public Double getPercentualJuro() {
        return this.percentualJuro;
    }

    public void setPercentualJuro(Double percentualJuro) {
        this.percentualJuro = percentualJuro;
        this.addCampoAlterado("percentualJuro");
    }

    public Double getPercentualAcrescimo() {
        return this.percentualAcrescimo;
    }

    public void setPercentualAcrescimo(Double percentualAcrescimo) {
        this.percentualAcrescimo = percentualAcrescimo;
        this.addCampoAlterado("percentualAcrescimo");
    }

    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
        this.addCampoAlterado("percentualDesconto");
    }

    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
        this.addCampoAlterado("valorTotal");
    }

    public String getTipoJuro() {
        return this.tipoJuro;
    }

    public void setTipoJuro(String tipoJuro) {
        this.tipoJuro = tipoJuro;
        this.addCampoAlterado("tipoJuro");
    }

    public Set getCentrosCusto() {
        return this.centrosCusto;
    }

    public void setCentrosCusto(Set centrosCusto) {
        this.centrosCusto = centrosCusto;
    }

    public void addCentroCusto(LancamentoCentroCustoBean centroCusto) {
        this.centrosCusto.add(centroCusto);
    }

    public void removeCentroCusto(LancamentoCentroCustoBean centroCusto) {
        this.centrosCusto.remove(centroCusto);
    }

    public void setUsarValorMulta(Boolean usarValorMulta) {
        this.usarValorMulta = usarValorMulta;
    }

    public Boolean getUsarValorMulta() {
        return this.usarValorMulta;
    }

    public void setPlanoContaErrado(boolean planoContaErrado) {
        this.planoContaErrado = planoContaErrado;
    }

    public boolean isPlanoContaErrado() {
        return this.planoContaErrado;
    }

    public void setCentroCustoErrado(boolean centroCustoErrado) {
        this.centroCustoErrado = centroCustoErrado;
    }

    public boolean isCentroCustoErrado() {
        return this.centroCustoErrado;
    }

    public void setCentroCustoNaoConfigurado(boolean centroCustoNaoConfigurado) {
        this.centroCustoNaoConfigurado = centroCustoNaoConfigurado;
    }

    public boolean isCentroCustoNaoConfigurado() {
        return this.centroCustoNaoConfigurado;
    }

    public void setPlanoContaNaoConfigurado(boolean planoContaNaoConfigurado) {
        this.planoContaNaoConfigurado = planoContaNaoConfigurado;
    }

    public boolean isPlanoContaNaoConfigurado() {
        return this.planoContaNaoConfigurado;
    }

    public String getTipoTransferencia() {
        return this.tipoTransferencia;
    }

    public void setTipoTransferencia(String tipoTransferencia) {
        this.tipoTransferencia = tipoTransferencia;
    }

    public void addPlanoConta(ReceberPagarPlanoContaBean planoConta) {
        this.planosContas.add(planoConta);
    }

    public void removePlanoConta(ReceberPagarPlanoContaBean planoConta) {
        this.planosContas.remove(planoConta);
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getContaCorrente() != null) {
            buf.append(this.getContaCorrente().getConta()).append(" - ");
        }
        if (this.getTipoPagamento() != null) {
            buf.append(Tipos.tipoPagamento(this.getTipoPagamento())).append(" - ");
        }
        if (this.getValorTotal() != null) {
            buf.append(Funcoes.formataDecimal(this.getValorTotal()));
        }
        return buf.toString();
    }
}

