/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.financeiro;

import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.FaturaRequisicaoBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import java.util.ArrayList;
import java.util.Date;

@DataBaseTable(value="fatura")
public class FaturaBean
extends AbstractThreadBean {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="fat_codigo")
    @DataBaseFieldNotNull
    @DataBasePrimaryKey
    private Integer codigo;
    @DataBaseField(value="con_codigo")
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private ConvenioVO convenio;
    @DataBaseField(value="fat_dtvenc")
    @DataBaseFieldNotNull
    @FieldDate
    private Date vencimento;
    @DataBaseField(value="fat_dtemis")
    @DataBaseFieldNotNull
    @FieldDate
    private Date dataEmissao;
    @DataBaseField(value="fat_dtinicio")
    @DataBaseFieldNotNull
    @FieldDate
    private Date dataInicio;
    @DataBaseField(value="fat_dtfim")
    @DataBaseFieldNotNull
    @FieldDate
    private Date dataFim;
    @DataBaseField(value="fat_mensagem")
    private String mensagem;
    @DataBaseField(value="fat_totalexames")
    private Double valorTotalExames;
    @DataBaseField(value="fat_totalmateriais")
    private Double valorTotalMateriais;
    @DataBaseField(value="fat_adicional")
    private Double valorAdicional;
    @DataBaseField(value="fat_despcobranca")
    private Double valorDespCobranca;
    @DataBaseField(value="fat_percdesconto")
    private Double percentualDesconto;
    @DataBaseField(value="usr_codcomissao")
    @DataBaseForeignKey
    private UsuarioVO codigoUsuarioComissao;
    @DataBaseField(value="fat_datacomissao")
    @FieldTimeStamp
    private Date dataComissao;
    @DataBaseField(value="fat_nota")
    private Integer nota;
    @DataBaseField(value="fat_totalexamesch")
    private Double valorTotalExamesCH;
    @DataBaseField(value="fat_qtdeexames")
    private Integer quantidadeExames;
    @DataBaseField(value="fat_qtderequisicao")
    private Integer quantidadeRequisicoes;
    @DataBaseField(value="fat_percacrescimo")
    private Double percentualAcrescimo;
    @DataBaseField(value="fat_datacancelamento")
    @FieldTimeStamp
    private Date dataCancelamento;
    @DataBaseField(value="fat_dtconferencia")
    private Date dataConferencia;
    @DataBaseField(value="fat_datahora")
    @FieldTimeStamp
    private Date dataHora;
    @DataBaseField(value="usr_codigo")
    @DataBaseForeignKey
    private UsuarioVO usuario;
    @DataBaseField(value="usr_codconferencia")
    @DataBaseForeignKey
    private UsuarioVO usuarioConferencia;
    @DataBaseField(value="usr_codcancelamento")
    @DataBaseForeignKey
    private UsuarioVO usuarioCancelamento;
    @FieldTransient
    private ArrayList<NotaFiscalVO> notaFiscal = new ArrayList();
    @FieldTransient
    private ArrayList<FaturaRequisicaoBean> requisicoes = new ArrayList();
    @FieldTransient
    private Double valorRestanteFaturar = 0.0;
    @FieldTransient
    private boolean isComissaoGerada = false;
    @DataBaseField(value="fat_dataarquivo")
    @FieldTimeStamp
    private Date dataArquivo;

    public Double getValorTotal() {
        Double valorExamesMateriais = this.valorTotalExames + this.valorTotalMateriais;
        return valorExamesMateriais + this.valorAdicional + this.valorDespCobranca + valorExamesMateriais * this.percentualAcrescimo / 100.0 - valorExamesMateriais * this.percentualDesconto / 100.0;
    }

    public Double getValorRestanteFaturar() {
        return this.valorRestanteFaturar;
    }

    public void setValorRestanteFaturar(Double valorRestanteFaturar) {
        this.valorRestanteFaturar = valorRestanteFaturar;
    }

    public Double getValorTotalMateriais() {
        return this.valorTotalMateriais;
    }

    public void setValorTotalMateriais(Double valorTotalMateriais) {
        this.valorTotalMateriais = valorTotalMateriais;
        this.addCampoAlterado("valorTotalMateriais");
    }

    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
        this.addCampoAlterado("valorAdicional");
    }

    public Double getValorDespCobranca() {
        return this.valorDespCobranca;
    }

    public void setValorDespCobranca(Double valorDespCobranca) {
        this.valorDespCobranca = valorDespCobranca;
        this.addCampoAlterado("valorDespCobranca");
    }

    public Double getPercentualDesconto() {
        return this.percentualDesconto;
    }

    public void setPercentualDesconto(Double percentualDesconto) {
        this.percentualDesconto = percentualDesconto;
        this.addCampoAlterado("percentualDesconto");
    }

    public boolean getComissaoGerada() {
        return this.isComissaoGerada;
    }

    public void setComissaoGerada(boolean isComissaoGerada) {
        this.isComissaoGerada = isComissaoGerada;
        this.addCampoAlterado("isComissaoGerada");
    }

    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
        this.addCampoAlterado("dataEmissao");
    }

    public UsuarioVO getCodigoUsuarioComissao() {
        return this.codigoUsuarioComissao;
    }

    public void setCodigoUsuarioComissao(UsuarioVO codigoUsuarioComissao) {
        this.codigoUsuarioComissao = codigoUsuarioComissao;
        this.addCampoAlterado("codigoUsuarioComissao");
    }

    public Date getDataComissao() {
        return this.dataComissao;
    }

    public void setDataComissao(Date dataComissao) {
        this.dataComissao = dataComissao;
        this.addCampoAlterado("dataComissao");
    }

    @Override
    public AbstractThreadBean toVO() {
        FaturaVO vo = new FaturaVO();
        vo.setFilial(this.getFilial());
        vo.setCodigo(this.getCodigo());
        return vo;
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public Date getVencimento() {
        return this.vencimento;
    }

    public void setVencimento(Date vencimento) {
        this.vencimento = vencimento;
        this.addCampoAlterado("vencimento");
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
        this.addCampoAlterado("dataInicio");
    }

    public Date getDataFim() {
        return this.dataFim;
    }

    public void setDataFim(Date dataFim) {
        this.dataFim = dataFim;
        this.addCampoAlterado("dataFim");
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
        this.addCampoAlterado("mensagem");
    }

    public Double getValorTotalExames() {
        return this.valorTotalExames;
    }

    public void setValorTotalExames(Double valorTotalExames) {
        this.valorTotalExames = valorTotalExames;
        this.addCampoAlterado("valorTotalExames");
    }

    public ConvenioVO getConvenio() {
        return this.convenio;
    }

    public void setConvenio(ConvenioVO convenio) {
        this.convenio = convenio;
        this.addCampoAlterado("convenio");
    }

    public Integer getNota() {
        return this.nota;
    }

    public void setNota(Integer nota) {
        this.nota = nota;
        this.addCampoAlterado("nota");
    }

    public Double getValorTotalExamesCH() {
        return this.valorTotalExamesCH;
    }

    public void setValorTotalExamesCH(Double valorTotalExamesCH) {
        this.valorTotalExamesCH = valorTotalExamesCH;
        this.addCampoAlterado("valorTotalExamesCH");
    }

    public Integer getQuantidadeExames() {
        return this.quantidadeExames;
    }

    public void setQuantidadeExames(Integer quantidadeExames) {
        this.quantidadeExames = quantidadeExames;
        this.addCampoAlterado("quantidadeExames");
    }

    public Integer getQuantidadeRequisicoes() {
        return this.quantidadeRequisicoes;
    }

    public void setQuantidadeRequisicoes(Integer quantidadeRequisicoes) {
        this.quantidadeRequisicoes = quantidadeRequisicoes;
        this.addCampoAlterado("quantidadeRequisicoes");
    }

    public Double getPercentualAcrescimo() {
        return this.percentualAcrescimo;
    }

    public void setPercentualAcrescimo(Double percentualAcrescimo) {
        this.percentualAcrescimo = percentualAcrescimo;
        this.addCampoAlterado("percentualAcrescimo");
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
        this.addCampoAlterado("dataCancelamento");
    }

    public Date getDataArquivo() {
        return this.dataArquivo;
    }

    public void setDataArquivo(Date dataArquivo) {
        this.dataArquivo = dataArquivo;
    }

    public Date getDataConferencia() {
        return this.dataConferencia;
    }

    public void setDataConferencia(Date dataConferencia) {
        this.dataConferencia = dataConferencia;
        this.addCampoAlterado("dataConferencia");
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public void setDataHora(Date dataHora) {
        this.dataHora = dataHora;
        this.addCampoAlterado("dataHora");
    }

    public UsuarioVO getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioVO usuario) {
        this.usuario = usuario;
        this.addCampoAlterado("usuario");
    }

    public UsuarioVO getUsuarioConferencia() {
        return this.usuarioConferencia;
    }

    public void setUsuarioConferencia(UsuarioVO usuarioConferencia) {
        this.usuarioConferencia = usuarioConferencia;
        this.addCampoAlterado("usuarioConferencia");
    }

    public UsuarioVO getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(UsuarioVO usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
        this.addCampoAlterado("usuarioCancelamento");
    }

    public ArrayList<FaturaRequisicaoBean> getRequisicoes() {
        return this.requisicoes;
    }

    public void setRequisicoes(ArrayList<FaturaRequisicaoBean> requisicoes) {
        this.requisicoes = requisicoes;
    }

    public ArrayList<NotaFiscalVO> getNotaFiscal() {
        return this.notaFiscal;
    }

    public void setNotaFiscal(ArrayList<NotaFiscalVO> notaFiscal) {
        this.notaFiscal = notaFiscal;
    }
}

