/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.estoque;

import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.material.FichaTecnicaBean;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.model.bean.estoque.MaterialAlternativoBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.TipoMaterialBean;
import jalis.model.bean.estoque.UnidadeMedidaBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import java.util.ArrayList;
import java.util.Date;

@DataBaseTable(value="material")
public class MaterialBean
extends AbstractThreadBean
implements BuscaBeanPreenchido {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="mat_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="unm_codigo")
    @DataBaseForeignKey
    private UnidadeMedidaBean unidadeMedida;
    @DataBaseField(value="tpm_codigo")
    @DataBaseForeignKey
    private TipoMaterialBean tipoMaterial;
    @DataBaseField(value="mat_descricao")
    private String descricao;
    @DataBaseField(value="mat_valorunit")
    private Double valorUnitario;
    @DataBaseField(value="mat_valorultcompra")
    private Double valorUltimaCompra;
    @DataBaseField(value="mat_dataultcompra")
    @FieldDate
    private Date dataUltimaCompra;
    @DataBaseField(value="mat_qtdeultcompra")
    private Double quantidadeUltimaCompra;
    @DataBaseField(value="mat_ptoreposicao")
    private Double pontoReposicao;
    @DataBaseField(value="mat_dataultentrega")
    @FieldDate
    private Date dataUltimaEntrega;
    @DataBaseField(value="mat_marca")
    private String marca;
    @DataBaseField(value="mat_modelo")
    private String modelo;
    @DataBaseField(value="mat_reposicaoautomatica")
    private Boolean reposicaoAutomatica;
    @DataBaseField(value="usr_codigo")
    @DataBaseForeignKey
    private UsuarioVO usuario;
    @DataBaseField(value="mat_imobilizado")
    private Boolean imobilizado;
    @DataBaseField(value="mat_solicitarpatrimonio")
    private Boolean solicitarPatrimonio;
    @DataBaseField(value="mat_fichatecnica")
    private Boolean fichaTecnica;
    @DataBaseField(value="mat_reutilizavel")
    private Boolean reutilizavel;
    @DataBaseField(value="mat_solicitarlote")
    private Boolean solicitarLote;
    @FieldTransient
    private String analiseCritica;
    @DataBaseField(value="mat_inativo")
    private Boolean inativo;
    @DataBaseField(value="mat_observacao")
    private String observacao;
    @DataBaseField(value="mat_diasavisolote")
    private Integer diasAvisoLote;
    @DataBaseField(value="usr_codavisolote")
    private UsuarioBean usuarioAviso;
    @DataBaseField(value="mat_avisarvalidadelote")
    private Boolean avisarValidadeLote;
    @FieldTransient
    private boolean inserir = false;
    @FieldTransient
    private boolean excluido = false;
    @FieldTransient
    private ArrayList<FichaTecnicaBean> materiaisComposicao = null;
    @FieldTransient
    private ArrayList<MaterialPatrimonioBean> patrimonios = null;
    @FieldTransient
    private ArrayList<MaterialLoteBean> lotes = new ArrayList();
    @FieldTransient
    private ArrayList<MaterialAlternativoBean> materiaisAlternativos = new ArrayList();
    @FieldTransient
    private Double valorTotalUltimaCompra = 0.0;
    @FieldTransient
    private Double quantidadeInformadaLotes = 0.0;
    @FieldTransient
    private boolean isAtualizarAlternativos = false;
    @DataBaseField(value="mat_ipiultcompra")
    private Double ipiUltimaCompra;
    @DataBaseField(value="mat_freteultcompra")
    private Double freteUltimaCompra;
    @DataBaseField(value="mat_calcrateiofreteultcompra")
    private Double calculoRateioFreteUltimaCompra;
    @DataBaseField(value="nfi_codigoultcompra")
    private Integer codigoUltimaCompraNfi;
    @DataBaseField(value="ped_codigoultcompra")
    private Integer codigoUltimaCompraPed;
    @DataBaseField(value="cen_codigoultcompra")
    private Integer codigoUltimaCompraCen;

    public void setAtualizarAlternativos(boolean isAtualizarAlternativos) {
        this.isAtualizarAlternativos = isAtualizarAlternativos;
    }

    public boolean getAtualizarAlternativos() {
        return this.isAtualizarAlternativos;
    }

    public boolean isInserir() {
        return this.inserir;
    }

    public void setInserir(boolean inserir) {
        this.inserir = inserir;
    }

    public boolean isExcluido() {
        return this.excluido;
    }

    public void setExcluido(boolean excluido) {
        this.excluido = excluido;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
        this.addCampoAlterado("observacao");
    }

    public Boolean getInativo() {
        return this.inativo;
    }

    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
        this.addCampoAlterado("inativo");
    }

    public Double getQuantidadeInformadaLotes() {
        return this.quantidadeInformadaLotes;
    }

    public void setQuantidadeInformadaLotes(Double quantidadeInformadaLotes) {
        this.quantidadeInformadaLotes = quantidadeInformadaLotes;
    }

    public ArrayList<MaterialLoteBean> getLotes() {
        return this.lotes;
    }

    public void setLotes(ArrayList<MaterialLoteBean> lotes) {
        this.lotes = lotes;
    }

    public ArrayList<MaterialAlternativoBean> getMateriaisAlternativos() {
        return this.materiaisAlternativos;
    }

    public void setMateriaisAlternativos(ArrayList<MaterialAlternativoBean> materiaisAlternativos) {
        this.materiaisAlternativos = materiaisAlternativos;
    }

    public void setSolicitarLote(Boolean solicitarLote) {
        this.solicitarLote = solicitarLote;
        this.addCampoAlterado("solicitarLote");
    }

    public Boolean getSolicitarLote() {
        return this.solicitarLote == null ? false : this.solicitarLote;
    }

    public void setValorTotalUltimaCompra(Double valorTotalUltimaCompra) {
        this.valorTotalUltimaCompra = valorTotalUltimaCompra;
    }

    public Double getValorTotalUltimaCompra() {
        return this.valorTotalUltimaCompra;
    }

    public ArrayList<MaterialPatrimonioBean> getPatrimonios() {
        return this.patrimonios;
    }

    public void setPatrimonios(ArrayList<MaterialPatrimonioBean> patrimonios) {
        this.patrimonios = patrimonios;
    }

    public ArrayList<FichaTecnicaBean> getMateriaisComposicao() {
        return this.materiaisComposicao;
    }

    public void setMateriaisComposicao(ArrayList<FichaTecnicaBean> materiaisComposicao) {
        this.materiaisComposicao = materiaisComposicao;
    }

    public Boolean getFichaTecnica() {
        return this.fichaTecnica;
    }

    public void setFichaTecnica(Boolean fichaTecnica) {
        this.fichaTecnica = fichaTecnica == null ? false : fichaTecnica;
        this.addCampoAlterado("fichaTecnica");
    }

    public Boolean getSolicitarPatrimonio() {
        return this.solicitarPatrimonio;
    }

    public void setSolicitarPatrimonio(Boolean solicitarPatrimonio) {
        this.solicitarPatrimonio = solicitarPatrimonio;
        this.addCampoAlterado("solicitarPatrimonio");
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
        this.addCampoAlterado("codigo");
    }

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
        this.addCampoAlterado("filial");
    }

    public UnidadeMedidaBean getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public void setUnidadeMedida(UnidadeMedidaBean unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
        this.addCampoAlterado("unidadeMedida");
    }

    public TipoMaterialBean getTipoMaterial() {
        return this.tipoMaterial;
    }

    public void setTipoMaterial(TipoMaterialBean tipoMaterial) {
        this.tipoMaterial = tipoMaterial;
        this.addCampoAlterado("tipoMaterial");
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
        this.addCampoAlterado("descricao");
    }

    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
        this.addCampoAlterado("valorUnitario");
    }

    public Double getValorUltimaCompra() {
        return this.valorUltimaCompra;
    }

    public void setValorUltimaCompra(Double valorUltimaCompra) {
        this.valorUltimaCompra = valorUltimaCompra;
        this.addCampoAlterado("valorUltimaCompra");
    }

    public Date getDataUltimaCompra() {
        return this.dataUltimaCompra;
    }

    public void setDataUltimaCompra(Date dataUltimaCompra) {
        this.dataUltimaCompra = dataUltimaCompra;
        this.addCampoAlterado("dataUltimaCompra");
    }

    public Double getQuantidadeUltimaCompra() {
        return this.quantidadeUltimaCompra;
    }

    public void setQuantidadeUltimaCompra(Double quantidadeUltimaCompra) {
        this.quantidadeUltimaCompra = quantidadeUltimaCompra;
        this.addCampoAlterado("quantidadeUltimaCompra");
    }

    public Double getPontoReposicao() {
        return this.pontoReposicao;
    }

    public void setPontoReposicao(Double pontoReposicao) {
        this.pontoReposicao = pontoReposicao;
        this.addCampoAlterado("pontoReposicao");
    }

    public Date getDataUltimaEntrega() {
        return this.dataUltimaEntrega;
    }

    public void setDataUltimaEntrega(Date dataUltimaEntrega) {
        this.dataUltimaEntrega = dataUltimaEntrega;
        this.addCampoAlterado("dataUltimaEntrega");
    }

    public String getMarca() {
        return this.marca;
    }

    public void setMarca(String marca) {
        this.marca = marca;
        this.addCampoAlterado("marca");
    }

    public String getModelo() {
        return this.modelo;
    }

    public void setModelo(String modelo) {
        this.modelo = modelo;
        this.addCampoAlterado("modelo");
    }

    public Boolean getReposicaoAutomatica() {
        return this.reposicaoAutomatica;
    }

    public void setReposicaoAutomatica(Boolean reposicaoAutomatica) {
        this.reposicaoAutomatica = reposicaoAutomatica;
        this.addCampoAlterado("reposicaoAutomatica");
    }

    public UsuarioVO getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioVO usuario) {
        this.usuario = usuario;
        this.addCampoAlterado("usuario");
    }

    public Boolean getImobilizado() {
        return this.imobilizado;
    }

    public void setImobilizado(Boolean imobilizado) {
        this.imobilizado = imobilizado;
        this.addCampoAlterado("imobilizado");
    }

    public Boolean getReutilizavel() {
        return this.reutilizavel;
    }

    public void setReutilizavel(Boolean reutilizavel) {
        this.reutilizavel = reutilizavel;
        this.addCampoAlterado("reutilizavel");
    }

    public Integer getDiasAvisoLote() {
        return this.diasAvisoLote;
    }

    public void setDiasAvisoLote(Integer diasAvisoLote) {
        this.diasAvisoLote = diasAvisoLote;
        this.addCampoAlterado("diasavisolote");
    }

    public UsuarioBean getUsuarioAviso() {
        return this.usuarioAviso;
    }

    public void setUsuarioAviso(UsuarioBean usuarioAviso) {
        this.usuarioAviso = usuarioAviso;
    }

    public boolean isAvisarValidadeLote() {
        return this.avisarValidadeLote != null && this.avisarValidadeLote != false;
    }

    public void setAvisarValidadeLote(Boolean avisarValidadeLote) {
        this.avisarValidadeLote = avisarValidadeLote;
        this.addCampoAlterado("avisarvalidadelote");
    }

    public boolean isAtualizarAlternativos() {
        return this.isAtualizarAlternativos;
    }

    public Double getIpiUltimaCompra() {
        return this.ipiUltimaCompra;
    }

    public void setIpiUltimaCompra(Double ipiUltimaCompra) {
        this.ipiUltimaCompra = ipiUltimaCompra;
        this.addCampoAlterado("ipiUltimaCompra");
    }

    public Double getFreteUltimaCompra() {
        return this.freteUltimaCompra;
    }

    public void setFreteUltimaCompra(Double freteUltimaCompra) {
        this.freteUltimaCompra = freteUltimaCompra;
        this.addCampoAlterado("freteUltimaCompra");
    }

    public Double getCalculoRateioFreteUltimaCompra() {
        return this.calculoRateioFreteUltimaCompra;
    }

    public void setCalculoRateioFreteUltimaCompra(Double calculoRateioFreteUltimaCompra) {
        this.calculoRateioFreteUltimaCompra = calculoRateioFreteUltimaCompra;
        this.addCampoAlterado("calculoRateioFreteUltimaCompra");
    }

    public Integer getCodigoUltimaCompraNfi() {
        return this.codigoUltimaCompraNfi;
    }

    public void setCodigoUltimaCompraNfi(Integer codigoUltimaCompraNfi) {
        this.codigoUltimaCompraNfi = codigoUltimaCompraNfi;
        this.addCampoAlterado("codigoUltimaCompraNfi");
    }

    public Integer getCodigoUltimaCompraPed() {
        return this.codigoUltimaCompraPed;
    }

    public void setCodigoUltimaCompraPed(Integer codigoUltimaCompraPed) {
        this.codigoUltimaCompraPed = codigoUltimaCompraPed;
        this.addCampoAlterado("codigoUltimaCompraPed");
    }

    public Integer getCodigoUltimaCompraCen() {
        return this.codigoUltimaCompraCen;
    }

    public void setCodigoUltimaCompraCen(Integer codigoUltimaCompraCen) {
        this.codigoUltimaCompraCen = codigoUltimaCompraCen;
        this.addCampoAlterado("codigoUltimaCompraCen");
    }

    @Override
    public AbstractThreadVO toVO() {
        MaterialVO materialVO = new MaterialVO();
        materialVO.setFilial(this.filial);
        materialVO.setCodigo(this.codigo);
        materialVO.setDescricao(this.descricao);
        materialVO.setSolicitarPatrimonio(this.solicitarPatrimonio);
        materialVO.setImobilizado(this.imobilizado);
        materialVO.setUnidadeMedida(this.unidadeMedida);
        materialVO.setValorUnit(this.valorUnitario);
        materialVO.setInativo(this.inativo);
        materialVO.setDataUltimaCompra(this.dataUltimaCompra);
        materialVO.setDataUltimaEntrega(this.dataUltimaEntrega);
        materialVO.setFichaTecnica(this.fichaTecnica);
        materialVO.setLotes(this.lotes);
        materialVO.setMarca(this.marca);
        materialVO.setMateriaisComposicao(this.materiaisComposicao);
        materialVO.setModelo(this.modelo);
        materialVO.setObservacao(this.observacao);
        materialVO.setPatrimonios(this.patrimonios);
        materialVO.setPontoReposicao(this.pontoReposicao);
        materialVO.setQuantidadeInformadaLotes(this.quantidadeInformadaLotes);
        materialVO.setQuantidadeUltimaCompra(this.quantidadeUltimaCompra);
        materialVO.setReposicaoAutomatica(this.reposicaoAutomatica);
        materialVO.setReutilizavel(this.reutilizavel);
        materialVO.setSolicitarLote(this.solicitarLote);
        materialVO.setTipoMaterial(this.tipoMaterial);
        materialVO.setUsuario(this.usuario);
        materialVO.setValorTotalUltimaCompra(this.valorTotalUltimaCompra);
        materialVO.setValorUltimaCompra(this.valorUltimaCompra);
        materialVO.setAnaliseCritica(this.analiseCritica);
        materialVO.setAvisarValidadeLote(this.avisarValidadeLote);
        materialVO.setDiasAvisoLote(this.diasAvisoLote);
        return materialVO;
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this;
    }

    public String toString() {
        return this.descricao;
    }

    public Double getQuantidadeLotes() {
        if (this.lotes != null) {
            Double qtde = 0.0;
            for (int i = 0; i < this.lotes.size(); ++i) {
                if (this.lotes.get(i).getRemovido().booleanValue()) continue;
                qtde = qtde + this.lotes.get(i).getQuantidade();
            }
            return qtde;
        }
        return 0.0;
    }

    public Double getQuantidadeLotes(CelulaEstoqueVO celula) {
        if (celula == null) {
            return this.getQuantidadeLotes();
        }
        Double qtde = 0.0;
        if (this.lotes != null) {
            block0: for (int i = 0; i < this.lotes.size(); ++i) {
                if (this.lotes.get(i).getRemovido().booleanValue() || this.lotes.get(i).getLancamentosEstoque() == null) continue;
                for (MaterialLoteLanctoEstoqueBean loteLancto : this.lotes.get(i).getLancamentosEstoque()) {
                    if (!loteLancto.getLancamento().getTipo().equalsIgnoreCase("E") || !loteLancto.getLancamento().getCelula().equals(celula)) continue;
                    qtde = qtde + this.lotes.get(i).getQuantidade();
                    continue block0;
                }
            }
        }
        return qtde;
    }

    public Double getQuantidadeConsumidaLotes() {
        Double qtde = 0.0;
        if (this.lotes != null) {
            for (int i = 0; i < this.lotes.size(); ++i) {
                if (this.lotes.get(i).getRemovido().booleanValue()) continue;
                qtde = qtde + this.lotes.get(i).getQuantidadeConsumida();
            }
        }
        return qtde;
    }

    public Double getQuantidadeConsumidaLotes(CelulaEstoqueVO celula) {
        if (celula == null) {
            return this.getQuantidadeConsumidaLotes();
        }
        Double qtde = 0.0;
        if (this.lotes != null) {
            block0: for (int i = 0; i < this.lotes.size(); ++i) {
                if (this.lotes.get(i).getRemovido().booleanValue() || this.lotes.get(i).getLancamentosEstoque() == null) continue;
                for (MaterialLoteLanctoEstoqueBean loteLancto : this.lotes.get(i).getLancamentosEstoque()) {
                    if (!loteLancto.getLancamento().getTipo().equalsIgnoreCase("E") || !loteLancto.getLancamento().getCelula().equals(celula)) continue;
                    qtde = qtde + this.lotes.get(i).getQuantidadeConsumida();
                    continue block0;
                }
            }
        }
        return qtde;
    }

    public Double getQuantidadeConsumidaOriginalLotes() {
        Double qtde = 0.0;
        if (this.lotes != null) {
            for (int i = 0; i < this.lotes.size(); ++i) {
                if (this.lotes.get(i).getRemovido().booleanValue()) continue;
                qtde = qtde + this.lotes.get(i).getQuantidadeConsumidaOriginal();
            }
        }
        return qtde;
    }

    public Double getQuantidadeConsumidaOriginalLotes(CelulaEstoqueVO celula) {
        if (celula == null) {
            return this.getQuantidadeConsumidaOriginalLotes();
        }
        Double qtde = 0.0;
        if (this.lotes != null) {
            block0: for (int i = 0; i < this.lotes.size(); ++i) {
                if (this.lotes.get(i).getRemovido().booleanValue() || this.lotes == null || this.lotes.isEmpty() || this.lotes.get(i) == null || this.lotes.get(i).getLancamentosEstoque() == null) continue;
                for (MaterialLoteLanctoEstoqueBean loteLancto : this.lotes.get(i).getLancamentosEstoque()) {
                    if (!loteLancto.getLancamento().getTipo().equalsIgnoreCase("E") || !loteLancto.getLancamento().getCelula().equals(celula)) continue;
                    qtde = qtde + this.lotes.get(i).getQuantidadeConsumidaOriginal();
                    continue block0;
                }
            }
        }
        return qtde;
    }

    public void setAnaliseCritica(String analiseCritica) {
        this.analiseCritica = analiseCritica;
    }

    public String getAnaliseCritica() {
        return this.analiseCritica;
    }
}

