/*
 * Decompiled with CFR 0.152.
 */
package jalis.model.bean.cadastro.financeiro;

import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.FormaPagamentoParcelaBean;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldTransient;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@DataBaseTable(value="formapagto")
public class FormaPagamentoBean
extends AbstractThreadBean {
    @DataBaseField(value="fil_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    @DataBaseForeignKey
    private FilialVO filial;
    @DataBaseField(value="fpg_codigo")
    @DataBasePrimaryKey
    @DataBaseFieldNotNull
    private Integer codigo;
    @DataBaseField(value="fpg_descricao")
    @DataBaseFieldNotNull
    private String descricao;
    @FieldTransient
    private Set parcelas = new HashSet();

    public FilialVO getFilial() {
        return this.filial;
    }

    public void setFilial(FilialVO filial) {
        this.filial = filial;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Override
    public AbstractThreadVO toVO() {
        FormaPagamentoVO vo = new FormaPagamentoVO();
        vo.setCodigo(this.getCodigo());
        vo.setDescricao(this.getDescricao());
        vo.setFilial(this.getFilial());
        return vo;
    }

    public Set getParcelas() {
        return Collections.unmodifiableSet(this.parcelas);
    }

    public void setParcelas(Set parcelas) {
        this.parcelas = parcelas;
    }

    public void addParcela(FormaPagamentoParcelaBean parcela) {
        this.parcelas.add(parcela);
    }

    public void removeParcela(FormaPagamentoParcelaBean parcela) {
        this.parcelas.remove(parcela);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        result = 31 * result + (this.descricao == null ? 0 : this.descricao.hashCode());
        result = 31 * result + (this.filial == null ? 0 : this.filial.hashCode());
        result = 31 * result + (this.parcelas == null ? 0 : this.parcelas.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormaPagamentoBean other = (FormaPagamentoBean)obj;
        if (this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo)) {
            return false;
        }
        if (this.descricao == null ? other.descricao != null : !this.descricao.equals(other.descricao)) {
            return false;
        }
        if (this.filial == null ? other.filial != null : !this.filial.equals(other.filial)) {
            return false;
        }
        return !(this.parcelas == null ? other.parcelas != null : !this.parcelas.equals(other.parcelas));
    }
}

