/*
 * Decompiled with CFR 0.152.
 */
package jalis.model;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.FabricaDao;
import jalis.model.ThreadBeanDaoMultiplasChaves;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseFieldNotNull;
import jalis.model.utils.DataBaseFieldSerial;
import jalis.model.utils.DataBaseFieldSkipUpdate;
import jalis.model.utils.DataBaseForeignKey;
import jalis.model.utils.DataBaseMostImportantKey;
import jalis.model.utils.DataBaseMultipleKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.FieldDate;
import jalis.model.utils.FieldTime;
import jalis.model.utils.FieldTimeStamp;
import jalis.model.utils.FieldTransient;
import jalis.model.utils.JoinPermited;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.postgresql.util.PGInterval;

public abstract class AbstractThreadDao {
    public abstract AbstractThreadBean getBean(String var1) throws ThreadDaoException;

    public abstract AbstractThreadVO getVO(String var1) throws ThreadDaoException;

    public abstract AbstractThreadVO getVO(String var1, String var2) throws ThreadDaoException;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Integer getProximoCodigo(AbstractThreadBean bean) throws ThreadDaoException {
        Integer n;
        Class<?> cls = bean.getClass();
        if (!cls.isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + cls);
        }
        Statement st = null;
        try {
            String tabela = cls.getAnnotation(DataBaseTable.class).value();
            Field f = cls.getDeclaredField("filial");
            if (f == null) {
                throw new ThreadDaoException("Campo filial n\u00e3o definido para a classe: " + cls);
            }
            f.setAccessible(true);
            st = Conexao.getStatement();
            String s = DBUtil.getSequencia(st, tabela, AbstractThreadDao.getFieldValue(f, bean));
            n = Integer.parseInt(s);
        }
        catch (IllegalArgumentException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
                catch (IllegalAccessException e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
                catch (SecurityException e3) {
                    throw new ThreadDaoException(e3.getMessage());
                }
                catch (NoSuchFieldException e4) {
                    throw new ThreadDaoException(e4.getMessage());
                }
                catch (SQLException e5) {
                    throw new ThreadDaoException(e5.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return n;
    }

    protected static String getSql(Class cls, String where) throws ThreadDaoException {
        boolean isVO = false;
        boolean usarJoin = false;
        try {
            isVO = cls.newInstance() instanceof AbstractThreadVO;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!cls.isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + cls);
        }
        Field[] fields = cls.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + cls);
        }
        HashSet<String> campos = new HashSet<String>();
        ArrayList<String> joins = new ArrayList<String>();
        String tabelaPrincipal = cls.getAnnotation(DataBaseTable.class).value();
        for (Field f : fields) {
            if (!f.isAnnotationPresent(JoinPermited.class)) continue;
            usarJoin = true;
            break;
        }
        for (Field f : fields) {
            if (f.isAnnotationPresent(DataBaseField.class)) {
                campos.add((usarJoin ? tabelaPrincipal + "." : "") + f.getAnnotation(DataBaseField.class).value());
            }
            if (f.isAnnotationPresent(DataBaseMultipleKey.class)) {
                try {
                    Object obj = f.getType().newInstance();
                    if (!(obj instanceof AbstractThreadBean)) {
                        throw new ThreadDaoException(obj.getClass() + ", anotado como DataBaseMultipleKey, n\u00e3o \u00e9 um AbstractThreadBean");
                    }
                    campos.addAll(AbstractThreadDao.getPrimaryKeys((AbstractThreadBean)obj, usarJoin ? tabelaPrincipal + "." : null));
                }
                catch (IllegalAccessException e) {
                    throw new ThreadDaoException(e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new ThreadDaoException(e.getMessage());
                }
            }
            if (!isVO || !f.isAnnotationPresent(DataBaseForeignKey.class) || !f.isAnnotationPresent(JoinPermited.class)) continue;
            try {
                if (!(f.getType().newInstance() instanceof AbstractThreadVO)) continue;
                String tabelaJoin = Class.forName(f.getType().getName()).getAnnotation(DataBaseTable.class).value();
                String campoTabelaPrincipal = f.getAnnotation(DataBaseField.class).value();
                List<String> camposJoin = AbstractThreadDao.getPrimaryKeys((AbstractThreadVO)f.getType().newInstance(), null);
                StringBuilder bufJoin = new StringBuilder();
                for (String s : camposJoin) {
                    if (bufJoin.length() > 0) {
                        bufJoin.append(" and ");
                    }
                    bufJoin.append(tabelaPrincipal).append(".").append(s).append(" = ").append(tabelaJoin).append(".").append(s);
                }
                joins.add(" left join " + tabelaJoin + " on " + bufJoin.toString());
            }
            catch (Exception e) {
                throw new ThreadDaoException(f.getClass() + ", valor inv\u00e1lido para a liga\u00e7\u00e3o entre tabelas");
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(StringUtil.implode(campos, ", "));
        sql.append(" from ").append(tabelaPrincipal);
        if (joins.size() > 0 && usarJoin) {
            for (String s : joins) {
                sql.append(s);
            }
        }
        sql.append(" ");
        if (usarJoin) {
            StringTokenizer tokenizer = new StringTokenizer(where, " ,()<>=", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (Funcoes.textoVazio(token)) continue;
                if (token.equalsIgnoreCase(",") || token.equalsIgnoreCase("(") || token.equalsIgnoreCase(")") || token.equalsIgnoreCase("<") || token.equalsIgnoreCase(">") || token.equalsIgnoreCase("=")) {
                    sql.append(token);
                    continue;
                }
                boolean isCampo = false;
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].isAnnotationPresent(DataBaseField.class) || !token.equalsIgnoreCase(fields[i].getAnnotation(DataBaseField.class).value())) continue;
                    isCampo = true;
                    break;
                }
                if (isCampo) {
                    sql.append(tabelaPrincipal).append(".").append(token);
                } else {
                    sql.append(token);
                }
                sql.append(" ");
            }
        } else {
            sql.append(where);
        }
        return sql.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(AbstractThreadBean bean, String filial) throws ThreadDaoException {
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null) throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        if (fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        }
        StringBuilder sql = new StringBuilder();
        StringBuilder values = new StringBuilder();
        sql.append("insert into ").append(bean.getClass().getAnnotation(DataBaseTable.class).value()).append(" (");
        values.append(") values (");
        Statement st = Conexao.getStatement();
        try {
            int cont = 0;
            for (Field f : fields) {
                f.setAccessible(true);
                if (f.isAnnotationPresent(DataBaseFieldSerial.class) || !f.isAnnotationPresent(DataBaseField.class)) continue;
                if (cont > 0) {
                    sql.append(", ");
                    values.append(", ");
                }
                sql.append(f.getAnnotation(DataBaseField.class).value());
                values.append(AbstractThreadDao.getFieldValue(f, bean));
                ++cont;
            }
            sql.append(values.toString()).append(")");
            Conexao.executeUpdate(filial, st, sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
                catch (IllegalArgumentException e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
                catch (IllegalAccessException e3) {
                    throw new ThreadDaoException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(AbstractThreadBean bean, String filial) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Field> fields;
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        if (bean.getCamposAlterados() != null && bean.getCamposAlterados().size() > 0) {
            fields = new ArrayList();
            for (Field f : bean.getClass().getDeclaredFields()) {
                if (f.isAnnotationPresent(DataBaseFieldSkipUpdate.class) || !f.isAnnotationPresent(DataBasePrimaryKey.class) && !bean.getCamposAlterados().contains(f)) continue;
                fields.add(f);
            }
        } else {
            fields = new ArrayList<Field>();
            for (Field f : bean.getClass().getDeclaredFields()) {
                fields.add(f);
            }
        }
        if (fields == null) throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        if (fields.size() == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        }
        StringBuilder sql = new StringBuilder();
        StringBuilder where = new StringBuilder();
        sql.append("update ").append(bean.getClass().getAnnotation(DataBaseTable.class).value()).append(" set ");
        Statement st = null;
        try {
            int cont = 0;
            int contWhere = 0;
            for (Field f : fields) {
                if (f.isAnnotationPresent(DataBaseField.class) && !f.isAnnotationPresent(DataBasePrimaryKey.class) && !f.isAnnotationPresent(DataBaseFieldSkipUpdate.class)) {
                    if (cont > 0) {
                        sql.append(", ");
                    }
                    sql.append(f.getAnnotation(DataBaseField.class).value());
                    sql.append(" = ");
                    sql.append(AbstractThreadDao.getFieldValue(f, bean));
                    ++cont;
                    continue;
                }
                if (!f.isAnnotationPresent(DataBasePrimaryKey.class)) continue;
                if (contWhere > 0) {
                    where.append(" and ");
                }
                where.append(f.getAnnotation(DataBaseField.class).value());
                where.append(" = ");
                where.append(AbstractThreadDao.getFieldValue(f, bean));
                ++contWhere;
            }
            sql.append(" where ").append(where.toString());
            st = Conexao.getStatement();
            if (cont > 0) {
                Conexao.executeUpdate(filial, st, sql.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage() + "\n" + sql.toString());
                catch (IllegalArgumentException e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
                catch (IllegalAccessException e3) {
                    throw new ThreadDaoException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(AbstractThreadBean bean, String filial) throws ThreadDaoException {
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null) throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        if (fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ").append(bean.getClass().getAnnotation(DataBaseTable.class).value()).append(" where ");
        Statement st = null;
        try {
            int cont = 0;
            for (Field f : fields) {
                if (!f.isAnnotationPresent(DataBasePrimaryKey.class)) continue;
                if (cont > 0) {
                    sql.append(" and ");
                }
                sql.append(f.getAnnotation(DataBaseField.class).value());
                sql.append(" = ");
                sql.append(AbstractThreadDao.getFieldValue(f, bean));
                ++cont;
            }
            st = Conexao.getStatement();
            Conexao.executeUpdate(filial, st, sql.toString());
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
                catch (IllegalArgumentException e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
                catch (IllegalAccessException e3) {
                    throw new ThreadDaoException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public Set load(Class cls) throws ThreadDaoException {
        return AbstractThreadDao.load(cls, "");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set loadManual(Class cls, String sql) throws ThreadDaoException {
        HashSet<AbstractThreadBean> beans = new HashSet<AbstractThreadBean>();
        Statement st = null;
        try {
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                AbstractThreadBean b = (AbstractThreadBean)cls.getConstructors()[0].newInstance(new Object[0]);
                AbstractThreadDao.popularDadosBean(b, rs);
                beans.add(b);
            }
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
                catch (Exception e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return beans;
    }

    public static Set load(Class cls, String where) throws ThreadDaoException {
        return AbstractThreadDao.load(cls, where, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set load(Class cls, String where, Statement st) throws ThreadDaoException {
        boolean fecharStatement = false;
        HashSet<AbstractThreadBean> beans = new HashSet<AbstractThreadBean>();
        String sql = AbstractThreadDao.getSql(cls, where);
        try {
            if (st == null) {
                st = Conexao.getStatement();
                fecharStatement = true;
            }
            ResultSet rs = Conexao.executeQueryPerformance(st, sql.toString());
            while (rs.next()) {
                AbstractThreadBean b = (AbstractThreadBean)cls.getConstructors()[0].newInstance(new Object[0]);
                AbstractThreadDao.popularDadosBean(b, rs);
                beans.add(b);
            }
            if (!fecharStatement) return beans;
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage() + "\n" + sql.toString());
                catch (Exception e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                if (!fecharStatement) throw throwable;
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return beans;
    }

    public static Set load2(Class cls, String where, Statement st, String filialPadrao) throws ThreadDaoException {
        HashSet<AbstractThreadBean> beans = new HashSet<AbstractThreadBean>();
        String sql = AbstractThreadDao.getSql(cls, where);
        try {
            st.setPoolable(true);
            ResultSet rs = st.executeQuery(sql);
            while (rs.next()) {
                AbstractThreadBean b = (AbstractThreadBean)cls.getConstructors()[0].newInstance(new Object[0]);
                AbstractThreadDao.popularDadosBean(b, rs, filialPadrao);
                beans.add(b);
            }
        }
        catch (SQLException e) {
            throw new ThreadDaoException(e.getMessage() + "\n" + sql);
        }
        catch (Exception e) {
            throw new ThreadDaoException(e.getMessage());
        }
        return beans;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LinkedHashSet<AbstractThreadBean> loadOrdenado(Class cls, String where) throws ThreadDaoException {
        LinkedHashSet<AbstractThreadBean> beans = new LinkedHashSet<AbstractThreadBean>();
        String sql = AbstractThreadDao.getSql(cls, where);
        Statement st = null;
        try {
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                AbstractThreadBean b = (AbstractThreadBean)cls.getConstructors()[0].newInstance(new Object[0]);
                AbstractThreadDao.popularDadosBean(b, rs);
                beans.add(b);
            }
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage() + "\n" + sql);
                catch (Exception e2) {
                    throw new ThreadDaoException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return beans;
    }

    public Set loadVO(Class cls) throws ThreadDaoException {
        return this.loadVO(cls, "");
    }

    public Set loadVO(Class cls, String where) throws ThreadDaoException {
        return AbstractThreadDao.load(cls, where);
    }

    protected static AbstractThreadBean popularDadosBean(AbstractThreadBean bean, ResultSet rs) throws ThreadDaoException {
        return AbstractThreadDao.popularDadosBean(bean, rs, Variaveis.filialPadrao);
    }

    protected static AbstractThreadBean popularDadosBean(AbstractThreadBean bean, ResultSet rs, String filialPadrao) throws ThreadDaoException {
        Field[] fields = bean.getClass().getDeclaredFields();
        Method[] metodos = bean.getClass().getDeclaredMethods();
        if (fields == null || fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + (bean != null ? bean.getClass() : " (bean NULL) "));
        }
        try {
            String valorFilial = filialPadrao;
            for (Field f : fields) {
                int pos;
                String campo;
                if (f.isAnnotationPresent(FieldTransient.class) || !f.isAnnotationPresent(DataBaseField.class) || f.getAnnotation(DataBaseField.class) == null || !(campo = f.getAnnotation(DataBaseField.class).value()).equalsIgnoreCase("fil_codigo") || (pos = rs.findColumn(campo)) <= -1) continue;
                valorFilial = rs.getString(pos);
            }
            for (Field f : fields) {
                if (f.isAnnotationPresent(FieldTransient.class)) continue;
                StringBuilder nomeMetodo = new StringBuilder();
                nomeMetodo.append("set");
                nomeMetodo.append(f.getName().substring(0, 1).toUpperCase());
                nomeMetodo.append(f.getName().substring(1));
                Method metodo = null;
                for (Method m : metodos) {
                    m.setAccessible(true);
                    if (!m.getName().equalsIgnoreCase(nomeMetodo.toString())) continue;
                    metodo = m;
                    break;
                }
                if (metodo == null) continue;
                if (f.isAnnotationPresent(DataBaseField.class) && !f.isAnnotationPresent(DataBaseMultipleKey.class)) {
                    String nomeCampo = f.getAnnotation(DataBaseField.class).value();
                    f.setAccessible(true);
                    if (f.getType() == Integer.class || f.getType() == String.class || f.getType() == Boolean.class || f.getType() == java.util.Date.class || f.getType() == Long.class) {
                        try {
                            if (f.getType() == Long.class && rs.getObject(nomeCampo) instanceof Integer) {
                                metodo.invoke((Object)bean, Long.parseLong(rs.getString(nomeCampo)));
                            }
                            metodo.invoke((Object)bean, rs.getObject(nomeCampo));
                        }
                        catch (Exception e) {
                            throw new ThreadDaoException(e.getMessage() + " - M\u00e9todo = \"" + metodo.getName() + "\", valor = " + (nomeCampo == null ? "null" : "\"" + rs.getObject(nomeCampo) + "\""));
                        }
                    } else if (f.getType() == Double.class) {
                        metodo.invoke((Object)bean, new Double(rs.getDouble(nomeCampo)));
                    } else if (f.getType() == PGInterval.class) {
                        PGInterval interval = null;
                        if (rs.getDate(nomeCampo) != null) {
                            Date d = rs.getDate(nomeCampo);
                            Calendar c = Calendar.getInstance();
                            c.setTime(d);
                            interval = new PGInterval(0, 0, 0, c.get(11), c.get(12), (double)c.get(13));
                        }
                        metodo.invoke((Object)bean, interval);
                    } else if (f.getType() == Integer[].class) {
                        try {
                            Array aux = (Array)rs.getObject(nomeCampo);
                            if (aux == null) continue;
                            Object[] auxInt = (Object[])aux.getArray();
                            Integer[] lista = new Integer[auxInt.length];
                            for (int i = 0; i < auxInt.length; ++i) {
                                if (!Funcoes.isNumeric(auxInt[i].toString())) continue;
                                lista[i] = new Integer(auxInt[i].toString());
                            }
                            metodo.invoke((Object)bean, new Object[]{lista});
                        }
                        catch (Exception e) {
                            throw new ThreadDaoException(e.getMessage() + " - M\u00e9todo = \"" + metodo.getName() + "\", valor = " + (nomeCampo == null ? "null" : "\"" + rs.getObject(nomeCampo) + "\""));
                        }
                    } else if (f.getType() == BigDecimal.class) {
                        metodo.invoke((Object)bean, rs.getBigDecimal(nomeCampo));
                    } else {
                        Object obj = f.getType().newInstance();
                        String codigo = String.valueOf(rs.getObject(nomeCampo));
                        Object objDaSessao = null;
                        if (!Funcoes.textoVazio(codigo) && !codigo.equalsIgnoreCase("null") && Conexao.getSessaoConexao()) {
                            objDaSessao = Conexao.getObjetoDeSessao(obj.getClass().getName(), codigo);
                        }
                        if (objDaSessao != null) {
                            if (objDaSessao instanceof AbstractThreadVO) {
                                metodo.invoke((Object)bean, objDaSessao);
                            } else if (objDaSessao instanceof AbstractThreadBean) {
                                metodo.invoke((Object)bean, objDaSessao);
                            } else {
                                f.set(bean, null);
                            }
                        } else {
                            AbstractThreadDao dao = FabricaDao.criarDao((AbstractThreadBean)obj);
                            if (Funcoes.textoVazio(codigo) || codigo.equalsIgnoreCase("null")) {
                                f.set(bean, null);
                            } else if (obj instanceof AbstractThreadVO) {
                                AbstractThreadVO vo = dao.getVO(valorFilial, codigo);
                                if (vo != null) {
                                    metodo.invoke((Object)bean, vo);
                                } else {
                                    metodo.invoke((Object)bean, dao.getVO(codigo));
                                }
                            } else if (obj instanceof AbstractThreadBean) {
                                metodo.invoke((Object)bean, dao.getBean(codigo));
                            }
                        }
                    }
                }
                if (!f.isAnnotationPresent(DataBaseMultipleKey.class)) continue;
                f.setAccessible(true);
                Object obj = f.getType().newInstance();
                AbstractThreadDao dao = FabricaDao.criarDao((AbstractThreadBean)obj);
                if (obj instanceof AbstractThreadBean) {
                    AbstractThreadBean campoBean = (AbstractThreadBean)obj;
                    List<String> chavesPrimarias = AbstractThreadDao.getPrimaryKeys(campoBean, null);
                    if (chavesPrimarias.size() > 0) {
                        if (dao instanceof ThreadBeanDaoMultiplasChaves) {
                            ThreadBeanDaoMultiplasChaves daoMultiplaChaves = (ThreadBeanDaoMultiplasChaves)((Object)dao);
                            HashMap<String, Object> chavesValores = new HashMap<String, Object>();
                            boolean chavesPreenchidasOk = true;
                            for (String chave : chavesPrimarias) {
                                if (rs.getObject(chave) != null) {
                                    chavesValores.put(chave, rs.getObject(chave));
                                    continue;
                                }
                                if (f.isAnnotationPresent(DataBaseFieldNotNull.class)) {
                                    String msg = "O campo " + (chave != null ? chave : "(chave NULL)") + " (DataBasePrimaryKey da classe " + (obj != null && obj.getClass() != null ? obj.getClass().getSimpleName() : "(obj NULL)") + ") da classe " + (obj != null && obj.getClass() != null ? obj.getClass().getSimpleName() : "(obj NULL)") + " n\u00e3o tem valor";
                                    throw new ThreadDaoException(msg);
                                }
                                chavesPreenchidasOk = false;
                                break;
                            }
                            Object objDaSessao = null;
                            if (f.getAnnotation(DataBaseField.class) == null) {
                                f.setAccessible(true);
                                throw new ThreadDaoException("O m\u00e9todo \"" + f.getName() + "\" n\u00e3o possui anota\u00e7\u00e3o de nome do campo.\nClasse \"" + bean.getClass() + "\".");
                            }
                            String nomeCampo = f.getAnnotation(DataBaseField.class).value();
                            String codigo = String.valueOf(rs.getObject(nomeCampo));
                            if (!Funcoes.textoVazio(codigo) && !Funcoes.textoVazio(nomeCampo) && !codigo.equalsIgnoreCase("null") && Conexao.getSessaoConexao()) {
                                objDaSessao = Conexao.getObjetoDeSessao(obj.getClass().getName(), codigo);
                            }
                            if (objDaSessao != null) {
                                if (objDaSessao instanceof AbstractThreadVO) {
                                    metodo.invoke((Object)bean, objDaSessao);
                                    continue;
                                }
                                if (objDaSessao instanceof AbstractThreadBean) {
                                    metodo.invoke((Object)bean, objDaSessao);
                                    continue;
                                }
                                f.set(bean, null);
                                continue;
                            }
                            if (chavesPreenchidasOk) {
                                if (obj instanceof AbstractThreadVO) {
                                    metodo.invoke((Object)bean, daoMultiplaChaves.getVO(chavesValores));
                                    continue;
                                }
                                if (!(obj instanceof AbstractThreadBean)) continue;
                                metodo.invoke((Object)bean, daoMultiplaChaves.getBean(chavesValores));
                                continue;
                            }
                            f.set(bean, null);
                            continue;
                        }
                        throw new ThreadDaoException("A classe " + (obj != null && obj.getClass() != null ? obj.getClass().getSimpleName() : "(obj NULL)") + " deve  implementar ThreadBeanDaoMultiplasChaves");
                    }
                    throw new ThreadDaoException("Nenhuma chave prim\u00e1ria encontrada em " + (obj != null ? obj.getClass() : " (objeto NULL)"));
                }
                throw new ThreadDaoException((obj != null ? obj.getClass() : "(obj NULL)") + ", anotado como DataBaseMultipleKey, n\u00e3o \u00e9 um AbstractThreadBean");
            }
            bean.clearCamposAlterados();
        }
        catch (IllegalArgumentException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        catch (SQLException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        if (Conexao.getSessaoConexao()) {
            try {
                if (Conexao.getHashMapSessao().get(bean.getClass().getName()) == null) {
                    Conexao.getHashMapSessao().put(bean.getClass().getName(), new HashMap());
                }
                Conexao.getHashMapSessao().get(bean.getClass().getName()).put(bean.gerarChavePrimaryKeys(), bean);
            }
            catch (Exception e) {
                throw new ThreadDaoException(e.getMessage());
            }
        }
        return bean;
    }

    private static List<String> getPrimaryKeys(AbstractThreadBean bean, String nomeTabela) throws ThreadDaoException {
        ArrayList<String> keys = new ArrayList<String>();
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        }
        try {
            for (Field campo : fields) {
                campo.setAccessible(true);
                if (!campo.isAnnotationPresent(DataBasePrimaryKey.class) || !campo.isAnnotationPresent(DataBaseField.class)) continue;
                keys.add((nomeTabela != null ? nomeTabela : "") + campo.getAnnotation(DataBaseField.class).value());
            }
        }
        catch (IllegalArgumentException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        if (keys.size() == 0) {
            throw new ThreadDaoException("Nenhuma chave prim\u00e1ria encontrada para classe: " + bean.getClass());
        }
        return keys;
    }

    private static String getForeingKeyValue(AbstractThreadBean bean) throws ThreadDaoException {
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        }
        try {
            for (Field f : fields) {
                f.setAccessible(true);
                if (!f.isAnnotationPresent(DataBasePrimaryKey.class) || f.isAnnotationPresent(DataBaseForeignKey.class)) continue;
                return AbstractThreadDao.getFieldValue(f, bean);
            }
            for (Field f : fields) {
                f.setAccessible(true);
                if (!f.isAnnotationPresent(DataBaseMostImportantKey.class)) continue;
                return AbstractThreadDao.getForeingKeyValue((AbstractThreadBean)f.get(bean));
            }
            throw new ThreadDaoException("Chave prim\u00e1ria n\u00e3o encontrada para classe: " + bean.getClass());
        }
        catch (IllegalArgumentException e) {
            throw new ThreadDaoException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ThreadDaoException(e.getMessage());
        }
    }

    public static String getFieldValue(Field f, AbstractThreadBean bean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        f.setAccessible(true);
        if (f.get(bean) == null) {
            return "null";
        }
        if (f.getType() == Long.class) {
            return ((Long)f.get(bean)).toString();
        }
        if (f.getType() == Integer.class) {
            return ((Integer)f.get(bean)).toString();
        }
        if (f.getType() == Boolean.class) {
            return (Boolean)f.get(bean) == true ? " true " : " false ";
        }
        if (f.getType() == String.class) {
            return StringUtil.textoDBEscape(f.get(bean).toString());
        }
        if (f.getType() == Double.class) {
            String d = Double.toString((Double)f.get(bean));
            d = d.replaceAll("\\,", "\\.");
            return d;
        }
        if (f.getType() == BigDecimal.class) {
            return ((BigDecimal)f.get(bean)).toString();
        }
        if (f.getType() == java.util.Date.class) {
            String data = "";
            String formato = "";
            if (f.isAnnotationPresent(FieldDate.class)) {
                formato = "MM/dd/yyyy";
            } else if (f.isAnnotationPresent(FieldTime.class)) {
                formato = "HH:mm:ss";
            } else if (f.isAnnotationPresent(FieldTimeStamp.class)) {
                formato = "MM/dd/yyyy HH:mm:ss";
            } else {
                throw new ThreadDaoException("O Campo " + f.getName() + " n\u00e3o possui tipo de data atribu\u00eddo");
            }
            data = "'" + Funcoes.formataData(formato, (java.util.Date)f.get(bean)) + "'";
            return data;
        }
        if (f.getType() == Integer[].class) {
            return "'{" + StringUtil.arrayParaString((Integer[])f.get(bean)) + "}'";
        }
        if (f.isAnnotationPresent(DataBaseForeignKey.class)) {
            Object obj = f.get(bean);
            if (obj instanceof AbstractThreadBean) {
                return AbstractThreadDao.getForeingKeyValue((AbstractThreadBean)obj);
            }
        } else if (f.isAnnotationPresent(DataBaseFieldNotNull.class)) {
            Object obj = f.get(bean);
            if (obj == null) {
                throw new ThreadDaoException("O Campo " + f.getName() + " n\u00e3o possui valor atribu\u00eddo");
            }
            if (obj != null && obj instanceof AbstractThreadBean) {
                return AbstractThreadDao.getForeingKeyValue((AbstractThreadBean)obj);
            }
        }
        return "";
    }

    public AbstractThreadBean voToBean(AbstractThreadVO vo, Class classeBean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        String where = AbstractThreadDao.getWhere(vo);
        HashSet beans = (HashSet)AbstractThreadDao.load(classeBean, where);
        if (beans == null || beans.size() != 1) {
            return null;
        }
        return (AbstractThreadBean)beans.toArray()[0];
    }

    protected String getValorParaBanco(Object valor) {
        boolean aspas = !(valor instanceof Integer) && !(valor instanceof BigInteger) && !(valor instanceof Long);
        return aspas ? StringUtil.textoDBEscape(String.valueOf(valor)) : String.valueOf(valor);
    }

    public static String getWhere(AbstractThreadBean bean) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        StringBuilder where = new StringBuilder();
        where.append(" where ");
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            throw new ThreadDaoException("Campos n\u00e3o definidos para a classe: " + bean.getClass());
        }
        int cont = 0;
        for (Field f : fields) {
            if (!f.isAnnotationPresent(DataBaseField.class) || !f.isAnnotationPresent(DataBasePrimaryKey.class)) continue;
            if (cont > 0) {
                where.append(" and ");
            }
            where.append(f.getAnnotation(DataBaseField.class).value());
            where.append(" = ");
            where.append(AbstractThreadDao.getFieldValue(f, bean));
            ++cont;
        }
        return where.toString();
    }

    @Deprecated
    public void atualizarValorSequence(String sequence, String valor) throws ThreadDaoException {
        StringBuilder buf = new StringBuilder();
        buf.append("select setval('").append(sequence).append("', ");
        buf.append(valor);
        buf.append(")");
        Statement st = null;
        try {
            st = Conexao.getStatement();
            Conexao.execute(st, buf.toString());
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public int ultimoValorSequence(String sequence) throws ThreadDaoException {
        int retorno = -1;
        StringBuilder buf = new StringBuilder();
        buf.append(" select nextval('").append(sequence).append("') ");
        Statement st = null;
        try {
            st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                retorno = rs.getInt("nextval");
            }
        }
        catch (SQLException e) {
            try {
                throw new ThreadDaoException(e.getMessage());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static Object getValorCampo(AbstractThreadBean bean, String campoBanco) throws IllegalArgumentException, IllegalAccessException {
        if (bean == null || Funcoes.textoVazio(campoBanco)) {
            return null;
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return null;
        }
        for (Field f : fields) {
            if (!f.isAnnotationPresent(DataBaseField.class) || !f.getAnnotation(DataBaseField.class).value().equalsIgnoreCase(campoBanco)) continue;
            f.setAccessible(true);
            return f.get(bean);
        }
        return null;
    }

    public static java.util.Date dataServidor() throws SQLException {
        Timestamp dataAtual = null;
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery("select current_timestamp");
            if (rs.next()) {
                dataAtual = rs.getTimestamp(1);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return dataAtual;
    }
}

