/*
 * Decompiled with CFR 0.152.
 */
package jalis.model;

import jalis.model.AbstractThreadDao;
import jalis.model.utils.DataBaseField;
import jalis.model.utils.DataBaseMostImportantKey;
import jalis.model.utils.DataBasePrimaryKey;
import jalis.model.utils.ThreadDaoException;
import java.lang.reflect.Field;
import java.util.ArrayList;

public abstract class AbstractThreadBean {
    private ArrayList<Field> camposAlterados = new ArrayList();
    private Field[] fields = this.getClass().getDeclaredFields();

    public abstract AbstractThreadBean toVO();

    public void addCampoAlterado(String field) {
        Field f = this.getFieldByName(field);
        if (f != null) {
            this.camposAlterados.add(f);
        }
    }

    private Field getFieldByName(String field) {
        for (Field f : this.fields) {
            if (!f.getName().equalsIgnoreCase(field)) continue;
            return f;
        }
        return null;
    }

    public Field getFieldByColumnName(String coluna) {
        for (Field f : this.fields) {
            if (!f.isAnnotationPresent(DataBaseField.class) || !f.getAnnotation(DataBaseField.class).value().equalsIgnoreCase(coluna)) continue;
            return f;
        }
        return null;
    }

    public ArrayList<Field> getCamposAlterados() {
        return this.camposAlterados;
    }

    public void clearCamposAlterados() {
        this.camposAlterados.clear();
    }

    public AbstractThreadBean clonar() {
        AbstractThreadBean clone = null;
        Class<?> cls = this.getClass();
        try {
            clone = (AbstractThreadBean)cls.newInstance();
            Field[] camposOrigem = cls.getDeclaredFields();
            Field[] camposDestino = clone.getClass().getDeclaredFields();
            block3: for (Field fOrigem : camposOrigem) {
                fOrigem.setAccessible(true);
                for (Field fDestino : camposDestino) {
                    fDestino.setAccessible(true);
                    if (!fOrigem.getName().equalsIgnoreCase(fDestino.getName())) continue;
                    fDestino.set(clone, fOrigem.get(this));
                    continue block3;
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (this.camposAlterados.size() > 0 && clone != null) {
            clone.camposAlterados = this.camposAlterados;
        }
        return clone;
    }

    public boolean isChavesPrimariasNaoPreenchidas() {
        Field[] campos;
        for (Field f : campos = this.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(DataBasePrimaryKey.class)) continue;
            f.setAccessible(true);
            try {
                if (f.get(this) != null) continue;
                return true;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object getValorPrimaryKey() throws Exception {
        String coluna = this.getFieldPrimaryKey();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(DataBaseField.class)) continue;
            f.setAccessible(true);
            if (!f.getAnnotation(DataBaseField.class).value().equalsIgnoreCase(coluna)) continue;
            return f.get(this);
        }
        return null;
    }

    public String getFieldPrimaryKey() {
        for (Field f : this.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(DataBaseMostImportantKey.class)) continue;
            f.setAccessible(true);
            return f.getAnnotation(DataBaseField.class).value();
        }
        return null;
    }

    public String gerarChavePrimaryKeys() throws IllegalArgumentException, ThreadDaoException, IllegalAccessException {
        String chave = "";
        for (Field f : this.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(DataBasePrimaryKey.class)) continue;
            f.setAccessible(true);
            chave = chave + AbstractThreadDao.getFieldValue(f, this);
        }
        return chave;
    }
}

