/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.mensagens.IAvisaMensagens;
import jalis.mensagens.TelaAviso;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.Timer;

public class VerificaMensagens
extends Timer {
    private static final int TEMPO = 60000;
    private static ArrayList<IAvisaMensagens> listener = new ArrayList();
    private static ArrayList<Integer> mensagensAvisadas = new ArrayList();

    public VerificaMensagens(final JFrame owner) {
        super(60000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Statement st;
                block9: {
                    st = Conexao.getStatement();
                    try {
                        String p = ParametrosUsuarios.getValor("mensagens");
                        boolean naoMostrarMinhasMensagens = !Funcoes.textoVazio(StringUtil.getValor(p, "ocultarMinhasMensagens")) && StringUtil.getValor(p, "ocultarMinhasMensagens").equals("1");
                        StringBuilder buf = new StringBuilder();
                        if (naoMostrarMinhasMensagens) {
                            buf.append("select ume_codigo from usuariomensagem where usr_coddestino = '");
                            buf.append(Variaveis.login);
                            buf.append("' and ume_avisada = false and usr_coddestino = usr_codorigem ");
                            ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
                            while (rs.next()) {
                                if (mensagensAvisadas.contains(rs.getInt("ume_codigo"))) continue;
                                mensagensAvisadas.add(rs.getInt("ume_codigo"));
                            }
                        }
                        buf.delete(0, buf.length());
                        buf.append("select ume_codigo, ume_tipo from usuariomensagem where usr_coddestino = '");
                        buf.append(Variaveis.login);
                        buf.append("' and ume_avisada = false ");
                        if (naoMostrarMinhasMensagens) {
                            buf.append(" and usr_coddestino <> usr_codorigem ");
                        }
                        int contagem = 0;
                        ResultSet rs = Conexao.executeQueryPerformance(st, buf);
                        String tipoMensagem = "C";
                        while (rs.next()) {
                            tipoMensagem = rs.getString("ume_tipo");
                            if (mensagensAvisadas.contains(rs.getInt("ume_codigo"))) continue;
                            ++contagem;
                            mensagensAvisadas.add(rs.getInt("ume_codigo"));
                        }
                        if (contagem <= 0) break block9;
                        VerificaMensagens.mostraAviso(owner, "Voc\u00ea tem " + String.valueOf(contagem) + (contagem > 1 ? " novas mensagens" : " nova mensagem"), tipoMensagem);
                        for (IAvisaMensagens o : listener) {
                            o.novaMensagemRecebida();
                        }
                    }
                    catch (Exception ex) {
                        try {
                            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "VerificaMensagens (62)");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
            }
        });
    }

    public void addAvisaMensagem(IAvisaMensagens l) {
        if (!listener.contains(l)) {
            listener.add(l);
        }
    }

    public void removeAvisaMensagem(IAvisaMensagens l) {
        listener.remove(l);
    }

    public void removeAllAvisaMensagem() {
        listener.clear();
    }

    public static void mostraAviso(JFrame owner, String mensagem) {
        VerificaMensagens.mostraAviso(owner, mensagem, "C");
    }

    public static void mostraAviso(JFrame owner, String mensagem, String tipo) {
        if (Funcoes.textoVazio(Variaveis.login)) {
            return;
        }
        Color cor = Color.GREEN;
        if (tipo.equals("E")) {
            cor = Color.YELLOW;
        } else if (tipo.equals("R")) {
            cor = Color.ORANGE;
        } else if (tipo.equals("N")) {
            cor = new Color(128, 255, 0);
        }
        TelaAviso aviso = new TelaAviso(owner, cor);
        aviso.setTipo(2);
        VerificaMensagens.mostrar(aviso, owner, mensagem);
    }

    public static void mostraErro(JFrame owner, String mensagem) {
        if (Funcoes.textoVazio(Variaveis.login) || owner == null || mensagem == null || Funcoes.textoVazio(mensagem)) {
            return;
        }
        TelaAviso aviso = new TelaAviso(owner, Color.RED);
        aviso.setTipo(1);
        VerificaMensagens.mostrar(aviso, owner, mensagem);
    }

    public static void mostraAlarmeCompromisso(JFrame owner, String mensagem) {
        if (Funcoes.textoVazio(Variaveis.login)) {
            return;
        }
        TelaAviso aviso = new TelaAviso(owner, Color.GREEN);
        aviso.setTipo(3);
        VerificaMensagens.mostrar(aviso, owner, mensagem);
    }

    private static void mostrar(TelaAviso tela, JFrame owner, String mensagem, Color cor) {
        tela.setLocationRelativeTo(owner);
        tela.setSize(new Dimension(150, 160));
        int posOwnerX = owner.getX();
        int posOwnerY = owner.getY();
        if (cor != null) {
            tela.setColor(cor);
        }
        tela.setMensagem(mensagem);
        tela.setLocation(posOwnerX + owner.getWidth() - 155, posOwnerY + owner.getHeight() - 165);
        tela.setVisible(true);
    }

    private static void mostrar(TelaAviso tela, JFrame owner, String mensagem) {
        VerificaMensagens.mostrar(tela, owner, mensagem, null);
    }

    public void gravarAvisadas(Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        for (Integer i : mensagensAvisadas) {
            buf.setLength(0);
            buf.append("update usuariomensagem set ume_avisada = true where ume_codigo = ");
            buf.append(i).append("  and ume_avisada = false ");
            Conexao.execute(Variaveis.filialPadrao, st, buf);
        }
        mensagensAvisadas.clear();
    }
}

