/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.mensagens.LerMensagem;
import jalis.mensagens.MarcarLida;
import jalis.mensagens.NovaMensagem;
import jalis.mensagens.ObjetoContato;
import jalis.mensagens.PedirImpressora;
import jalis.mensagens.RenderTabela;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.ImpressaoTexto;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TelaMensagens
extends FrmPadrao
implements ActionListener {
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Mensagens");
    private DefaultMutableTreeNode recebidas = new DefaultMutableTreeNode("Recebidas");
    private DefaultMutableTreeNode enviadas = new DefaultMutableTreeNode("Enviadas");
    private JTree treePastas = new JTree(this.root);
    private DefaultListModel modeloLista = new DefaultListModel();
    private JList listaContatos = new JList(this.modeloLista);
    private JScrollPane scrollContatos = new JScrollPane(this.listaContatos);
    private ModeloGridTable modeloMensagens = new ModeloGridTable(new String[]{"De", "Data/Hora", "Assunto"});
    private JTable tableMensagens = new JTable(this.modeloMensagens);
    private JScrollPane scrollMensagens = new JScrollPane(this.tableMensagens);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JTextPane txtMensagem = new JTextPane();
    private JScrollPane scrollMensagem = new JScrollPane(this.txtMensagem);
    private JPanel panelAtalhos = new JPanel(new GridBagLayout());
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonNovo = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonLer = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonImprimir = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonExcluir = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonResponder = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonEncaminhar = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonMarcarLidas = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonMarcarNaoLidas = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private TTextField textLocalizar = ComponenteFactory.novoTTextField(100, 3, null, null, "Digite para Localizar", "", null);
    private JPanel panelLocalizar = new JPanel(new GridBagLayout());
    private JLabel labelLocalizar = ComponenteFactory.novoJLabel("Localizar:", 'O', null, this.textLocalizar);
    private JComboBox comboLocalizar = ComponenteFactory.novoJComboBox(new String[]{"Assunto", "Usu\u00e1rio", "Mensagem"}, null);
    private JButton buttonBuscar = ComponenteFactory.novoJButton("Buscar", 'U', this, null, null);
    private JButton buttonLimparPesquisa = ComponenteFactory.novoJButton("Limpar pesquisa", 'p', this, null, null);
    private JPanel painelMensagens = new JPanel(new BorderLayout());
    private TitledBorder titledBorderMensagens = new TitledBorder("Mensagens");
    private static final long ACESSO_EXCLUIR = Long.parseLong("1101001001");
    private static final int RECEBIDAS = 1;
    private static final int ENVIADAS = 2;
    private static final int COLUNA_DATA = 1;
    private static final int COLUNA_ASSUNTO = 2;
    private static final int COLUNA_CODIGO = 3;
    private static final int COLUNA_SITUACAO = 4;
    private static final int COLUNA_MENSAGEM = 5;
    private static final int COLUNA_USUARIO_ORIGEM = 6;
    private static final int COLUNA_CONFIRMAR_LEITURA = 7;
    private static final int COLUNA_TIPO = 8;
    private static final String SITUACAO_LIDAS = "R";
    private static final String LISTAR_USUARIO = "Usu\u00e1rio";
    private static final String LISTAR_ASSUNTO = "Assunto";
    private static final String LISTAR_MENSAGEM = "Mensagem";
    public static final String DEFAULT = "C";
    private String no;
    private MarcarLida marcarLida = new MarcarLida(2000, this.tableMensagens, this.modeloMensagens, 4);

    public TelaMensagens() {
        this.montaTela();
        Statement st = Conexao.getStatement();
        try {
            this.buscaUsuarios(st);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TelaMensagens (52)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        this.tableMensagens.setDefaultRenderer(Object.class, new RenderTabela());
        this.treePastas.setSelectionRow(1);
        ScreenUtil.requisitarFoco(this.treePastas);
        this.listaMensagens(1);
        this.listaContatos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TelaMensagens.this.listaContatos.getSelectedValue() != null && TelaMensagens.this.listaContatos.getSelectedValue() instanceof ObjetoContato) {
                    TelaMensagens.this.enviarMensagem(((ObjetoContato)TelaMensagens.this.listaContatos.getSelectedValue()).getLogin());
                }
            }
        });
        this.listaContatos.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && TelaMensagens.this.listaContatos.getSelectedValue() != null && TelaMensagens.this.listaContatos.getSelectedValue() instanceof ObjetoContato) {
                    TelaMensagens.this.enviarMensagem(((ObjetoContato)TelaMensagens.this.listaContatos.getSelectedValue()).getLogin());
                }
            }
        });
        this.treePastas.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TelaMensagens.this.no = e.getPath().getLastPathComponent().toString();
                if (TelaMensagens.this.no.equals(TelaMensagens.this.recebidas.toString())) {
                    TelaMensagens.this.listaMensagens(1);
                } else if (TelaMensagens.this.no.equals(TelaMensagens.this.enviadas.toString())) {
                    TelaMensagens.this.listaMensagens(2);
                } else {
                    TelaMensagens.this.listaMensagens(1);
                }
            }
        });
        this.tableMensagens.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TelaMensagens.this.tableMensagens.getSelectedRow() > -1 && TelaMensagens.this.modeloMensagens.getValueAt(TelaMensagens.this.tableMensagens.getSelectedRow(), 5) != null) {
                    TelaMensagens.this.txtMensagem.setText(TelaMensagens.this.modeloMensagens.getValueAt(TelaMensagens.this.tableMensagens.getSelectedRow(), 5).toString());
                    ScreenUtil.posicionaTextoTopo(TelaMensagens.this.txtMensagem);
                    if (TelaMensagens.this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(TelaMensagens.this.recebidas.toString()) && (TelaMensagens.this.modeloMensagens.getValueAt(TelaMensagens.this.tableMensagens.getSelectedRow(), 4) == null || Funcoes.textoVazio(TelaMensagens.this.modeloMensagens.getValueAt(TelaMensagens.this.tableMensagens.getSelectedRow(), 4).toString()))) {
                        int linha = TelaMensagens.this.tableMensagens.getSelectedRow();
                        TelaMensagens.this.marcarLida.setCodigoMensagem(Integer.parseInt(TelaMensagens.this.modeloMensagens.getValueAt(linha, 3).toString()), linha, (Boolean)TelaMensagens.this.modeloMensagens.getValueAt(linha, 7), TelaMensagens.this.modeloMensagens.getValueAt(linha, 6).toString(), TelaMensagens.this.modeloMensagens.getValueAt(linha, 2).toString());
                    } else if (TelaMensagens.this.marcarLida.isRunning()) {
                        TelaMensagens.this.marcarLida.stop();
                    }
                }
            }
        });
        this.tableMensagens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TelaMensagens.this.tableMensagens.getSelectedRow() > -1) {
                    TelaMensagens.this.lerMensagem(TelaMensagens.this.tableMensagens.getSelectedRow());
                }
            }
        });
        this.buttonBuscar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaMensagens.this.localizar();
            }
        });
        this.buttonLimparPesquisa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaMensagens.this.limparPequisa();
            }
        });
    }

    private void enviarMensagem(String login) {
        NovaMensagem nova = new NovaMensagem((JFrame)this.getTopLevelAncestor());
        if (!Funcoes.textoVazio(login)) {
            nova.setUsuarioDestino(login);
        }
        nova.setVisible(true);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1101001000");
    }

    private void montaTela() {
        this.setName("TelaMensagens");
        this.root.add(this.recebidas);
        this.root.add(this.enviadas);
        this.treePastas.setName("treePastas");
        this.treePastas.setShowsRootHandles(false);
        this.treePastas.expandPath(new TreePath(this.root));
        this.txtMensagem.setEditable(false);
        this.txtMensagem.setName("txtMensagem");
        this.modeloMensagens.setColumnSize(new int[]{80, 120, 0}, this.tableMensagens);
        this.listaContatos.setName("listaContatos");
        this.listaContatos.setFont(new Font(this.listaContatos.getFont().getName(), 0, this.listaContatos.getFont().getSize()));
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Enviadas/Recebidas", "Mensagens enviadas ou recebidas pelo usu\u00e1rio", "mensagem/mensagem_enviada_recebida.jpg");
        this.listaContatos.setToolTipText("<html>Duplo clique ou barra de espa\u00e7os para enviar uma nova mensagem</html>");
        this.listaContatos.setSelectionMode(0);
        JPanel panelCentro = new JPanel(new GridBagLayout());
        panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        panelCentro.setName("panelCentro");
        this.add((Component)panelCentro, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridwidth = 25;
        c.gridy = 0;
        c.weightx = 1.0;
        this.panelAtalhos.setMinimumSize(new Dimension(900, 110));
        this.panelAtalhos.setPreferredSize(new Dimension(900, 110));
        panelCentro.add((Component)this.panelAtalhos, c);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonAtualizar.setName("buttonAtualizar");
        this.panelAtalhos.add(this.buttonAtualizar);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonNovo.setName("buttonNovo");
        this.panelAtalhos.add(this.buttonNovo);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonLer.setName("buttonLer");
        this.panelAtalhos.add(this.buttonLer);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.panelAtalhos.add(this.buttonImprimir);
        if (Acesso.getAcesso(ACESSO_EXCLUIR)) {
            ++c.gridx;
            c.gridy = 0;
            c.gridwidth = 1;
            this.buttonExcluir.setName("buttonExcluir");
            this.panelAtalhos.add(this.buttonExcluir);
        }
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonResponder.setName("buttonResponder");
        this.panelAtalhos.add(this.buttonResponder);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonEncaminhar.setName("buttonEncaminhar");
        this.panelAtalhos.add(this.buttonEncaminhar);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonMarcarLidas.setName("buttonMarcarLidas");
        this.panelAtalhos.add(this.buttonMarcarLidas);
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        this.buttonMarcarNaoLidas.setName("buttonMarcarNaoLidas");
        this.panelAtalhos.add(this.buttonMarcarNaoLidas);
        this.buttonAtualizar.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_atualizar.jpg"));
        this.buttonNovo.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_nova.jpg"));
        this.buttonLer.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_ler.jpg"));
        this.buttonImprimir.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_imprimir.jpg"));
        this.buttonExcluir.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_excluir.jpg"));
        this.buttonMarcarLidas.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_lidas.jpg"));
        this.buttonMarcarNaoLidas.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_nao_lidas.jpg"));
        this.buttonResponder.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_responder.jpg"));
        this.buttonEncaminhar.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_encaminhadas.jpg"));
        this.panelLocalizar.setBorder(new TitledBorder("Pesquisar mensagens"));
        GridBagConstraints pa = new GridBagConstraints();
        Insets insetsEsquerda = new Insets(1, 1, 0, 0);
        Dimension dim = new Dimension(80, 20);
        Dimension dimMinima = new Dimension(20, 20);
        pa.fill = 0;
        pa.insets = insetsEsquerda;
        pa.gridx = 0;
        pa.gridy = 0;
        pa.gridwidth = 1;
        pa.insets = new Insets(5, 1, 5, 0);
        this.panelLocalizar.add((Component)this.labelLocalizar, pa);
        this.labelLocalizar.setMinimumSize(dimMinima);
        ++pa.gridx;
        pa.gridy = 0;
        pa.gridwidth = 1;
        this.comboLocalizar.setName("comboLocalizar");
        this.panelLocalizar.add((Component)this.comboLocalizar, pa);
        this.comboLocalizar.setPreferredSize(new Dimension(90, 20));
        pa.fill = 1;
        pa.gridwidth = 1;
        ++pa.gridx;
        pa.gridy = 0;
        pa.weightx = 1.0;
        this.textLocalizar.setName("textLocalizar");
        this.panelLocalizar.add((Component)this.textLocalizar, pa);
        pa.weightx = -8.0;
        ++pa.gridx;
        pa.gridy = 0;
        pa.gridwidth = 1;
        this.buttonBuscar.setName("buttonBuscar");
        this.panelLocalizar.add((Component)this.buttonBuscar, pa);
        this.buttonBuscar.setPreferredSize(dim);
        ++pa.gridx;
        pa.gridy = 0;
        pa.gridwidth = 1;
        this.panelLocalizar.add((Component)this.buttonLimparPesquisa, pa);
        this.buttonLimparPesquisa.setName("buttonLimparPesquisa");
        this.buttonLimparPesquisa.setEnabled(false);
        this.buttonLimparPesquisa.setPreferredSize(new Dimension(120, 20));
        c.fill = 2;
        ++c.gridx;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.panelAtalhos.add((Component)new JPanel(), c);
        int totalColunas = c.gridx + 1;
        c.fill = 2;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = totalColunas;
        this.panelLocalizar.setName("panelLocalizar");
        this.panelAtalhos.add((Component)this.panelLocalizar, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        JPanel p1 = new JPanel(new BorderLayout());
        p1.setBorder(new TitledBorder("Pastas"));
        p1.setPreferredSize(new Dimension(200, 100));
        p1.setMinimumSize(p1.getPreferredSize());
        p1.add((Component)this.treePastas, "Center");
        panelCentro.add((Component)p1, c);
        c.gridy = 2;
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(new TitledBorder("Contatos"));
        p2.setPreferredSize(new Dimension(200, 100));
        p2.setMinimumSize(p2.getPreferredSize());
        p2.add((Component)this.scrollContatos, "Center");
        panelCentro.add((Component)p2, c);
        c.gridy = 1;
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.painelMensagens.setBorder(this.titledBorderMensagens);
        this.painelMensagens.setPreferredSize(new Dimension(100, 100));
        this.painelMensagens.setMinimumSize(this.painelMensagens.getPreferredSize());
        this.painelMensagens.add((Component)this.scrollMensagens, "Center");
        panelCentro.add((Component)this.painelMensagens, c);
        c.gridy = 2;
        JPanel p4 = new JPanel(new BorderLayout());
        p4.setBorder(new TitledBorder(LISTAR_MENSAGEM));
        p4.setPreferredSize(new Dimension(100, 100));
        p4.setMinimumSize(p4.getPreferredSize());
        p4.add((Component)this.scrollMensagem, "Center");
        panelCentro.add((Component)p4, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.setName("panelBotoes");
        this.buttonFechar.setName("buttonFechar");
        panelBotoes.add(this.buttonFechar);
        ++c.gridx;
        c.gridy = 3;
        c.gridwidth = 2;
        c.fill = 2;
        c.weighty = 0.0;
        panelCentro.add((Component)panelBotoes, c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonNovo) {
            this.enviarMensagem("");
        } else if (e.getSource() == this.buttonAtualizar) {
            this.listaMensagens(this.treePastas.getSelectionPath() != null && this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) ? 2 : 1);
        } else if (e.getSource() == this.buttonEncaminhar || e.getSource() == this.buttonResponder) {
            if (this.tableMensagens.getSelectedRow() > -1) {
                NovaMensagem nova = new NovaMensagem((JFrame)this.getTopLevelAncestor());
                nova.setAssunto((e.getSource() == this.buttonResponder ? "Re:" : "") + this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 2).toString());
                nova.setMensagem((e.getSource() == this.buttonResponder ? "\n\n" + Funcoes.preencheVazio("", "=", 40, 2) + "\n" : "") + this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 5).toString());
                nova.setTipoMensagem(this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 8).toString());
                if (e.getSource() == this.buttonResponder) {
                    nova.setUsuarioDestino(this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 6).toString());
                }
                nova.setVisible(true);
            }
        } else if (e.getSource() == this.buttonLer && this.tableMensagens.getSelectedRow() > -1) {
            this.lerMensagem(this.tableMensagens.getSelectedRow());
        } else if (e.getSource() == this.buttonMarcarLidas && this.tableMensagens.getSelectedRow() > -1) {
            this.marcarDesmarcaLidas(this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) ? 2 : 1, SITUACAO_LIDAS);
        } else if (e.getSource() == this.buttonMarcarNaoLidas && this.tableMensagens.getSelectedRow() > -1) {
            this.marcarDesmarcaLidas(this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) ? 2 : 1, null);
        } else if (e.getSource() == this.buttonExcluir && this.tableMensagens.getSelectedRow() > -1 && this.treePastas.getSelectionPath() != null) {
            this.excluirMensagem(this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) ? 2 : 1);
        }
        if (e.getSource() == this.buttonImprimir && this.tableMensagens.getSelectedRow() > -1) {
            this.imprimirMensagem(this.tableMensagens.getSelectedRow());
        }
    }

    private void excluirMensagem(int tipo) {
        if (this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 1) {
            return;
        }
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Excluindo..");
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        try {
            for (int i = 0; i < this.modeloMensagens.getRowCount(); ++i) {
                buf.delete(0, buf.length());
                if (!this.tableMensagens.getSelectionModel().isSelectedIndex(i)) continue;
                buf.append("delete from usuariomensagem where ume_codigo = ").append(this.modeloMensagens.getValueAt(i, 3));
                Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            }
            Conexao.arquivaSQL();
            this.listaMensagens(tipo == 1 ? 1 : 2);
            this.txtMensagem.setText("");
            splash.apagar();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TelaMensagens (373)");
        }
        if (this.tableMensagens.getRowCount() > 0) {
            this.tableMensagens.grabFocus();
        }
    }

    private void marcarDesmarcaLidas(int tipo, String situacao) {
        if (this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString())) {
            return;
        }
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Atualizando..");
        int linha = -1;
        boolean confirmarLeitura = false;
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        try {
            for (int i = 0; i < this.modeloMensagens.getRowCount(); ++i) {
                String[] filiaisIntegracao;
                buf.delete(0, buf.length());
                if (!this.tableMensagens.getSelectionModel().isSelectedIndex(i)) continue;
                linha = this.tableMensagens.getSelectedRow();
                confirmarLeitura = (Boolean)this.modeloMensagens.getValueAt(linha, 7);
                String assuntoMensagem = this.modeloMensagens.getValueAt(linha, 2).toString();
                String usuarioOrigem = this.modeloMensagens.getValueAt(linha, 6).toString();
                buf.append("update usuariomensagem set ume_situacao = ").append(situacao != null ? "'" + situacao + "'" : null).append(" where ume_codigo = ");
                buf.append(this.modeloMensagens.getValueAt(i, 3));
                Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
                    if (filial.equals(Variaveis.filialPadrao) && (!filial.equals(Variaveis.filialPadrao) || !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W"))) continue;
                    IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
                }
                if (!confirmarLeitura || situacao != SITUACAO_LIDAS) continue;
                buf.delete(0, buf.length());
                buf.append("A mensagem com o t\u00edtulo:\n").append(StringUtil.textoDB(assuntoMensagem));
                buf.append(" acaba de ser lida pelo destinat\u00e1rio.\n");
                buf.append("Data da leitura: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
                NovaMensagem.enviarMensagem(st, Variaveis.login, usuarioOrigem, "Confirma\u00e7\u00e3o de leitura", buf.toString(), false, DEFAULT);
            }
            Conexao.arquivaSQL();
            Conexao.fecharStatement(st);
            splash.apagar();
            this.listaMensagens(tipo == 1 ? 1 : 2);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TelaMensagens (402)");
            }
        }
    }

    private void imprimirMensagem(int linha) {
        PedirImpressora pedir = new PedirImpressora((JFrame)this.getTopLevelAncestor());
        pedir.setVisible(true);
        if (!pedir.getOK() || Funcoes.textoVazio(pedir.getImpressora())) {
            return;
        }
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select lay_geral from layout where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and lay_codigo = ");
            buf.append(ParametrosGerais.getLayCodigo());
            ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_geral"))) {
                String layout = rsLayout.getString("lay_geral");
                buf.delete(0, buf.length());
                buf.append("De: ").append(this.modeloMensagens.getValueAt(linha, 6)).append("\n");
                buf.append("Assunto: ").append(this.modeloMensagens.getValueAt(linha, 2)).append("\n");
                buf.append("Data: ").append(this.modeloMensagens.getValueAt(linha, 1)).append("\n");
                buf.append("\n");
                buf.append(this.modeloMensagens.getValueAt(linha, 5));
                ImpressaoTexto.imprimir(pedir.getImpressora(), layout, buf.toString(), new Font("Arial", 0, 11));
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
            st.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "TelaMensagens (377)");
        }
        if (this.tableMensagens.getRowCount() > 0) {
            this.tableMensagens.grabFocus();
        }
    }

    private void lerMensagem(int linha) {
        if (!Funcoes.isNumeric(this.modeloMensagens.getValueAt(linha, 3).toString())) {
            return;
        }
        LerMensagem ler = new LerMensagem((JFrame)this.getTopLevelAncestor());
        ler.setCodigoMensagem(Integer.parseInt(this.modeloMensagens.getValueAt(linha, 3).toString()));
        ler.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listaMensagens(int tipo) {
        block18: {
            ResultSet rs;
            Statement st;
            block16: {
                st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder();
                rs = null;
                buf.append("select ume_datahora, usr_codorigem, usr_coddestino, ume_assunto, ume_mensagem, ume_codigo, ");
                buf.append("ume_confirmarleitura, ume_situacao, ume_tipo from usuariomensagem where ");
                if (tipo == 1) {
                    buf.append("usr_coddestino = ");
                } else {
                    buf.append("usr_codorigem = ");
                }
                buf.append("'").append(Variaveis.login).append("'");
                buf.append(" order by ume_datahora desc");
                rs = Conexao.executeQuery(st, buf);
                this.modeloMensagens.clear();
                if (tipo == 1) {
                    this.modeloMensagens.changeColumnName("De", 0);
                    this.titledBorderMensagens.setTitle("Mensagens recebidas");
                } else {
                    this.modeloMensagens.changeColumnName("Para", 0);
                    this.titledBorderMensagens.setTitle("Mensagens enviadas");
                }
                this.painelMensagens.repaint();
                while (rs.next()) {
                    this.modeloMensagens.addLine(new Object[]{rs.getString(tipo == 1 ? "usr_codorigem" : "usr_coddestino"), Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("ume_datahora")), rs.getString("ume_assunto"), rs.getString("ume_codigo"), rs.getString("ume_situacao"), rs.getString("ume_mensagem"), rs.getString("usr_codorigem"), rs.getBoolean("ume_confirmarleitura"), rs.getString("ume_tipo")});
                }
                if (rs == null) break block16;
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            Conexao.fecharStatement(st);
            break block18;
            catch (Exception ex) {
                block17: {
                    try {
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TelaMensagens (441)");
                        if (rs == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                Conexao.fecharStatement(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localizarMensagens(int tipo) {
        if (!this.textLocalizar.getText().isEmpty()) {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            try {
                buf.append("select ume_datahora, usr_codorigem, usr_coddestino, ume_assunto, ume_mensagem, ume_codigo, ");
                buf.append("ume_confirmarleitura, ume_situacao, ume_tipo from usuariomensagem where ");
                if (tipo == 1) {
                    buf.append("usr_coddestino = ");
                    buf.append("'").append(Variaveis.login).append("'");
                    buf.append(" and (");
                } else {
                    buf.append("usr_codorigem = ");
                    buf.append("'").append(Variaveis.login).append("'");
                    buf.append(" and (");
                }
                if (this.comboLocalizar.getSelectedItem().toString().equals(LISTAR_MENSAGEM)) {
                    buf.append("ume_mensagem");
                    buf.append(") ilike ('%").append(StringUtil.textoDB(this.textLocalizar.getText())).append("%')");
                }
                if (this.comboLocalizar.getSelectedItem().toString().equals(LISTAR_ASSUNTO)) {
                    buf.append("ume_assunto");
                    buf.append(") ilike ('%").append(StringUtil.textoDB(this.textLocalizar.getText())).append("%')");
                }
                if (this.comboLocalizar.getSelectedItem().toString().equals(LISTAR_USUARIO)) {
                    if (tipo == 1) {
                        buf.append("usr_codorigem");
                        buf.append(") ilike ('%").append(StringUtil.textoDB(this.textLocalizar.getText())).append("%')");
                    } else {
                        buf.append("usr_coddestino");
                        buf.append(") ilike ('%").append(StringUtil.textoDB(this.textLocalizar.getText())).append("%')");
                    }
                }
                buf.append(" order by ume_datahora desc");
                ResultSet rs = Conexao.executeQuery(st, buf);
                this.modeloMensagens.clear();
                if (tipo == 1) {
                    this.modeloMensagens.changeColumnName("De", 0);
                } else {
                    this.modeloMensagens.changeColumnName("Para", 0);
                }
                while (rs.next()) {
                    this.modeloMensagens.addLine(new Object[]{rs.getString(tipo == 1 ? "usr_codorigem" : "usr_coddestino"), Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("ume_datahora")), rs.getString("ume_assunto"), rs.getString("ume_codigo"), rs.getString("ume_situacao"), rs.getString("ume_mensagem"), rs.getString("usr_codorigem"), rs.getBoolean("ume_confirmarleitura"), rs.getString("ume_tipo")});
                }
                this.posLocalizar();
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TelaMensagens (441)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void buscaUsuarios(Statement st) throws SQLException {
        ResultSet rs = Conexao.executeQuery(st, "select usr_codigo, usr_nome from usuario where (usr_inativo = false or usr_inativo is null) order by usr_nome");
        this.modeloLista.removeAllElements();
        while (rs.next()) {
            if (rs.getString("usr_codigo").equals(Variaveis.login)) continue;
            this.modeloLista.addElement(new ObjetoContato(rs.getString("usr_nome"), rs.getString("usr_codigo")));
        }
    }

    private void posLocalizar() {
        this.comboLocalizar.setSelectedItem(LISTAR_ASSUNTO);
        this.comboLocalizar.setEnabled(false);
        this.textLocalizar.setEditable(false);
        this.buttonBuscar.setEnabled(false);
        this.buttonLimparPesquisa.setEnabled(true);
    }

    private void limparPequisa() {
        this.listaMensagens(this.treePastas.getSelectionPath() != null && this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) ? 2 : 1);
        this.comboLocalizar.setEnabled(true);
        this.textLocalizar.setEditable(true);
        this.buttonBuscar.setEnabled(true);
        this.textLocalizar.setText("");
        this.buttonLimparPesquisa.setEnabled(false);
    }

    private void localizar() {
        if (this.textLocalizar.getText().isEmpty()) {
            this.listaMensagens(this.treePastas.getSelectionPath() != null && this.treePastas.getSelectionPath().getLastPathComponent().toString().equals(this.enviadas.toString()) ? 2 : 1);
        } else if (this.no == null || this.no.equals(this.recebidas.toString())) {
            this.localizarMensagens(1);
        } else {
            this.localizarMensagens(2);
        }
    }
}

