/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import jalis.util.ImagemUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.Timer;

class TelaAviso
extends JWindow {
    private Color corInicial = new Color(0x99CCFF);
    private String mensagem = "";
    private int tipo = 0;
    public static final int TIPO_VAZIO = 0;
    public static final int TIPO_ERRO = 1;
    public static final int TIPO_AVISO = 2;
    public static final int TIPO_ALARME_RELOGIO = 3;
    private final ImageIcon IMAGEM_ERRO = ImagemUtils.carregaImagemJalis("aviso_erro.png");
    private final ImageIcon IMAGEM_AVISO = ImagemUtils.carregaImagemJalis("aviso_aviso.png");
    private final ImageIcon IMAGEM_ALARME_RELOGIO = ImagemUtils.carregaImagemJalis("aviso_relogio.png");

    public TelaAviso(JFrame owner) {
        super(owner);
        this.montaTela();
    }

    public TelaAviso(JFrame owner, Color corInicial) {
        super(owner);
        this.corInicial = corInicial;
        this.montaTela();
    }

    public void setColor(Color cor) {
        this.corInicial = cor;
    }

    public void setMensagem(String msg) {
        this.mensagem = msg;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    private void montaTela() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TelaAviso.this.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Timer t = new Timer(6000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TelaAviso.this.setVisible(false);
                    }
                });
                t.start();
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        int diferenca;
        Graphics2D g2d = (Graphics2D)g;
        Color startColor = this.corInicial;
        Color endColor = Color.WHITE;
        GradientPaint gradient = new GradientPaint(1.0f, 1.0f, startColor, 0.0f, 159.0f, endColor);
        g2d.setPaint(gradient);
        g2d.fillRect(1, 1, 149, 159);
        g2d.setPaint(null);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, 149, 159);
        int n = diferenca = this.tipo == 0 ? 20 : 60;
        if (this.tipo == 1) {
            g2d.drawImage(this.IMAGEM_ERRO.getImage(), 50, 10, 48, 48, this);
        } else if (this.tipo == 2) {
            g2d.drawImage(this.IMAGEM_AVISO.getImage(), 50, 10, 48, 48, this);
        } else if (this.tipo == 3) {
            g2d.drawImage(this.IMAGEM_ALARME_RELOGIO.getImage(), 50, 10, 48, 48, this);
        }
        g2d.setColor(Color.BLACK);
        g2d.setFont(new Font("Arial", 1, 12));
        String[] palavras = this.mensagem.split(" ");
        String tmp = "";
        boolean contador = false;
        int linha = 1;
        for (String s : palavras) {
            if (tmp.length() + s.length() > 20 || tmp.length() == 0 && s.length() > 20) {
                g2d.drawString(tmp, 10, 20 * linha++ + diferenca);
                tmp = s + " ";
                continue;
            }
            tmp = tmp + s + " ";
        }
        g2d.drawString(tmp, 10, 20 * linha++ + diferenca);
    }
}

