/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class RenderTabela
extends DefaultTableCellRenderer {
    private static final String TIPO_USO_DISCO = "D";
    private static final String TIPO_NOVA_VERSAO = "A";
    private static final String TIPO_BACKUP = "B";
    private static final int COLUNA_SITUACAO = 4;
    private static final int COLUNA_TIPO = 8;
    private static final Color FUCSIA = new Color(202, 44, 146);
    private static final Color LARANJA = new Color(252, 113, 20);
    private static final Color AZUL = new Color(27, 153, 161);

    RenderTabela() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean lida = table.getModel().getValueAt(row, 4) != null && table.getModel().getValueAt(row, 4).toString().equalsIgnoreCase("R");
        c.setOpaque(lida || isSelected);
        c.setFont(table.getFont());
        if (!lida) {
            c.setFont(new Font(table.getFont().getFontName(), 1, table.getFont().getSize()));
        }
        if (table.getModel().getValueAt(row, 8).toString().equals(TIPO_BACKUP)) {
            c.setForeground(FUCSIA);
        } else if (table.getModel().getValueAt(row, 8).toString().equals(TIPO_NOVA_VERSAO)) {
            c.setForeground(LARANJA);
        } else if (table.getModel().getValueAt(row, 8).toString().equals(TIPO_USO_DISCO)) {
            c.setForeground(AZUL);
        } else {
            c.setForeground(table.getForeground());
        }
        if (isSelected) {
            c.setBackground(table.getSelectionBackground());
        } else {
            c.setBackground(Color.WHITE);
        }
        return c;
    }
}

