/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.DialogoFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NovaMensagem
extends JDialog
implements ActionListener {
    public static final String ESTOQUE = "E";
    public static final String REQUISICAO = "R";
    public static final String NAOCONFORMIDADE = "N";
    public static final String DEFAULT = "C";
    private JButton buttonPara = ComponenteFactory.novoJButton("Para:", 'P', this);
    private JTextArea txtPara = new JTextArea();
    private TTextField txtAssunto = new TTextField(100);
    private JLabel labelAssunto = ComponenteFactory.novoJLabel("Assunto:", 'A', null, this.txtAssunto);
    private JCheckBox checkConfirmar = ComponenteFactory.novoJCheckBox("Confirmar leitura", 'l', null);
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'E', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private JTextArea txtMensagem = new JTextArea(new TTextAreaDocument(2000));
    private JScrollPane scrollMensagem = new JScrollPane(this.txtMensagem);
    private JLabel labelMensagem = ComponenteFactory.novoJLabel("Mensagem:", 'M', null, this.scrollMensagem);
    private JPopupMenu menuPara = new JPopupMenu();
    private JMenuItem itemUsuario = ComponenteFactory.novoJMenuItem("Usu\u00e1rio", 'U', (ActionListener)this);
    private JMenuItem itemTipoUsuario = ComponenteFactory.novoJMenuItem("Tipo de usu\u00e1rio", 'i', (ActionListener)this);
    private String tipoMensagem = "C";

    public NovaMensagem(JFrame owner) {
        super((Frame)owner, "Nova mensagem");
        this.setSize(new Dimension(520, 480));
        this.setModal(true);
        this.setLocationRelativeTo(owner);
        this.montaTela();
    }

    private void montaTela() {
        this.menuPara.add(this.itemUsuario);
        this.menuPara.add(this.itemTipoUsuario);
        this.txtPara.setToolTipText("<html>Destinat\u00e1rio(s) da mensagem.<br>Para selecionar mais de um destinat\u00e1rio: separe-os com <b>,</b> (v\u00edrgula)</html>");
        this.txtPara.setWrapStyleWord(true);
        this.txtPara.setLineWrap(true);
        this.txtMensagem.setWrapStyleWord(true);
        this.txtMensagem.setLineWrap(true);
        this.setLayout(new BorderLayout());
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.add((Component)panelCentro, "Center");
        panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        panelCentro.add((Component)this.buttonPara, c);
        c.gridy = 1;
        panelCentro.add((Component)this.labelAssunto, c);
        c.gridy = 2;
        panelCentro.add((Component)this.labelMensagem, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        JScrollPane scroll = new JScrollPane(this.txtPara);
        scroll.setPreferredSize(new Dimension(100, 40));
        scroll.setMinimumSize(new Dimension(100, 40));
        panelCentro.add((Component)scroll, c);
        c.gridy = 1;
        panelCentro.add((Component)this.txtAssunto, c);
        c.weighty = 1.0;
        c.gridy = 2;
        c.fill = 1;
        panelCentro.add((Component)this.scrollMensagem, c);
        c.gridy = 3;
        c.fill = 2;
        c.weighty = 0.0;
        panelCentro.add((Component)this.checkConfirmar, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        c.gridy = 4;
        c.fill = 2;
        panelCentro.add((Component)panelBotoes, c);
        panelBotoes.add(this.buttonEnviar);
        panelBotoes.add(this.buttonCancelar);
        Funcoes.montaEnter(panelCentro, panelBotoes);
        ScreenUtil.montaSaidaTextArea(this.txtPara);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (Funcoes.textoVazio(NovaMensagem.this.txtPara.getText())) {
                    NovaMensagem.this.txtPara.grabFocus();
                } else {
                    NovaMensagem.this.txtMensagem.grabFocus();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonPara) {
            this.menuPara.show(this.buttonPara, this.buttonPara.getX(), this.buttonPara.getY() + this.buttonPara.getHeight());
        } else if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonEnviar) {
            this.enviarMensagem();
        } else if (e.getSource() == this.itemUsuario) {
            this.selecionarUsuario();
        } else if (e.getSource() == this.itemTipoUsuario) {
            this.selecionarTipoUsuario();
        }
    }

    private void selecionarUsuario() {
        DialogoFiltro fil = new DialogoFiltro(this, "Selecionar usu\u00e1rio", true);
        String sql = "select a.usr_codigo, a.usr_nome, b.tpu_descricao from usuario a left join tipousuario b on a.tpu_codigo = b.tpu_codigo where (a.usr_inativo = false or a.usr_inativo is null) ";
        fil.setDados(sql, new String[]{"usr_codigo", "usr_nome", "tpu_descricao"}, new String[]{"Usu\u00e1rio", "Nome", "Tipo"}, new int[]{90, 0, 120}, "", true);
        fil.setVisible(true);
        String[] selecao = fil.getSelecionados(0);
        StringBuilder buf = new StringBuilder(this.txtPara.getText().trim());
        for (String s : selecao) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(s);
        }
        this.txtPara.setText(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selecionarTipoUsuario() {
        DialogoFiltro fil = new DialogoFiltro(this, "Selecionar tipo", true);
        fil.setDados("tipousuario", new String[]{"tpu_codigo", "tpu_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, "");
        fil.setVisible(true);
        String[] selecao = fil.getSelecionados(0);
        if (selecao != null && selecao.length > 0) {
            Statement st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select usr_codigo from usuario where tpu_codigo in (");
                for (int i = 0; i < selecao.length; ++i) {
                    buf.append(selecao[i]);
                    if (i >= selecao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") and (usr_inativo is null or usr_inativo = false) ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                buf.delete(0, buf.length());
                buf.append(this.txtPara.getText().trim());
                while (rs.next()) {
                    if (!Funcoes.textoVazio(buf.toString())) {
                        buf.append(", ");
                    }
                    buf.append(rs.getString("usr_codigo"));
                }
                this.txtPara.setText(buf.toString());
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "NovaMensagem (186)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private String procuraUsuario(ArrayList<String> a, String usr) {
        String retorno = "";
        for (String s : a) {
            if (!s.equalsIgnoreCase(usr.trim())) continue;
            retorno = s;
            break;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarMensagem() {
        block14: {
            if (!this.valida()) break block14;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            String[] destinos = this.txtPara.getText().split(",");
            ArrayList<String> usuarioNaoLocalizado = new ArrayList<String>();
            try {
                buf.append("select usr_codigo from usuario order by usr_codigo");
                ResultSet rs = Conexao.executeQuery(st, buf);
                ArrayList<String> usuarios = new ArrayList<String>();
                while (rs.next()) {
                    usuarios.add(rs.getString("usr_codigo"));
                }
                for (String s : destinos) {
                    String usuario = this.procuraUsuario(usuarios, s);
                    if (Funcoes.textoVazio(usuario)) {
                        usuarioNaoLocalizado.add(s);
                        continue;
                    }
                    NovaMensagem.enviarMensagem(st, Variaveis.login, usuario, StringUtil.textoDB(this.txtAssunto.getTextDB()), StringUtil.textoDB(this.txtMensagem.getText()), this.checkConfirmar.isSelected(), this.tipoMensagem);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NovaMensagem (113)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            int resposta = 1;
            if (usuarioNaoLocalizado.size() > 0 && (resposta = Funcoes.mensagem(this, "Alguns destinat\u00e1rios n\u00e3o foram localizados, deseja corrigir os destinos?", 4)) == 0) {
                buf.delete(0, buf.length());
                for (String s : usuarioNaoLocalizado) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(s);
                }
                this.txtPara.setText(buf.toString());
            }
            if (resposta == 1) {
                this.setVisible(false);
            } else {
                this.txtPara.grabFocus();
            }
        }
    }

    public static void enviarMensagemNcf(Statement st, String usuarioOrigem, String usuarioDestino, String assunto, String mensagem, boolean exigeResposta, int codigoFilial, int codigoNcf, int codigoSetorNaoConformidade, String codigoUserNaoConformidade) throws Exception {
        String[] filiaisIntegracao;
        SalvaDados salvar = new SalvaDados("usuariomensagem", 0);
        ResultSet rs = Conexao.executeQuery(st, "select nextval('usuariomensagem_ume_codigo_seq')");
        String codigo = "-1";
        if (rs != null && rs.next()) {
            codigo = rs.getString(1);
        }
        salvar.adicionaCampo("ume_codigo", 2, false, false, codigo);
        salvar.adicionaCampo("usr_codorigem", 0, false, false, usuarioOrigem);
        salvar.adicionaCampo("usr_coddestino", 0, false, false, usuarioDestino);
        salvar.adicionaCampo("ume_assunto", 0, false, false, assunto);
        salvar.adicionaCampo("ume_mensagem", 0, false, false, mensagem);
        salvar.adicionaCampo("ume_confirmarleitura", 4, false, false, exigeResposta);
        salvar.adicionaCampo("fil_codigo", 2, false, false, codigoFilial);
        salvar.adicionaCampo("nac_codigo", 2, false, false, codigoNcf);
        salvar.adicionaCampo("sna_codigo", 2, false, false, codigoSetorNaoConformidade);
        salvar.adicionaCampo("usr_codnaoconformidade", 0, false, false, codigoUserNaoConformidade);
        int hash = (codigo + usuarioOrigem + usuarioDestino + assunto + mensagem).hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        salvar.adicionaCampo("ume_hash", 2, false, false, hash);
        String comando = salvar.getComando();
        Conexao.execute(Variaveis.filialPadrao, st, comando, true);
        for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
            if (!filial.equals(Variaveis.filialPadrao) || filial.equals(Variaveis.filialPadrao) && ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W")) {
                salvar.removerCampo("ume_codigo");
            }
            IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, salvar.getComando());
        }
    }

    public static void enviarMensagem(Statement st, String usuarioOrigem, String usuarioDestino, String assunto, String mensagem, boolean exigeResposta) throws Exception {
        NovaMensagem.enviarMensagem(false, st, Variaveis.filialPadrao, usuarioOrigem, usuarioDestino, assunto, mensagem, exigeResposta, DEFAULT);
    }

    public static void enviarMensagem(Statement st, String usuarioOrigem, String usuarioDestino, String assunto, String mensagem, boolean exigeResposta, String tipoMensagem) throws Exception {
        NovaMensagem.enviarMensagem(false, st, Variaveis.filialPadrao, usuarioOrigem, usuarioDestino, assunto, mensagem, exigeResposta, tipoMensagem);
    }

    public static void enviarMensagem(boolean isColetaWeb, Statement st, String filialOrigem, String usuarioOrigem, String usuarioDestino, String assunto, String mensagem, boolean exigeResposta, String tipo) throws Exception {
        SalvaDados salvar = new SalvaDados("usuariomensagem", 0);
        ResultSet rs = st.executeQuery("select nextval('usuariomensagem_ume_codigo_seq')");
        String codigo = "-1";
        if (rs != null && rs.next()) {
            codigo = rs.getString(1);
        }
        salvar.adicionaCampo("ume_codigo", 2, false, false, codigo);
        salvar.adicionaCampo("usr_codorigem", 0, false, false, usuarioOrigem);
        salvar.adicionaCampo("usr_coddestino", 0, false, false, usuarioDestino);
        salvar.adicionaCampo("ume_assunto", 0, false, false, assunto);
        salvar.adicionaCampo("ume_mensagem", 0, false, false, mensagem);
        salvar.adicionaCampo("ume_confirmarleitura", 4, false, false, exigeResposta);
        if (isColetaWeb) {
            salvar.adicionaCampo("ume_datahora", 5, false, false, new Timestamp(new Date().getTime()));
        } else {
            Timestamp dataHoraServidor = new Timestamp(Funcoes.getDataHoraServidor().getTime());
            salvar.adicionaCampo("ume_datahora", 5, false, false, dataHoraServidor);
        }
        salvar.adicionaCampo("ume_tipo", 0, false, false, tipo);
        int hash = (codigo + usuarioOrigem + usuarioDestino + assunto + mensagem).hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        salvar.adicionaCampo("ume_hash", 2, false, false, hash);
        String comando = salvar.getComando();
        if (isColetaWeb) {
            st.executeUpdate(comando);
        } else {
            String[] filiaisIntegracao;
            Conexao.execute(Variaveis.filialPadrao, st, comando, true);
            for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
                salvar.removerCampo("ume_codigo");
                IntegracaoUtil.insereComandoLog(st, filialOrigem, filial, salvar.getComando());
            }
        }
    }

    private boolean valida() {
        boolean retorno = false;
        if (Funcoes.textoVazio(this.txtPara.getText())) {
            Funcoes.mensagem(this, "Nenhum destinat\u00e1rio selecionado", 1);
            this.txtPara.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtAssunto.getText())) {
            Funcoes.mensagem(this, "Nenhum assunto foi definido", 1);
            this.txtAssunto.grabFocus();
            return false;
        }
        return true;
    }

    public void setUsuarioDestino(String usr) {
        this.txtPara.setText(usr);
    }

    public void setAssunto(String assunto) {
        this.txtAssunto.setText(assunto);
    }

    public void setMensagem(String mensagem) {
        this.txtMensagem.setText(mensagem);
    }

    public void setTipoMensagem(String tipo) {
        this.tipoMensagem = tipo;
    }
}

