/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.mensagens.NovaMensagem;
import jalis.service.cadastro.SetorNaoConformidadeUsuarioService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class LerMensagem
extends JDialog
implements ActionListener {
    private JLabel labelDe = ComponenteFactory.novoJLabel("De:", null);
    private JLabel txtDe = ComponenteFactory.novoJLabel("", null);
    private JLabel txtAssunto = ComponenteFactory.novoJLabel("", null);
    private JLabel labelAssunto = ComponenteFactory.novoJLabel("Assunto:", 'A', null, null);
    private JButton buttonResponder = ComponenteFactory.novoJButton("Responder", 'R', this);
    private JButton buttonEncaminhar = ComponenteFactory.novoJButton("Encaminhar", 'E', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JTextArea txtMensagem = new JTextArea();
    private JScrollPane scrollMensagem = new JScrollPane(this.txtMensagem);
    private JLabel labelMensagem = ComponenteFactory.novoJLabel("Mensagem:", 'M', null, this.scrollMensagem);
    private int codigoMensagem = -1;
    private int hashMensagem = -1;
    private boolean confirmarLeitura = false;
    private SetorNaoConformidadeUsuarioService setorNaoConformidadeUsuarioService = new SetorNaoConformidadeUsuarioService();

    public LerMensagem(JFrame owner) {
        super((Frame)owner, "Lendo mensagem");
        this.setSize(new Dimension(520, 480));
        this.setModal(true);
        this.setLocationRelativeTo(owner);
        this.montaTela();
    }

    private void montaTela() {
        ScreenUtil.setBorda(new Component[]{this.txtDe, this.txtAssunto}, BorderFactory.createTitledBorder(""));
        this.txtMensagem.setWrapStyleWord(true);
        this.txtMensagem.setLineWrap(true);
        this.setLayout(new BorderLayout());
        JPanel panelCentro = new JPanel(new GridBagLayout());
        this.add((Component)panelCentro, "Center");
        panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.txtMensagem.setEditable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 2;
        panelCentro.add((Component)this.labelDe, c);
        c.gridy = 1;
        panelCentro.add((Component)this.labelAssunto, c);
        c.gridy = 2;
        panelCentro.add((Component)this.labelMensagem, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.txtDe.setPreferredSize(new Dimension(100, 20));
        this.txtDe.setMinimumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.txtDe, c);
        c.gridy = 1;
        this.txtAssunto.setPreferredSize(new Dimension(100, 20));
        this.txtAssunto.setMinimumSize(new Dimension(100, 20));
        panelCentro.add((Component)this.txtAssunto, c);
        c.weighty = 1.0;
        c.gridy = 2;
        c.fill = 1;
        panelCentro.add((Component)this.scrollMensagem, c);
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        c.weighty = 0.0;
        c.gridy = 3;
        c.fill = 2;
        panelCentro.add((Component)panelBotoes, c);
        panelBotoes.add(this.buttonResponder);
        panelBotoes.add(this.buttonEncaminhar);
        panelBotoes.add(this.buttonFechar);
        Funcoes.montaEnter(panelCentro, panelBotoes);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                LerMensagem.this.txtMensagem.grabFocus();
                Timer marcarLida = new Timer(2000, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LerMensagem.this.codigoMensagem < 0) {
                            return;
                        }
                        Statement st = Conexao.getStatement();
                        try {
                            StringBuilder buf = new StringBuilder();
                            buf.append("update usuariomensagem set ume_situacao = 'R', ume_avisada = true where ume_codigo = ");
                            buf.append(LerMensagem.this.codigoMensagem);
                            Conexao.execute(Variaveis.filialPadrao, st, buf);
                            LerMensagem.this.setorNaoConformidadeUsuarioService.confirmaLeituraMsgNcf(LerMensagem.this.codigoMensagem);
                            String[] filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st);
                            if (filiaisIntegracao != null && filiaisIntegracao.length > 0) {
                                if (LerMensagem.this.hashMensagem > -1) {
                                    buf.setLength(0);
                                    buf.append("update usuariomensagem set ume_situacao = 'R', ume_avisada = true where ume_hash = ");
                                    buf.append(LerMensagem.this.hashMensagem);
                                }
                                for (String filial : filiaisIntegracao) {
                                    if (filial.equals(Variaveis.filialPadrao) && (!filial.equals(Variaveis.filialPadrao) || !ParametrosGerais.getTipoIntegracao().equals("F") && !ParametrosGerais.getTipoIntegracao().equals("W"))) continue;
                                    IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
                                }
                            }
                            if (LerMensagem.this.confirmarLeitura) {
                                buf.delete(0, buf.length());
                                buf.append("A mensagem com o t\u00edtulo:\n").append(LerMensagem.this.txtAssunto.getText());
                                buf.append("\nacaba de ser lida pelo destinat\u00e1rio.\n");
                                buf.append("Data da leitura: ").append(Funcoes.formataData("dd/MM/yyyy HH:mm", new Date()));
                                NovaMensagem.enviarMensagem(st, Variaveis.login, LerMensagem.this.txtDe.getText(), "Confirma\u00e7\u00e3o de leitura", buf.toString(), false);
                            }
                            Conexao.arquivaSQL();
                        }
                        catch (Exception excecao) {
                            try {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(LerMensagem.this, excecao.getMessage(), excecao.getStackTrace(), "LerMensagem (120)");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                        Conexao.fecharStatement(st);
                    }
                });
                marcarLida.setRepeats(false);
                marcarLida.start();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonResponder) {
            this.responderMensagem();
        } else if (e.getSource() == this.buttonEncaminhar) {
            this.encaminharMensagem();
        }
    }

    private void responderMensagem() {
        NovaMensagem nova = new NovaMensagem((JFrame)this.getParent());
        nova.setUsuarioDestino(this.txtDe.getText());
        nova.setAssunto("Re: " + this.txtAssunto.getText());
        nova.setMensagem("\n\n" + Funcoes.preencheVazio("", "=", 40, 2) + "\n" + this.txtMensagem.getText());
        nova.setVisible(true);
    }

    private void encaminharMensagem() {
        NovaMensagem nova = new NovaMensagem((JFrame)this.getParent());
        nova.setAssunto("Enc: " + this.txtAssunto.getText());
        nova.setMensagem("\n\n" + Funcoes.preencheVazio("", "=", 40, 2) + "\n" + this.txtMensagem.getText());
        nova.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodigoMensagem(int codigo) {
        Statement st;
        block5: {
            this.codigoMensagem = codigo;
            this.hashMensagem = -1;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select ume_datahora, ume_mensagem, ume_assunto, usr_codorigem, ume_confirmarleitura, ume_hash ");
            buf.append("from usuariomensagem ");
            buf.append("where ume_codigo = ").append(codigo);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block5;
                this.txtDe.setText(rs.getString("usr_codorigem"));
                this.txtAssunto.setText(rs.getString("ume_assunto"));
                this.txtMensagem.setText(rs.getString("ume_mensagem"));
                this.confirmarLeitura = rs.getBoolean("ume_confirmarleitura");
                if (!DBUtil.campoNull(rs.getString("ume_hash"))) {
                    this.hashMensagem = rs.getInt("ume_hash");
                }
                ScreenUtil.posicionaTextoTopo(this.txtMensagem);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }
}

