/*
 * Decompiled with CFR 0.152.
 */
package jalis.mensagens;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.mensagens.LerMensagem;
import jalis.mensagens.NovaMensagem;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.ImpressaoTexto;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class AuditoriaMensagens
extends FrmPadrao
implements ActionListener {
    private static final String ULTIMO_FILTRO = "AuditoriaMensagem.ultimoFiltro";
    private ModeloGridTable modeloMensagens = new ModeloGridTable(new String[]{"De", "Para", "Data/Hora", "Assunto"});
    private JTable tableMensagens = new JTable(this.modeloMensagens);
    private JScrollPane scrollMensagens = new JScrollPane(this.tableMensagens);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this, null, null);
    private JButton buttonOcultar = ComponenteFactory.novoJButton("Ocultar Filtro", 'O', this, null, null);
    private JTextPane txtMensagem = new JTextPane();
    private JScrollPane scrollMensagem = new JScrollPane(this.txtMensagem);
    private JPanel panelAtalhos = new JPanel(new FlowLayout(0));
    private JButton buttonAtualizar = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonNovo = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonImprimir = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonResponder = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private JButton buttonEncaminhar = ComponenteFactory.novoJButton("", this, new Dimension(52, 50), new Dimension(52, 50));
    private static final int COLUNA_USUARIO_ORIGEM = 0;
    private static final int COLUNA_USUARIO_DESTINO = 1;
    private static final int COLUNA_DATA = 2;
    private static final int COLUNA_ASSUNTO = 3;
    private static final int COLUNA_CODIGO = 4;
    private static final int COLUNA_SITUACAO = 5;
    private static final int COLUNA_MENSAGEM = 6;
    private static final int COLUNA_CONFIRMAR_LEITURA = 7;
    private JPanel panelFiltro;
    private CheckItemFiltro itemUsuarioEnvio;
    private CheckItemFiltro itemUsuarioRecebeu;
    private JLabel labelDataIni = new JLabel("Data Inicial:");
    private JLabel labelDataFin = new JLabel("Data Final:");
    private JLabel labelTextAssunto = new JLabel("Cont\u00e9m no Assunto");
    private JLabel labelTextCorpo = new JLabel("Cont\u00e9m no Conte\u00fado");
    private TTextField textDataIni = new TTextField(0, 4);
    private TTextField textDataFin = new TTextField(0, 4);
    private TTextField textAssunto = new TTextField(0, 3);
    private TTextField textCorpo = new TTextField(0, 3);
    private JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this, null, null);

    public AuditoriaMensagens() {
        this.montaTela();
        this.carregarParametros();
        this.tableMensagens.setDefaultRenderer(Object.class, new RenderTabela());
        this.tableMensagens.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (AuditoriaMensagens.this.tableMensagens.getSelectedRow() >= 0 && AuditoriaMensagens.this.modeloMensagens.getValueAt(AuditoriaMensagens.this.tableMensagens.getSelectedRow(), 6) != null) {
                    AuditoriaMensagens.this.txtMensagem.setText(AuditoriaMensagens.this.modeloMensagens.getValueAt(AuditoriaMensagens.this.tableMensagens.getSelectedRow(), 6).toString());
                    ScreenUtil.posicionaTextoTopo(AuditoriaMensagens.this.txtMensagem);
                }
            }
        });
        this.tableMensagens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && AuditoriaMensagens.this.tableMensagens.getSelectedRow() >= 0) {
                    AuditoriaMensagens.this.lerMensagem(AuditoriaMensagens.this.tableMensagens.getSelectedRow());
                }
            }
        });
    }

    private void enviarMensagem(String login) {
        NovaMensagem nova = new NovaMensagem((JFrame)this.getTopLevelAncestor());
        if (!Funcoes.textoVazio(login)) {
            nova.setUsuarioDestino(login);
        }
        nova.setVisible(true);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1101002000");
    }

    private void montaTela() {
        this.txtMensagem.setEditable(false);
        this.textDataIni.setPreferredSize(new Dimension(90, 20));
        this.textDataIni.setMinimumSize(new Dimension(90, 20));
        this.textDataFin.setPreferredSize(new Dimension(90, 20));
        this.textDataFin.setMinimumSize(new Dimension(90, 20));
        this.buttonDataIni.setPreferredSize(new Dimension(20, 20));
        this.buttonDataIni.setMinimumSize(new Dimension(20, 20));
        this.buttonDataFin.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFin.setMinimumSize(new Dimension(20, 20));
        this.modeloMensagens.setColumnSize(new int[]{50, 50, 120, 0}, this.tableMensagens);
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Auditoria de mensagens", "Auditoria em mensagens enviadas e recebidas por usu\u00e1rios", "mensagem/p_auditoria.jpg");
        JPanel panelCentro = new JPanel(new GridBagLayout());
        panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)panelCentro, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 2;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelAtalhos.setPreferredSize(new Dimension(52, 55));
        this.panelAtalhos.setMinimumSize(new Dimension(52, 55));
        panelCentro.add((Component)this.panelAtalhos, c);
        this.panelAtalhos.add(this.buttonAtualizar);
        this.panelAtalhos.add(this.buttonNovo);
        this.panelAtalhos.add(this.buttonImprimir);
        this.panelAtalhos.add(this.buttonResponder);
        this.panelAtalhos.add(this.buttonEncaminhar);
        this.buttonAtualizar.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_atualizar.jpg"));
        this.buttonNovo.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_nova.jpg"));
        this.buttonImprimir.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_imprimir.jpg"));
        this.buttonResponder.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_responder.jpg"));
        this.buttonEncaminhar.setIcon(ImagemUtils.carregaImagemJalis("mensagem/mensagem_encaminhadas.jpg"));
        ((FlowLayout)this.panelAtalhos.getLayout()).setHgap(0);
        ((FlowLayout)this.panelAtalhos.getLayout()).setVgap(0);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.gridheight = 2;
        this.panelFiltro = new JPanel(new GridBagLayout());
        this.panelFiltro.setBorder(new TitledBorder("Filtro"));
        this.panelFiltro.setPreferredSize(new Dimension(200, 100));
        this.panelFiltro.setMinimumSize(this.panelFiltro.getPreferredSize());
        panelCentro.add((Component)this.panelFiltro, c);
        c.gridheight = 1;
        c.gridy = 1;
        c.gridx = 1;
        c.weightx = 1.0;
        JPanel p3 = new JPanel(new BorderLayout());
        p3.setBorder(new TitledBorder("Mensagens"));
        p3.setPreferredSize(new Dimension(100, 100));
        p3.setMinimumSize(p3.getPreferredSize());
        p3.add((Component)this.scrollMensagens, "Center");
        panelCentro.add((Component)p3, c);
        c.gridy = 2;
        JPanel p4 = new JPanel(new BorderLayout());
        p4.setBorder(new TitledBorder("Mensagem"));
        p4.setPreferredSize(new Dimension(100, 100));
        p4.setMinimumSize(p4.getPreferredSize());
        p4.add((Component)this.scrollMensagem, "Center");
        panelCentro.add((Component)p4, c);
        JPanel panelBotoes = new JPanel(new BorderLayout());
        panelBotoes.add((Component)this.buttonOcultar, "West");
        panelBotoes.add((Component)this.buttonFechar, "East");
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.fill = 2;
        c.weighty = 0.0;
        panelCentro.add((Component)panelBotoes, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.gridwidth = 3;
        c.fill = 2;
        Dimension dim = new Dimension(10, 25);
        this.itemUsuarioEnvio = new CheckItemFiltro("De", "Filtrar", "Filtrando usu\u00e1rios", null);
        this.itemUsuarioEnvio.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemUsuarioEnvio.setColunaHint(1);
        this.itemUsuarioEnvio.setPreferredSize(dim);
        this.panelFiltro.add((Component)this.itemUsuarioEnvio, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 2;
        dim = new Dimension(10, 25);
        this.itemUsuarioRecebeu = new CheckItemFiltro("Para", "Filtrar", "Filtrando usu\u00e1rios", null);
        this.itemUsuarioRecebeu.setDados("usuario", new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.itemUsuarioRecebeu.setColunaHint(1);
        this.itemUsuarioRecebeu.setPreferredSize(dim);
        this.panelFiltro.add((Component)this.itemUsuarioRecebeu, c);
        c.gridy = 2;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.labelDataIni, c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.panelFiltro.add((Component)this.textDataIni, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttonDataIni.setFocusable(false);
        this.panelFiltro.add((Component)this.buttonDataIni, c);
        c.gridx = 0;
        c.gridy = 3;
        c.ipadx = 30;
        this.panelFiltro.add((Component)this.labelDataFin, c);
        c.gridx = 1;
        c.ipadx = 0;
        c.weightx = 0.5;
        this.panelFiltro.add((Component)this.textDataFin, c);
        c.gridx = 2;
        c.weightx = 0.0;
        this.buttonDataFin.setFocusable(false);
        this.panelFiltro.add((Component)this.buttonDataFin, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 3;
        c.weightx = 1.0;
        this.panelFiltro.add((Component)this.labelTextAssunto, c);
        c.gridy = 5;
        c.fill = 2;
        this.panelFiltro.add((Component)this.textAssunto, c);
        c.gridx = 0;
        c.gridy = 6;
        this.panelFiltro.add((Component)this.labelTextCorpo, c);
        c.gridy = 7;
        c.fill = 2;
        this.panelFiltro.add((Component)this.textCorpo, c);
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.gridy = 8;
        c.gridx = 0;
        this.panelFiltro.add((Component)this.buttonFiltrar, c);
        c.gridy = 9;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelFiltro.add((Component)new JPanel(), c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.gravarParametros();
            this.setVisible(false);
        } else if (e.getSource() == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, this.panelFiltro, true);
        } else if (e.getSource() == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, this.panelFiltro, true);
        } else if (e.getSource() == this.buttonNovo) {
            this.enviarMensagem("");
        } else if (e.getSource() == this.buttonAtualizar) {
            this.listaMensagens();
        } else if (e.getSource() == this.buttonFiltrar) {
            this.listaMensagens();
        } else if (e.getSource() == this.buttonOcultar) {
            this.ocultarFiltro();
        } else if (e.getSource() == this.buttonEncaminhar || e.getSource() == this.buttonResponder) {
            if (this.tableMensagens.getSelectedRow() > -1) {
                NovaMensagem nova = new NovaMensagem((JFrame)this.getTopLevelAncestor());
                nova.setAssunto((e.getSource() == this.buttonResponder ? "Re:" : "") + this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 3).toString());
                nova.setMensagem((e.getSource() == this.buttonResponder ? "\n\n" + Funcoes.preencheVazio("", "=", 40, 2) + "\n" : "") + this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 6).toString());
                if (e.getSource() == this.buttonResponder) {
                    nova.setUsuarioDestino(this.modeloMensagens.getValueAt(this.tableMensagens.getSelectedRow(), 0).toString());
                }
                nova.setVisible(true);
            }
        } else if (e.getSource() == this.buttonImprimir && this.tableMensagens.getSelectedRow() >= 0) {
            this.imprimirMensagem(this.tableMensagens.getSelectedRow());
        }
    }

    private void imprimirMensagem(int linha) {
        PedirImpressora pedir = new PedirImpressora((JFrame)this.getTopLevelAncestor());
        pedir.setVisible(true);
        if (!pedir.getOK() || Funcoes.textoVazio(pedir.getImpressora())) {
            return;
        }
        try {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.delete(0, buf.length());
            buf.append("select lay_geral from layout where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and lay_codigo = ");
            buf.append(ParametrosGerais.getLayCodigo());
            ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
            if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_geral"))) {
                String layout = rsLayout.getString("lay_geral");
                buf.delete(0, buf.length());
                buf.append("De: ").append(this.modeloMensagens.getValueAt(linha, 0)).append("\n");
                buf.append("Assunto: ").append(this.modeloMensagens.getValueAt(linha, 3)).append("\n");
                buf.append("Data: ").append(this.modeloMensagens.getValueAt(linha, 2)).append("\n");
                buf.append("\n");
                buf.append(this.modeloMensagens.getValueAt(linha, 6));
                ImpressaoTexto.imprimir(pedir.getImpressora(), layout, buf.toString(), new Font("Arial", 0, 11));
            } else {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            rsLayout.close();
            st.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "TelaMensagens (377)");
        }
        if (this.tableMensagens.getRowCount() > 0) {
            this.tableMensagens.grabFocus();
        }
    }

    private void lerMensagem(int linha) {
        if (!Funcoes.isNumeric(this.modeloMensagens.getValueAt(linha, 4).toString())) {
            return;
        }
        LerMensagem ler = new LerMensagem((JFrame)this.getTopLevelAncestor());
        ler.setCodigoMensagem(Integer.parseInt(this.modeloMensagens.getValueAt(linha, 4).toString()));
        ler.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void listaMensagens() {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        StringBuilder where = new StringBuilder();
        SimpleDateFormat brDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat usDate = new SimpleDateFormat("MM/dd/yyyy");
        try {
            if (this.itemUsuarioEnvio.isSelected()) {
                where.append(" usr_codorigem in ").append(this.getExpressaoWhere(this.itemUsuarioEnvio)).append(" \n");
            }
            if (this.itemUsuarioRecebeu.isSelected()) {
                if (where.length() > 0) {
                    where.append(" and ");
                }
                where.append(" usr_coddestino in ").append(this.getExpressaoWhere(this.itemUsuarioRecebeu)).append(" \n");
            }
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                if (where.length() > 0) {
                    where.append(" and ");
                }
                where.append(" cast(ume_datahora as date) >= '");
                where.append(usDate.format(brDate.parse(this.textDataIni.getText())));
                where.append("' \n");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                if (where.length() > 0) {
                    where.append(" and ");
                }
                where.append(" cast(ume_datahora as date) <= '");
                where.append(usDate.format(brDate.parse(this.textDataFin.getText())));
                where.append("' \n");
            }
            if (!Funcoes.textoVazio(this.textAssunto)) {
                if (where.length() > 0) {
                    where.append(" and ");
                }
                where.append(" ume_assunto ilike '%").append(this.textAssunto.getText()).append("%'");
            }
            if (!Funcoes.textoVazio(this.textCorpo)) {
                if (where.length() > 0) {
                    where.append(" and ");
                }
                where.append(" ume_mensagem ilike '%").append(this.textCorpo.getText()).append("%'");
            }
            buf.append("select ume_datahora, usr_codorigem, usr_coddestino, ume_assunto, ume_mensagem, ume_codigo, ");
            buf.append("ume_confirmarleitura, ume_situacao from usuariomensagem ");
            if (where.length() > 0) {
                buf.append(" where ").append(where.toString());
            }
            buf.append(" order by ume_datahora");
            ResultSet rs = Conexao.executeQuery(st, buf);
            this.modeloMensagens.clear();
            while (rs.next()) {
                this.modeloMensagens.addLine(new Object[]{rs.getString("usr_codorigem"), rs.getString("usr_coddestino"), Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("ume_datahora")), rs.getString("ume_assunto"), rs.getString("ume_codigo"), rs.getString("ume_situacao"), rs.getString("ume_mensagem"), rs.getBoolean("ume_confirmarleitura")});
            }
        }
        catch (Exception exception) {
            Conexao.fecharStatement(st);
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    private void ocultarFiltro() {
        if (this.panelFiltro.getPreferredSize().getWidth() == 0.0) {
            this.panelFiltro.setPreferredSize(new Dimension(200, 100));
            this.buttonOcultar.setText("Ocultar Filtro");
        } else {
            this.panelFiltro.setPreferredSize(new Dimension(0, 100));
            this.buttonOcultar.setText("Mostrar Filtro");
        }
        this.panelFiltro.setMinimumSize(this.panelFiltro.getPreferredSize());
    }

    private String getExpressaoWhere(CheckItemFiltro item) {
        StringBuilder bui = new StringBuilder();
        String asps = "'";
        String[] sel = item.getSelecionados(0);
        if (sel != null && sel.length > 0) {
            bui.append('(').append(asps).append(sel[0]).append(asps);
            for (int i = 1; i < sel.length; ++i) {
                bui.append(", ").append(asps).append(sel[i]).append(asps);
            }
            bui.append(')');
        }
        return bui.toString();
    }

    private void gravarParametros() {
        ParametrosUsuarios.setValor(ULTIMO_FILTRO, this.getAtributos());
        ParametrosUsuarios.salvarParametros(true);
    }

    private void carregarParametros() {
        this.setAtributos(ParametrosUsuarios.getValor(ULTIMO_FILTRO));
    }

    private String getAtributos() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.getAtributosFiltro(this.itemUsuarioEnvio, "usuarioEnvio"));
        bui.append(this.getAtributosFiltro(this.itemUsuarioRecebeu, "usuarioRecebeu"));
        bui.append(StringUtil.getTag("dataInicial", this.textDataIni.getText()));
        bui.append(StringUtil.getTag("dataFinal", this.textDataFin.getText()));
        bui.append(StringUtil.getTag("textAssunto", this.textAssunto.getText()));
        bui.append(StringUtil.getTag("textCorpo", this.textCorpo.getText()));
        return StringUtil.getTag("filtro", bui.toString());
    }

    private void setAtributos(String atr) {
        String str = StringUtil.getValor(atr, "filtro");
        this.setAtributosFiltro(this.itemUsuarioEnvio, StringUtil.getValor(str, "usuarioEnvio"));
        this.setAtributosFiltro(this.itemUsuarioRecebeu, StringUtil.getValor(str, "usuarioRecebeu"));
        this.textDataIni.setText(StringUtil.getValor(str, "dataInicial"));
        this.textDataFin.setText(StringUtil.getValor(str, "dataFinal"));
        this.textAssunto.setText(StringUtil.getValor(str, "textAssunto"));
        this.textCorpo.setText(StringUtil.getValor(str, "textCorpo"));
    }

    private String getAtributosFiltro(CheckItemFiltro item, String nome) {
        StringBuilder bui = new StringBuilder();
        bui.append(StringUtil.getTag("sel", String.valueOf(item.isSelected())));
        bui.append(StringUtil.getTag("item", item.getSelecionados(0)));
        return StringUtil.getTag(nome, bui.toString());
    }

    private void setAtributosFiltro(CheckItemFiltro item, String atributos) {
        if (StringUtil.getBoolean(atributos, "sel")) {
            item.setSelected(true);
            item.setSelecionados(StringUtil.getValores(atributos, "item"));
        }
    }

    class PedirImpressora
    extends JDialog
    implements ActionListener {
        private JComboBox comboImpressora;
        private JButton buttonOK;
        private JButton buttonCancelar;
        private JPanel panelBotoes;
        private boolean ok;

        public PedirImpressora(JFrame owner) {
            super((Frame)owner, "Selecionar impressora");
            this.comboImpressora = new JComboBox<String>(Funcoes.getNomeImpressorasLocais());
            this.buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
            this.buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
            this.panelBotoes = new JPanel(new FlowLayout(2));
            this.ok = false;
            this.setSize(new Dimension(210, 83));
            this.setLocationRelativeTo(owner);
            this.setModal(true);
            this.setResizable(false);
            this.setLayout(new BorderLayout());
            this.panelBotoes.add(this.buttonOK);
            this.panelBotoes.add(this.buttonCancelar);
            this.add((Component)this.comboImpressora, "Center");
            this.add((Component)this.panelBotoes, "South");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.ok = e.getSource() == this.buttonOK;
            this.setVisible(false);
        }

        public boolean getOK() {
            return this.ok;
        }

        public void setUltimaImpressora(String i) {
            this.comboImpressora.setSelectedItem(i);
        }

        public String getImpressora() {
            return this.comboImpressora.getSelectedItem() != null ? this.comboImpressora.getSelectedItem().toString() : "";
        }
    }

    class RenderTabela
    extends DefaultTableCellRenderer {
        private static final int COLUNA_SITUACAO = 5;

        RenderTabela() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent j = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            boolean lida = table.getModel().getValueAt(row, 5) != null && table.getModel().getValueAt(row, 5).toString().equalsIgnoreCase("R");
            j.setOpaque(lida || isSelected);
            j.setFont(table.getFont());
            if (!lida) {
                j.setFont(new Font(table.getFont().getFontName(), 1, table.getFont().getSize()));
            }
            if (isSelected) {
                j.setBackground(table.getSelectionBackground());
            } else {
                j.setBackground(Color.WHITE);
            }
            return j;
        }
    }
}

