/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab.resultado;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.unilab.Configuracao;
import jalis.laboratorio.util.parsers.unilab.ExameUnilab;
import jalis.laboratorio.util.parsers.unilab.LinhaResultado;
import jalis.laboratorio.util.parsers.unilab.ServiceImportacaoUnilab;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportacaoResultadoUnilab
extends AbstractImportadorResultadoLabExterno {
    private HashMap<String, ExameUnilab> examesCadastro = new HashMap();
    private HashMap<String, ExameUnilab> resultadoExame = new HashMap();
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private boolean adicionarEnterNaTagResultado = false;
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private ServiceImportacaoUnilab siu = new ServiceImportacaoUnilab();
    private boolean agruparMultiguia = false;

    public ImportacaoResultadoUnilab(int codigoLabExterno, String titulo, String descricao, Protocolo procotolo) {
        super(titulo, descricao, codigoLabExterno, procotolo);
        this.jbInit(codigoLabExterno);
    }

    public ImportacaoResultadoUnilab(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio Unilab a partir de arquivo XML", codigoLabExterno, Protocolo.Unilab, new JPanel(new FlowLayout(2)));
        this.jbInit(codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jbInit(int codigoLabExterno) {
        Statement st;
        block5: {
            this.getPanelAdicional().add(this.buttonImprimir);
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block5;
                if (!DBUtil.campoNull(rs.getString("lae_configuracao")) && StringUtil.getValor(rs.getString("lae_configuracao"), "processarEnter").trim().length() > 0) {
                    this.adicionarEnterNaTagResultado = StringUtil.getBoolean(rs.getString("lae_configuracao"), "processarEnter");
                }
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.agruparMultiguia = rs.getBoolean("lae_agruparmultiguias");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoUnilab (128)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultado() {
        block10: {
            if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
                return;
            }
            this.buttonImprimir.setEnabled(false);
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo do Lab. Unilab (*.u2u)", "u2u"));
            this.setTextoInformacoes("");
            if (chooser.showOpenDialog(this) != 0) break block10;
            try {
                this.adicionarEnterNaTagResultado(chooser.getSelectedFile());
                Map<String, String> listaZip = StringUtil.descompactarZip(chooser.getSelectedFile().toString());
                if (listaZip.isEmpty()) {
                    this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                }
                for (String chave : listaZip.keySet()) {
                    Registro lote;
                    block12: {
                        block11: {
                            lote = this.parse(this.leituraArquivo(listaZip.get(chave), chooser.getSelectedFile()));
                            if (lote == null) {
                                return;
                            }
                            if (lote.getValor("requisicoes") == null) break block11;
                            if (lote.getValor("requisicoes", List.class).size() != 0) break block12;
                        }
                        this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
                        return;
                    }
                    this.progress.setValue(0);
                    this.progress.setMaximum(lote.getValor("requisicoes", List.class).size());
                    this.progress.setVisible(true);
                    int i = 0;
                    while (true) {
                        if (i >= lote.getValor("requisicoes", List.class).size()) break;
                        Registro requisicao = (Registro)lote.getValor("requisicoes", List.class).get(i);
                        this.importarResultadoRequisicao(requisicao);
                        ++i;
                    }
                    this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
                }
            }
            catch (Exception e1) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel importar os resultados.\nMensagem: " + e1.getMessage(), 1);
            }
        }
    }

    private void adicionarEnterNaTagResultado(File file) throws Exception {
        if (this.adicionarEnterNaTagResultado) {
            String arquivo = StringUtil.lerArquivoTexto(file);
            String[] linhas = arquivo.split("/>");
            StringBuilder b = new StringBuilder();
            StringBuilder novoArquivo = new StringBuilder();
            for (int i = 0; i < linhas.length; ++i) {
                b.setLength(0);
                b.append(i);
                if (i != linhas.length - 1) {
                    b.append("/>");
                }
                int pos = -1;
                int pos2 = -1;
                pos = b.indexOf("<resultado");
                if (pos > 0 && (pos2 = b.indexOf(" resultado", pos)) > pos) {
                    String tmp;
                    int posAspasInicio = -1;
                    int posAspasFim = -1;
                    for (int j = pos2; j < b.length(); ++j) {
                        if (b.toString().charAt(j) != '\"') continue;
                        if (posAspasInicio == -1) {
                            posAspasInicio = j;
                            continue;
                        }
                        posAspasFim = j;
                        break;
                    }
                    if ((tmp = b.substring(posAspasInicio + 1, posAspasFim)).indexOf("&#xD;") < 0) {
                        tmp = tmp.replaceAll("\n", "&#xD;").replaceAll("\r", "");
                        b.delete(posAspasInicio + 1, posAspasFim);
                        b.insert(posAspasInicio + 1, tmp);
                    }
                }
                novoArquivo.append((CharSequence)b);
            }
            StringUtil.escreverArquivoTexto(file.getPath(), novoArquivo.toString());
        }
    }

    private void importarResultadoRequisicao(Registro requisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st == null) {
            return;
        }
        this.progress.setValue(this.progress.getValue() + 1);
        List exames = requisicao.getValor("listaexames", List.class);
        for (ExameUnilab exame : exames) {
            LinkedList<Registro> listaRegistros;
            String fil_codigo = null;
            String req_codigo = null;
            if (requisicao.getValor("codigoApoiado") != null) {
                fil_codigo = Funcoes.textoVazio(requisicao.getValor("codigoApoiado").toString()) ? null : requisicao.getValor("codigoApoiado").toString().substring(0, ParametrosGerais.getDigitosTuboFilial());
                String string = Funcoes.textoVazio(requisicao.getValor("codigoApoiado").toString()) ? null : (req_codigo = requisicao.getValor("codigoApoiado").toString().substring(ParametrosGerais.getDigitosTuboFilial()));
            }
            if ((listaRegistros = this.processarPaiFilhos(st, requisicao, exame, fil_codigo, req_codigo)).isEmpty()) {
                this.setTextoInformacoes("\nExame: " + exame.getCodExaJalis().trim() + " n\u00e3o foi encontrado na requisi\u00e7\u00e3o: " + req_codigo, false);
                continue;
            }
            for (Registro reg : listaRegistros) {
                Registro formatacao;
                boolean salvoParcial;
                if (reg == null) continue;
                if (this.exameLancado(reg)) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = requisicao.getString("codigoApoio");
                    objectArray[1] = exame.getMnemonico().trim();
                    objectArray[2] = Situacao.JA_LANCADO.descricao;
                    this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do Unilab: %s exame %s %s", objectArray), false);
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.JA_LANCADO);
                    continue;
                }
                if (!this.exameColetado(reg) && reg != null && !reg.getString("exr_situacao").equals("P")) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = requisicao.getString("codigoApoio");
                    objectArray[1] = exame.getMnemonico();
                    objectArray[2] = Situacao.SEM_MATERIAL.descricao;
                    this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do Unilab: %s exame %s %s", objectArray), false);
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.SEM_MATERIAL);
                    continue;
                }
                if (!this.exameRelacionado(reg)) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.SEM_RELACIONAMENTO);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
                    continue;
                }
                if (reg.getValor("examePai") != null) {
                    reg.setValor("exa_codigo", reg.getString("examePai"));
                }
                Registro registro = (salvoParcial = reg.getString("exr_situacao").equals("P")) ? (Registro)reg.getValor("formatacao") : (formatacao = this.localizarFormatacao(reg));
                if (formatacao == null) {
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
                    continue;
                }
                Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                for (LinhaResultado linha : exame.getConfiguracoes().get(0).getLinhasDeResultado()) {
                    dados.put(linha.getVariavel().trim(), linha.getValorResultado().trim());
                    dados.put(this.siu.getUnidadeMedidaVariavel(linha.getVariavel().trim()), linha.getUnidade());
                }
                dados.put("metodo".toUpperCase(), exame.getMetodo().trim());
                for (LinhaResultado linha : exame.getConfiguracoes().get(0).getLinhasDeResultado()) {
                    this.adicionaValorExameDesmembrado(reg, dados, linha);
                }
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                }
                Resultado res = new Resultado(formatacao.getString("formato"), dados);
                res.atualizarComponentes();
                res = new Resultado(null, formatacao.getString("formato"), dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                res.atualizarComponentes();
                if (!res.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                    continue;
                }
                boolean completo = true;
                if (reg.getBoolean("exa_salvaparcial")) {
                    completo = res.resultadoCompleto(true);
                }
                String novaSituacao = completo ? "L" : "P";
                String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                try {
                    Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                    boolean marcarConferido = false;
                    if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                        int verificacao = res.verificarValidacao();
                        boolean bl = marcarConferido = verificacao == 1;
                        if (!marcarConferido && verificacao != 2) {
                            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.VALIDACAO_INSATISFEITA);
                            this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                        }
                    }
                    if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), null)) {
                        this.inserirDadosRequisicao(st, this.codigoLabExterno, requisicao.getString("codigoApoio"), reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                    }
                    boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                    boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                    this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                    if (this.exportarBaseWeb(reg.getString("fil_codigo"))) {
                        Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                        this.exportarParaWeb(st, this.getCodigoBaseWeb(reg.getString("fil_codigo")), novaSituacao, reg, mapa, resultado, formatacao.getString("formatotexto"));
                        if (completo && ExportaWeb.isGerarPdfResultado(st2, reg.getString("fil_codigo"))) {
                            ExportaWeb.enviarResultadoPDF(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(reg.getString("fil_codigo")));
                        }
                    }
                    this.adicionarAoModeloRelatorio(requisicao, exame, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE);
                    if (completo) {
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                    }
                    ExportaWeb.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), Variaveis.codigoBaseWeb);
                    this.editarRequisicaoExportaFiliais(reg);
                    DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
                    this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document analisarXML(String txt) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(new ByteArrayInputStream(txt.getBytes()));
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    private List<Element> leituraArquivo(String arquivo, File file) {
        Document doc = this.analisarXML(arquivo);
        if (doc == null) {
            this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + file);
            return null;
        }
        Element raiz = doc.getDocumentElement();
        return XMLUtil.getElementosFilhos(raiz);
    }

    private String getXmlResultadoAtual(Registro reg, String resultadoAtual, LinhaResultado linha) {
        String tag = reg.getValor("exameFilho") == null ? reg.getValor("exa_codigo").toString() : reg.getValor("exameFilho").toString();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linha.getValorResultado();
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    private void adicionaValorExameDesmembrado(Registro reg, Map<String, Object> dados, LinhaResultado linha) {
        if (reg.getValor("examePai") != null) {
            String chave = linha.getVariavel().trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linha.getValorResultado());
        }
    }

    /*
     * Unable to fully structure code
     */
    private LinkedList<Registro> processarPaiFilhos(Statement st, Registro requisicao, ExameUnilab exame, String fil_codigo, String req_codigo) throws SQLException {
        block12: {
            block14: {
                block13: {
                    block9: {
                        block11: {
                            block10: {
                                retorno = new LinkedList<Registro>();
                                multiguias = null;
                                tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                                v0 = agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() != false || this.agruparMultiguia != false;
                                if (!agruparMultiguias) break block9;
                                if (requisicao.getValor("codigoApoiado") == null) break block10;
                                if (requisicao.getValor("codigoApoiado").toString().length() != tamTubo) break block10;
                                if (Funcoes.isNumeric(requisicao.getValor("codigoApoiado").toString())) break block11;
                            }
                            if (requisicao.getValor("codigoApoiado") == null) ** GOTO lbl18
                            if (Funcoes.textoVazio(requisicao.getValor("codigoApoiado").toString())) {
lbl18:
                                // 2 sources

                                v1 = requisicao.getValor("codigoApoio").toString();
                            } else {
                                v1 = requisicao.getValor("codigoApoiado").toString();
                            }
                            tubo = v1;
                            this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompat\u00edvel com as configura\u00e7\u00f5es de tubo: " + tubo, false);
                            return retorno;
                        }
                        multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
                        break block12;
                    }
                    if (requisicao.getValor("codigoApoiado").toString().length() != tamTubo) break block13;
                    if (Funcoes.isNumeric(requisicao.getValor("codigoApoiado").toString())) break block14;
                }
                this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompat\u00edvel com as configura\u00e7\u00f5es de tubo: " + requisicao.getValor("codigoApoiado").toString(), false);
                return retorno;
            }
            multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        }
        for (Integer multiguia : multiguias) {
            codigoJalisAux = (String)requisicao.getValor("codigoApoiado");
            requisicao.setValor("codigoApoiado", StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1));
            exameSeparado = this.localizaExameRequisicao(requisicao, exame, st, false);
            if (exameSeparado != null) {
                retorno.add(exameSeparado);
            }
            if (this.buscaDadosExameAssociado(fil_codigo, multiguia.toString(), exame) && (pai = this.getExamesDesmembrados(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exame.getCodExaJalis(), exame.getCodMatJalis())) != null) {
                codigoJalisTemp = exame.getCodExaJalis();
                exame.setCodExaJalis(pai.getCodigoExame());
                exame.setCodMatJalis(String.valueOf(pai.getCodigomaterial()));
                reg = this.localizaExameRequisicao(requisicao, exame, st, true);
                if (reg != null) {
                    reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                    reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                    reg.setValor("examePai", pai.getCodigoExame());
                    reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                    exame.setCodExaJalis(codigoJalisTemp);
                    retorno.add(reg);
                }
            }
            requisicao.setValor("codigoApoiado", codigoJalisAux);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buscaDadosExameAssociado(String fil_codigo, String req_codigo, ExameUnilab exame) throws SQLException {
        boolean bl;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.exa_codigo as examepai, ");
        sql.append(" e.exa_kodigo as examefilho, ");
        sql.append(" a.mco_codigo, ");
        sql.append(" p.ele_xmllabexterno ");
        sql.append(" \t\tFROM examerequisicao a ");
        sql.append(" \t\t\tJOIN examematcoletalabextdesm e ON a.fil_codigo = e.fil_codigo ");
        sql.append(" \t\t\t\tAND a.exa_codigo = e.exa_codigo ");
        sql.append(" \t\t\t\tAND a.mco_codigo = e.mco_codigo ");
        sql.append(" \t\t\tJOIN examematcoletalabexterno p ON e.fil_codigo = p.fil_codigo ");
        sql.append(" \t\t\t\tAND e.exa_kodigo = p.exa_codigo ");
        sql.append(" \t\t\t\tAND e.mco_codigo = p.mco_codigo ");
        sql.append(" \t\t\t\tAND e.lae_codigo = p.lae_codigo ");
        sql.append(" WHERE a.fil_codigo = ").append(fil_codigo);
        sql.append(" \t\tAND a.req_codigo = ").append(req_codigo);
        sql.append("    AND upper(p.ele_xmllabexterno) ilike '%<").append("mnemonico").append(">").append(exame.getMnemonico()).append("</").append("mnemonico").append(">%'");
        sql.append(" \t\tAND p.ele_xmllabexterno is not null and p.ele_xmllabexterno <> '' ");
        Statement st = Conexao.getStatement();
        ResultSet resultSet = null;
        try {
            resultSet = Conexao.executeQuery(st, sql);
            while (resultSet.next()) {
                if (!exame.getCodExaJalis().equals(resultSet.getString("examefilho"))) continue;
                exame.setXmlJalis(resultSet.getString("ele_xmllabexterno"));
                exame.setCodExaJalis(resultSet.getString("examefilho"));
                exame.setMaterialJalis(resultSet.getString("mco_codigo"));
                bl = true;
                if (resultSet == null) break block5;
            }
        }
        catch (Throwable throwable) {
            if (resultSet != null) {
                resultSet.close();
            }
            Conexao.fecharStatement(st);
            throw throwable;
        }
        {
            block5: {
                resultSet.close();
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        Conexao.fecharStatement(st);
        return false;
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "mnemonico");
                    mco = StringUtil.getValor(xml, "material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select unl_xml from examesunilab where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and unl_codigoexame = '").append(exa).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("unl_xml", rs.getString("unl_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private Registro localizaExameRequisicao(Registro requisicao, ExameUnilab exame, Statement st, boolean procuraDesm) throws SQLException {
        String fil = "";
        String req = requisicao.getString("codigoApoiado");
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. C\u00f3digo DB: " + requisicao.getString("codigoApoiado"), false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req = req.substring(ParametrosGerais.getDigitosTuboFilial());
        if (!Funcoes.isNumeric(fil) || !Funcoes.isNumeric(req)) {
            this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Filial ou requisi\u00e7\u00e3o incorreta. C\u00f3digo DB: " + requisicao.getString("codigoApoiado"), false);
            return null;
        }
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, null as exameFilho, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
        sql.append("  a.req_guia, b.exr_codautorizacao, b.exr_solicitadotiss \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false \n");
        if (!Funcoes.textoVazio(exame.getCodExaJalis()) && !Funcoes.textoVazio(exame.getCodMatJalis())) {
            sql.append(" and b.exa_codigo = '").append(exame.getCodExaJalis().trim()).append("' \n");
            sql.append(" and b.mco_codigo = ").append(exame.getCodMatJalis()).append(" \n");
        } else {
            sql.append("  and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
            sql.append("  and upper(g.ele_xmllabexterno) ilike '%<").append("mnemonico").append(">").append(exame.getMnemonico().toUpperCase()).append("</").append("mnemonico").append(">%'");
        }
        ResultSet res = Conexao.executeQuery(st, sql.toString());
        if (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(fil, reg.getString("codigo-layout")));
            Registro formatacao = new Registro();
            formatacao.setValor("formato", reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor("formatacao", formatacao);
            exame.setCodExaJalis(res.getString("exa_codigo"));
            exame.setCodMatJalis(res.getString("mco_codigo"));
            return reg;
        }
        return null;
    }

    private void adicionarAoModeloRelatorio(Registro requisicao, ExameUnilab exame, Situacao situacao) {
        if (requisicao.getString("codigoApoiado").length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboFilial()) {
            return;
        }
        String fil_codigo = requisicao.getString("codigoApoiado").substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = requisicao.getString("codigoApoiado").substring(ParametrosGerais.getDigitosTuboFilial());
        if (exame != null && !Funcoes.textoVazio(exame.getCodExaJalis()) && !Funcoes.textoVazio(exame.getCodMatJalis())) {
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, fil_codigo, req_codigo, exame.getCodExaJalis(), Integer.parseInt(exame.getCodMatJalis()), situacao.descricao);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            if (this.modeloRelatorio.getRowCount() > 0) {
                RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
            }
        } else if (e.getSource() == this.buttonImportar) {
            this.importarResultado();
        } else {
            if (this.getParent() != null) {
                this.getParent().removeAll();
            }
            this.setVisible(false);
        }
    }

    private Registro parse(List<Element> elements) {
        Registro lote = new Registro();
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("resultados")) {
                if (e.getAttribute("versao").equalsIgnoreCase("20060809")) continue;
                this.setTextoInformacoes("O arquivo selecionado n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                return null;
            }
            if (e.getNodeName().equalsIgnoreCase("convenio")) {
                lote.setValor("convenio", e.getTextContent());
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("numerolote")) {
                lote.setValor("numerolote", e.getTextContent());
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("pedidos")) continue;
            List<Element> pedidos = XMLUtil.getElementosFilhos(e);
            lote.setValor("requisicoes", new ArrayList());
            for (Element p : pedidos) {
                if (!p.getNodeName().equalsIgnoreCase("pedido")) continue;
                List<Element> requicoes = XMLUtil.getElementosFilhos(p);
                this.parseSolicitacao(requicoes, lote);
            }
        }
        return lote;
    }

    private List<ExameUnilab> parseExameCadastro(Element element) {
        List<Element> elements = XMLUtil.getElementosFilhos(element);
        ArrayList<ExameUnilab> listaExames = new ArrayList<ExameUnilab>();
        for (Element e : elements) {
            ExameUnilab exame = new ExameUnilab();
            List<Element> ele = XMLUtil.getElementosFilhos(e);
            for (Element exa : ele) {
                if (exa.getNodeName().equalsIgnoreCase("mnemonico")) {
                    exame.setMnemonico(exa.getTextContent(), false);
                    continue;
                }
                if (exa.getNodeName().equalsIgnoreCase("nome")) {
                    exame.setNome(exa.getTextContent(), false);
                    continue;
                }
                if (exa.getNodeName().equalsIgnoreCase("codigomtbi")) {
                    exame.setCodigoMtbi(exa.getTextContent(), false);
                    continue;
                }
                if (exa.getNodeName().equalsIgnoreCase("idapoiado")) {
                    if (exa.getTextContent().contains("|")) {
                        String[] idExaApoiado = exa.getTextContent().split("[|]");
                        exame.setCodExaJalis(idExaApoiado[0]);
                        exame.setCodMatJalis(idExaApoiado[1]);
                        continue;
                    }
                    exame.setCodExaJalis("");
                    exame.setCodMatJalis("");
                    continue;
                }
                if (exa.getNodeName().equalsIgnoreCase("numeroamostra")) continue;
                if (exa.getNodeName().equalsIgnoreCase("dataliberacao")) continue;
                if (exa.getNodeName().equalsIgnoreCase("alteramtbi")) continue;
                if (exa.getNodeName().equalsIgnoreCase("nomematerialbiologico")) continue;
                if (exa.getNodeName().equalsIgnoreCase("vigencia")) continue;
                if (exa.getNodeName().equalsIgnoreCase("metodo")) {
                    exame.setMetodo(exa.getTextContent(), false);
                    continue;
                }
                if (!exa.getNodeName().equalsIgnoreCase("resultados")) continue;
                this.parseExameResultado(exa, exame);
            }
            listaExames.add(exame);
        }
        return listaExames;
    }

    private void parseSolicitacao(List<Element> requisicoes, Registro lote) {
        Registro requisicao = new Registro();
        for (Element e : requisicoes) {
            if (e.getNodeName().equalsIgnoreCase("codigoApoiado")) {
                requisicao.setValor("codigoApoiado", e.getTextContent());
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("codigoApoio")) {
                requisicao.setValor("codigoApoio", e.getTextContent());
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("paciente")) continue;
            if (!e.getNodeName().equalsIgnoreCase("exames")) continue;
            requisicao.setValor("listaexames", this.parseExameCadastro(e));
        }
        lote.getValor("requisicoes", List.class).add(requisicao);
    }

    private void parseExameResultado(Element e, ExameUnilab exameRes) {
        List<Element> elements = XMLUtil.getElementosFilhos(e);
        ArrayList<LinhaResultado> linhasResultado = new ArrayList<LinhaResultado>();
        String codigoExame = "";
        ArrayList<Configuracao> configuracoes = new ArrayList<Configuracao>();
        Configuracao conf = new Configuracao();
        configuracoes.add(conf);
        exameRes.setConfiguracoes(configuracoes);
        conf.setLinhasDeResultado(linhasResultado);
        for (Element ele : elements) {
            List<Element> resultado = XMLUtil.getElementosFilhos(ele);
            Registro exame = new Registro();
            LinhaResultado linha = new LinhaResultado();
            for (Element element : resultado) {
                if (element.getNodeName().equalsIgnoreCase("variavel")) {
                    linha.setVariavel(element.getTextContent());
                    continue;
                }
                if (element.getNodeName().equalsIgnoreCase("impresso")) {
                    linha.setImpresso(element.getTextContent());
                    continue;
                }
                if (element.getNodeName().equalsIgnoreCase("tipo")) {
                    linha.setTipo(element.getTextContent());
                    continue;
                }
                if (element.getNodeName().equalsIgnoreCase("descricao")) {
                    linha.setDescricao(element.getTextContent());
                    continue;
                }
                if (element.getNodeName().equalsIgnoreCase("unidade")) {
                    linha.setUnidade(element.getTextContent());
                    continue;
                }
                if (element.getNodeName().equalsIgnoreCase("valordereferencia")) {
                    linha.setValorReferencia(element.getTextContent());
                    continue;
                }
                if (!element.getNodeName().equalsIgnoreCase("valorresultado")) continue;
                linha.setValorResultado(element.getTextContent());
            }
            linhasResultado.add(linha);
        }
    }

    private String removeCaracteresMetodo(String texto) {
        if (texto == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] caracteres = texto.split(";");
        for (int i = 0; i < caracteres.length; ++i) {
            if (caracteres[i].equals("&#xD") || caracteres[i].equals("&#xA")) continue;
            buf.append(caracteres[i]);
        }
        texto = buf.toString();
        texto = texto.replace("&#xD", "");
        texto = texto.replace("&#xA", "");
        texto = texto.replace("&amp;#xA;", "");
        texto = texto.replace("&amp;#xD;", "");
        return texto;
    }

    private String trocaCaracteres(String texto) {
        if (texto == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] caracteres = texto.split(";");
        boolean isFim = false;
        for (int i = 0; i < caracteres.length; ++i) {
            if (!isFim && caracteres[i].equals("&#xD") || caracteres[i].equals("&#xA")) {
                if (caracteres[i + 1].equals("&#xD") || caracteres[i + 1].equals("&#xA")) continue;
                isFim = true;
                continue;
            }
            buf.append(caracteres[i]);
        }
        texto = buf.toString();
        texto = texto.replace("&#xD", "\n");
        texto = texto.replace("&#xA", "\n");
        texto = texto.replace("&amp;#xA;", "\n");
        texto = texto.replace("&amp;#xD;", "\n");
        return texto;
    }

    public static long getModuloAcesso() {
        String acesso = "904000101";
        return Long.parseLong(acesso);
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_RELACIONAMENTO("Sem relacionamento"),
        SEM_MATERIAL("Sem material"),
        LAYOUT_ATUALIZADO("Layout atualizado, mas n\u00e3o relacionado");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

