/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.unilab.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.unilab.Configuracao;
import jalis.laboratorio.util.parsers.unilab.ExameUnilab;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class CamposImportacaoUnilab
implements CamposImportacao {
    List<Configuracao> linhas = new ArrayList<Configuracao>();
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoUnilab(String xml, String xmlExameLabApoio, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        this.codigoExamePai = codigoExamePai;
        this.codigoMaterialPai = codigoMaterialPai;
        ExameUnilab exame = ExameUnilab.novaInstanciaExame(xml);
        if (xml.indexOf("?xml version") < 0) {
            this.codigoExame = StringUtil.getValor(xml, "codigo");
            if (Funcoes.textoVazio(this.codigoExame)) {
                this.codigoExame = codigoExameLabApoio.substring(0, codigoExameLabApoio.indexOf(124));
            }
            this.versao = exame.getVigencia();
            if (exame.getConfiguracoes().size() > 0 && exame.getConfiguracoes().get(0).getLinhasDeResultado().size() > 0) {
                for (Configuracao conf : exame.getConfiguracoes()) {
                    this.linhas.add(conf);
                }
            }
        }
    }

    @Deprecated
    private void carregaTemposLinhas(String linha, String descricao, String xml) {
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    public int[] carregaTempos(String tempos) {
        String[] tmps = tempos.split(",");
        int[] retorno = new int[tmps.length];
        ArrayList<Integer> temp = new ArrayList<Integer>();
        for (String t : tmps) {
            temp.add(new Integer(Funcoes.isNumeric(t) ? Integer.parseInt(t) : 0));
        }
        Collections.sort(temp);
        for (int i = 0; i < tmps.length; ++i) {
            retorno[i] = (Integer)temp.get(i);
        }
        return retorno;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }
}

